/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import com.pingidentity.templates.mgmt.DefaultTemplateParams;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.domain.AdvancedAuthnPolicy;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.ProxyScoping;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.encryption.EncryptionEngine;
import org.sourceid.saml20.encryption.NoEncryptionKeyException;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.BindingEndptChooser;
import org.sourceid.saml20.profiles.ProfileProcessorMatrix;
import org.sourceid.saml20.profiles.ResumableRequestHandlerBase;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.profiles.idp.AuthnCtxChecker;
import org.sourceid.saml20.profiles.idp.AuthnRequestOptions;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupport;
import org.sourceid.saml20.protocol.AssertionAssembler;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.service.PseudonymServiceException;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.wrapper.SignaturePolicy;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.ConditionsType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectType;
import org.sourceid.saml20.xmlbinding.protocol.AuthnContextComparisonType;
import org.sourceid.saml20.xmlbinding.protocol.AuthnRequestDocument;
import org.sourceid.saml20.xmlbinding.protocol.AuthnRequestType;
import org.sourceid.saml20.xmlbinding.protocol.NameIDPolicyType;
import org.sourceid.saml20.xmlbinding.protocol.RequestedAuthnContextType;
import org.sourceid.saml20.xmlbinding.protocol.ResponseDocument;
import org.sourceid.saml20.xmlbinding.protocol.ResponseType;
import org.sourceid.saml20.xmlbinding.protocol.ScopingType;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.commondomain.CommonDomainUtil;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.idp.FailedAuthnSsoException;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuthenticationResult;
import org.sourceid.websso.profiles.idp.SsoRespSupport;
import org.sourceid.websso.servlet.SessionIdUtil;
import org.sourceid.websso.servlet.reqparam.ProprietaryURLParams;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.websso.wrapper.OutMessageContextUtil;
import org.sourceid.websso.wrapper.XmlMessageLogWrapper;

public class HandleAuthnRequest
extends ResumableRequestHandlerBase
implements ResumeRequestFromAuthnResponseHandler {
    private static final String MSG_ERROR_ASSERTION_ENCRYPTION = "Unable to encrypt Assertion.";
    private final ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private final AssertionAssembler assertionAssembler = new AssertionAssembler();
    private final ProfileProcessorMatrix profileProcessorMatrix = ProfileProcessorMatrix.getInstance();
    private final EncryptionEngine encryptionEngine = GlobalRegistry.getService(EncryptionEngine.class);
    private static final String COMMON_DOMAIN_SERVICE_FLAG = "CommonDomainServiceFlag";
    private final SsoRespSupport respSupport = new SsoRespSupport();
    private final AuthnSourceSupport adapterSupport = new AuthnSourceSupport();
    private final String[] EMPTY = new String[0];
    private static final String CONSENT_TYPE_PARAMETER_NAME = "consentType";
    private static final String CONSENT_TYPE_VALUE_EXPLICIT = "Explicit";
    private static final String CONSENT_TYPE_VALUE_IMPLICIT = "Implicit";
    private static final String CONSENT_TYPE_VALUE_OBTAINED = "Obtained";
    private static final String CONSENT_TYPE_VALUE_PRIOR = "Prior";
    private static final String CONSENT_TYPE_VALUE_UNSPECIFIED = "Unspecified";
    private static final String SESSION_ATTRIBUTE_NAME_AUTHN_RESULT = "AuthnResult";

    public static boolean isEnableCDCDuringSSO() {
        ConfigStore configStore = ConfigStoreFarm.getConfig(HandleAuthnRequest.class);
        return configStore.getBooleanValue("EnableCDCDuringSSO", false);
    }

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        String nameIdFormat;
        SpConnection spConnection = MetadataSupport.getSpConnection(inMsgCtx.getEntityId());
        OutMessageContext outMsgCtx = OutMessageContextUtil.buildDefaultSaml20RespCtx(inMsgCtx, spConnection);
        LicenseManager.checkLicenseForConnection(spConnection);
        if (!inMsgCtx.isBackChannelBinding()) {
            IndexedEndpoints acss = spConnection.getAssertionConsumerServiceEndpoints();
            String binding = req.getParameter("Binding");
            String acsIdx = req.getParameter("ACSIdx");
            BindingEndptChooser.doCheckBindingOverride(binding, acss, outMsgCtx, "assertion consumer", acsIdx);
        }
        if (!StringUtils.isBlank((String)(nameIdFormat = req.getParameter("RequestedFormat")))) {
            inMsgCtx.setParam("RequestedFormat", nameIdFormat);
        }
        return outMsgCtx;
    }

    @Override
    protected void verifySignature(InMessageContext inMsgCtx) throws StatusResponseException {
        SpConnection spMetadata = MetadataSupport.getSpConnection(inMsgCtx.getEntityId());
        boolean spSignsAuthnReqs = spMetadata.isAuthnRequestsSigned();
        if (spSignsAuthnReqs) {
            super.verifySignature(inMsgCtx);
        }
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        if (!inMsgCtx.isUnsolicitedResponse()) {
            SpConnection spConnection = MetadataSupport.getSpConnection(inMsgCtx.getEntityId());
            EnabledProfiles enabledProfs = spConnection.getEnabledProfiles();
            this.profileProcessorMatrix.verifyProcessorEnablement(6, enabledProfs);
            this.getSetRequestedUserId(inMsgCtx);
        }
        HashMap<String, Object> otherState = new HashMap<String, Object>();
        otherState.put("PartnerEntityId", inMsgCtx.getEntityId());
        this.addTrackedParams(req, otherState);
        String policyAction = ProprietaryURLParams.getParam(req, "PolicyAction");
        otherState.put("PolicyAction", policyAction);
        this.resume(inMsgCtx, req, resp, outMsgCtx, otherState);
    }

    private void getSetRequestedUserId(InMessageContext inMsgCtx) {
        String reqSubject;
        SubjectType subjectType;
        AuthnRequestDocument authnRequestDoc = (AuthnRequestDocument)inMsgCtx.getXmlObject();
        AuthnRequestType authnRequestType = authnRequestDoc.getAuthnRequest();
        if (authnRequestType.isSetSubject() && (subjectType = authnRequestType.getSubject()).isSetNameID() && !StringUtils.isEmpty((String)(reqSubject = subjectType.getNameID().getStringValue()))) {
            inMsgCtx.setRequestedUserId(reqSubject);
        }
    }

    @Override
    protected void doResume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws IOException, StatusResponseException, AuthnAdapterException, PseudonymServiceException {
        IdpAuthenticationResult authnResult;
        if (otherState != null && otherState.containsKey(COMMON_DOMAIN_SERVICE_FLAG)) {
            return;
        }
        String partnerEntityId = inMsgCtx.getEntityId();
        IdpAuditLogger.setPartnerId(partnerEntityId);
        IdpAuditLogger.setVirtualServerId(inMsgCtx.getVirtualServerId());
        SpConnection spConnection = MetadataSupport.getSpConnection(partnerEntityId);
        IdpAuditLogger.setProtocol(spConnection.getProtocol().toString());
        AuthnPolicy authnPolicy = this.getAuthnPolicy(inMsgCtx);
        ConfigStore configStore = ConfigStoreFarm.getConfig("consent");
        boolean consentEnabled = configStore.getBooleanValue("enabled", false);
        try {
            if (consentEnabled) {
                authnResult = this.processUserConsentAndLookupAuthn(inMsgCtx, req, resp, outMsgCtx, otherState, authnPolicy);
            } else {
                String resumePath = this.saveState(req, resp, inMsgCtx, outMsgCtx, otherState);
                authnResult = this.adapterSupport.lookupAuthNs(req, resp, authnPolicy, resumePath, otherState, inMsgCtx, outMsgCtx, this, false);
            }
        }
        catch (AuthnProcessorException.ProxyCountException e) {
            this.processOptionalAuthnRequestParameters(spConnection, inMsgCtx, outMsgCtx);
            throw new StatusResponseException(TopLevelStatusCode.RESPONDER, "urn:oasis:names:tc:SAML:2.0:status:ProxyCountExceeded", e.getMessage());
        }
        catch (AuthorizationException | AuthnProcessorException e) {
            this.processOptionalAuthnRequestParameters(spConnection, inMsgCtx, outMsgCtx);
            throw new StatusResponseException(TopLevelStatusCode.RESPONDER, e.getMessage(), e);
        }
        if (authnResult != null) {
            AttributeValue authnCtxValue = this.respSupport.getAuthnCtxFromAuthnAttrs(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans(), "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
            this.doResumeSsoFromAuthnSource(authnResult, spConnection, authnPolicy, inMsgCtx, req, resp, outMsgCtx, otherState, authnCtxValue);
        } else {
            this.doResumeSsoFromAuthnSource(authnResult, spConnection, authnPolicy, inMsgCtx, req, resp, outMsgCtx, otherState, null);
        }
    }

    private AuthnRequestOptions processOptionalAuthnRequestParameters(SpConnection spConnection, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) throws StatusResponseException {
        AuthnRequestOptions requestOptions = null;
        if (!inMsgCtx.isUnsolicitedResponse() && !inMsgCtx.isBackChannelBinding()) {
            AuthnRequestDocument authnRequestDoc = (AuthnRequestDocument)inMsgCtx.getXmlObject();
            requestOptions = AuthnRequestOptions.getAuthnRequestOptions(authnRequestDoc);
            if (requestOptions.getAssertionConsumerServiceIndex() != null) {
                this.processRequestedAssertionConsumerServiceIndex(requestOptions, spConnection, outMsgCtx);
            } else {
                StatusResponseException exceptionFromProcessRequestedProtocolBinding = null;
                try {
                    if (requestOptions.getProtocolBinding() != null) {
                        this.processRequestedProtocolBinding(requestOptions, spConnection, outMsgCtx);
                    }
                }
                catch (StatusResponseException ex) {
                    exceptionFromProcessRequestedProtocolBinding = ex;
                }
                if (requestOptions.getAssertionConsumerServiceURL() != null) {
                    this.processRequestedAssertionConsumerServiceURL(requestOptions, spConnection, inMsgCtx, outMsgCtx);
                }
                if (exceptionFromProcessRequestedProtocolBinding != null) {
                    throw exceptionFromProcessRequestedProtocolBinding;
                }
            }
        }
        return requestOptions;
    }

    @Override
    public void resumeSsoFromIdp(IdpAuthenticationResult authnResult, HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherState, AttributeValue authnCtxValue) throws StatusResponseException, PseudonymServiceException {
        String partnerEntityId = inMsgCtx.getEntityId();
        SpConnection spConnection = MetadataSupport.getSpConnection(partnerEntityId);
        AuthnPolicy authnPolicy = this.getAuthnPolicy(inMsgCtx);
        IdpAuditLogger.setPartnerId(partnerEntityId);
        IdpAuditLogger.setVirtualServerId(inMsgCtx.getVirtualServerId());
        IdpAuditLogger.setProtocol(spConnection.getProtocol().toString());
        this.doResumeSsoFromAuthnSource(authnResult, spConnection, authnPolicy, inMsgCtx, req, resp, outMsgCtx, otherState, authnCtxValue);
    }

    @Override
    public boolean isAuthnApiHandlesException(HttpServletRequest req, Map<String, Object> stateParams, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) {
        return inMsgCtx == null || this.respSupport.isHandleExceptionLocally(inMsgCtx, outMsgCtx);
    }

    private void doResumeSsoFromAuthnSource(IdpAuthenticationResult authnResult, SpConnection spConnection, AuthnPolicy authnPolicy, InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState, AttributeValue authnCtxValue) throws StatusResponseException, PseudonymServiceException {
        if (!resp.isCommitted()) {
            boolean doCdc;
            ResponseDocument responseDoc;
            ResponseType responseType;
            AuthnRequestOptions requestOptions = this.processOptionalAuthnRequestParameters(spConnection, inMsgCtx, outMsgCtx);
            String partnerEntityId = inMsgCtx.getEntityId();
            if (authnResult != null) {
                IdpAuditLogger.setAuthnSourceId(AuthnSourceSupport.getAuthnSourceKeys(authnResult.getAuthnBeans()));
            }
            if (authnResult == null || Util.isEmpty(authnResult.getAuthnAttrs())) {
                String s = authnPolicy.allowUserInteraction() ? "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed" : "urn:oasis:names:tc:SAML:2.0:status:NoPassive";
                throw new StatusResponseException(TopLevelStatusCode.RESPONDER, s, "Authentication Failed", "AUTHENTICATION_FAILED", "errorDetail.authenticationFailed", new FailedAuthnSsoException());
            }
            AttributeMap incomingAttrs = authnResult.getAuthnAttrs();
            if (incomingAttrs.get((Object)"TargetResource") == null && outMsgCtx.getRelayState() != null) {
                AttributeValue value = new AttributeValue(outMsgCtx.getRelayState());
                incomingAttrs.put("TargetResource", value);
            }
            String inResponseTo = (responseType = (responseDoc = (ResponseDocument)outMsgCtx.getXmlObject()).getResponse()).isSetInResponseTo() ? responseType.getInResponseTo() : null;
            this.setAuditMdcValues((AttributeValue)incomingAttrs.get((Object)"TargetResource"), inResponseTo);
            LinkedList authenticatingAuthorities = (LinkedList)otherState.get("authnAuthorityEntityIds");
            AttributeMap contextAttributes = new AttributeMap();
            contextAttributes.put(SourceContextType.AUTHN_CTX.getId(), authnCtxValue);
            contextAttributes.put(SourceContextType.CLIENT_IP.getId(), req.getRemoteAddr());
            contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
            contextAttributes.put(SourceContextType.VIRTUAL_SERVER_ID.getId(), inMsgCtx.getVirtualServerId());
            contextAttributes.put(SourceContextType.SRI.getId(), SessionIdUtil.getInstance().getExtendedSriV2(req, resp, otherState));
            if (authenticatingAuthorities != null && !authenticatingAuthorities.isEmpty()) {
                AttributeValue authnAuthoritiesAttributeValue = new AttributeValue((Collection)authenticatingAuthorities);
                contextAttributes.put(SourceContextType.AUTHENTICATING_AUTHORITY.getId(), authnAuthoritiesAttributeValue);
            }
            AttributeMap attributes = this.respSupport.executeAuthnSourceToAssertionMapping(authnResult, spConnection, contextAttributes, otherState);
            outMsgCtx.setMaskedAttributeNames(attributes.getMaskedAttributeNames());
            this.setAuditMdcValues(attributes);
            String acs = outMsgCtx.getEndpoint();
            this.checkDoPseudonymAsNameId(spConnection, authnResult, attributes, inMsgCtx);
            attributes.putIfNotPresent(AssertionMapKeys.getAuthnCtxKey(), authnCtxValue);
            String authnCtxClassRef = this.assertionAssembler.getAuthnCtxClassRef(attributes);
            attributes.putIfNotPresent(AssertionMapKeys.getAuthnCtxKey(), new AttributeValue(authnCtxClassRef));
            AuthnCtxChecker authnChecker = AuthnCtxChecker.getInstance();
            RequestedAuthnContextType requestedAuthnContextType = this.evalRequestedAuthnCtx(inMsgCtx, req);
            authnChecker.validateAuthnCtx(requestedAuthnContextType, authnCtxClassRef);
            boolean maskNameId = attributes.getMaskedAttributeNames().contains(AssertionMapKeys.getNameIdValueKey());
            Calendar authnInst = this.respSupport.getAuthnInstantValue(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans());
            String issuer = VirtualIdentityUtil.resolve((BaseMessageContext)inMsgCtx, spConnection).getVirtualEntityId(DomainMode.RUNTIME);
            AttributeMap copyOfAttributes = null;
            if (spConnection.hasMessageCustomizationHook("assertion") || spConnection.hasMessageCustomizationHook("authn-response")) {
                copyOfAttributes = new AttributeMap((Map)attributes);
            }
            AssertionType[] assertions = new AssertionType[]{this.assertionAssembler.assembleForWebSSO(attributes, partnerEntityId, acs, inResponseTo, authnInst, issuer, (List<String>)authenticatingAuthorities)};
            IdpAuditLogger.setVirtualServerId(issuer);
            NameIDType unencryptedNameID = (NameIDType)assertions[0].getSubject().getNameID().copy();
            if (requestOptions != null && requestOptions.getSubject() != null) {
                this.validateRequestedSubject(assertions[0], requestOptions.getSubject());
            }
            if (requestOptions != null && requestOptions.getConditions() != null) {
                this.processRequestedConditions(assertions[0], requestOptions.getConditions(), inMsgCtx);
            }
            boolean signAssertion = spConnection.isWantAssertionsSigned();
            boolean encryptedNameIDRequested = this.checkEncryptedNameIDRequested(inMsgCtx);
            boolean encryptAssertion = spConnection.getEncryptionSettings().getEncryptionPolicy().isEncryptAssertion();
            this.assertionAssembler.encryptSubjectNameID(spConnection, assertions[0].getSubject(), encryptedNameIDRequested);
            Map<String, Object> assertionCustomizeContext = MessageCustomization.getAssertionCustomisationContext((XmlObject)assertions[0], copyOfAttributes, authnResult.getAuthnBeans());
            assertions = spConnection.customizeAssertions(req, resp, assertions[0], assertionCustomizeContext, otherState);
            if (signAssertion) {
                try {
                    for (int i = 0; i < assertions.length; ++i) {
                        assertions[i] = this.signatureEngine.signAssertion(outMsgCtx, assertions[i]);
                    }
                }
                catch (SigningException e) {
                    throw new StatusResponseException(TopLevelStatusCode.RESPONDER, "Unable to sign assertion.", e);
                }
                if (!(spConnection.isSignResponseAsRequired().booleanValue() || encryptAssertion && !this.omitRespSigOnSignedEncryptedAssertion(partnerEntityId))) {
                    outMsgCtx.setSignaturePolicy(SignaturePolicy.DO_NOT_SIGN);
                    if (this.config.getBooleanValue("OmitIssuerWhenPossible", false) && !encryptAssertion) {
                        responseType.unsetIssuer();
                    }
                }
            }
            for (AssertionType assertion : assertions) {
                if (encryptAssertion) {
                    this.encryptAssertion(spConnection, responseType, assertion, outMsgCtx.getMaskedAttributeNames());
                    continue;
                }
                responseType.addNewAssertion().set((XmlObject)assertion);
            }
            if (spConnection.supportsSLO()) {
                IdpSessionRegistrySupport.registerAssertionIssued(req, resp, otherState, authnResult.getAuthnBeans(), assertions[0], partnerEntityId, unencryptedNameID, maskNameId, inMsgCtx.getVirtualServerId());
            }
            boolean bl = doCdc = this.localMetaData.getEnableIdpDiscovery() && this.localMetaData.getIdpDiscovery().isIdpCommonDomainClient() && spConnection.isEnableCDCDuringSSO();
            if (doCdc) {
                this.registerWithCommonDomainService(req, resp, inMsgCtx, outMsgCtx, otherState);
            }
            Map<String, Object> respCustomizeContext = MessageCustomization.getResponseCustomizeContext(spConnection, copyOfAttributes, authnResult.getAuthnBeans());
            responseDoc = spConnection.customizeResponse(ResponseDocument.class, req, resp, responseDoc, "ResponseDocument", respCustomizeContext, otherState);
            inMsgCtx.setXmlObject((XmlObject)responseDoc);
            this.cleanUpFedHubMessageStateParams(otherState);
            if (responseType.isSetInResponseTo()) {
                ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)"Request");
                ThreadContext.put((String)AuditLogger.MDC_KEY.IN_XML_MESSAGE.toString(), (String)new XmlMessageLogWrapper(inMsgCtx).toString());
            }
            outMsgCtx.populateOutUrlAuditLogParameter();
            ThreadContext.put((String)AuditLogger.MDC_KEY.RESPONSE_ID.toString(), (String)responseDoc.getResponse().getID());
            ThreadContext.put((String)AuditLogger.MDC_KEY.OUT_XML_MESSAGE.toString(), (String)new XmlMessageLogWrapper(outMsgCtx).toString());
            IdpAuditLogger.setEvent("SSO");
            IdpAuditLogger.setStatus("success");
            IdpAuditLogger.log("issuing assertion...");
        }
    }

    private boolean omitRespSigOnSignedEncryptedAssertion(String partnerEntityId) {
        String listConfigKey = "EntityIdsToOmitResponseSignatureOnSignedEncryptedAssertion";
        List<String> exceptions = this.config.getListValue(listConfigKey, Collections.emptyList());
        return exceptions.contains(partnerEntityId);
    }

    private void setAuditMdcValues(AttributeValue targetResAttr, String inResponseTo) {
        if (targetResAttr != null) {
            IdpAuditLogger.setAppUrl(targetResAttr.getValue());
        }
        if (inResponseTo != null) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.IN_RESPONSE_TO.toString(), (String)inResponseTo);
            ThreadContext.put((String)AuditLogger.MDC_KEY.REQUEST_ID.toString(), (String)inResponseTo);
            ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"SP");
        } else {
            ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"IdP");
        }
    }

    private void setAuditMdcValues(AttributeMap attributes) {
        IdpAuditLogger.setUserName((Map<String, AttributeValue>)attributes);
        IdpAuditLogger.setAttributes(attributes.toString());
    }

    private IdpAuthenticationResult processUserConsentAndLookupAuthn(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState, AuthnPolicy authnPolicy) throws AuthnAdapterException, IOException, StatusResponseException, AuthnProcessorException, AuthorizationException {
        String resumePath;
        SessionStateSupport sss = new SessionStateSupport();
        IdpAuthenticationResult authnResult = (IdpAuthenticationResult)sss.removeAttribute(SESSION_ATTRIBUTE_NAME_AUTHN_RESULT, req, resp);
        if (authnResult == null) {
            resumePath = this.saveState(req, resp, inMsgCtx, outMsgCtx, otherState);
            authnResult = this.adapterSupport.lookupAuthNs(req, resp, authnPolicy, resumePath, otherState, inMsgCtx, outMsgCtx, this, false);
        }
        if (!resp.isCommitted()) {
            String consentGivenParameter = req.getParameter("consentGiven");
            if (StringUtils.isEmpty((String)consentGivenParameter)) {
                sss.setAttribute(SESSION_ATTRIBUTE_NAME_AUTHN_RESULT, (Object)authnResult, req, resp);
                resumePath = this.saveState(req, resp, inMsgCtx, outMsgCtx, otherState);
                ResponseTemplateRenderer consentFormRenderer = ResponseTemplateRenderer.getInstance();
                Map<String, Object> params = new DefaultTemplateParams.Builder(DefaultTemplateParams.Role.IDP).entityId(inMsgCtx.getEntityId()).build();
                params.put("action", resumePath);
                params.put("consentTypeName", CONSENT_TYPE_PARAMETER_NAME);
                params.put("consentTypeValueExplicit", CONSENT_TYPE_VALUE_EXPLICIT);
                params.put("consentTypeValueImplicit", CONSENT_TYPE_VALUE_IMPLICIT);
                params.put("consentTypeValueObtained", CONSENT_TYPE_VALUE_OBTAINED);
                params.put("consentTypeValuePrior", CONSENT_TYPE_VALUE_PRIOR);
                params.put("consentTypeValueUnspecified", CONSENT_TYPE_VALUE_UNSPECIFIED);
                params.put("entityId", inMsgCtx.getEntityId());
                consentFormRenderer.render(req, resp, "consent-form-template.html", params);
            } else if (Boolean.parseBoolean(consentGivenParameter)) {
                String consentTypeParameter;
                ResponseDocument responseDoc = (ResponseDocument)outMsgCtx.getXmlObject();
                ResponseType responseType = responseDoc.getResponse();
                switch (consentTypeParameter = req.getParameter(CONSENT_TYPE_PARAMETER_NAME)) {
                    case "Explicit": {
                        responseType.setConsent("urn:oasis:names:tc:SAML:2.0:consent:current-explicit");
                        break;
                    }
                    case "Implicit": {
                        responseType.setConsent("urn:oasis:names:tc:SAML:2.0:consent:current-implicit");
                        break;
                    }
                    case "Obtained": {
                        responseType.setConsent("urn:oasis:names:tc:SAML:2.0:consent:obtained");
                        break;
                    }
                    case "Prior": {
                        responseType.setConsent("urn:oasis:names:tc:SAML:2.0:consent:prior");
                        break;
                    }
                    case "Unspecified": {
                        responseType.setConsent("urn:oasis:names:tc:SAML:2.0:consent:unspecified");
                        break;
                    }
                }
            } else {
                throw new StatusResponseException(TopLevelStatusCode.RESPONDER, "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "User has not given consent for SSO to the SP.");
            }
        }
        return authnResult;
    }

    private RequestedAuthnContextType evalRequestedAuthnCtx(InMessageContext inMsgCtx, HttpServletRequest req) {
        RequestedAuthnContextType requestedAuthnContext = null;
        String[] requestedAuthnCtxClassRefs = this.EMPTY;
        if (!inMsgCtx.isUnsolicitedResponse()) {
            AuthnRequestDocument authnRequestDoc = (AuthnRequestDocument)inMsgCtx.getXmlObject();
            AuthnRequestType authnRequest = authnRequestDoc.getAuthnRequest();
            if (authnRequest.isSetRequestedAuthnContext()) {
                requestedAuthnContext = authnRequest.getRequestedAuthnContext();
                requestedAuthnCtxClassRefs = requestedAuthnContext.getAuthnContextClassRefArray();
            }
            req.setAttribute("org.sourceid.saml20.adapter.idp.authn.authnCtx", (Object)requestedAuthnCtxClassRefs);
        }
        return requestedAuthnContext;
    }

    private void registerWithCommonDomainService(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherState) {
        HashMap<String, Object> tmpMap = new HashMap<String, Object>(otherState);
        tmpMap.put(COMMON_DOMAIN_SERVICE_FLAG, Boolean.TRUE);
        String resumePath = this.saveState(req, resp, inMsgCtx, outMsgCtx, tmpMap);
        String myEntityId = VirtualIdentityUtil.resolve(inMsgCtx).getVirtualEntityId(DomainMode.RUNTIME);
        String url = CommonDomainUtil.createIdpRegistrationUrl(req, myEntityId, resumePath);
        if (url != null) {
            try {
                resp.sendRedirect(url);
            }
            catch (IOException ex) {
                this.log.warn((Object)("Unable to redirect to " + url + ". " + ex));
            }
        }
    }

    private void encryptAssertion(ConnectionBase connection, ResponseType responseType, AssertionType assertion, Set<String> maskedAttrs) throws StatusResponseException {
        try {
            EncryptedElementType encryptedAssertion = this.encryptionEngine.encryptAssertion(connection, assertion, maskedAttrs);
            responseType.addNewEncryptedAssertion().set((XmlObject)encryptedAssertion);
        }
        catch (NoSuchAlgorithmException | XMLEncryptionException ex) {
            throw new StatusResponseException(TopLevelStatusCode.RESPONDER, MSG_ERROR_ASSERTION_ENCRYPTION, ex);
        }
        catch (NoEncryptionKeyException ex) {
            throw new StatusResponseException(TopLevelStatusCode.RESPONDER, ex.getMessage(), ex);
        }
    }

    private void checkDoPseudonymAsNameId(SpConnection spConnection, IdpAuthenticationResult authnResult, AttributeMap attributes, InMessageContext inMsgCtx) throws PseudonymServiceException, StatusResponseException {
        String requestedFormat = null;
        String requestedSpNameQualifier = null;
        boolean allowCreate = true;
        if (!inMsgCtx.isUnsolicitedResponse()) {
            AuthnRequestDocument authnRequestDoc = (AuthnRequestDocument)inMsgCtx.getXmlObject();
            AuthnRequestType authnRequestType = authnRequestDoc.getAuthnRequest();
            if (authnRequestType.isSetNameIDPolicy()) {
                NameIDPolicyType nameIdPolicyType = authnRequestType.getNameIDPolicy();
                requestedFormat = nameIdPolicyType.getFormat();
                requestedSpNameQualifier = nameIdPolicyType.getSPNameQualifier();
                allowCreate = nameIdPolicyType.getAllowCreate();
            }
        } else {
            requestedFormat = inMsgCtx.getParam("RequestedFormat");
        }
        String nameIdFormatKey = AssertionMapKeys.getNameIdFormatKey();
        String spEntityId = this.metadataDirectory.checkForAffiliations(spConnection.getEntityId());
        String virtualEntityId = VirtualIdentityUtil.resolve((BaseMessageContext)inMsgCtx, spConnection).getVirtualEntityId(DomainMode.RUNTIME);
        this.respSupport.nameId(spEntityId, virtualEntityId, spConnection, authnResult, allowCreate, attributes, requestedFormat);
        AttributeValue attributeValue = (AttributeValue)attributes.get((Object)nameIdFormatKey);
        this.checkRequestedFormat(requestedFormat, attributeValue != null ? attributeValue.getValue() : null);
        this.checkSPNameQualifier(requestedSpNameQualifier, (Map<String, AttributeValue>)attributes, spConnection);
    }

    private void checkRequestedFormat(String requestedFormat, String configuredNameIdFormat) throws StatusResponseException {
        if (!(requestedFormat == null || requestedFormat.equals(configuredNameIdFormat) || requestedFormat.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted") || requestedFormat.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"))) {
            StringBuilder statusMsg = new StringBuilder();
            statusMsg.append("Cannot provide requested name identifier with format ");
            statusMsg.append(requestedFormat);
            statusMsg.append(" for the given subject");
            throw new StatusResponseException(TopLevelStatusCode.REQUESTER, "urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", statusMsg.toString());
        }
    }

    private void checkSPNameQualifier(String requestedSpNameQualifier, Map<String, AttributeValue> attributes, SpConnection spConnection) throws StatusResponseException {
        if (requestedSpNameQualifier != null) {
            AttributeValue spNameQualAttrVal = attributes.get(AssertionMapKeys.getNameIdSpQualifierKey());
            String configuredSpNameQualifier = spNameQualAttrVal != null ? spNameQualAttrVal.getValue() : null;
            boolean found = false;
            if (StringUtils.isBlank((String)configuredSpNameQualifier)) {
                ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
                Collection<Affiliation> affiliations = connectionManager.getAffiliations();
                String entityId = spConnection.getEntityId();
                if (affiliations != null && !affiliations.isEmpty()) {
                    for (Affiliation affiliation : affiliations) {
                        List<String> members = affiliation.getMembers();
                        if (!affiliation.isActive() || members == null || !members.contains(entityId) || !requestedSpNameQualifier.equals(configuredSpNameQualifier = affiliation.getAffiliationId())) continue;
                        attributes.put(AssertionMapKeys.getNameIdSpQualifierKey(), new AttributeValue(requestedSpNameQualifier));
                        found = true;
                        break;
                    }
                }
            }
            if (!found && !requestedSpNameQualifier.equals(configuredSpNameQualifier)) {
                String msg = "Cannot provide requested name identifier qualified with " + requestedSpNameQualifier;
                throw new StatusResponseException(TopLevelStatusCode.REQUESTER, "urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", msg);
            }
        }
    }

    private AuthnPolicy getAuthnPolicy(InMessageContext inMsgCtx) {
        boolean isPassive = false;
        boolean forceAuthn = false;
        List<String> reqContexts = Collections.emptyList();
        List<String> reqContextDecls = Collections.emptyList();
        AuthnContextComparisonType.Enum reqComparisonType = null;
        ProxyScoping proxyScoping = null;
        if (!inMsgCtx.isUnsolicitedResponse()) {
            AuthnRequestDocument authnRequestDoc = (AuthnRequestDocument)inMsgCtx.getXmlObject();
            AuthnRequestType authnReq = authnRequestDoc.getAuthnRequest();
            isPassive = authnReq.isSetIsPassive() && authnReq.getIsPassive();
            forceAuthn = authnReq.isSetForceAuthn() && authnReq.getForceAuthn();
            RequestedAuthnContextType reqAuthnContextType = authnRequestDoc.getAuthnRequest().getRequestedAuthnContext();
            if (reqAuthnContextType != null) {
                reqContexts = Arrays.asList(reqAuthnContextType.getAuthnContextClassRefArray());
                reqContextDecls = Arrays.asList(reqAuthnContextType.getAuthnContextDeclRefArray());
                AuthnContextComparisonType.Enum comparisonType = reqAuthnContextType.getComparison();
                if (comparisonType != null) {
                    reqComparisonType = comparisonType;
                }
            }
            if (authnReq.isSetScoping()) {
                ScopingType scopingType = authnReq.getScoping();
                Integer proxyCount = null;
                LinkedList<String> idpList = null;
                LinkedList<String> requesterIds = null;
                if (scopingType.isSetProxyCount()) {
                    BigInteger bigProxyCount = scopingType.getProxyCount();
                    proxyCount = bigProxyCount.intValue();
                }
                if (scopingType.isSetIDPList()) {
                    idpList = new LinkedList<String>();
                    for (String string : scopingType.getIDPList().getIDPEntryArray()) {
                        idpList.add(string.getProviderID());
                    }
                }
                requesterIds = new LinkedList<String>();
                for (String string : scopingType.getRequesterIDArray()) {
                    requesterIds.add(string);
                }
                requesterIds.add(inMsgCtx.getEntityId());
                proxyScoping = new ProxyScoping(proxyCount, idpList, requesterIds);
            }
        }
        return new AdvancedAuthnPolicy(!isPassive, forceAuthn, reqContexts, reqContextDecls, reqComparisonType, proxyScoping);
    }

    private void processRequestedAssertionConsumerServiceIndex(AuthnRequestOptions requestOptions, SpConnection spConnection, OutMessageContext outMsgCtx) throws StatusResponseException {
        Integer acsIdx = requestOptions.getAssertionConsumerServiceIndex();
        Endpoint requestedAcsEndpoint = spConnection.getAssertionConsumerServiceEndpoint(acsIdx);
        if (requestedAcsEndpoint == null) {
            if (!this.config.getBooleanValue("UseDefaultIfRequestedACSIndexNotFound", false)) {
                String msg = "The requested AssertionConsumerServiceIndex " + acsIdx + " does not exist.";
                throw new StatusResponseException(TopLevelStatusCode.REQUESTER, msg);
            }
        } else {
            outMsgCtx.setBinding(requestedAcsEndpoint.getBinding());
            outMsgCtx.setEndpoint(requestedAcsEndpoint.getFullLocation());
        }
    }

    private void processRequestedAssertionConsumerServiceURL(AuthnRequestOptions requestOptions, SpConnection spConnection, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) throws StatusResponseException {
        String acsURL = requestOptions.getAssertionConsumerServiceURL();
        SignatureStatus signatureStatus = inMsgCtx.getSignatureStatus();
        if (signatureStatus == SignatureStatus.VALID) {
            try {
                new URL(acsURL);
            }
            catch (MalformedURLException e) {
                throw new StatusResponseException(TopLevelStatusCode.REQUESTER, "AssertionConsumerServiceURL must be a valid absolute URL", e);
            }
            outMsgCtx.setEndpoint(acsURL);
        } else if (spConnection.hasAssertionConsumerServiceEndpoint(acsURL)) {
            outMsgCtx.setEndpoint(acsURL);
        } else {
            throw new StatusResponseException(TopLevelStatusCode.REQUESTER, "Unknown AssertionConsumerServiceURL " + acsURL);
        }
    }

    private void processRequestedProtocolBinding(AuthnRequestOptions reqOpts, SpConnection sp, OutMessageContext outMsgCtx) throws StatusResponseException {
        String requestedBinding = reqOpts.getProtocolBinding();
        IndexedEndpoints acss = sp.getAssertionConsumerServiceEndpoints();
        Endpoint endpointByBinding = acss.getEndpointByBinding(requestedBinding);
        if (endpointByBinding == null) {
            String pattern = "ProtocolBinding: {0} disallowed for transport of SSO response.";
            String msg = MessageFormat.format(pattern, requestedBinding);
            throw new StatusResponseException(TopLevelStatusCode.REQUESTER, msg);
        }
        outMsgCtx.setEndpoint(endpointByBinding.getFullLocation());
        outMsgCtx.setBinding(requestedBinding);
    }

    private void validateRequestedSubject(AssertionType assertionType, SubjectType requestedSubject) throws StatusResponseException {
        if (requestedSubject != null) {
            NameIDType nameIDType = requestedSubject.getNameID();
            String requestedSubjectValue = nameIDType.getStringValue();
            String requestedQualifier = nameIDType.getNameQualifier();
            SubjectType authenticatedSubject = assertionType.getSubject();
            NameIDType authenticatedNameIDType = authenticatedSubject.getNameID();
            String authenticatedSubjectValue = authenticatedNameIDType.getStringValue();
            String authenticatedQualifier = authenticatedNameIDType.getNameQualifier();
            boolean subjectMatch = authenticatedSubjectValue.equals(requestedSubjectValue);
            if (!subjectMatch || requestedQualifier != null && !requestedQualifier.equals(authenticatedQualifier)) {
                Object qualifierAndSubject = requestedQualifier == null ? requestedSubjectValue : requestedQualifier + ":" + requestedSubjectValue;
                String statusMessage = "Unable to satisfy the requested subject " + (String)qualifierAndSubject + " from AuthnRequest.";
                throw new StatusResponseException(TopLevelStatusCode.REQUESTER, statusMessage);
            }
        }
    }

    private void processRequestedConditions(AssertionType assertionType, ConditionsType requestedConditionsType, InMessageContext inMsgCtx) {
        SignatureStatus signatureStatus = inMsgCtx.getSignatureStatus();
        if (signatureStatus == SignatureStatus.VALID) {
            ConditionsType conditionsTypeInAssertion = assertionType.getConditions();
            if (requestedConditionsType.isSetNotBefore()) {
                conditionsTypeInAssertion.setNotBefore(requestedConditionsType.getNotBefore());
            }
            if (requestedConditionsType.isSetNotOnOrAfter()) {
                conditionsTypeInAssertion.setNotOnOrAfter(requestedConditionsType.getNotOnOrAfter());
            }
        }
    }

    private boolean checkEncryptedNameIDRequested(InMessageContext inMsgCtx) {
        boolean retV = false;
        if (!inMsgCtx.isUnsolicitedResponse()) {
            AuthnRequestDocument authnRequestDoc = (AuthnRequestDocument)inMsgCtx.getXmlObject();
            AuthnRequestType authnRequestType = authnRequestDoc.getAuthnRequest();
            if (authnRequestType.isSetNameIDPolicy()) {
                NameIDPolicyType nameIdPolicyType = authnRequestType.getNameIDPolicy();
                String requestedFormat = nameIdPolicyType.getFormat();
                retV = "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted".equals(requestedFormat);
            }
        } else {
            retV = "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted".equals(inMsgCtx.getParam("RequestedFormat"));
        }
        return retV;
    }

    @Override
    protected void handleEx(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.handleEx(e, inMsgCtx, outMsgCtx, stateParams, req, resp);
        this.respSupport.handleException(e, inMsgCtx, outMsgCtx, stateParams, req, resp, Role.IDP);
    }

    @Override
    protected boolean isStateAppropriate(State state) {
        OutMessageContext outMsgCtx = state.getOutMsgCtx();
        return outMsgCtx.getXmlObject() instanceof ResponseDocument;
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return Protocol.SAML20.toString();
    }

    @Override
    public void resumeAuthn(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws IOException {
        try {
            this.resume(inMsgCtx, req, resp, outMsgCtx, otherState);
        }
        catch (Exception e) {
            this.handleException(req, resp, inMsgCtx, outMsgCtx, otherState, e);
        }
    }

    public void cleanUpFedHubMessageStateParams(Map<String, Object> stateParams) {
        stateParams.remove("FEDHUB_IN_REQ_CONTEXT");
        stateParams.remove("FEDHUB_IN_RESP_CONTEXT");
        stateParams.remove("FEDHUB_OUT_REQ_CONTEXT");
    }
}

