/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.HandleLogoutRequestBase;
import org.sourceid.saml20.profiles.PartnerLogoutManager;
import org.sourceid.saml20.profiles.ProfileProcessorMatrix;
import org.sourceid.saml20.profiles.SpPartnerLogoutManager;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.Session;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.xmlbinding.protocol.LogoutRequestDocument;
import org.sourceid.saml20.xmlbinding.protocol.LogoutRequestType;
import org.sourceid.saml20.xmlbinding.protocol.LogoutResponseDocument;
import org.sourceid.saml20.xmlbinding.protocol.StatusResponseType;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.IdpPartnerLogoutManager;
import org.sourceid.websso.profiles.LogoutResult;
import org.sourceid.websso.profiles.ProtocolResponseObject;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.idp.InvisibleSloTemplateRenderer;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.websso.wrapper.XmlMessageLogWrapper;

public class HandleLogoutRequest
extends HandleLogoutRequestBase {
    public final String RESUME_PATH_QUALIFIER = "/req";
    private final ProfileProcessorMatrix profileProcessorMatrix = ProfileProcessorMatrix.getInstance();
    private final SLOSupport sloSupport = new SLOSupport(this.localMetaData);

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        String[] sessionIndexArray;
        String[] notOnOrAfter;
        Date now;
        String spEntityId = inMsgCtx.getEntityId();
        LogoutRequestDocument logoutRequestDoc = (LogoutRequestDocument)inMsgCtx.getXmlObject();
        LogoutRequestType logoutRequest = logoutRequestDoc.getLogoutRequest();
        if (logoutRequest.isSetNotOnOrAfter() && !(now = new Date()).before((Date)(notOnOrAfter = logoutRequest.getNotOnOrAfter().getTime()))) {
            String msg = "NotOnOrAfter attribute of the logout request message has past";
            throw new StatusResponseException(TopLevelStatusCode.REQUESTER, msg);
        }
        if (logoutRequest.sizeOfSessionIndexArray() == 0) {
            String msg = "Missing SessionIndex: session participants MUST include at least one <SessionIndex> element in the logout request";
            throw new StatusResponseException(TopLevelStatusCode.REQUESTER, msg);
        }
        for (String sessionIndex : sessionIndexArray = logoutRequest.getSessionIndexArray()) {
            TrackingIdSupport.addReference(sessionIndex);
        }
        Map<IdpHashableAuthnBean, Collection<Session>> beansAndSessions = IdpSessionRegistrySupport.getRegisteredForAssertionIds(sessionIndexArray);
        if (beansAndSessions.isEmpty()) {
            String statusMessage = "Unable to resolve local session(s) to fulfill logout request";
            throw new StatusResponseException(TopLevelStatusCode.RESPONDER, statusMessage);
        }
        this.prepareSecurityAuditLog(beansAndSessions, spEntityId);
        this.securityAuditLog(inMsgCtx, outMsgCtx);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("success", true);
        if (!inMsgCtx.isBackChannelBinding()) {
            IdpSessionRegistrySupport.checkLogSessionDeleted(req, resp);
            this.sloSupport.checkRevokeUserSession(req, resp);
            IdpSessionRegistrySupport.deleteStoredSessions(req, resp, null);
            this.sloSupport.terminateAndUnregisterIrsmSessions(beansAndSessions, req, resp);
            InvisibleSloTemplateRenderer renderer = new InvisibleSloTemplateRenderer(req, resp);
            params.putAll(renderer.getParams());
        }
        Collection storedSessionGroupIds = beansAndSessions.keySet().stream().map(IdpHashableAuthnBean::getStoredSessionGroupId).filter(Objects::nonNull).collect(Collectors.toSet());
        IdpSessionRegistrySupport.deleteStoredSessions(storedSessionGroupIds);
        IdpSessionRegistrySupport.setInvalidForSso(beansAndSessions.keySet());
        this.setStage(params, HandleLogoutRequestBase.ProcessingStage.LOGGING_OUT_IDP_ADAPTERS);
        this.addIdpBeansToParams(beansAndSessions.keySet(), params);
        Collection<SpHashableAuthnBean> spBeans = this.getSpAdapterBeans(beansAndSessions.keySet());
        this.addSpBeansToParams(spBeans, params);
        this.resume(inMsgCtx, req, resp, outMsgCtx, params);
    }

    private void prepareSecurityAuditLog(Map<IdpHashableAuthnBean, Collection<Session>> beansAndSessions, String spEntityId) {
        Collection<WebSsoSession> issuedSessions = null;
        IdpHashableAuthnBean bean = null;
        Map<IdpHashableAuthnBean, Collection<WebSsoSession>> beansAndWebSsoSessions = this.sloSupport.getWebSsoSessions(beansAndSessions);
        if (beansAndWebSsoSessions != null && !beansAndWebSsoSessions.isEmpty()) {
            bean = beansAndWebSsoSessions.keySet().iterator().next();
            issuedSessions = beansAndWebSsoSessions.get(bean);
        }
        if (issuedSessions != null && !issuedSessions.isEmpty()) {
            WebSsoSession session = (WebSsoSession)issuedSessions.iterator().next();
            IdpAuditLogger.setEvent("SLO");
            IdpAuditLogger.setProtocol(Protocol.SAML20.toString());
            if (session.isMaskUserName()) {
                IdpAuditLogger.setUserName("*****");
            } else {
                IdpAuditLogger.setUserName(session.getNameId());
            }
            IdpAuditLogger.setPartnerId(spEntityId);
            IdpAuditLogger.setVirtualServerId(session.getVirtualServerId());
        }
    }

    private void securityAuditLog(InMessageContext inMsgCtx, OutMessageContext outMsgCtx) {
        ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"SP");
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString(), (String)"Request");
        ThreadContext.put((String)AuditLogger.MDC_KEY.IN_XML_MESSAGE.toString(), (String)new XmlMessageLogWrapper(inMsgCtx).toString());
        if (outMsgCtx != null) {
            StatusResponseType responseType;
            outMsgCtx.populateOutUrlAuditLogParameter();
            ThreadContext.put((String)AuditLogger.MDC_KEY.OUT_XML_MESSAGE.toString(), (String)new XmlMessageLogWrapper(outMsgCtx).toString());
            LogoutResponseDocument responseDoc = (LogoutResponseDocument)outMsgCtx.getXmlObject();
            if (responseDoc != null && (responseType = responseDoc.getLogoutResponse()) != null) {
                ThreadContext.put((String)AuditLogger.MDC_KEY.RESPONSE_ID.toString(), (String)responseType.getID());
                String inResponseTo = responseType.isSetInResponseTo() ? responseType.getInResponseTo() : null;
                ThreadContext.put((String)AuditLogger.MDC_KEY.REQUEST_ID.toString(), (String)inResponseTo);
                ThreadContext.put((String)AuditLogger.MDC_KEY.IN_RESPONSE_TO.toString(), (String)inResponseTo);
            }
        }
        IdpAuditLogger.log("SP-initiated logout...");
        ThreadContext.remove((String)AuditLogger.MDC_KEY.IN_MESSAGE_TYPE.toString());
        ThreadContext.remove((String)AuditLogger.MDC_KEY.IN_XML_MESSAGE.toString());
        ThreadContext.remove((String)AuditLogger.MDC_KEY.RESPONSE_ID.toString());
        ThreadContext.remove((String)AuditLogger.MDC_KEY.IN_RESPONSE_TO.toString());
    }

    @Override
    protected void doResume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> params) throws StatusResponseException, AuthnAdapterException, IOException {
        boolean suspend = false;
        block7: while (!suspend) {
            HandleLogoutRequestBase.ProcessingStage stage = this.getStage(params);
            switch (stage) {
                case LOGGING_OUT_IDP_ADAPTERS: {
                    if (this.logoutIdpAdapters(inMsgCtx, req, resp, outMsgCtx, params)) {
                        this.setStage(params, HandleLogoutRequestBase.ProcessingStage.LOGGING_OUT_IDP_PARTNERS);
                        continue block7;
                    }
                    suspend = true;
                    continue block7;
                }
                case LOGGING_OUT_IDP_PARTNERS: {
                    if (this.logoutIdpPartners(inMsgCtx, req, resp, outMsgCtx, params)) {
                        this.setStage(params, HandleLogoutRequestBase.ProcessingStage.LOGGING_OUT_SP_ADAPTERS);
                        continue block7;
                    }
                    suspend = true;
                    continue block7;
                }
                case LOGGING_OUT_SP_ADAPTERS: {
                    if (this.logoutSpAdapters(inMsgCtx, req, resp, outMsgCtx, params)) {
                        this.setStage(params, HandleLogoutRequestBase.ProcessingStage.LOGGING_OUT_SP_PARTNERS);
                        continue block7;
                    }
                    suspend = true;
                    continue block7;
                }
                case LOGGING_OUT_SP_PARTNERS: {
                    if (this.logoutSpPartners(inMsgCtx, req, resp, outMsgCtx, params)) {
                        this.setStage(params, HandleLogoutRequestBase.ProcessingStage.DONE);
                        continue block7;
                    }
                    suspend = true;
                    continue block7;
                }
                case DONE: {
                    this.finishLogout(inMsgCtx, outMsgCtx, req, resp, params);
                    suspend = true;
                    continue block7;
                }
            }
            throw new IllegalStateException("Unexpected processing stage: " + stage);
        }
    }

    @Override
    protected void doResumeFromResponse(ProtocolResponseObject responseObject, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, HttpServletRequest req, HttpServletResponse resp, State originalState) {
        LogoutResult logoutResult = (LogoutResult)responseObject;
        PartnerLogoutManager logoutManager = this.getStage(originalState.getParameters()) == HandleLogoutRequestBase.ProcessingStage.LOGGING_OUT_IDP_PARTNERS ? IdpPartnerLogoutManager.forSaml(originalState.getParameters()) : new SpPartnerLogoutManager(originalState.getParameters());
        logoutManager.handleLogoutResult(logoutResult);
        this.copyLogoutStatusFromManager(logoutManager, originalState.getParameters());
    }

    protected void finishLogout(InMessageContext inMsgCtx, OutMessageContext outMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws StatusResponseException {
        InvisibleSloTemplateRenderer templateSupport = new InvisibleSloTemplateRenderer(params);
        if (templateSupport.checkRenderTemplate() && !templateSupport.isTemplateRendered()) {
            String resumePath = this.saveState(req, resp, inMsgCtx, outMsgCtx, params);
            templateSupport.renderTemplate(resumePath, resumePath, req, resp);
            return;
        }
        if (!((Boolean)params.get("success")).booleanValue()) {
            throw new StatusResponseException(TopLevelStatusCode.SUCCESS, "urn:oasis:names:tc:SAML:2.0:status:PartialLogout", "Not all sessions for indicated subject and session index(es) were successfully terminated");
        }
    }

    @Override
    protected ConnectionBase getPartnerMetadata(InMessageContext inMsgCtx) {
        SpConnection conn = MetadataSupport.getSpConnection(inMsgCtx.getEntityId());
        this.profileProcessorMatrix.verifyProcessorEnablement(7, conn.getEnabledProfiles());
        return conn;
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return "/req";
    }
}

