/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.idp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.profiles.ResumableResponseHandlerBase;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.LogoutResult;
import org.sourceid.websso.profiles.LogoutResultHandler;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.SloHandler;
import org.sourceid.websso.profiles.sp.ResumeRequestFromResponseSupport;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class HandleLogoutResponse
extends ResumableResponseHandlerBase
implements SloHandler {
    private final SLOSupport sloSupport;
    public static final String RESUME_PATH_QUALIFIER = "/resp";
    private LogoutResultHandler resultHandler;

    public HandleLogoutResponse() {
        this.sloSupport = new SLOSupport(this.localMetaData);
    }

    public void setResultHandler(LogoutResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    @Override
    protected void doProcess(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws InvalidResponseException, IOException, ProcessRuntimeException, RenderPageException {
        if (!this.forwardToTarget(new LogoutResult(true, null), respMsgCtx, reqMsgCtx, req, resp)) {
            String problem = "Missing original request for logout response";
            this.sloSupport.finishLocalLogout(false, null, req, resp, Arrays.asList(problem), true);
        }
    }

    @Override
    protected void handleException(InvalidResponseException e, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderPageException {
        if (!this.forwardToTarget(new LogoutResult(false, e.getMessage()), respMsgCtx, reqMsgCtx, req, resp)) {
            this.sloSupport.finishLocalLogout(false, null, req, resp, Arrays.asList(e.getMessage()), true);
        }
    }

    @Override
    protected void doResume(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> otherState) throws IOException, GeneralAdapterException, GeneralServiceException {
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return RESUME_PATH_QUALIFIER;
    }

    private boolean forwardToTarget(LogoutResult logoutResult, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.resultHandler != null) {
            this.resultHandler.handleLogoutResult(logoutResult);
            return true;
        }
        return ResumeRequestFromResponseSupport.resumeRequestFromResponse(logoutResult, respMsgCtx, reqMsgCtx, req, resp);
    }
}

