/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.AttributeAuthority;
import org.sourceid.saml20.domain.AttributeNameMapping;
import org.sourceid.saml20.domain.DNtoIdPMappings;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.DNtoIdPMappingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.encryption.EncryptionEngine;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.protocol.RequestAbstractTypeUtil;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.wrapper.SignaturePolicy;
import org.sourceid.saml20.xmlbinding.assertion.AttributeType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectType;
import org.sourceid.saml20.xmlbinding.protocol.AttributeQueryDocument;
import org.sourceid.saml20.xmlbinding.protocol.AttributeQueryType;
import org.sourceid.saml20.xmlbinding.protocol.RequestAbstractType;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;
import org.sourceid.websso.wrapper.OutMessageContext;

public class AttributeQueryCreatorSupport {
    private static final DNtoIdPMappingsManager IDP_MAPPINGS_MGR = MgmtFactory.getDNtoIdPMappingsManager();
    private String idpEntityId = null;
    private String subject = null;
    private String issuer = null;
    private String[] attrNames = null;
    private String nameIdFormat = null;

    public String[] getAttrNames() {
        return this.attrNames;
    }

    public void setAttrNames(String[] attrNames) {
        this.attrNames = attrNames;
    }

    public String getIdpEntityId() {
        return this.idpEntityId;
    }

    public void setIdpEntityId(String idpEntityId) {
        this.idpEntityId = idpEntityId;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    public void setNameIdFormat(String nameIdFormat) {
        this.nameIdFormat = nameIdFormat;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public OutMessageContext makeAttributeQuery(HttpServletRequest req) {
        OutMessageContext outMsgCtx = new OutMessageContext(Role.IDP);
        if (this.nameIdFormat == null) {
            this.nameIdFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        }
        if (StringUtils.isBlank((String)this.idpEntityId) && "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName".equals(this.nameIdFormat)) {
            DNtoIdPMappings dNtoIdPMappings = IDP_MAPPINGS_MGR.get(true);
            this.idpEntityId = dNtoIdPMappings.getIdpId(this.issuer, this.subject);
        }
        if (StringUtils.isBlank((String)this.idpEntityId)) {
            String msg = "'PartnerIdpId' is a required parameter for invoking: " + req.getRequestURL();
            String[] errorDetailParameters = new String[]{"PartnerIdpId", req.getRequestURL().toString()};
            throw new InvalidRequestParameterException(msg, "errorDetail.makeAttributeQuery.missingRequiredParameter.idpEntityId", errorDetailParameters);
        }
        IdpConnection idp = MetadataSupport.getIdpConnection(this.idpEntityId);
        AttributeAuthority attributeAuthority = idp.getAttributeAuthority();
        Endpoint attributeServiceEndPt = attributeAuthority.getAttributeService();
        outMsgCtx.setEndpoint(attributeServiceEndPt.getFullLocation());
        outMsgCtx.setBinding(attributeServiceEndPt.getBinding());
        outMsgCtx.setEntityId(this.idpEntityId);
        outMsgCtx.setSignaturePolicy(attributeAuthority.isSignAttributeQuery() ? SignaturePolicy.SIGN : SignaturePolicy.DO_NOT_SIGN);
        outMsgCtx.setVirtualServerId(VirtualIdentityUtil.getDefaultVirtualIdForRuntime(idp).getVirtualEntityId(DomainMode.RUNTIME));
        AttributeQueryDocument attrQueryDoc = AttributeQueryDocument.Factory.newInstance();
        AttributeQueryType attrQueryType = attrQueryDoc.addNewAttributeQuery();
        RequestAbstractTypeUtil.setDefaults((RequestAbstractType)attrQueryType, VirtualIdentityUtil.resolve(idp, req).getVirtualEntityId(DomainMode.RUNTIME));
        SubjectType subjectType = attrQueryType.addNewSubject();
        NameIDType nameIDType = subjectType.addNewNameID();
        nameIDType.setFormat(this.nameIdFormat);
        nameIDType.setStringValue(this.subject);
        if (!StringUtils.isBlank((String)this.issuer)) {
            nameIDType.setNameQualifier(this.issuer);
        }
        if (attributeAuthority.isEncryptNameId()) {
            EncryptionEngine encryptor = GlobalRegistry.getService(EncryptionEngine.class);
            try {
                EncryptedElementType encryptedElementType = encryptor.encryptNameID(idp, nameIDType);
                subjectType.unsetNameID();
                subjectType.setEncryptedID(encryptedElementType);
            }
            catch (Exception e) {
                throw new ProcessRuntimeException("Unable to encrypt NameIdentifier", e);
            }
        }
        if (this.attrNames != null) {
            AttributeNameMapping attributeNameMapping = attributeAuthority.getAttributeNameMapping();
            List<String> translatedNames = attributeNameMapping.mapToIdpAttributeNames(this.attrNames);
            for (String name : translatedNames) {
                AttributeType attributeType = attrQueryType.addNewAttribute();
                attributeType.setName(name);
            }
        }
        outMsgCtx.setXmlObject((XmlObject)attrQueryDoc);
        return outMsgCtx;
    }
}

