/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.common.security.LockingService;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.auth.BasicAuth;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.AppAuthMap;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AppAuthMapManagerImpl;
import org.sourceid.saml20.profiles.sp.AttributeQueryCreatorSupport;
import org.sourceid.websso.profiles.RequestCreatorBase;
import org.sourceid.websso.servlet.reqparam.ProprietaryURLParams;
import org.sourceid.websso.wrapper.OutMessageContext;

public class CreateAttrQuery
extends RequestCreatorBase {
    private static final LockingService accountLockingService = MgmtFactory.getAccountLockingService().getInstance(BasicAuth.class.getName());
    private static final AppAuthMapManagerImpl appAuthMapMgr = new AppAuthMapManagerImpl();
    protected static final String ATTRIBUTE_QUERY_REQUEST = "attribute-query-request";
    private final boolean disallowQueryString;

    public CreateAttrQuery() {
        ConfigStore config = ConfigStoreFarm.getConfig(ATTRIBUTE_QUERY_REQUEST);
        this.disallowQueryString = config.getBooleanValue("disallowQueryString", true);
    }

    @Override
    public OutMessageContext doProcess(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String appId = req.getParameter("AppId");
        String sharedSecret = req.getParameter("SharedSecret");
        String loginKey = AccountLockingService.getUserKey(req.getRemoteAddr(), appId);
        AppAuthMap appAuthMap = appAuthMapMgr.getAttributeQueryMap();
        String errorMessage = null;
        if (!appAuthMap.isActive()) {
            errorMessage = "Attribute Query Service is not active.";
        } else if (StringUtils.isEmpty((String)appId)) {
            errorMessage = "AppId is a required parameter and has not been defined.";
        } else if (StringUtils.isEmpty((String)sharedSecret)) {
            errorMessage = "SharedSecret is a required parameter and has not been defined.";
        } else if (this.queryStringContainsSharedSecret(req)) {
            errorMessage = "SharedSecret MUST NOT be sent as part of the query string.";
        } else if (accountLockingService.isLocked(loginKey)) {
            errorMessage = "Too many failed logins, account temporarily locked";
        } else if (!appAuthMap.authenticate(appId, sharedSecret)) {
            accountLockingService.logFailedLogin(loginKey);
            if (accountLockingService.isLocked(loginKey)) {
                errorMessage = "Too many failed logins, account temporarily locked";
            } else {
                String msg = "Unable to authenticate to Attribute Query Service. Verify that %s and %s are correct.";
                errorMessage = String.format(msg, "AppId", "SharedSecret");
            }
        }
        if (errorMessage != null) {
            this.log.info((Object)(errorMessage + " Client IP: " + req.getRemoteAddr()));
            resp.sendError(401);
            return null;
        }
        accountLockingService.clearFailedLogins(loginKey);
        this.log.info((Object)("Application " + appId + " is authenticated. Client IP: " + req.getRemoteAddr()));
        String idpEntityId = ProprietaryURLParams.getParam(req, "PartnerIdpId");
        String subject = ProprietaryURLParams.getRequiredReqParam(req, "Subject");
        String issuer = ProprietaryURLParams.getParam(req, "Issuer");
        String[] attrNames = req.getParameterValues("RequestedAttrName");
        String nameIdFormat = ProprietaryURLParams.getParam(req, "Format");
        AttributeQueryCreatorSupport supporter = new AttributeQueryCreatorSupport();
        supporter.setIdpEntityId(idpEntityId);
        supporter.setSubject(subject);
        supporter.setIssuer(issuer);
        supporter.setAttrNames(attrNames);
        supporter.setNameIdFormat(nameIdFormat);
        return supporter.makeAttributeQuery(req);
    }

    private boolean queryStringContainsSharedSecret(HttpServletRequest request) {
        boolean result = false;
        if (this.disallowQueryString && StringUtils.isNotBlank((String)request.getQueryString())) {
            Map<String, String> queryStringMap = Util.parseQueryString(request.getQueryString(), true);
            result = queryStringMap.containsKey("SharedSecret");
        }
        return result;
    }
}

