/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.sdk.DeviceSharingType;
import com.pingidentity.session.quotas.exception.SessionQuotaException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.SignatureResult;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.sp.authn.SsoContext;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.encryption.EncryptionEngine;
import org.sourceid.saml20.encryption.EncryptionSupport;
import org.sourceid.saml20.encryption.NoEncryptionKeyException;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.ProfileProcessorMatrix;
import org.sourceid.saml20.profiles.ResumableResponseHandlerBase;
import org.sourceid.saml20.profiles.sp.SLOSupport;
import org.sourceid.saml20.profiles.sp.SpAdapterSupport;
import org.sourceid.saml20.profiles.sp.SpAdapterSupportBase;
import org.sourceid.saml20.protocol.AssertionAssembler;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.protocol.AssertionTypeUtil;
import org.sourceid.saml20.protocol.ValidateWebSsoResponse;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.wrapper.WebSsoResponse;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.AttributeStatementType;
import org.sourceid.saml20.xmlbinding.assertion.AttributeType;
import org.sourceid.saml20.xmlbinding.assertion.AuthnStatementType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedIDDocument;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectType;
import org.sourceid.saml20.xmlbinding.protocol.AuthnRequestDocument;
import org.sourceid.saml20.xmlbinding.protocol.ResponseDocument;
import org.sourceid.saml20.xmlbinding.protocol.ResponseType;
import org.sourceid.util.AuthenticationContextUtil;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.InvalidSsoResponseException;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.sp.IdpIdCookieSupport;
import org.sourceid.websso.profiles.sp.ProvisioningProcessor;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.profiles.sp.SsoRespSupport;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.w3c.dom.Node;

public class HandleAuthnResponse
extends ResumableResponseHandlerBase {
    private static final String KEY_SSO_RESP = "rsp";
    private static final String ENCRYPTED_ID_NODE_NAME = "EncryptedID";
    private static final String CFG_DECRYPT_ENCRYPTED_ID_IN_ATTRIBUTE = "DecryptEncryptedIdInAttribute";
    private static final boolean CFG_DECRYPT_ENCRYPTED_ID_IN_ATTRIBUTE_DEFAULT_VALUE = true;
    static final String REQ_ATTR_KEY_ASSERTION_SIG = "AssertionSigsVerified";
    private final AssertionAssembler assertionAssembler = new AssertionAssembler();
    private final ValidateWebSsoResponse validateWebSsoResponse = new ValidateWebSsoResponse();
    private final ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private final ProfileProcessorMatrix profileProcessorMatrix = ProfileProcessorMatrix.getInstance();
    private final EncryptionEngine encryptionEngine = GlobalRegistry.getService(EncryptionEngine.class);
    private final AssertionTypeUtil assertionTypeUtil = new AssertionTypeUtil();
    private final SsoRespSupport ssoRespSupport = new SsoRespSupport(this.localMetaData);
    private final ProvisioningProcessor provisioningProcessor = new ProvisioningProcessor();
    private final SpAdapterSupport spAdapterSupport = new SpAdapterSupport();
    private final SLOSupport sloSupport = new SLOSupport();

    @Override
    protected void doProcess(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws InvalidResponseException, IOException {
        String binding = respMsgCtx.getBinding();
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(binding) && this.config.getBooleanValue("EnforceRedirectNotAllowed", true)) {
            throw new InvalidSsoResponseException("The HTTP Redirect binding MUST NOT be used (for an SSO Response), as the response will typically exceed the URL length permitted by most user agents.");
        }
        if (respMsgCtx.isBackChannelBinding()) {
            throw new InvalidSsoResponseException("A back channel binding (" + respMsgCtx.getBinding() + ") cannot be used to send an SSO response.");
        }
        String requestId = null;
        if (!respMsgCtx.isUnsolicitedResponse()) {
            AuthnRequestDocument authnRequestDoc = (AuthnRequestDocument)reqMsgCtx.getXmlObject();
            requestId = authnRequestDoc.getAuthnRequest().getID();
        }
        ConnectionBase connection = MetadataSupport.getBaseConnectionMetadata(respMsgCtx);
        List<String> myEntityIds = VirtualIdentityUtil.getAllowedAudiences(respMsgCtx, connection);
        String myAcs = req.getRequestURL().toString();
        boolean sigsChecked = req.getAttribute(REQ_ATTR_KEY_ASSERTION_SIG) != null;
        WebSsoResponse webSsoResp = this.validateWebSsoResponse.validateResponse(respMsgCtx, myEntityIds, sigsChecked, myAcs, requestId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_SSO_RESP, webSsoResp);
        this.resume(respMsgCtx, reqMsgCtx, req, resp, params);
    }

    @Override
    protected void doResume(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException, GeneralAdapterException, GeneralServiceException {
        AssertionType ssoAssertion;
        String partnerEntityId = respMsgCtx.getEntityId();
        SpAuditLogger.setPartnerId(partnerEntityId);
        SsoContext ssoContext = (SsoContext)params.get("ssoctx");
        SsoContext tempSsoContext = (SsoContext)params.get("tmpssoctx");
        WebSsoResponse webSsoResp = (WebSsoResponse)params.get(KEY_SSO_RESP);
        IdpConnection idpConnection = MetadataSupport.getIdpConnection(partnerEntityId);
        SpAuditLogger.setProtocol(idpConnection.getProtocol().toString());
        LicenseManager.checkLicenseForConnection(idpConnection);
        if (respMsgCtx.isUnsolicitedResponse()) {
            ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"IdP");
            EnabledProfiles profs = idpConnection.getEnabledProfiles();
            this.profileProcessorMatrix.verifyProcessorEnablement(2, profs);
        } else {
            ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"SP");
        }
        IdpIdCookieSupport.writeIdpIdCookie(resp, partnerEntityId);
        TargetSessionId targetId = this.ssoRespSupport.getTargetSessionIdFromCtx(reqMsgCtx, idpConnection);
        String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)respMsgCtx, idpConnection).getVirtualEntityId(DomainMode.RUNTIME);
        SpAuditLogger.setVirtualServerId(virtualServerId);
        if (tempSsoContext == null) {
            ssoAssertion = webSsoResp.getSsoAssertion().getAssertionType();
            List otherValidAssertionTypes = Collections.emptyList();
            List<Assertion> otherValidAssertions = webSsoResp.getOtherValidAssertions();
            if (!otherValidAssertions.isEmpty()) {
                otherValidAssertionTypes = new ArrayList(otherValidAssertions.size());
                for (Assertion ass : otherValidAssertions) {
                    otherValidAssertionTypes.add(ass.getAssertionType());
                }
            }
            String targetUrl = this.ssoRespSupport.getTargetUri(reqMsgCtx, respMsgCtx);
            targetId = this.ssoRespSupport.getTargetSessionId(targetId, targetUrl, idpConnection, virtualServerId);
            params.put("targetsessionid", targetId);
            tempSsoContext = new SsoContext(null, ssoAssertion, otherValidAssertionTypes, partnerEntityId, targetUrl);
            params.put("tmpssoctx", tempSsoContext);
        }
        if (targetId == null) {
            targetId = (TargetSessionId)params.get("targetsessionid");
        }
        if (targetId == null) {
            this.ssoRespSupport.finishAndRedirect(req, resp, respMsgCtx.getTargetResource(), partnerEntityId, true);
            return;
        }
        SpAuditLogger.setTargetSessionId(targetId);
        if (ssoContext == null) {
            ssoAssertion = tempSsoContext.getSsoAssertion();
            IdpConnHashableAuthnBean idpConnBean = (IdpConnHashableAuthnBean)params.get("idpConnBean");
            if (idpConnBean == null) {
                Set<String> maskedAttributeNames = idpConnection.getMaskedAttributeNames();
                AttributeMap assertionAttributes = this.assertionAssembler.disassemble(webSsoResp, maskedAttributeNames);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Incoming Assertion Attributes: " + assertionAttributes));
                }
                List<String> authnAuthorities = SpAdapterSupportBase.retrieveAuthenticatingAuthorities(idpConnection, ssoAssertion, null, false);
                AttributeValue authnCtxAttributeValue = (AttributeValue)assertionAttributes.get((Object)AssertionMapKeys.getAuthnCtxKey());
                if (authnCtxAttributeValue != null) {
                    AuthenticationContextUtil.performRemoteToLocalMapping(idpConnection, assertionAttributes, authnCtxAttributeValue, AssertionMapKeys.getAuthnCtxKey());
                }
                DeviceSharingType deviceSharingType = this.ssoRespSupport.getDeviceSharingTypeFromCtx(reqMsgCtx);
                IdpConnAuthnSourceKey authnSourceKey = new IdpConnAuthnSourceKey(idpConnection.getId());
                idpConnBean = new IdpConnHashableAuthnBean(assertionAttributes, StateMgmtFactory.getLocalSessionId(req, resp), (AuthnSourceKey)authnSourceKey, partnerEntityId, this.ssoRespSupport.getRequestedUserIdFromCtx(reqMsgCtx), virtualServerId, authnAuthorities, this.assertionTypeUtil.getSessionIndex(ssoAssertion), ssoAssertion.getSubject().getNameID(), deviceSharingType);
                params.put("idpConnBean", idpConnBean);
            }
            if (idpConnBean.getAssertionAttrs() != null) {
                SpAuditLogger.setAttributes(idpConnBean.getAssertionAttrs().toString());
            }
            if (this.ssoRespSupport.accountLinking(idpConnection, virtualServerId, idpConnBean.getAssertionAttrs(), respMsgCtx, params, targetId, tempSsoContext.getTargetResourceUrl(), req, resp, reqMsgCtx, this)) {
                return;
            }
            if (idpConnection.getUserProvisioning() != null) {
                this.provisioningProcessor.process(req, resp, idpConnection, idpConnBean.getAssertionAttrs());
            }
            SpAuditLogger.setUserName((Map<String, AttributeValue>)idpConnBean.getAssertionAttrs());
            boolean checkRegisterForSso = !this.hasOneTimeUseAssertion(tempSsoContext);
            try {
                IdpSessionRegistrySupport.checkRegisterAuthnBean(req, resp, this.ssoRespSupport.getOriginalStateParams(reqMsgCtx, params), idpConnBean, this.getSessionNotOnOrAfterMillis(webSsoResp.getAuthnStatementType()), checkRegisterForSso, false);
            }
            catch (SessionQuotaException e) {
                throw new GeneralServiceException("Session limit exceeded.");
            }
            if (!StringUtils.isBlank((String)tempSsoContext.getTargetResourceUrl()) && idpConnBean.getAssertionAttrs().get((Object)"TargetResource") == null) {
                idpConnBean.getAssertionAttrs().put("TargetResource", tempSsoContext.getTargetResourceUrl());
            }
            String authnResponseAssertionKey = AssertionMapKeys.getAuthnResponseAssertionKey();
            if (idpConnection.getAttributeContract().attributeExists(authnResponseAssertionKey)) {
                if (idpConnBean.getAssertionAttrs().get((Object)authnResponseAssertionKey) == null) {
                    AttributeValue ssoAssertionAttributeValue = AttrValueSupport.make((Object)ssoAssertion);
                    ssoAssertionAttributeValue.setMasked(idpConnection.getMaskedAttributeNames().contains(authnResponseAssertionKey));
                    idpConnBean.getAssertionAttrs().put(authnResponseAssertionKey, ssoAssertionAttributeValue);
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("SAML response already contains an attribute with name '" + authnResponseAssertionKey + "'. The existing attribute from SAML Response will be used."));
                }
            }
            String authnCtx = this.ssoRespSupport.getAuthnCtx(idpConnBean);
            AttributeMap contextAttributes = this.ssoRespSupport.makeIdpConnContextAttributes(idpConnBean, req);
            if (this.ssoRespSupport.isResumeOtherHandler(reqMsgCtx, req, resp, idpConnBean, contextAttributes)) {
                return;
            }
            AttributeMap mappedAttributes = this.ssoRespSupport.executeIdpConnMapping(idpConnection, idpConnBean.getAssertionAttrs(), targetId, contextAttributes);
            List others = tempSsoContext.getOtherValidAssertions();
            String targetUrl = tempSsoContext.getTargetResourceUrl();
            Date authnInst = this.ssoRespSupport.getAuthnInst(idpConnBean.getAssertionAttrs());
            ssoContext = new SsoContext(mappedAttributes, ssoAssertion, others, partnerEntityId, targetUrl, authnCtx, authnInst);
            params.put("ssoctx", ssoContext);
            params.remove(KEY_SSO_RESP);
        }
        String resumePath = this.saveState(req, resp, respMsgCtx, reqMsgCtx, params);
        SpHashableAuthnBean authnBean = this.spAdapterSupport.createAuthN(ssoContext, req, resp, targetId, resumePath, reqMsgCtx, respMsgCtx, (IdpConnHashableAuthnBean)params.get("idpConnBean"));
        if (SpAdapterSupportBase.isCreateAuthnComplete(req, resp)) {
            if (this.sloSupport.checkRegisterSpAuthnBean(idpConnection, targetId)) {
                AssertionType ssoAssertion2 = ssoContext.getSsoAssertion();
                SpSessionRegistrySupport.registerSessionReceived(authnBean, ssoAssertion2, partnerEntityId, respMsgCtx.getVirtualServerId());
            }
            this.ssoRespSupport.finishAndRedirect(req, resp, ssoContext, false);
        }
    }

    protected boolean hasOneTimeUseAssertion(SsoContext ssoContext) {
        ArrayList<AssertionType> allAssertions = new ArrayList<AssertionType>();
        if (ssoContext.getSsoAssertion() != null) {
            allAssertions.add(ssoContext.getSsoAssertion());
        }
        if (ssoContext.getOtherValidAssertions() != null) {
            allAssertions.addAll(ssoContext.getOtherValidAssertions());
        }
        return this.assertionTypeUtil.hasOneTimeUseAssertion(allAssertions);
    }

    protected Long getSessionNotOnOrAfterMillis(AuthnStatementType statement) {
        Calendar cal = statement.getSessionNotOnOrAfter();
        if (cal == null) {
            return null;
        }
        return cal.getTimeInMillis();
    }

    @Override
    protected void checkIssuer(OutMessageContext reqMsgCtx, InMessageContext respMsgCtx) throws InvalidResponseException {
        if (respMsgCtx.getEntityId() == null) {
            if (reqMsgCtx != null) {
                respMsgCtx.setEntityId(reqMsgCtx.getEntityId());
            } else {
                ResponseDocument respDoc = (ResponseDocument)respMsgCtx.getXmlObject();
                ResponseType responseType = respDoc.getResponse();
                if (responseType.sizeOfAssertionArray() > 0) {
                    AssertionType assertionType = responseType.getAssertionArray(0);
                    String issuer = this.assertionTypeUtil.getIssuer(assertionType);
                    respMsgCtx.setEntityId(issuer);
                }
            }
        }
        if (reqMsgCtx != null) {
            super.checkIssuer(reqMsgCtx, respMsgCtx);
        }
    }

    @Override
    protected void verifySignature(InMessageContext respMsgCtx, HttpServletRequest request) throws InvalidResponseException {
        if (respMsgCtx.getSignatureStatus() == SignatureStatus.UNVERIFIED) {
            ResponseDocument respDoc = (ResponseDocument)respMsgCtx.getXmlObject();
            ResponseType responseType = respDoc.getResponse();
            if (responseType.isSetSignature()) {
                if (!responseType.isSetIssuer()) {
                    throw new InvalidSsoResponseException("(Profiles 4.1.4.2) If the Response is signed, it MUST contain the unique identifier of the issuing identity provider");
                }
            } else {
                respMsgCtx.setSignatureStatus(SignatureStatus.NOT_PRESENT);
            }
        }
        String partnerEntityId = respMsgCtx.getEntityId();
        IdpConnection idpConnection = MetadataSupport.getIdpConnection(partnerEntityId);
        ResponseDocument respDoc = (ResponseDocument)respMsgCtx.getXmlObject();
        ResponseType responseType = respDoc.getResponse();
        this.decryptAssertions(responseType, idpConnection, respMsgCtx);
        this.validateXml(respMsgCtx);
        boolean assertionSignatureRequired = idpConnection.isAssertionSigned();
        if (respMsgCtx.getSignatureStatus() == SignatureStatus.NOT_PRESENT && respMsgCtx.isSignatureRequired() || assertionSignatureRequired) {
            for (AssertionType assertionType : responseType.getAssertionArray()) {
                SignatureResult signatureResult = this.signatureEngine.verifyAssertionSignature(assertionType);
                if (signatureResult.getStatus() != SignatureStatus.VALID) {
                    StringBuilder sb = new StringBuilder("Missing or invalid signature (");
                    sb.append(signatureResult).append(") on assertion (ID=");
                    sb.append(assertionType.getID()).append("). ");
                    sb.append("All assertions must have valid signatures because the Response was not signed ");
                    sb.append("or the system is configured to require a signed assertion from ");
                    sb.append(idpConnection.getEntityId()).append(".");
                    sb.append(Util.LINE_BREAK).append(respMsgCtx);
                    throw new InvalidSsoResponseException(sb.toString());
                }
                request.setAttribute(REQ_ATTR_KEY_ASSERTION_SIG, (Object)true);
            }
        } else {
            super.verifySignature(respMsgCtx, request);
            request.setAttribute(REQ_ATTR_KEY_ASSERTION_SIG, (Object)true);
        }
        this.decryptOtherElements(responseType, idpConnection, respMsgCtx);
    }

    private void decryptAssertions(ResponseType responseType, IdpConnection idp, InMessageContext rspCtx) throws InvalidResponseException {
        EncryptedElementType[] encryptedAssertions = responseType.getEncryptedAssertionArray();
        if (encryptedAssertions.length > 0) {
            this.checkOkToDecryptAssertion(rspCtx);
            for (EncryptedElementType encAssertionType : encryptedAssertions) {
                String virtualEntityId = VirtualIdentityUtil.resolve((BaseMessageContext)rspCtx, idp).getVirtualEntityId(DomainMode.RUNTIME);
                AssertionType decryptedAssertion = EncryptionSupport.decryptAssertion(idp, encAssertionType, virtualEntityId, idp.getMaskedAttributeNames());
                responseType.addNewAssertion().set((XmlObject)decryptedAssertion);
            }
            responseType.setEncryptedAssertionArray(new EncryptedElementType[0]);
        }
    }

    void checkOkToDecryptAssertion(InMessageContext rspCtx) throws InvalidResponseException {
        SignatureStatus status = rspCtx.getSignatureStatus();
        boolean ok = status == SignatureStatus.VALID;
        ok = ok || !rspCtx.isSignatureRequired() && status == SignatureStatus.NOT_PRESENT;
        String keyname = "EntityIdsToAllowAssertionDecryptionWithoutResponseSignature";
        boolean bl = ok = ok || this.config.getListValue(keyname, Collections.emptyList()).contains(rspCtx.getEntityId());
        if (!ok) {
            SignatureResult result = rspCtx.getSignatureResult();
            throw this.newIRE("For security reasons a Response sent via the front channel that contains encrypted Assertion(s) must have a valid signature (but was " + result + ").");
        }
    }

    private void decryptOtherElements(ResponseType responseType, IdpConnection idpConnection, InMessageContext respMsgCtx) {
        for (AssertionType assertionType : responseType.getAssertionArray()) {
            AttributeStatementType[] attribStmts;
            if (assertionType.getSubject() != null && assertionType.getSubject().isSetEncryptedID()) {
                EncryptedElementType encryptedNameId = assertionType.getSubject().getEncryptedID();
                try {
                    String myRecip = VirtualIdentityUtil.resolve((BaseMessageContext)respMsgCtx, idpConnection).getVirtualEntityId(DomainMode.RUNTIME);
                    NameIDType nameId = this.encryptionEngine.decryptNameID(idpConnection, encryptedNameId, myRecip);
                    SubjectType subject = assertionType.getSubject();
                    subject.unsetEncryptedID();
                    subject.setNameID(nameId);
                }
                catch (XMLEncryptionException ex) {
                    throw new ProcessRuntimeException("Unable to decrypt the NameID.", ex);
                }
                catch (NoEncryptionKeyException ex) {
                    throw new ProcessRuntimeException("No decryption key to decrypt the NameID.", ex);
                }
            }
            for (AttributeStatementType attibStmt : attribStmts = assertionType.getAttributeStatementArray()) {
                EncryptedElementType[] encryptedAttribs = attibStmt.getEncryptedAttributeArray();
                try {
                    for (EncryptedElementType encryptedAttrib : encryptedAttribs) {
                        String virtualEntityId = VirtualIdentityUtil.resolve((BaseMessageContext)respMsgCtx, idpConnection).getVirtualEntityId(DomainMode.RUNTIME);
                        AttributeType attribute = this.encryptionEngine.decryptAttribute(idpConnection, encryptedAttrib, virtualEntityId);
                        attibStmt.addNewAttribute().set((XmlObject)attribute);
                    }
                    attibStmt.setEncryptedAttributeArray(new EncryptedElementType[0]);
                }
                catch (Exception ex) {
                    this.log.warn((Object)"Unable to decrypt an attribute.", (Throwable)ex);
                }
                if (!this.config.getBooleanValue(CFG_DECRYPT_ENCRYPTED_ID_IN_ATTRIBUTE, true)) continue;
                try {
                    for (AttributeType attrib : attibStmt.getAttributeArray()) {
                        for (XmlObject attribValue : attrib.getAttributeValueArray()) {
                            this.decryptEncryptedIdInAttribute(attribValue, idpConnection, respMsgCtx);
                        }
                    }
                }
                catch (Exception ex) {
                    this.log.warn((Object)"Unable to decrypt an EncryptedID attribute.", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decryptEncryptedIdInAttribute(XmlObject attribValue, IdpConnection idpConnection, InMessageContext respMsgCtx) throws XmlException, NoEncryptionKeyException, XMLEncryptionException {
        XmlCursor xmlCursor = null;
        try {
            Node childNode;
            xmlCursor = attribValue.newCursor();
            if (xmlCursor.toFirstChild() && (childNode = xmlCursor.getDomNode()).getNodeType() == 1 && ENCRYPTED_ID_NODE_NAME.equals(childNode.getLocalName())) {
                String virtualEntityId = VirtualIdentityUtil.resolve((BaseMessageContext)respMsgCtx, idpConnection).getVirtualEntityId(DomainMode.RUNTIME);
                EncryptedElementType encryptedElement = EncryptedIDDocument.Factory.parse((String)attribValue.xmlText()).getEncryptedID();
                XmlObject decrypted = this.encryptionEngine.decrypt(idpConnection, encryptedElement, virtualEntityId);
                attribValue.set(decrypted);
            }
        }
        finally {
            XmlBeansUtil.disposeCursor(xmlCursor);
        }
    }

    @Override
    protected InvalidResponseException newIRE(String message) {
        return new InvalidSsoResponseException(message);
    }

    @Override
    protected void handleException(InvalidResponseException e, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.ssoRespSupport.isResumeFromException(e, reqMsgCtx, req, resp)) {
            this.ssoRespSupport.handleException(e, respMsgCtx, reqMsgCtx, req, resp);
        }
    }
}

