/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.saml20.profiles.ResumableResponseHandlerBase;
import org.sourceid.saml20.profiles.sp.SLOSupport;
import org.sourceid.saml20.xmlbinding.protocol.LogoutResponseDocument;
import org.sourceid.saml20.xmlbinding.protocol.StatusCodeType;
import org.sourceid.saml20.xmlbinding.protocol.StatusResponseType;
import org.sourceid.saml20.xmlbinding.protocol.StatusType;
import org.sourceid.websso.profiles.InvalidGeneralResponseException;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.LogoutResult;
import org.sourceid.websso.profiles.LogoutResultHandler;
import org.sourceid.websso.profiles.SloHandler;
import org.sourceid.websso.profiles.sp.ResumeRequestFromResponseSupport;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class HandleLogoutResponse
extends ResumableResponseHandlerBase
implements SloHandler {
    private final SLOSupport sloSupport = new SLOSupport();
    private LogoutResultHandler resultHandler;

    public void setResultHandler(LogoutResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    @Override
    protected void doProcess(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws InvalidResponseException, IOException {
        LogoutResponseDocument logoutResponseDocument = (LogoutResponseDocument)respMsgCtx.getXmlObject();
        StatusResponseType logoutResponse = logoutResponseDocument.getLogoutResponse();
        StatusType statusType = logoutResponse.getStatus();
        StatusCodeType statusCode = statusType.getStatusCode();
        if (statusCode.isSetStatusCode() && "urn:oasis:names:tc:SAML:2.0:status:PartialLogout".equals(statusCode.getStatusCode().getValue())) {
            Object msg = "Single Logout was only partially successful.";
            if (statusType.isSetStatusMessage()) {
                msg = (String)msg + "  " + statusType.getStatusMessage();
            }
            throw new InvalidGeneralResponseException((String)msg);
        }
        if (this.forwardToTarget(new LogoutResult(true, null), respMsgCtx, reqMsgCtx, req, resp)) {
            return;
        }
        Map<String, Object> params = Collections.emptyMap();
        this.resume(respMsgCtx, reqMsgCtx, req, resp, params);
    }

    @Override
    protected void handleException(InvalidResponseException e, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String msg;
        if (this.forwardToTarget(new LogoutResult(false, e.getMessage()), respMsgCtx, reqMsgCtx, req, resp)) {
            return;
        }
        String inErrorResource = null;
        String targetResource = null;
        if (reqMsgCtx != null) {
            inErrorResource = reqMsgCtx.getInErrorResource();
            targetResource = this.getTargetResource(reqMsgCtx);
        }
        msg = (msg = e.getMessage()) == null ? e.toString() : msg;
        String stack = ExceptionUtil.getStackTrace(e);
        XmlObject xml = respMsgCtx.getXmlObject();
        this.sloSupport.handleError(targetResource, inErrorResource, req, resp, Arrays.asList(msg), stack, xml);
    }

    @Override
    protected void doResume(InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> params) throws IOException {
        if (reqMsgCtx != null) {
            this.sloSupport.localLogoutSuccess(reqMsgCtx.getTargetResource(), req, resp, reqMsgCtx.getEntityId());
        } else {
            String defaultAfterSLOPage = this.localMetaData.getApplicationURL("sp.after.slo");
            if (defaultAfterSLOPage == null || "".equals(defaultAfterSLOPage)) {
                this.log.debug((Object)"Please configure the default url after successful SLO");
            }
            this.sloSupport.localLogoutSuccess(defaultAfterSLOPage, req, resp, "");
        }
    }

    private boolean forwardToTarget(LogoutResult logoutResult, InMessageContext respMsgCtx, OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.resultHandler != null) {
            this.resultHandler.handleLogoutResult(logoutResult);
            return true;
        }
        return ResumeRequestFromResponseSupport.resumeRequestFromResponse(logoutResult, respMsgCtx, reqMsgCtx, req, resp);
    }

    private String getTargetResource(OutMessageContext reqMsgCtx) {
        String applicationURL = reqMsgCtx.getTargetResource();
        if (applicationURL == null) {
            applicationURL = this.localMetaData.getApplicationURL("sp.after.slo");
        }
        return applicationURL;
    }

    @Override
    protected boolean validateInResponseTo(OutMessageContext requestMsgCtx, StatusResponseType statusResponseType) {
        try {
            super.validateInResponseTo(requestMsgCtx, statusResponseType);
        }
        catch (InvalidResponseException e) {
            this.log.info((Object)e.getMessage());
        }
        return true;
    }

    @Override
    protected void checkIssuer(OutMessageContext reqMsgCtx, InMessageContext respMsgCtx) {
        try {
            super.checkIssuer(reqMsgCtx, respMsgCtx);
        }
        catch (InvalidResponseException e) {
            this.log.info((Object)e.getMessage());
        }
    }
}

