/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.BindingService;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.profiles.sp.AttributeQueryCreatorSupport;
import org.sourceid.saml20.profiles.sp.HandleInternalAttrQueryResponse;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class InternalAttributeQuerier {
    private static final BindingService bindingSvc = GlobalRegistry.getService(BindingService.class);
    private static final Log log = LogFactory.getLog(InternalAttributeQuerier.class);

    public AttributeMap query(HttpServletRequest req, HttpServletResponse resp, IdpConnection idpConnection, AttributeMap assertionAttributes) {
        AttributeMap attrMap = new AttributeMap();
        AttributeValue subjectAttrValue = (AttributeValue)assertionAttributes.get((Object)AssertionMapKeys.getNameIdValueKey());
        String subject = subjectAttrValue.getValue();
        String idpId = idpConnection.getEntityId();
        AttributeQueryCreatorSupport supporter = new AttributeQueryCreatorSupport();
        supporter.setIdpEntityId(idpId);
        supporter.setSubject(subject);
        try {
            OutMessageContext outMsgCtx = supporter.makeAttributeQuery(req);
            Map<String, AttributeValue> attributes = this.sendAttributeQuery(req, resp, outMsgCtx);
            if (attributes != null) {
                attrMap.putAll(attributes);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception in InternalAttributeQuerier", (Throwable)e);
            attrMap = null;
        }
        return attrMap;
    }

    private Map<String, AttributeValue> sendAttributeQuery(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtxOut) throws IOException, BindingException, RedirectException, RenderPageException {
        Map<String, AttributeValue> attrMap = null;
        InMessageContext msgCtxIn = bindingSvc.transportRequest(request, response, msgCtxOut);
        if (msgCtxIn != null) {
            HandleInternalAttrQueryResponse handler = new HandleInternalAttrQueryResponse();
            handler.process(msgCtxOut, msgCtxIn, request, response);
            attrMap = handler.getAttributes();
        }
        return attrMap;
    }
}

