/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import com.pingidentity.templates.mgmt.DefaultTemplateParams;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.Util;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.saml20.state.SessionSettings;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.wrapper.OutMessageContext;

public class SLOSupport {
    private static TargetResourceValidationMgr redirectValidationMgr = GlobalRegistry.getService(TargetResourceValidationMgr.class);

    public boolean checkRegisterSpAuthnBean(IdpConnection idpConn, TargetSessionId targetSessionId) {
        if (targetSessionId.getType() != TargetSessionId.TargetSessionType.ADAPTER) {
            return false;
        }
        SessionSettings sessionSettings = MgmtFactory.getSessionSettingsManager().getSessionSettings();
        if (sessionSettings.isTrackAdapterSessionsForLogout()) {
            return true;
        }
        return idpConn != null && (idpConn.supportsSLO() || idpConn.doAccountLinking() || idpConn.getProtocol() == Protocol.OIDC && idpConn.getOidcSettings().isTrackUserSessionsForLogout());
    }

    public void localLogoutSuccess(OutMessageContext originalRequestCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.localLogoutSuccess(originalRequestCtx.getTargetResource(), req, resp, originalRequestCtx.getEntityId());
    }

    public void localLogoutSuccess(String applicationURL, HttpServletRequest req, HttpServletResponse resp, String connectionID) throws IOException {
        if (!StringUtils.isBlank((String)applicationURL)) {
            try {
                redirectValidationMgr.validateTargetResourceSloAndOther(applicationURL, "sp.after.slo");
            }
            catch (InvalidRedirectValidationException ex) {
                throw new ProcessRuntimeException(ex.getMessage());
            }
            resp.sendRedirect(applicationURL);
        } else {
            ResponseTemplateRenderer renderingThing = ResponseTemplateRenderer.getInstance();
            Map<String, Object> pageParams = new DefaultTemplateParams.Builder(DefaultTemplateParams.Role.SP).entityId(connectionID).build();
            if (StringUtils.isBlank((String)connectionID)) {
                connectionID = "unknown";
            }
            pageParams.put("connectionID", connectionID);
            pageParams.put("entityId", connectionID);
            renderingThing.render(req, resp, "sp.slo.success.page.template.html", pageParams);
        }
    }

    public void handleError(String targetResource, String inErrorResource, HttpServletRequest req, HttpServletResponse resp, List<String> problems, String fullStack, XmlObject xmlObj) throws IOException {
        boolean inErrorValidationFailed = false;
        if (!StringUtils.isBlank((String)inErrorResource)) {
            try {
                redirectValidationMgr.validateInErrorResource(inErrorResource);
                resp.sendRedirect(inErrorResource);
            }
            catch (InvalidRedirectValidationException ex) {
                inErrorValidationFailed = true;
            }
        }
        if (StringUtils.isBlank((String)inErrorResource) || inErrorValidationFailed) {
            ResponseTemplateRenderer renderingThing = ResponseTemplateRenderer.getInstance();
            HashMap<String, Object> pageParams = new HashMap<String, Object>();
            pageParams.put("targetResource", targetResource == null ? "unknown" : targetResource);
            pageParams.put("errorMessage", Util.isEmpty(problems) ? "" : StringUtils.join(problems, (String)" "));
            pageParams.put("fullStackTrace", fullStack);
            pageParams.put("responseXml", xmlObj);
            renderingThing.render(req, resp, "sp.slo.error.page.template.html", pageParams);
        }
    }
}

