/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.profiles.AdapterLogoutMode;
import org.sourceid.saml20.profiles.sp.LinkingSupport;
import org.sourceid.saml20.profiles.sp.SpAdapterLogoutManager;
import org.sourceid.saml20.service.AccountLinkingServiceException;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.TargetSessionId;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.state.SpSessionRegistrySupport;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.ResumableRequestCreatorBase;
import org.sourceid.websso.wrapper.OutMessageContext;

public class TerminateAccountLinks
extends ResumableRequestCreatorBase {
    private static final String KEY_LOGOUT_BEANS = "beanstologout";
    private static final String KEY_NUMBER_TERM = "numterm";

    @Override
    public OutMessageContext doProcess(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            return this.doIt(req, resp);
        }
        catch (AccountLinkingServiceException e) {
            throw new ProcessRuntimeException("Unable to terminate account link.", e);
        }
    }

    OutMessageContext doIt(HttpServletRequest req, HttpServletResponse resp) throws IOException, AccountLinkingServiceException {
        String localSessionId = StateMgmtFactory.getLocalSessionId(req, resp);
        Map<SpHashableAuthnBean, WebSsoSession> beansAndSessions = SpSessionRegistrySupport.lookupAuthnBeansAndSessions(localSessionId);
        ArrayList<SpHashableAuthnBean> beansToLogout = new ArrayList<SpHashableAuthnBean>(beansAndSessions.size());
        if (!Util.isEmpty(beansAndSessions)) {
            for (Map.Entry<SpHashableAuthnBean, WebSsoSession> entry : beansAndSessions.entrySet()) {
                String externalIdentifier;
                String adapterId;
                String partnerEntityId;
                String localId;
                WebSsoSession session;
                SpHashableAuthnBean bean = entry.getKey();
                if (bean.getTargetSessionId().getType() != TargetSessionId.TargetSessionType.ADAPTER || (session = entry.getValue()) == null || StringUtils.isBlank((String)(localId = LinkingSupport.lookupLink(partnerEntityId = session.getEntityId(), adapterId = bean.getTargetSessionId().getId(), externalIdentifier = this.getExternalName(session))))) continue;
                LinkingSupport.terminateLink(partnerEntityId, adapterId, externalIdentifier);
                beansToLogout.add(bean);
            }
        } else {
            throw new ProcessRuntimeException("No sessions have been established via SSO.");
        }
        if (beansToLogout.isEmpty()) {
            throw new ProcessRuntimeException("No sessions have been established via federated SSO.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_LOGOUT_BEANS, beansToLogout);
        params.put(KEY_NUMBER_TERM, beansToLogout.size());
        this.addTrackedParams(req, params);
        return this.resume(null, req, resp, params);
    }

    @Override
    protected OutMessageContext doResume(OutMessageContext reqMsgCtx, HttpServletRequest req, HttpServletResponse resp, final Map<String, Object> params) throws IOException, GeneralAdapterException {
        int count = (Integer)params.get(KEY_NUMBER_TERM);
        List authnBeans = (List)params.get(KEY_LOGOUT_BEANS);
        SpAdapterLogoutManager logoutManager = new SpAdapterLogoutManager(authnBeans, req, resp, AdapterLogoutMode.FRONT_OR_BACK_CHANNEL, false){

            @Override
            public String saveLogoutState() {
                return TerminateAccountLinks.this.saveState(this.req, this.resp, null, params);
            }
        };
        if (!logoutManager.doLogout()) {
            return null;
        }
        ResponseTemplateRenderer renderer = ResponseTemplateRenderer.getInstance();
        renderer.renderResponse(req, resp, new Page(count));
        return null;
    }

    private String getExternalName(WebSsoSession session) {
        String externalIdentifier = null;
        if (session.getNameId() != null) {
            externalIdentifier = session.getNameId().getValue();
        }
        return externalIdentifier;
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return null;
    }

    private class Page
    extends ResponseTemplateRenderer.ContentTemplate {
        final Object[] args;

        public Page(int numberTerminated) {
            super("TerminateAccountLinks.page.template.html");
            this.args = new Object[]{numberTerminated};
        }

        @Override
        public Object[] getArguments() {
            return this.args;
        }
    }
}

