/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.profiles.sp.UrlMatchingService;

public class UrlMatchingServiceMultipleStarImpl
implements UrlMatchingService {
    private static final String WILDCARD = "*";
    private static final Pattern ORIGIN_PATTERN = Pattern.compile("^([A-Za-z][A-Za-z0-9\\+\\-\\.]*)://(.+)$");

    @Override
    public boolean isMatch(String urlPattern, String url) {
        throw new UnsupportedOperationException("This method implementation is not complete and is currently unsupported.");
    }

    @Override
    public boolean isValidUrlPattern(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return false;
        }
        String urlToCheck = url.trim();
        if (urlToCheck.equals(WILDCARD)) {
            return true;
        }
        Matcher originMatcher = ORIGIN_PATTERN.matcher(urlToCheck);
        if (!originMatcher.find() || originMatcher.group(1) == null || originMatcher.group(2) == null) {
            return false;
        }
        String authority = originMatcher.group(2);
        if (authority.equals(WILDCARD) || authority.startsWith("*:")) {
            return false;
        }
        if (authority.contains("**")) {
            return false;
        }
        if (!authority.endsWith(":*")) {
            if (authority.contains(":") && authority.substring(authority.lastIndexOf(":")).contains(WILDCARD)) {
                return false;
            }
            return this.isValidUri(urlToCheck);
        }
        return true;
    }

    @Override
    public boolean isValidURIPattern(String uri) {
        throw new UnsupportedOperationException("This method implementation is not complete and is currently unsupported.");
    }

    private boolean isValidUri(String inputUri) {
        URI parsedUri;
        try {
            parsedUri = new URI(inputUri);
        }
        catch (URISyntaxException e) {
            return false;
        }
        int port = parsedUri.getPort();
        if (port != -1 && (port < 1 || port > 65535)) {
            return false;
        }
        return parsedUri.getQuery() == null;
    }
}

