/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.profiles.sp;

import com.pingidentity.common.util.LogGuard;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.profiles.sp.UrlMatchingService;

public class UrlMatchingServiceOneStarImpl
implements UrlMatchingService {
    private static final String WILDCARD = "*";
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public boolean isMatch(String urlPattern, String url) {
        String tempUrlPattern = urlPattern;
        String tempUrl = url;
        try {
            tempUrlPattern = Util.getUrlWithLowercaseHostname(urlPattern);
            tempUrl = Util.getUrlWithLowercaseHostname(url);
        }
        catch (URISyntaxException e) {
            this.log.debug((Object)String.format("URL %s is not a valid URI: %s", LogGuard.encode(url), LogGuard.encode(e.getMessage())));
        }
        int wildCardIdx = tempUrlPattern.indexOf(WILDCARD);
        if (wildCardIdx < 0) {
            return tempUrlPattern.equals(tempUrl);
        }
        String pre = tempUrlPattern.substring(0, wildCardIdx);
        String post = tempUrlPattern.substring(wildCardIdx + 1);
        if (!pre.isEmpty() && !tempUrl.startsWith(pre)) {
            return false;
        }
        if (!post.isEmpty()) {
            return tempUrl.substring(pre.length()).endsWith(post);
        }
        return true;
    }

    @Override
    public boolean isValidUrlPattern(String url) {
        String urlToCheck = url.trim();
        if (!ValidationUtil.hasOnlyOneWildcard(urlToCheck)) {
            return false;
        }
        if (urlToCheck.startsWith(WILDCARD)) {
            return true;
        }
        return ValidationUtil.isValidHttpOrHttpsUrl(urlToCheck);
    }

    @Override
    public boolean isValidURIPattern(String uri) {
        String uriToCheck = uri.trim();
        if (!ValidationUtil.hasOnlyOneWildcard(uriToCheck)) {
            return false;
        }
        try {
            new URI(uri);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }
}

