/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.XmlEncryption;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.protocol.dsig10.xml.KeyInfoType;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.encryption.EncryptionEngine;
import org.sourceid.saml20.encryption.NoEncryptionKeyException;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.protocol.AssertionTypeUtil;
import org.sourceid.saml20.protocol.AttributeStatementTypeUtil;
import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.wrapper.WebSsoResponse;
import org.sourceid.saml20.xmlbinding.assertion.AssertionDocument;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.AttributeStatementType;
import org.sourceid.saml20.xmlbinding.assertion.AttributeType;
import org.sourceid.saml20.xmlbinding.assertion.AuthnContextType;
import org.sourceid.saml20.xmlbinding.assertion.AuthnStatementType;
import org.sourceid.saml20.xmlbinding.assertion.EncryptedElementType;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectType;
import org.sourceid.util.Defense;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.protocol.AssertionAssemblerUtil;
import org.sourceid.wstrust.handlers.WSTrustException;

public class AssertionAssembler {
    private final Log log = LogFactory.getLog(this.getClass());
    private final AssertionTypeUtil assertionTypeUtil = new AssertionTypeUtil();
    private static final String MSG_ERROR_NAMEID_ENCRYPTION = "Unable to encrypt NameID.";
    private final EncryptionEngine encryptionEngine = GlobalRegistry.getService(EncryptionEngine.class);
    private ConfigStore config = ConfigStoreFarm.getConfig(AssertionAssembler.class);

    public AssertionType assembleForWebSSO(AttributeMap values, SpConnection spConnection, String acs, String inResponseTo, Calendar authnInst, String issuer, List<String> authnAuthorities) throws StatusResponseException {
        AssertionType assertionType = this.assertionTypeUtil.getTemplateAssertion(issuer);
        int nMinutesBeforeNow = spConnection.getAssertionValidityBeforeMinutes();
        int nMinutesAfterNow = spConnection.getAssertionValidityAfterMinutes();
        this.assertionTypeUtil.setConditions(spConnection.getEntityId(), nMinutesBeforeNow, nMinutesAfterNow, assertionType);
        this.addSubject(values, assertionType);
        String bearer = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
        SubjectType subject = assertionType.getSubject();
        Calendar notOnOrAfter = assertionType.getConditions().getNotOnOrAfter();
        this.assertionTypeUtil.setSubjConf(bearer, acs, inResponseTo, subject, notOnOrAfter);
        String authnCtxClassRef = this.getAuthnCtxClassRef(values);
        this.assertionTypeUtil.addAuthnStmt(authnInst, authnCtxClassRef, authnAuthorities, assertionType);
        this.assertionTypeUtil.addAttributeStatement(values, spConnection, assertionType);
        return assertionType;
    }

    public AssertionType assembleForWebSSO(AttributeMap values, String partnerEntityId, String acs, String inResponseTo, Calendar authnInst, String issuer) throws StatusResponseException {
        SpConnection spConnection = MetadataSupport.getSpConnection(partnerEntityId);
        return this.assembleForWebSSO(values, spConnection, acs, inResponseTo, authnInst, issuer, null);
    }

    public AssertionType assembleForWebSSO(AttributeMap values, String partnerEntityId, String acs, String inResponseTo, Calendar authnInst, String issuer, List<String> authnAuthorities) throws StatusResponseException {
        SpConnection spConnection = MetadataSupport.getSpConnection(partnerEntityId);
        return this.assembleForWebSSO(values, spConnection, acs, inResponseTo, authnInst, issuer, authnAuthorities);
    }

    public String getAuthnCtxClassRef(AttributeMap values) {
        return AssertionAssemblerUtil.getValue(AssertionMapKeys.getAuthnCtxKey(), "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified", (Map<String, AttributeValue>)values);
    }

    public AssertionType assembleForAttrQueryResponse(Map<String, AttributeValue> values, String spEntityId, SubjectType subject, String issuer) throws StatusResponseException {
        if (values.isEmpty()) {
            throw new StatusResponseException(TopLevelStatusCode.REQUESTER, "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", "No attributes found for requested subject");
        }
        SpConnection spConnection = MetadataSupport.getSpConnection(spEntityId);
        AssertionType assertionType = this.assertionTypeUtil.getTemplateAssertion(issuer);
        int nMinutesBeforeNow = spConnection.getAssertionValidityBeforeMinutes();
        int nMinutesAfterNow = spConnection.getAssertionValidityAfterMinutes();
        this.assertionTypeUtil.setConditions(spEntityId, nMinutesBeforeNow, nMinutesAfterNow, assertionType);
        assertionType.setSubject(subject);
        AttributeStatementType attributeStatement = assertionType.addNewAttributeStatement();
        for (Map.Entry<String, AttributeValue> e : values.entrySet()) {
            AttributeStatementTypeUtil.addBasicAttribute(e.getKey(), e.getValue(), attributeStatement);
        }
        return assertionType;
    }

    public AttributeMap disassemble(WebSsoResponse webSsoResponse, Set<String> maskedAttributeNames) {
        AttributeMap parsedRsp = new AttributeMap();
        SubjectType subject = webSsoResponse.getSubject();
        this.disassembleSubject(subject, parsedRsp);
        AuthnStatementType authnStatementType = webSsoResponse.getAuthnStatementType();
        Calendar authnInstant = authnStatementType.getAuthnInstant();
        AttributeValue attrValueAuthnInst = AttrValueSupport.make((Object)authnInstant);
        parsedRsp.put(AssertionMapKeys.getAuthnInstantKey(), attrValueAuthnInst);
        AuthnContextType authnContext = authnStatementType.getAuthnContext();
        if (authnContext.isSetAuthnContextClassRef()) {
            parsedRsp.put(AssertionMapKeys.getAuthnCtxKey(), new AttributeValue(authnContext.getAuthnContextClassRef()));
        }
        LinkedList<AttributeStatementType> attrStmts = new LinkedList<AttributeStatementType>();
        Assertion ssoAssertion = webSsoResponse.getSsoAssertion();
        String assertionId = ssoAssertion.getAssertionType().getID();
        TrackingIdSupport.addReference(assertionId);
        ThreadContext.put((String)AuditLogger.MDC_KEY.ASSERTION_ID.toString(), (String)assertionId);
        attrStmts.addAll(Arrays.asList(ssoAssertion.getAssertionType().getAttributeStatementArray()));
        for (Assertion assertion : webSsoResponse.getOtherValidAssertions()) {
            attrStmts.addAll(Arrays.asList(assertion.getAssertionType().getAttributeStatementArray()));
        }
        this.disassembleAttrStatements(attrStmts, (Map<String, AttributeValue>)parsedRsp);
        AttrValueSupport.checkSetMasked((Map)parsedRsp, maskedAttributeNames);
        return parsedRsp;
    }

    public AttributeMap disassemble(AssertionType assertionType) {
        AttributeMap parsedAttrs = new AttributeMap();
        this.disassembleSubject(assertionType.getSubject(), parsedAttrs);
        this.disassembleAttrStmts(assertionType, parsedAttrs);
        return parsedAttrs;
    }

    public Map<String, AttributeValue> disassembleAttrStmts(AssertionType assertion) {
        AttributeMap attrs = new AttributeMap();
        this.disassembleAttrStmts(assertion, attrs);
        return attrs;
    }

    public AttributeMap disassemble(AssertionType assertionType, Set<String> maskedAttributeNames) {
        AttributeMap parsedAttrs = this.disassemble(assertionType);
        AttrValueSupport.checkSetMasked((Map)parsedAttrs, maskedAttributeNames);
        if (assertionType.sizeOfAuthnStatementArray() > 0) {
            AuthnStatementType authnStatementType = assertionType.getAuthnStatementArray(0);
            Calendar authenticationInstant = authnStatementType.getAuthnInstant();
            parsedAttrs.put(AssertionMapKeys.getAuthnInstantKey(), AttrValueSupport.make((Object)authenticationInstant));
            String authenticationMethod = authnStatementType.getAuthnContext().getAuthnContextClassRef();
            parsedAttrs.put(AssertionMapKeys.getAuthnCtxKey(), new AttributeValue(authenticationMethod));
        }
        return parsedAttrs;
    }

    private void disassembleAttrStmts(AssertionType assertion, AttributeMap targetAttrs) {
        AttributeStatementType[] attrStmtArray = assertion.getAttributeStatementArray();
        List<AttributeStatementType> attributeStatements = Arrays.asList(attrStmtArray);
        this.disassembleAttrStatements(attributeStatements, (Map<String, AttributeValue>)targetAttrs);
    }

    private void disassembleSubject(SubjectType subject, AttributeMap parsedAttrs) {
        if (subject != null && subject.isSetNameID()) {
            NameIDType nameID = subject.getNameID();
            String nameId = nameID.getStringValue();
            parsedAttrs.put(AssertionMapKeys.getNameIdValueKey(), new AttributeValue(nameId));
            if (nameID.isSetFormat()) {
                String format = nameID.getFormat();
                parsedAttrs.put(AssertionMapKeys.getNameIdFormatKey(), new AttributeValue(format));
            }
            if (nameID.isSetNameQualifier()) {
                String nameQualifier = nameID.getNameQualifier();
                parsedAttrs.put(AssertionMapKeys.getNameIdQualifierKey(), new AttributeValue(nameQualifier));
            }
        }
    }

    void disassembleAttrStatements(Iterable<AttributeStatementType> attrStmts, Map<String, AttributeValue> parsed) {
        for (AttributeStatementType attrStmt : attrStmts) {
            for (AttributeType attributeType : attrStmt.getAttributeArray()) {
                String name = attributeType.getName();
                AttributeValue value = AttributeStatementTypeUtil.getBasicAttributeValues(attributeType);
                parsed.put(name, value);
            }
        }
    }

    public void encryptSubjectNameID(ConnectionBase connection, SubjectType subject, boolean encryptedNameIDRequested) throws StatusResponseException {
        if (connection.getEncryptionSettings().getEncryptionPolicy().isEncryptSubjectNameID() || encryptedNameIDRequested) {
            try {
                NameIDType nameId = subject.getNameID();
                EncryptedElementType encryptedNameId = this.encryptionEngine.encryptNameID(connection, nameId);
                subject.unsetNameID();
                subject.addNewEncryptedID().set((XmlObject)encryptedNameId);
            }
            catch (NoSuchAlgorithmException | XMLEncryptionException ex) {
                throw new StatusResponseException(TopLevelStatusCode.RESPONDER, MSG_ERROR_NAMEID_ENCRYPTION, ex);
            }
            catch (NoEncryptionKeyException ex) {
                if (encryptedNameIDRequested) {
                    String msg = "Unable to provide an encrypted name id because an encryption key has not been configured.";
                    throw new StatusResponseException(TopLevelStatusCode.REQUESTER, "urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", msg);
                }
                throw new StatusResponseException(TopLevelStatusCode.RESPONDER, ex.getMessage());
            }
        }
    }

    private void addSubject(AttributeMap values, AssertionType assertionType) {
        String nameIdValueKey = AssertionMapKeys.getNameIdValueKey();
        String subjectValue = AssertionAssemblerUtil.getValue(nameIdValueKey, null, (Map<String, AttributeValue>)values);
        if (subjectValue == null) {
            throw new ProcessRuntimeException("No value found for " + nameIdValueKey + " when building the assertion from name/value pairs: " + values);
        }
        String format = AssertionAssemblerUtil.getValue(AssertionMapKeys.getNameIdFormatKey(), "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", (Map<String, AttributeValue>)values);
        String qualifier = AssertionAssemblerUtil.getValue(AssertionMapKeys.getNameIdQualifierKey(), null, (Map<String, AttributeValue>)values);
        String spQualifier = AssertionAssemblerUtil.getValue(AssertionMapKeys.getNameIdSpQualifierKey(), null, (Map<String, AttributeValue>)values);
        this.assertionTypeUtil.setSubject(format, qualifier, subjectValue, spQualifier, assertionType);
    }

    public AssertionType assembleForWSTrust(AttributeMap values, int nMinutesBeforeNow, int nMinutesAfterNow, String issuer, String audience, Calendar authnInst, String subjectConfirmationMethod) {
        AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
        AssertionType assertionType = assertionDoc.addNewAssertion();
        this.assertionTypeUtil.setDefaultAttributes(assertionType);
        this.assertionTypeUtil.setIssuer(issuer, assertionType);
        this.assertionTypeUtil.setConditions(audience, nMinutesBeforeNow, nMinutesAfterNow, assertionType);
        this.addSubject(values, assertionType);
        this.assertionTypeUtil.setSubjConf(subjectConfirmationMethod, assertionType.getSubject());
        if (authnInst != null) {
            String authnCtxClassRef = AssertionAssemblerUtil.getValue(AssertionMapKeys.getAuthnCtxKey(), "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified", (Map<String, AttributeValue>)values);
            this.assertionTypeUtil.addAuthnStmt(authnInst, authnCtxClassRef, null, assertionType);
        }
        this.assertionTypeUtil.addAttributeStatement(values, assertionType);
        try {
            assertionDoc = XmlBeansUtil.canonicalize(assertionDoc, AssertionDocument.class);
        }
        catch (Exception e) {
            this.log.warn((Object)"Couldn't canonicalize assertion.", (Throwable)e);
        }
        return assertionDoc.getAssertion();
    }

    public AssertionType assembleForWSTrust(AttributeMap attrs, int before, int after, String veid, String entityId, Calendar authnInst, String holderOfKey, X509Certificate rpCert, Key key) {
        return this.assembleForWSTrust(attrs, before, after, veid, entityId, authnInst, holderOfKey, rpCert, key, "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
    }

    public AssertionType assembleForWSTrust(AttributeMap attrs, int before, int after, String veid, String entityId, Calendar authnInst, String holderOfKey, X509Certificate rpCert, Key key, String keyTransportAlgo) {
        KeyInfoType keyInfo;
        AssertionType assertionType = this.assembleForWSTrust(attrs, before, after, veid, entityId, authnInst, holderOfKey);
        try {
            keyInfo = XmlEncryption.encryptProofKey((XmlObject)assertionType, key, rpCert, keyTransportAlgo);
        }
        catch (XMLEncryptionException | XmlException e) {
            throw new WSTrustException("Unable to assemble SAML 2.0 with holder-of-key confirmation.", e);
        }
        this.assertionTypeUtil.setSubjConfHolderOfKey(keyInfo, assertionType.getSubject());
        return assertionType;
    }

    public AssertionType assemble(Map<String, AttributeValue> attributes, SpConnection sp, String issuer, Calendar authnInst) throws StatusResponseException {
        AttributeMap attributeMap = new AttributeMap();
        attributeMap.putAll(attributes);
        AssertionDocument assertionDoc = AssertionDocument.Factory.newInstance();
        AssertionType assertion = assertionDoc.addNewAssertion();
        this.assertionTypeUtil.setDefaultAttributes(assertion);
        String assertionId = assertion.getID();
        TrackingIdSupport.addReference(assertionId);
        ThreadContext.put((String)AuditLogger.MDC_KEY.ASSERTION_ID.toString(), (String)assertionId);
        int nMinutesBeforeNow = sp.getAssertionValidityBeforeMinutes();
        int nMinutesAfterNow = sp.getAssertionValidityAfterMinutes();
        String audience = null;
        boolean includeAudience = this.config.getBooleanValue("include-AudienceRestrictionCondition-" + sp.getProtocol(), true);
        if (includeAudience) {
            audience = sp.getEntityId();
        }
        this.assertionTypeUtil.setConditions(audience, nMinutesBeforeNow, nMinutesAfterNow, assertion);
        Calendar issueInstant = Util.getUtcCalendar();
        assertion.setIssueInstant(issueInstant);
        this.setIssuer(issuer, assertion);
        String bearer = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
        this.addSubject(attributeMap, assertion);
        SubjectType subject = assertion.getSubject();
        Calendar notOnOrAfter = assertion.getConditions().getNotOnOrAfter();
        this.assertionTypeUtil.setSubjConf(bearer, issuer, null, subject, notOnOrAfter);
        String authnCtxClassRef = this.getAuthnCtxClassRef(attributeMap);
        this.assertionTypeUtil.addAuthnStmt(authnInst, authnCtxClassRef, null, assertion);
        String subjectAttributeKey = AssertionMapKeys.getNameIdValueKey();
        AttributeValue subjectObj = attributes.get(subjectAttributeKey);
        Defense.notNull(subjectObj, "No entry found to map to SAML subject. Looking for key: " + subjectAttributeKey + " in map: " + attributes);
        attributes.remove(subjectAttributeKey);
        attributes.remove(AssertionMapKeys.getNameIdSpQualifierKey());
        this.assertionTypeUtil.addAttributeStatement(attributeMap, sp, assertion);
        return assertion;
    }

    private void setIssuer(String issuer, AssertionType assertion) {
        NameIDType nameIDIssuer = NameIDType.Factory.newInstance();
        nameIDIssuer.setStringValue(issuer);
        assertion.setIssuer(nameIDIssuer);
    }
}

