/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlIDUtil;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.profiles.StatusResponseException;
import org.sourceid.saml20.protocol.GeneralXmlUtil;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.saml20.xmlbinding.protocol.RequestAbstractType;
import org.sourceid.saml20.xmlbinding.protocol.StatusCodeType;
import org.sourceid.saml20.xmlbinding.protocol.StatusDetailType;
import org.sourceid.saml20.xmlbinding.protocol.StatusResponseType;
import org.sourceid.saml20.xmlbinding.protocol.StatusType;

public class StatusResponseTypeUtil {
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.protocol.StatusResponseTypeUtil");

    public static void setDefaults(String issuer, StatusResponseType statusResponseType, RequestAbstractType requestAbstractType) {
        StatusResponseTypeUtil.setDefaultAttributes(statusResponseType, requestAbstractType);
        StatusResponseTypeUtil.setIssuer(issuer, statusResponseType);
        StatusResponseTypeUtil.setStatus(TopLevelStatusCode.SUCCESS, statusResponseType);
    }

    public static void setDefaultAttributes(StatusResponseType statusResponseType, RequestAbstractType requestAbstractType) {
        statusResponseType.setVersion("2.0");
        statusResponseType.setID(XmlIDUtil.createID());
        statusResponseType.setIssueInstant(Util.getUtcCalendar());
        if (requestAbstractType != null) {
            statusResponseType.setInResponseTo(requestAbstractType.getID());
        }
    }

    public static void setIssuer(String issuer, StatusResponseType statusRespType) {
        NameIDType nameIDType = statusRespType.isSetIssuer() ? statusRespType.getIssuer() : statusRespType.addNewIssuer();
        nameIDType.setStringValue(issuer);
    }

    public static void setStatus(TopLevelStatusCode topLevelStatusCode, StatusResponseType statusResponseType) {
        StatusType statusType = statusResponseType.getStatus();
        if (statusType == null) {
            statusType = statusResponseType.addNewStatus();
        }
        StatusCodeType statusCodeType = StatusCodeType.Factory.newInstance();
        statusCodeType.setValue(topLevelStatusCode.getURI());
        statusType.setStatusCode(statusCodeType);
    }

    public static void set2ndLevelStatus(String secondLevelStatusCode, StatusResponseType statusResponseType) {
        StatusCodeType statusCode = statusResponseType.getStatus().getStatusCode();
        if (statusCode.isSetStatusCode()) {
            statusCode.getStatusCode().setValue(secondLevelStatusCode);
        } else {
            statusCode.addNewStatusCode().setValue(secondLevelStatusCode);
        }
    }

    public static void addSubordinateStatus(String subordinateStatusCode, StatusResponseType statusResponseType) {
        StatusCodeType statusCode = statusResponseType.getStatus().getStatusCode();
        while (statusCode.isSetStatusCode()) {
            statusCode = statusCode.getStatusCode();
        }
        statusCode.addNewStatusCode().setValue(subordinateStatusCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStatus(StatusResponseException e, XmlObject requestDoc, XmlObject responseDoc, String virtualServerId) {
        Throwable cause;
        StatusResponseType statusResponseType = (StatusResponseType)XmlBeansUtil.unwrapDocumentToType(responseDoc);
        if (requestDoc != null && GeneralXmlUtil.isRequest(requestDoc)) {
            RequestAbstractType requestAbsType = (RequestAbstractType)XmlBeansUtil.unwrapDocumentToType(requestDoc);
            StatusResponseTypeUtil.setDefaults(virtualServerId, statusResponseType, requestAbsType);
        } else {
            StatusResponseTypeUtil.setDefaults(virtualServerId, statusResponseType, null);
        }
        StatusResponseTypeUtil.setStatus(e.getStatusCode(), statusResponseType);
        StatusType statusType = statusResponseType.getStatus();
        String statusMessage = e.getStatusMessage();
        if (statusMessage != null) {
            statusType.setStatusMessage(statusMessage);
        }
        StatusCodeType statusCodeType = statusType.getStatusCode();
        String[] secondaryStatusCodes = e.getSecondaryStatusCodes();
        for (int i = 0; secondaryStatusCodes != null && i < secondaryStatusCodes.length; ++i) {
            statusCodeType = statusCodeType.addNewStatusCode();
            statusCodeType.setValue(secondaryStatusCodes[i]);
        }
        if (configStore.getBooleanValue("IncludeErrorCauseInSamlResponse", true) && (cause = e.getCause()) != null && cause.getMessage() != null) {
            StatusDetailType statusDetailType = statusType.addNewStatusDetail();
            XmlCursor responseDetailCursor = null;
            try {
                responseDetailCursor = statusDetailType.newCursor();
                responseDetailCursor.toEndToken();
                responseDetailCursor.insertElementWithText("Cause", cause.getMessage());
            }
            finally {
                XmlBeansUtil.disposeCursor(responseDetailCursor);
            }
        }
    }
}

