/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.namespace.QName;
import org.sourceid.common.Util;
import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.AudienceRestrictionType;
import org.sourceid.saml20.xmlbinding.assertion.ConditionAbstractType;
import org.sourceid.saml20.xmlbinding.assertion.ConditionsType;
import org.sourceid.websso.protocol.AssertionConditionsValidator;
import org.sourceid.websso.protocol.TimeConditionUtil;
import org.sourceid.websso.wrapper.AssertionStatus;

public class ValidateAssertionConditions
extends AssertionConditionsValidator {
    private boolean requireAudienceRestriction = true;

    public void setRequireAudienceRestriction(boolean requireAudienceRestriction) {
        this.requireAudienceRestriction = requireAudienceRestriction;
    }

    public void validate(Assertion assertion, List<String> myAudienceIds) {
        int sizeOfUnknownConditions;
        int i;
        AudienceRestrictionType[] audienceRestrictionConditions;
        AssertionType assertionType = assertion.getAssertionType();
        if (!assertionType.isSetConditions()) {
            assertion.addInvalidRemark("No conditions set on assertion");
            return;
        }
        ConditionsType conditions = assertionType.getConditions();
        Calendar now = Util.getUtcCalendar();
        if (conditions.isSetNotBefore()) {
            Calendar notBefore = conditions.getNotBefore();
            try {
                this.timeConditionUtil.validateNotBefore(notBefore, now);
            }
            catch (TimeConditionUtil.InvalidTimeConditionException e) {
                assertion.addInvalidRemark(e.getMessage());
            }
        }
        if (conditions.isSetNotOnOrAfter()) {
            Calendar notOnOrAfter = conditions.getNotOnOrAfter();
            try {
                this.timeConditionUtil.validateNotOnOrAfter(notOnOrAfter, now);
            }
            catch (TimeConditionUtil.InvalidTimeConditionException e) {
                assertion.addInvalidRemark(e.getMessage());
            }
        } else if (this.requireNotOnOrAfter) {
            assertion.addInvalidRemark("Conditions do not contain a NotOnOrAfter restriction");
        }
        boolean allValid = (audienceRestrictionConditions = conditions.getAudienceRestrictionArray()).length > 0 || !this.requireAudienceRestriction;
        boolean[] isConditionValidList = new boolean[audienceRestrictionConditions.length];
        for (i = 0; i < audienceRestrictionConditions.length; ++i) {
            String[] audiences;
            AudienceRestrictionType cond = audienceRestrictionConditions[i];
            String[] stringArray = audiences = cond.getAudienceArray();
            int n = stringArray.length;
            block5: for (int j = 0; j < n; ++j) {
                String audience = stringArray[j];
                for (String myAudienceId : myAudienceIds) {
                    if (!this.audienceEvaluator.evalAudience(myAudienceId, audience)) continue;
                    isConditionValidList[i] = true;
                    continue block5;
                }
            }
        }
        for (i = 0; i < isConditionValidList.length && allValid; ++i) {
            allValid = isConditionValidList[i];
        }
        if (!allValid) {
            assertion.addInvalidRemark(this.audienceEvaluator.getRemark(myAudienceIds.toArray(new String[myAudienceIds.size()])));
        }
        if ((sizeOfUnknownConditions = conditions.sizeOfConditionArray()) > 0) {
            if (assertion.isValid()) {
                assertion.setStatus(AssertionStatus.Status.INDETERMINATE);
            }
            ArrayList<QName> qnames = new ArrayList<QName>(sizeOfUnknownConditions);
            for (ConditionAbstractType condition : conditions.getConditionArray()) {
                qnames.add(condition.schemaType().getName());
            }
            assertion.addRemark("Unknown assertion condition(s): " + ((Object)qnames).toString());
        }
    }
}

