/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.sourceid.common.Util;
import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.xmlbinding.assertion.SubjectConfirmationDataType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectConfirmationType;
import org.sourceid.util.ResourceEvaluator;
import org.sourceid.websso.protocol.SubjectConfirmationDataValidator;
import org.sourceid.websso.protocol.TimeConditionUtil;

public class ValidateSubjectConfirmationData
extends SubjectConfirmationDataValidator {
    private TimeConditionUtil timeConditionUtil = new TimeConditionUtil();
    private ResourceEvaluator resourceEvaluator = new ResourceEvaluator();

    public void validateBearerSubjectConfirmationData(Assertion assertion, String myRecipientId, boolean subjectConfirmationDataRequired) {
        Calendar now = Util.getUtcCalendar();
        SubjectConfirmationType[] subjectConfirmations = assertion.getAssertionType().getSubject().getSubjectConfirmationArray();
        HashMap<SubjectConfirmationDataType, Boolean> bearerSubjectConfirmationData = new HashMap<SubjectConfirmationDataType, Boolean>();
        for (SubjectConfirmationType subjectConfirmation : subjectConfirmations) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConfirmation.getMethod()) || !subjectConfirmation.isSetSubjectConfirmationData()) continue;
            bearerSubjectConfirmationData.put(subjectConfirmation.getSubjectConfirmationData(), Boolean.TRUE);
        }
        if (bearerSubjectConfirmationData.isEmpty() && subjectConfirmationDataRequired) {
            assertion.addInvalidRemark("Assertion Subject Confirmation Data validation failed.  Subject Confirmation Data missing.");
        }
        for (Map.Entry entry : bearerSubjectConfirmationData.entrySet()) {
            boolean isNotBeforeValid = false;
            boolean isNotOnOrAfterValid = false;
            if (((SubjectConfirmationDataType)entry.getKey()).isSetNotBefore()) {
                try {
                    this.timeConditionUtil.validateNotBefore(((SubjectConfirmationDataType)entry.getKey()).getNotBefore(), now);
                    isNotBeforeValid = true;
                }
                catch (TimeConditionUtil.InvalidTimeConditionException e) {
                    assertion.addRemark(e.getMessage());
                }
            } else {
                isNotBeforeValid = true;
            }
            if (((SubjectConfirmationDataType)entry.getKey()).isSetNotOnOrAfter()) {
                try {
                    this.timeConditionUtil.validateNotOnOrAfter(((SubjectConfirmationDataType)entry.getKey()).getNotOnOrAfter(), now);
                    isNotOnOrAfterValid = true;
                }
                catch (TimeConditionUtil.InvalidTimeConditionException e) {
                    assertion.addRemark(e.getMessage());
                }
            }
            if (!isNotBeforeValid || !isNotOnOrAfterValid) {
                entry.setValue(Boolean.FALSE);
                assertion.addRemark("Assertion Subject Confirmation Time Data validation failed.");
            }
            if (((SubjectConfirmationDataType)entry.getKey()).isSetRecipient()) {
                String recipient = ((SubjectConfirmationDataType)entry.getKey()).getRecipient();
                ResourceEvaluator.Result resourceMatch = this.resourceEvaluator.isResourceMatch(recipient, myRecipientId);
                if (resourceMatch.isMatch()) continue;
                StringBuilder remark = new StringBuilder();
                remark.append("Invalid Recipient in SubjectConfirmationData element: ").append(resourceMatch.getMessage());
                assertion.addRemark(remark.toString());
                entry.setValue(Boolean.FALSE);
                continue;
            }
            StringBuilder remark = new StringBuilder();
            remark.append("Assertion subject confirmation recipient validation failed.  Recipient missing.");
            assertion.addRemark(remark.toString());
            entry.setValue(Boolean.FALSE);
        }
        boolean result = false;
        for (Boolean value : bearerSubjectConfirmationData.values()) {
            result |= value.booleanValue();
        }
        if (!result && !bearerSubjectConfirmationData.isEmpty()) {
            assertion.addInvalidRemark("Assertion Subject Confirmation Data validation failed.");
        }
    }
}

