/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.protocol;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.protocol.ValidateAssertionConditions;
import org.sourceid.saml20.protocol.ValidateAssertionHasSubjectStatements;
import org.sourceid.saml20.protocol.ValidateAssertionIssuerNameId;
import org.sourceid.saml20.protocol.ValidateAssertionSignature;
import org.sourceid.saml20.protocol.ValidateWebSsoBearerAssertion;
import org.sourceid.saml20.wrapper.Assertion;
import org.sourceid.saml20.wrapper.WebSsoResponse;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.saml20.xmlbinding.assertion.AuthnStatementType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectType;
import org.sourceid.saml20.xmlbinding.protocol.ResponseDocument;
import org.sourceid.saml20.xmlbinding.protocol.ResponseType;
import org.sourceid.websso.profiles.InvalidResponseException;
import org.sourceid.websso.profiles.InvalidSsoResponseException;
import org.sourceid.websso.wrapper.InMessageContext;

public class ValidateWebSsoResponse {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ValidateAssertionSignature validateAssertionSignature = new ValidateAssertionSignature();
    private final ValidateAssertionConditions validateAssertionConditions = new ValidateAssertionConditions();
    private final ValidateAssertionIssuerNameId validateAssertionIssuerNameId = new ValidateAssertionIssuerNameId();
    private final ValidateAssertionHasSubjectStatements validateAssertionHasSubjectStmts = new ValidateAssertionHasSubjectStatements();
    private final ValidateWebSsoBearerAssertion validateWebSsoBearerAssertion = new ValidateWebSsoBearerAssertion();

    public WebSsoResponse validateResponse(InMessageContext respCtx, List<String> myAudienceIds, boolean assertionSignsAlreadyValidated, String assertionConsumerSvc, String requestId) throws InvalidResponseException, MalformedURLException {
        Assertion assertion;
        ResponseType responseType = ((ResponseDocument)respCtx.getXmlObject()).getResponse();
        int numAssertions = responseType.sizeOfAssertionArray();
        ArrayList<Assertion> validAssertions = new ArrayList<Assertion>(numAssertions);
        ArrayList<Assertion> invalidAssertions = new ArrayList<Assertion>(numAssertions);
        String binding = respCtx.getBinding();
        for (AssertionType assertionType : responseType.getAssertionArray()) {
            assertion = this.validateAssertion(assertionType, assertionSignsAlreadyValidated, myAudienceIds, assertionConsumerSvc, requestId, binding);
            if (assertion.isValid()) {
                validAssertions.add(assertion);
                continue;
            }
            this.log.warn((Object)("Invalid assertion " + assertion));
            invalidAssertions.add(assertion);
        }
        if (validAssertions.isEmpty()) {
            StringBuilder msg = new StringBuilder().append("Response contains no valid assertions: ");
            msg.append(((Object)invalidAssertions).toString()).append(". ").append(respCtx);
            throw new InvalidSsoResponseException(msg.toString());
        }
        SubjectType subject = null;
        AuthnStatementType authnStatementType = null;
        Assertion ssoAssertion = null;
        Iterator i = validAssertions.iterator();
        while (i.hasNext()) {
            assertion = (Assertion)i.next();
            AssertionType assertionType = assertion.getAssertionType();
            if (assertionType.sizeOfAuthnStatementArray() <= 0) continue;
            authnStatementType = assertionType.getAuthnStatementArray(0);
            subject = assertionType.getSubject();
            ssoAssertion = assertion;
            i.remove();
            break;
        }
        if (ssoAssertion == null) {
            StringBuilder msg = new StringBuilder();
            msg.append("(Profiles 4.1.4.2) The assertions in the <Response> MUST contain at ");
            msg.append("least one <AuthnStatement> that reflects the authentication of the principal to the identity ");
            msg.append("provider.   Valid assertions: ").append(validAssertions).append("  Not valid assertions: ");
            msg.append(invalidAssertions).append(". ").append(respCtx);
            throw new InvalidSsoResponseException(msg.toString());
        }
        return new WebSsoResponse(ssoAssertion, subject, authnStatementType, validAssertions);
    }

    Assertion validateAssertion(AssertionType assertionType, boolean assertionSignaturesAlreadyValidated, List<String> myAudienceIds, String assertionConsumerSvc, String requestId, String binding) throws MalformedURLException {
        Assertion assertion = new Assertion(assertionType);
        this.validateAssertionSignature.validate(assertion, assertionSignaturesAlreadyValidated);
        this.validateAssertionConditions.validate(assertion, myAudienceIds);
        this.validateAssertionIssuerNameId.validate(assertion);
        this.validateAssertionHasSubjectStmts.validate(assertion);
        this.validateWebSsoBearerAssertion.validate(assertion, assertionConsumerSvc, requestId, binding);
        return assertion;
    }
}

