/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.service.ArtifactPersistenceServiceException;
import org.sourceid.util.ExternalizationEncoder;

public interface ArtifactPersistenceService {
    public byte[] precomputeHandle(int var1);

    public Handle saveArtifact(Message var1, int var2) throws ArtifactPersistenceServiceException;

    public Message retrieveAndRemoveArtifact(byte[] var1) throws ArtifactPersistenceServiceException;

    public static class Message
    implements Externalizable {
        private Object msg;
        private String entityId;
        private Role partnerRole;
        private Set<String> maskedAttributeNames;
        private transient int messageHandleLength = 20;
        private transient byte[] handle;

        public Message() {
        }

        public Message(Object msg) {
            this.msg = msg;
        }

        public Message(XmlObject xml, String entityId, Role partnerRole) {
            this.msg = xml;
            this.entityId = entityId;
            this.partnerRole = partnerRole;
        }

        public XmlObject getXml() {
            return (XmlObject)this.msg;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public Role getPartnerRole() {
            return this.partnerRole;
        }

        public Set<String> getMaskedAttributeNames() {
            return this.maskedAttributeNames;
        }

        public void setMaskedAttributeNames(Set<String> maskedAttributeNames) {
            this.maskedAttributeNames = maskedAttributeNames;
        }

        public int getMessageHandleLength() {
            return this.messageHandleLength;
        }

        public void setMessageHandleLength(int messageHandleLength) {
            this.messageHandleLength = messageHandleLength;
        }

        public byte[] getHandle() {
            return this.handle;
        }

        public void setHandle(byte[] handle) {
            this.handle = handle;
        }

        public Object getMsg() {
            return this.msg;
        }

        public String toString() {
            return "Message{partnerRole=" + this.partnerRole + ", entityId='" + this.entityId + "', msg=" + this.msg + "}";
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            boolean isXmlObject = ExternalizationEncoder.readBoolean(in);
            this.msg = isXmlObject ? ExternalizationEncoder.readXmlObject(in) : in.readObject();
            this.entityId = ExternalizationEncoder.readString(in);
            String roleStr = ExternalizationEncoder.readString(in);
            if (roleStr != null) {
                this.partnerRole = Role.valueOf(roleStr);
            }
            this.maskedAttributeNames = ExternalizationEncoder.readStringSet(in);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            boolean isXmlObject = this.msg instanceof XmlObject;
            ExternalizationEncoder.writeBoolean(out, isXmlObject);
            if (isXmlObject) {
                ExternalizationEncoder.writeXmlObject(out, (XmlObject)this.msg);
            } else {
                out.writeObject(this.msg);
            }
            ExternalizationEncoder.writeString(out, this.entityId);
            if (this.partnerRole == null) {
                ExternalizationEncoder.writeNull(out);
            } else {
                ExternalizationEncoder.writeString(out, this.partnerRole.toString());
            }
            ExternalizationEncoder.writeStringSet(out, this.maskedAttributeNames);
        }
    }

    public static class Handle
    implements Serializable {
        private byte[] messageHandle;
        private int endpointIndex;

        public Handle(byte[] messageHandle) {
            this.messageHandle = messageHandle;
        }

        public Handle(byte[] messageHandle, int endpointIndex) {
            this.messageHandle = messageHandle;
            this.endpointIndex = endpointIndex;
        }

        public byte[] getMessageHandle() {
            return this.messageHandle;
        }

        public int getEndpointIndex() {
            return this.endpointIndex;
        }
    }
}

