/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service;

import java.util.Collection;
import java.util.Set;
import org.sourceid.saml20.service.AbstractAuthnSessionInfo;
import org.sourceid.saml20.service.AuthnSessionInfo;
import org.sourceid.saml20.service.CachedSessionGroupStatus;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.session.AuthnSessionContextData;

public class AuthnSessionInfoImpl
extends AbstractAuthnSessionInfo {
    AuthnSessionInfoImpl(long sessionSeriesId, Set<IdpHashableAuthnBean> beans, boolean hasAuthnSessions, String persistentSessionGroupId, Collection<CachedSessionGroupStatus> sessionGroupStatuses, long lastActivityTimeMillis, Set<String> uniqueUserKeys, AuthnSessionContextData sessionContextData, Set<String> indexKeysToRefresh) {
        super(sessionSeriesId, beans, hasAuthnSessions, persistentSessionGroupId, sessionGroupStatuses, lastActivityTimeMillis, uniqueUserKeys, sessionContextData, indexKeysToRefresh);
    }

    public static class Builder {
        private Set<IdpHashableAuthnBean> beans;
        private long sessionSeriesId;
        private Collection<CachedSessionGroupStatus> sessionGroupStatuses;
        private String persistentSessionGroupId;
        private long lastActivityTimeMillis;
        private Set<String> uniqueUserKeys;
        private AuthnSessionContextData sessionContextData;
        private Set<String> indexKeysToRefresh;

        public Builder setBeans(Set<IdpHashableAuthnBean> beans) {
            this.beans = beans;
            return this;
        }

        public Builder setSessionSeriesId(long sessionSeriesId) {
            this.sessionSeriesId = sessionSeriesId;
            return this;
        }

        public Builder setPersistentSessionGroupId(String persistentSessionGroupId) {
            this.persistentSessionGroupId = persistentSessionGroupId;
            return this;
        }

        public Builder setSessionGroupStatuses(Collection<CachedSessionGroupStatus> sessionGroupStatuses) {
            this.sessionGroupStatuses = sessionGroupStatuses;
            return this;
        }

        public Builder setLastActivityTimeMillis(long lastActivityTimeMillis) {
            this.lastActivityTimeMillis = lastActivityTimeMillis;
            return this;
        }

        public Builder setUniqueUserKeys(Set<String> uniqueUserKeys) {
            this.uniqueUserKeys = uniqueUserKeys;
            return this;
        }

        public Builder setSessionContextData(AuthnSessionContextData sessionContextData) {
            this.sessionContextData = sessionContextData;
            return this;
        }

        public Builder setIndexKeysToRefresh(Set<String> indexKeysToRefresh) {
            this.indexKeysToRefresh = indexKeysToRefresh;
            return this;
        }

        public AuthnSessionInfo build() {
            boolean hasAuthnSessions = this.beans != null && this.beans.stream().anyMatch(IdpHashableAuthnBean::isValidForSso);
            return new AuthnSessionInfoImpl(this.sessionSeriesId, this.beans, hasAuthnSessions, this.persistentSessionGroupId, this.sessionGroupStatuses, this.lastActivityTimeMillis, this.uniqueUserKeys, this.sessionContextData, this.indexKeysToRefresh);
        }
    }
}

