/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.pingidentity.sdk.AuthenticationSourceKey;
import java.io.Serializable;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;

@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public abstract class AuthnSourceKey
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final String id;

    @JsonIgnore
    public abstract AuthnSourceType getType();

    @JsonIgnore
    public abstract String getFriendlyId();

    protected AuthnSourceKey() {
        this.id = null;
    }

    protected AuthnSourceKey(String id) {
        this.id = id;
    }

    public AuthnSourceKey clone() {
        try {
            return (AuthnSourceKey)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.getType() == null ? 0 : this.getType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthnSourceKey other = (AuthnSourceKey)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.getType() == other.getType();
    }

    public boolean equalsIncludeAllFields(Object obj) {
        return this.equals(obj);
    }

    public String toString() {
        return "Type=" + this.getType().toString() + ", Id=" + this.getId();
    }

    public String getId() {
        return this.id;
    }

    public AuthenticationSourceKey toPublicAuthnSourceKey() {
        if (this.getType() == AuthnSourceType.ADAPTER) {
            return new AuthenticationSourceKey(AuthenticationSourceKey.Type.IDP_ADAPTER, this.id);
        }
        return new AuthenticationSourceKey(AuthenticationSourceKey.Type.IDP_CONNECTION, this.id);
    }

    public static AuthnSourceKey fromPublicAuthnSourceKey(AuthenticationSourceKey sourceKey) {
        if (sourceKey.getType() == AuthenticationSourceKey.Type.IDP_ADAPTER) {
            return new AdapterAuthnSourceKey(sourceKey.getId());
        }
        return new IdpConnAuthnSourceKey(sourceKey.getId());
    }

    public static enum AuthnSourceType {
        ADAPTER,
        IDP_CONN,
        LOCAL_IDENTITY,
        FRAGMENT,
        CONTEXT;

    }
}

