/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.sourceid.saml20.service.session.SessionGroupInfo;

public class CachedSessionGroupInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private long lastActivityTimeMillis;
    private boolean deleted = false;

    public CachedSessionGroupInfo(String sessionGroupId) {
        this.id = sessionGroupId;
    }

    public CachedSessionGroupInfo(SessionGroupInfo sessionGroupInfo) {
        this.id = sessionGroupInfo.getId();
        this.lastActivityTimeMillis = sessionGroupInfo.getLastActivityTimeMillis();
    }

    public static CachedSessionGroupInfo makeDeletedInfo(String sessionGroupId) {
        CachedSessionGroupInfo info = new CachedSessionGroupInfo(sessionGroupId);
        info.setDeleted(true);
        return info;
    }

    public String getId() {
        return this.id;
    }

    public long getLastActivityTimeMillis() {
        return this.lastActivityTimeMillis;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return String.format("CachedSessionGroupInfo: id=%s, lastActivityTime=%s, deleted=%s", this.id, dateFormat.format(this.lastActivityTimeMillis), this.deleted);
    }
}

