/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.sdk.DeviceSharingType;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.domain.SamlNameID;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.util.log.AttributeMap;

public class IdpConnHashableAuthnBean
extends IdpHashableAuthnBean {
    private static final long serialVersionUID = 1L;
    private String virtualServerId;
    private List<String> authenticatingAuthorities;
    private String sessionIndex;
    private SamlNameID nameId;
    private String entityId;
    private String subject;
    private String issuer;
    private String idToken;

    protected IdpConnHashableAuthnBean() {
    }

    public IdpConnHashableAuthnBean(AttributeMap assertionAttrs, String localSessionId, AuthnSourceKey authnSourceKey, String entityId, String requestedUserId, String virtualServerId, List<String> authenticatingAuthorities, String sessionIndex, SamlNameID nameId, DeviceSharingType deviceSharingType) throws IOException {
        super((Map<String, Object>)assertionAttrs, Arrays.asList(AssertionMapKeys.getAuthnInstantKey()), localSessionId, authnSourceKey, requestedUserId, Arrays.asList(entityId, virtualServerId, sessionIndex, nameId), deviceSharingType);
        this.entityId = entityId;
        this.virtualServerId = virtualServerId;
        this.authenticatingAuthorities = authenticatingAuthorities;
        this.sessionIndex = sessionIndex;
        this.nameId = nameId;
    }

    public IdpConnHashableAuthnBean(AttributeMap assertionAttrs, String localSessionId, AuthnSourceKey authnSourceKey, String entityId, String requestedUserId, String virtualServerId, List<String> authenticatingAuthorities, String sessionIndex, NameIDType nameId, DeviceSharingType deviceSharingType) throws IOException {
        this(assertionAttrs, localSessionId, authnSourceKey, entityId, requestedUserId, virtualServerId, authenticatingAuthorities, sessionIndex, nameId == null ? null : new SamlNameID(nameId), deviceSharingType);
    }

    public IdpConnHashableAuthnBean(AttributeMap assertionAttrs, String localSessionId, AuthnSourceKey authnSourceKey, String entityId, String requestedUserId, String virtualServerId, List<String> authenticatingAuthorities, String issuer, String subject, String sid, String idToken, DeviceSharingType deviceSharingType) throws IOException {
        super((Map<String, Object>)assertionAttrs, Arrays.asList(AssertionMapKeys.getAuthnInstantKey()), localSessionId, authnSourceKey, requestedUserId, Arrays.asList(entityId, virtualServerId, issuer, subject, sid), deviceSharingType);
        this.entityId = entityId;
        this.virtualServerId = virtualServerId;
        this.authenticatingAuthorities = authenticatingAuthorities;
        this.issuer = issuer;
        this.subject = subject;
        this.sessionIndex = sid;
        this.idToken = idToken;
    }

    public IdpConnHashableAuthnBean(IdpConnHashableAuthnBean copyFrom, boolean forSso) {
        super(copyFrom, (Map<String, Object>)(forSso ? new AttributeMap((Map)copyFrom.getAssertionAttrs()) : new AttributeMap()));
        this.entityId = copyFrom.entityId;
        this.virtualServerId = copyFrom.virtualServerId;
        this.authenticatingAuthorities = copyFrom.authenticatingAuthorities;
        this.sessionIndex = copyFrom.sessionIndex;
        this.nameId = copyFrom.nameId;
        this.issuer = copyFrom.issuer;
        this.subject = copyFrom.subject;
        this.idToken = copyFrom.idToken;
    }

    @JsonIgnore
    public AttributeMap getAssertionAttrs() {
        return (AttributeMap)this.getAuthnIdentifiersMap();
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getVirtualServerId() {
        return this.virtualServerId;
    }

    public List<String> getAuthenticatingAuthorities() {
        return this.authenticatingAuthorities;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public SamlNameID getNameId() {
        return this.nameId;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    @JsonIgnore
    public String getSid() {
        return this.sessionIndex;
    }

    public String getIdToken() {
        return this.idToken;
    }

    @Override
    protected Map<String, Object> copyAuthnIdentifiersMap() {
        if (this.authnIdentifiersMap == null) {
            return null;
        }
        return new AttributeMap(this.authnIdentifiersMap);
    }
}

