/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.pingidentity.common.util.SerialHashable;
import com.pingidentity.sdk.AuthenticationSession;
import com.pingidentity.sdk.AuthenticationSourceKey;
import com.pingidentity.sdk.DeviceSharingType;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.session.AuthnIdentifiersToString;
import org.sourceid.saml20.service.session.StringToAuthnIdentifiers;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.servlet.SessionIdUtil;

@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class IdpHashableAuthnBean
extends SerialHashable
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, Object> authnIdentifiersMap;
    private Map<String, Object> mutableAuthnIdentifiersMap;
    private String primarySessionId;
    private AuthnSourceKey authnSourceKey;
    private String requestedUserId;
    private int originalIdleTimeoutMins = -1;
    private long creationTimeMillis;
    private long notOnOrAfterMillis = Long.MAX_VALUE;
    private boolean validForSso = false;
    private boolean doLogout = false;
    private String storedSessionGroupId;
    private DeviceSharingType deviceSharingType = DeviceSharingType.PRIVATE;

    protected IdpHashableAuthnBean() {
    }

    public IdpHashableAuthnBean(Map<String, Object> authnIdentifiers, String primarySessionId, AuthnSourceKey authnSourceKey, String requestedUserId) throws IOException {
        this(authnIdentifiers, primarySessionId, authnSourceKey, requestedUserId, DeviceSharingType.PRIVATE);
    }

    public IdpHashableAuthnBean(Map<String, Object> authnIdentifiers, String primarySessionId, AuthnSourceKey authnSourceKey, String requestedUserId, DeviceSharingType deviceSharingType) throws IOException {
        this(authnIdentifiers, Arrays.asList("org.sourceid.saml20.adapter.idp.authn.authnInst"), primarySessionId, authnSourceKey, requestedUserId, Collections.emptyList(), deviceSharingType);
    }

    public IdpHashableAuthnBean(IdpHashableAuthnBean copyFrom) {
        this(copyFrom, new HashMap<String, Object>(copyFrom.authnIdentifiersMap));
    }

    public static IdpHashableAuthnBean copy(IdpHashableAuthnBean copyFrom) {
        if (copyFrom instanceof IdpConnHashableAuthnBean) {
            return new IdpConnHashableAuthnBean((IdpConnHashableAuthnBean)copyFrom, copyFrom.isValidForSso());
        }
        return new IdpHashableAuthnBean(copyFrom);
    }

    @JsonIgnore
    public AuthenticationSession getAuthenticationSession() {
        AuthenticationSourceKey publicSourceKey = null;
        if (this.authnSourceKey != null) {
            publicSourceKey = this.authnSourceKey.toPublicAuthnSourceKey();
        }
        return new AuthenticationSession(publicSourceKey, this.getAuthnIdentifiersMap(), this.creationTimeMillis);
    }

    public IdpHashableAuthnBean(IdpHashableAuthnBean copyFrom, Map<String, Object> authnIdentifiersCopy) {
        super(copyFrom);
        this.authnIdentifiersMap = authnIdentifiersCopy;
        this.primarySessionId = copyFrom.primarySessionId;
        this.authnSourceKey = copyFrom.authnSourceKey;
        this.requestedUserId = copyFrom.requestedUserId;
        this.creationTimeMillis = copyFrom.creationTimeMillis;
        this.notOnOrAfterMillis = copyFrom.notOnOrAfterMillis;
        this.validForSso = copyFrom.validForSso;
        this.doLogout = copyFrom.doLogout;
        this.storedSessionGroupId = copyFrom.storedSessionGroupId;
        this.originalIdleTimeoutMins = copyFrom.originalIdleTimeoutMins;
        this.deviceSharingType = copyFrom.deviceSharingType;
    }

    protected IdpHashableAuthnBean(Map<String, Object> authnIdentifiers, List<String> identifiersIgnoredForKey, String primarySessionId, AuthnSourceKey authnSourceKey, String requestedUserId, List<Serializable> additionalKeys, DeviceSharingType deviceSharingType) throws IOException {
        ArrayList<Object> serializables = new ArrayList<Object>();
        serializables.add(this.getAuthnIdentifiersForKey(authnIdentifiers, identifiersIgnoredForKey));
        serializables.add(authnSourceKey);
        serializables.add(requestedUserId);
        serializables.addAll(additionalKeys);
        this.initializeHash(new Serializable[]{serializables.toArray()});
        this.authnIdentifiersMap = authnIdentifiers;
        this.primarySessionId = primarySessionId;
        this.authnSourceKey = authnSourceKey;
        this.requestedUserId = requestedUserId;
        this.creationTimeMillis = System.currentTimeMillis();
        this.deviceSharingType = deviceSharingType;
    }

    @JsonSerialize(converter=AuthnIdentifiersToString.class)
    @JsonDeserialize(converter=StringToAuthnIdentifiers.class)
    public Map<String, Object> getAuthnIdentifiersMap() {
        if (this.mutableAuthnIdentifiersMap == null) {
            this.mutableAuthnIdentifiersMap = this.copyAuthnIdentifiersMap();
        }
        return this.mutableAuthnIdentifiersMap;
    }

    public String getPrimarySessionId() {
        return this.primarySessionId;
    }

    @JsonIgnore
    public String getSri() {
        return SessionIdUtil.getInstance().getSriFromPrimaryValue(this.primarySessionId);
    }

    public void setPrimarySessionId(String primarySessionId) {
        this.primarySessionId = primarySessionId;
    }

    public AuthnSourceKey getAuthnSourceKey() {
        return this.authnSourceKey;
    }

    public String getRequestedUserId() {
        return this.requestedUserId;
    }

    public long getCreationTimeMillis() {
        return this.creationTimeMillis;
    }

    public long getNotOnOrAfterMillis() {
        return this.notOnOrAfterMillis;
    }

    public void setNotOnOrAfterMillis(long notOnOrAfterMillis) {
        this.notOnOrAfterMillis = notOnOrAfterMillis;
    }

    public boolean isValidForSso() {
        return this.validForSso;
    }

    public void setValidForSso(boolean validForSso) {
        this.validForSso = validForSso;
    }

    public boolean isDoLogout() {
        return this.doLogout;
    }

    public void setDoLogout(boolean doLogout) {
        this.doLogout = doLogout;
    }

    public String getStoredSessionGroupId() {
        return this.storedSessionGroupId;
    }

    public void setStoredSessionGroupId(String storedSessionGroupId) {
        this.storedSessionGroupId = storedSessionGroupId;
    }

    public int getOriginalIdleTimeoutMins() {
        return this.originalIdleTimeoutMins;
    }

    public void setOriginalIdleTimeoutMins(int mins) {
        this.originalIdleTimeoutMins = mins;
    }

    public DeviceSharingType getDeviceSharingType() {
        return this.deviceSharingType;
    }

    public void setDeviceSharingType(DeviceSharingType deviceSharingType) {
        this.deviceSharingType = deviceSharingType;
    }

    @JsonIgnore
    public AttributeValue getAuthnCtx() {
        String authnCtxString = this.getAuthnCtxString();
        if (authnCtxString == null) {
            return null;
        }
        return new AttributeValue(authnCtxString);
    }

    protected Map<String, Object> copyAuthnIdentifiersMap() {
        if (this.authnIdentifiersMap == null) {
            return null;
        }
        return new HashMap<String, Object>(this.authnIdentifiersMap);
    }

    private TreeMap<String, Object> getAuthnIdentifiersForKey(Map<String, Object> identifiers, List<String> identifiersIgnoredForKey) {
        TreeMap<String, Object> result = new TreeMap<String, Object>(identifiers);
        for (String ignored : identifiersIgnoredForKey) {
            result.remove(ignored);
        }
        return result;
    }

    private String getAuthnCtxString() {
        String currentDefaultAuthnCtx;
        String authnCtxString = null;
        AuthnSourceKey authnSourceKey = this.getAuthnSourceKey();
        Map<String, Object> authnBeanAttrs = this.getAuthnIdentifiersMap();
        Object o = null;
        if (authnBeanAttrs.containsKey(AssertionMapKeys.getAuthnCtxOverrideKey())) {
            o = authnBeanAttrs.get(AssertionMapKeys.getAuthnCtxOverrideKey());
        }
        if (o == null && authnBeanAttrs.containsKey(AssertionMapKeys.getAuthnCtxKey())) {
            o = authnBeanAttrs.get(AssertionMapKeys.getAuthnCtxKey());
        }
        if (o == null && this instanceof IdpConnHashableAuthnBean) {
            IdpConnHashableAuthnBean idpConnBean = (IdpConnHashableAuthnBean)this;
            IdpConnection idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(idpConnBean.getAuthnSourceKey().getId(), false);
            if (idpConn != null && idpConn.getProtocol() == Protocol.OIDC) {
                o = authnBeanAttrs.get("acr");
            }
        }
        Object adapterCtx = null;
        if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
            adapterCtx = authnBeanAttrs.get("org.sourceid.saml20.adapter.idp.authn.authnCtx");
            if (o == null && adapterCtx != null) {
                o = adapterCtx;
            }
        }
        if (o != null) {
            authnCtxString = o instanceof AttributeValue ? ((AttributeValue)o).getValue() : o.toString();
        }
        if (authnCtxString == null && authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER && StringUtils.isNotEmpty((String)(currentDefaultAuthnCtx = this.getConfiguredAuthnCtx(authnSourceKey.getId())))) {
            authnCtxString = currentDefaultAuthnCtx;
        }
        return authnCtxString;
    }

    private String getConfiguredAuthnCtx(String adapterId) {
        IdpAuthnAdapterInstance instance = MgmtFactory.getAdapterManager().getIdpAuthnAdapterInstance(adapterId);
        if (instance != null && instance.getDescriptor().allowConfigurableAuthnCtx()) {
            return instance.getAuthnCtxClassRef();
        }
        return null;
    }
}

