/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service;

import org.sourceid.saml20.domain.SamlNameID;
import org.sourceid.saml20.service.Session;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;

public class WebSsoSession
extends Session {
    private final String entityId;
    private final String virtualServerId;
    private final String assertionId;
    private final String sessionIndex;
    private SamlNameID nameId = null;
    private boolean maskUserName = false;

    public WebSsoSession(String entityId, String virtualServerId, String assertionId, String sessionIndex, SamlNameID nameId) {
        this.entityId = entityId;
        this.virtualServerId = virtualServerId;
        this.assertionId = assertionId;
        this.sessionIndex = sessionIndex;
        this.nameId = nameId;
    }

    public WebSsoSession(String entityId, String virtualServerId, String assertionId, String sessionIndex, NameIDType nameId) {
        this(entityId, virtualServerId, assertionId, sessionIndex, nameId == null ? null : new SamlNameID(nameId));
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getVirtualServerId() {
        return this.virtualServerId;
    }

    public String getAssertionId() {
        return this.assertionId;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public SamlNameID getNameId() {
        return this.nameId;
    }

    public void setMaskUserName(boolean maskUserName) {
        this.maskUserName = maskUserName;
    }

    @Override
    public boolean isMaskUserName() {
        return this.maskUserName;
    }

    @Override
    public String getUserName() {
        return this.getNameId().getValue();
    }

    @Override
    public String getPartnerId() {
        return this.getEntityId();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.assertionId == null ? 0 : this.assertionId.hashCode());
        result = 31 * result + (this.entityId == null ? 0 : this.entityId.hashCode());
        result = 31 * result + (this.maskUserName ? 1231 : 1237);
        result = 31 * result + (this.nameId == null ? 0 : this.nameId.hashCode());
        result = 31 * result + (this.sessionIndex == null ? 0 : this.sessionIndex.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSsoSession other = (WebSsoSession)obj;
        if (this.assertionId == null ? other.assertionId != null : !this.assertionId.equals(other.assertionId)) {
            return false;
        }
        if (this.entityId == null ? other.entityId != null : !this.entityId.equals(other.entityId)) {
            return false;
        }
        if (this.maskUserName != other.maskUserName) {
            return false;
        }
        if (this.nameId == null) {
            if (other.nameId != null) {
                return false;
            }
        } else {
            if (other.nameId == null) {
                return false;
            }
            if (!this.nameId.equals(other.nameId)) {
                return false;
            }
        }
        return !(this.sessionIndex == null ? other.sessionIndex != null : !this.sessionIndex.equals(other.sessionIndex));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WebSsoSession");
        sb.append("{entityId='").append(this.entityId).append('\'');
        sb.append(", assertionId='").append(this.assertionId).append('\'');
        sb.append(", sessionIndex='").append(this.sessionIndex).append('\'');
        sb.append(", nameId(value)=").append(this.nameId != null ? this.nameId.getValue() : null);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "WebSsoSession{assertionId='" + this.assertionId + "'}";
    }
}

