/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl;

import com.pingidentity.common.util.JDBCHelper;
import com.pingidentity.configservice.AutoReloadable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.naming.NamingException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AccountLinkingService;
import org.sourceid.saml20.service.AccountLinkingServiceException;
import org.sourceid.saml20.service.impl.AccountLinkingServiceBase;

public class AccountLinkingServiceDBImpl
extends AccountLinkingServiceBase
implements AccountLinkingService,
AutoReloadable {
    private ConfigStore configStore = ConfigStoreFarm.getConfig(this.getClass());
    private static final String TABLENAME = "pingfederate_account_link";
    private static final String FIELDNAME_IDP_ID = "idp_entityid";
    private static final String FIELDNAME_EXTERNAL_USERID = "external_userid";
    private static final String FIELDNAME_ADAPTERID = "adapter_id";
    private static final String FIELDNAME_LOCAL_USERID = "local_userid";
    private static final String FIELDNAME_DATECREATED = "date_created";
    private static String selectStmt = "SELECT local_userid FROM pingfederate_account_link WHERE idp_entityid=? and adapter_id=? and external_userid=?";
    private static String insertStmt = "INSERT INTO pingfederate_account_link (idp_entityid,external_userid,adapter_id,local_userid,date_created) VALUES (?,?,?,?,?)";
    private static String deleteStmt = "DELETE FROM pingfederate_account_link WHERE idp_entityid=? and adapter_id=? and external_userid=?";

    @Override
    public void terminateLink(String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = new JDBCHelper(this.getJndiName(), this);
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(deleteStmt);
            stmt.setString(1, idpEntityId);
            stmt.setString(2, authnAdapterId);
            stmt.setString(3, externalIdentifier);
            stmt.execute();
        }
        catch (SQLException | NamingException e) {
            throw new AccountLinkingServiceException(e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
    }

    @Override
    public String lookupLink(String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        String localUserId = null;
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = new JDBCHelper(this.getJndiName(), this);
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(selectStmt);
            stmt.setString(1, idpEntityId);
            stmt.setString(2, authnAdapterId);
            stmt.setString(3, externalIdentifier);
            ResultSet resultSet = jdbcHelper.getResultSet();
            if (resultSet.next()) {
                localUserId = resultSet.getString(FIELDNAME_LOCAL_USERID);
            }
        }
        catch (SQLException | NamingException e) {
            throw new AccountLinkingServiceException(e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
        return localUserId;
    }

    @Override
    public void storeLink(String localIdentifier, String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        Date now = new Date();
        JDBCHelper jdbcHelper = null;
        try {
            jdbcHelper = new JDBCHelper(this.getJndiName(), this);
            PreparedStatement stmt = jdbcHelper.getPreparedStatement(insertStmt);
            stmt.setString(1, idpEntityId);
            stmt.setString(2, externalIdentifier);
            stmt.setString(3, authnAdapterId);
            stmt.setString(4, localIdentifier);
            stmt.setTimestamp(5, new Timestamp(now.getTime()));
            stmt.execute();
        }
        catch (SQLException | NamingException e) {
            throw new AccountLinkingServiceException(e);
        }
        finally {
            if (jdbcHelper != null) {
                jdbcHelper.cleanUp();
            }
        }
    }

    @Override
    public boolean isDataSourceInUse(String datasourceId) {
        return datasourceId != null && datasourceId.equals(this.getJndiName());
    }

    private String getJndiName() {
        return this.configStore.getStringValue("PingFederateDSJNDIName", "PFDefaultDS");
    }

    static {
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        dsMgr.getJdbcDataSources();
    }
}

