/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl;

import com.pingidentity.common.util.B64;
import com.pingidentity.configservice.AutoReloadable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Random;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.service.PseudonymService;

public class PseudonymServiceSha1Impl
implements PseudonymService,
AutoReloadable {
    private static final byte NULL_CHAR_BYTE = 0;
    private static final String ENTROPY_KEY = "entropy";
    private ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private byte[] entropy;

    public PseudonymServiceSha1Impl() {
        this.loadConfig();
    }

    private void loadConfig() {
        this.entropy = this.doGetSetEntropy(ENTROPY_KEY);
    }

    private byte[] doGetSetEntropy(String configKey) {
        byte[] temp;
        String value = this.config.getStringValue(configKey, null);
        if (value == null) {
            Random random = new Random();
            temp = new byte[3 + random.nextInt(8)];
            random.nextBytes(temp);
            value = new String(temp, StandardCharsets.UTF_8);
            value = B64.encode((String)value);
            this.config.setStringValue(configKey, value);
        }
        temp = B64.decodeToBytes((String)value);
        return temp;
    }

    @Override
    public String getPseudonym(String localIdentification, String spEntityId, boolean allowCreate) {
        MessageDigest digester = HashUtil.getMessageDigester((HashAlgorithm)HashAlgorithm.SHA1);
        try {
            digester.update(this.entropy);
            digester.update((byte)0);
            digester.update(localIdentification.getBytes("UTF-8"));
            digester.update((byte)0);
            digester.update(spEntityId.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] digestBytes = digester.digest();
        return HexBin.bytesToString((byte[])digestBytes);
    }

    public void terminatePseudonym(String pseudonym, String spEntityId) {
    }
}

