/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.cookie;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.CookieMonster;
import com.pingidentity.common.util.CtxClassLoaderObjectInputStream;
import com.pingidentity.common.util.ErrorHandler;
import com.pingidentity.common.util.LogGuard;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.common.compression.DeflateRFC1951;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.service.InterRequestStateMgmt;
import org.sourceid.saml20.service.impl.cookie.KeyTracker;
import org.sourceid.saml20.service.impl.cookie.KeyTrackerGroupRpcImpl;
import org.sourceid.saml20.service.impl.cookie.KeyTrackerStaticKeyImpl;
import org.sourceid.saml20.service.impl.cookie.KeyWrapper;
import org.sourceid.saml20.state.State;
import org.sourceid.servlet.HttpServletRespProxy;

@Deprecated
public class InterReqStateMgmtCookieImpl
implements InterRequestStateMgmt {
    private Log log = LogFactory.getLog(this.getClass());
    private ConfigStore config = ConfigStoreFarm.getConfig("inter-req-cookie-config");
    private final String STATE_COOKIE_NAME = this.config.getStringValue("state-cookie-name", "X");
    private final String IDP_COOKIE_NAME = this.config.getStringValue("idp-cookie-name", "");
    private final String SP_COOKIE_NAME = this.config.getStringValue("sp-cookie-name", "");
    private final String IDP_COOKIE_PATH = this.config.getStringValue("idp-cookie-path", "/idp/");
    private final String SP_COOKIE_PATH = this.config.getStringValue("sp-cookie-path", "/sp/");
    private final String IDP_COOKIE_DOMAIN = this.config.getStringValue("idp-cookie-domain", "");
    private final String SP_COOKIE_DOMAIN = this.config.getStringValue("sp-cookie-domain", "");
    private final String ATTR_COOKIE_DOMAIN = this.config.getStringValue("attributes-cookie-domain", null);
    private final String ATTR_COOKIE_PATH = this.config.getStringValue("attributes-cookie-path", "/");
    private final String ATTR_COOKIE_NAME = this.config.getStringValue("attributes-cookie-name", "Z");
    private static final String AES_TRANSFORM = "AES/CBC/PKCS5Padding";
    private static final String AES = "AES";
    private static final int KEY_IDX_LEN = 2;
    private static final String ATTRIBUTES_MAP = "ATTRIBUTES_MAP";
    private KeyTracker keyTracker;

    public InterReqStateMgmtCookieImpl() throws NoSuchAlgorithmException, Exception {
        this.init(this.config.getStringValue("static-key", null));
    }

    InterReqStateMgmtCookieImpl(String hexKey) throws NoSuchAlgorithmException, Exception {
        this.init(hexKey);
    }

    protected void init(String hexKey) throws NoSuchAlgorithmException, Exception {
        if (hexKey != null) {
            byte[] bytes = HexBin.stringToBytes((String)hexKey.trim());
            try {
                SecretKeySpec spec = new SecretKeySpec(bytes, AES);
                this.log.debug((Object)("Using " + spec.getEncoded().length * 8 + " bit static key"));
                this.keyTracker = new KeyTrackerStaticKeyImpl(spec);
            }
            catch (Exception e) {
                ErrorHandler.handleFatalError("Invalid static key in inter-req-cookie-config.xml", e);
            }
        } else {
            this.getDynamicKeyTracker();
        }
    }

    private void getDynamicKeyTracker() throws NoSuchAlgorithmException, Exception {
        this.log.debug((Object)"Using dynamic key management via RPC");
        this.keyTracker = new KeyTrackerGroupRpcImpl();
    }

    @Override
    public void saveState(String stateKey, State state, HttpServletRequest req, HttpServletResponse resp) {
        String cookieName = this.getCookieName(req);
        String cookiepath = this.getCookiePath(req);
        String cookieDomain = this.getCookieDomain(req);
        this.encode(cookieName, cookiepath, cookieDomain, state, resp);
    }

    @Override
    public State retrieveAndRemoveState(String stateKey, HttpServletRequest req, HttpServletResponse resp) {
        String cookieName = this.getCookieName(req);
        String cookiePath = this.getCookiePath(req);
        String cookieDomain = this.getCookieDomain(req);
        State state = (State)this.decode(cookieName, cookiePath, cookieDomain, req, resp);
        this.delete(cookieName, cookiePath, cookieDomain, resp);
        return state;
    }

    private void encode(String name, String path, String domain, Object obj, HttpServletResponse resp) {
        if (obj == null) {
            this.delete(name, path, domain, resp);
        } else {
            try {
                String encoded = this.encodedToString(obj);
                Cookie cookie = new Cookie(name, encoded);
                cookie.setMaxAge(this.keyTracker.getCookieLife());
                if (path != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Cookie Creation - Setting path: " + path));
                    }
                    cookie.setPath(path);
                }
                if (domain != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Cookie Creation - Setting domain: " + domain));
                    }
                    cookie.setDomain(domain);
                }
                resp.addCookie(cookie);
            }
            catch (Exception e) {
                throw new RuntimeException("Problem encoding data to cookie", e);
            }
        }
    }

    private void delete(String name, String path, String domain, HttpServletResponse resp) {
        Cookie cookie = new Cookie(name, null);
        cookie.setMaxAge(0);
        if (path != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cookie Deletion - Setting path: " + path));
            }
            cookie.setPath(path);
        }
        if (domain != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cookie Deletion - Setting domain: " + domain));
            }
            cookie.setDomain(domain);
        }
        resp.addCookie(cookie);
    }

    String encodedToString(Object obj) throws IOException, GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(AES_TRANSFORM);
        KeyWrapper currentKey = this.keyTracker.getCurrentKey();
        SecretKey key = currentKey.getSecretKey();
        cipher.init(1, key);
        byte[] iv = cipher.getIV();
        ByteArrayOutputStream byteArrayOutStream = new ByteArrayOutputStream(4096);
        ObjectOutputStream objOutStream = new ObjectOutputStream(byteArrayOutStream);
        objOutStream.writeObject(obj);
        byte[] data = byteArrayOutStream.toByteArray();
        byte[] compressedBytes = DeflateRFC1951.deflate(data);
        byte[] cipherBytes = cipher.doFinal(compressedBytes);
        ByteBuffer byteBuffer = ByteBuffer.allocate(3 + iv.length + cipherBytes.length);
        byteBuffer.put(currentKey.getIndexBytes());
        byteBuffer.put((byte)iv.length);
        byteBuffer.put(iv);
        byteBuffer.put(cipherBytes);
        return B64.encode((byte[])byteBuffer.array());
    }

    Object decode(String name, String path, String domain, HttpServletRequest req, HttpServletResponse resp) {
        String cookieValue = CookieMonster.getCookieValue(name, req);
        try {
            return StringUtils.isBlank((String)cookieValue) ? null : this.decodeToObject(cookieValue);
        }
        catch (Exception e) {
            this.delete(name, path, domain, resp);
            HttpServletRespProxy.flushCookies(resp);
            throw new RuntimeException("Problem decoding data from '" + name + "' ", e);
        }
    }

    Object decodeToObject(String encodedStringValue) throws GeneralSecurityException, DataFormatException, IOException, ClassNotFoundException {
        byte[] decodedBytes = B64.decodeToBytes((String)encodedStringValue);
        ByteBuffer byteBuffer = ByteBuffer.wrap(decodedBytes);
        byte[] keyIdx = new byte[2];
        byteBuffer.get(keyIdx);
        byte ivLength = byteBuffer.get();
        byte[] iv = new byte[ivLength];
        byteBuffer.get(iv);
        byte[] cipherBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(cipherBytes);
        Cipher cipher = Cipher.getInstance(AES_TRANSFORM);
        cipher.init(2, (Key)this.keyTracker.getKey(keyIdx), new IvParameterSpec(iv));
        byte[] compressedBytes = cipher.doFinal(cipherBytes);
        byte[] bytes = DeflateRFC1951.inflateToBytes(compressedBytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        CtxClassLoaderObjectInputStream objInStream = new CtxClassLoaderObjectInputStream(bais);
        Object decodedObjTree = objInStream.readObject();
        return decodedObjTree;
    }

    @Override
    public void setAttribute(String name, Object value, HttpServletRequest req, HttpServletResponse resp, boolean usedAsLoginCtx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting attribute: " + name));
        }
        Map<String, Object> map = this.getAttributeMap(req, resp);
        map.put(name, value);
        this.encode(this.ATTR_COOKIE_NAME, this.ATTR_COOKIE_PATH, this.ATTR_COOKIE_DOMAIN, map, resp);
        this.cacheAttributesMap(map, req);
    }

    @Override
    public void setAttribute(String key, Object value) {
        throw new UnsupportedOperationException("Key based attribute storage is not supported");
    }

    private Map<String, Object> getAttributeMap(HttpServletRequest req, HttpServletResponse resp) {
        HashMap<String, Object> map = (HashMap<String, Object>)req.getAttribute(ATTRIBUTES_MAP);
        if (map == null) {
            try {
                map = (Map)this.decode(this.ATTR_COOKIE_NAME, this.ATTR_COOKIE_PATH, this.ATTR_COOKIE_DOMAIN, req, resp);
            }
            catch (Exception e) {
                this.log.error((Object)("Ignoring problem reading 'session' attributes from " + this.ATTR_COOKIE_NAME), (Throwable)e);
            }
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            this.cacheAttributesMap(map, req);
        }
        return map;
    }

    private void cacheAttributesMap(Map<String, Object> map, HttpServletRequest req) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        req.setAttribute(ATTRIBUTES_MAP, map);
    }

    @Override
    public Object getAttribute(String name, HttpServletRequest req, HttpServletResponse resp) {
        Map<String, Object> map = this.getAttributeMap(req, resp);
        Object value = map.get(name);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("retrieved attribute: " + name));
        }
        return value;
    }

    @Override
    public Map<String, Object> getAttributes(HttpServletRequest req, HttpServletResponse resp) {
        return new HashMap<String, Object>(this.getAttributeMap(req, resp));
    }

    @Override
    public Object getAttribute(String key) {
        throw new UnsupportedOperationException("Key based attribute storage is not supported");
    }

    @Override
    public Object removeAttribute(String name, HttpServletRequest req, HttpServletResponse resp) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("removing attribute: " + name));
        }
        Map<String, Object> map = this.getAttributeMap(req, resp);
        Object oldValue = map.remove(name);
        this.encode(this.ATTR_COOKIE_NAME, this.ATTR_COOKIE_PATH, this.ATTR_COOKIE_DOMAIN, map, resp);
        this.cacheAttributesMap(map, req);
        return oldValue;
    }

    @Override
    public Object removeAttribute(String key) {
        throw new UnsupportedOperationException("Key based attribute storage is not supported");
    }

    @Override
    public <T> Set<T> addToSetAttribute(String key, Collection<T> items, Boolean synchronous) {
        throw new UnsupportedOperationException("Key based attribute storage is not supported");
    }

    @Override
    public <T> Set<T> removeFromSetAttribute(String key, Collection<T> items, Boolean synchronous) {
        throw new UnsupportedOperationException("Key based attribute storage is not supported");
    }

    @Override
    public <T> Set<T> getSetAttribute(String key) {
        throw new UnsupportedOperationException("Key based attribute storage is not supported");
    }

    @Override
    public int getAttributeMapSize() {
        return 0;
    }

    @Override
    public int getTransactionStateMapSize() {
        return 0;
    }

    private Role getRole(HttpServletRequest req) {
        if (req.getRequestURI().startsWith("/idp")) {
            return Role.IDP;
        }
        if (req.getRequestURI().startsWith("/sp")) {
            return Role.SP;
        }
        this.log.warn((Object)("Unable to determine role from request URI : " + LogGuard.encode(req.getRequestURI())));
        return null;
    }

    private String getCookieName(HttpServletRequest req) {
        Role role = this.getRole(req);
        if (role == Role.IDP && !StringUtils.isEmpty((String)this.IDP_COOKIE_NAME)) {
            return this.IDP_COOKIE_NAME;
        }
        if (role == Role.SP && !StringUtils.isEmpty((String)this.SP_COOKIE_NAME)) {
            return this.SP_COOKIE_NAME;
        }
        return this.STATE_COOKIE_NAME;
    }

    private String getCookiePath(HttpServletRequest req) {
        Role role = this.getRole(req);
        if (role == Role.IDP && !StringUtils.isEmpty((String)this.IDP_COOKIE_PATH)) {
            return this.IDP_COOKIE_PATH;
        }
        if (role == Role.SP && !StringUtils.isEmpty((String)this.SP_COOKIE_PATH)) {
            return this.SP_COOKIE_PATH;
        }
        return null;
    }

    private String getCookieDomain(HttpServletRequest req) {
        Role role = this.getRole(req);
        if (role == Role.IDP && !StringUtils.isEmpty((String)this.IDP_COOKIE_DOMAIN)) {
            return this.IDP_COOKIE_DOMAIN;
        }
        if (role == Role.SP && !StringUtils.isEmpty((String)this.SP_COOKIE_DOMAIN)) {
            return this.SP_COOKIE_DOMAIN;
        }
        return null;
    }
}

