/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.cookie;

import com.pingidentity.common.util.TimerTaskBase;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.jgroups.JGUtil;
import com.pingidentity.jgroups.MembershipListenerStub;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.View;
import org.jgroups.util.RspList;
import org.sourceid.common.ByteUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.service.impl.cookie.KeyTracker;
import org.sourceid.saml20.service.impl.cookie.KeyTrackerState;
import org.sourceid.saml20.service.impl.cookie.KeyWrapper;
import org.sourceid.saml20.service.impl.grouprpc.BaseGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.RspUtil;
import org.sourceid.util.Defense;

public class KeyTrackerGroupRpcImpl
extends BaseGroupRpc
implements KeyTracker {
    private static final String METHOD_NAME = "addKey";
    private static final Class[] METHOD_SIG = new Class[]{KeyWrapper.class};
    private static final String AES = "AES";
    static final String CONFIG_NAME = "key-tracker";
    private KeyTrackerState keyTrackerState;
    private KeyGenerator keyGen;
    int cookieLife;

    public KeyTrackerGroupRpcImpl() throws NoSuchAlgorithmException, Exception {
        this.keyTrackerState = (KeyTrackerState)this.muxRpcDispatcherMgr.getRpcInvocationTarget(RpcTarget.class);
        this.muxRpcDispatcherMgr.addMembershipListener(new MbrshpListener());
        try {
            this.keyGen = KeyGenerator.getInstance(AES, SecurityProviderUtil.getSunJCEProviderOrEquivalent());
        }
        catch (NoSuchProviderException e) {
            this.log.error((Object)(e.getMessage() + " Unable to find Sun JCE provider. Please check your java.security"));
            throw new Exception(e.getMessage());
        }
        this.keyGen.init(this.config.getIntValue("key-length", 128));
        ConfigStore cfg = ConfigStoreFarm.getConfig(CONFIG_NAME);
        int keyRollingSeconds = cfg.getIntValue("key-rolling-period", 600);
        this.cookieLife = (this.keyTrackerState.getMaxNumKeys() - 1) * keyRollingSeconds;
        if (this.config.getBooleanValue("use-session-cookie", true)) {
            this.cookieLife = -1;
        }
        long newKeyPeriod = (long)keyRollingSeconds * 1000L;
        this.addNewKey();
        Timer timer = new Timer(this.getClass().getName() + " timer", true);
        timer.schedule((TimerTask)new TimerTaskBase(){

            @Override
            public void doTask() {
                KeyTrackerGroupRpcImpl.this.addNewKey();
            }
        }, newKeyPeriod, newKeyPeriod);
    }

    void addNewKey() {
        JChannel channel = this.rpcDispatcher.getChannel();
        if (JGUtil.isLead(channel)) {
            SecretKey secretKey = this.keyGen.generateKey();
            int index = this.keyTrackerState.chooseIndex();
            Object[] args = new Object[]{new KeyWrapper(index, secretKey)};
            this.callRemoteMethods(METHOD_NAME, METHOD_SIG, true, 20000, args);
        }
    }

    @Override
    public KeyWrapper getCurrentKey() {
        return this.keyTrackerState.getLatestKey();
    }

    @Override
    public SecretKey getKey(byte[] idx) {
        KeyWrapper keyWrapper = this.keyTrackerState.getKey(idx);
        if (keyWrapper == null) {
            int index = ByteUtil.getInt(idx);
            this.log.warn((Object)("No key found locally for index " + index + " will attempt to resolve from cluster..."));
            Class[] sig = new Class[]{byte[].class};
            Object[] args = new Object[]{idx};
            RspList rspList = this.callRemoteMethods("getKey", sig, true, 2000, args);
            this.log.debug((Object)rspList);
            keyWrapper = RspUtil.getFirstNotNull(rspList, KeyWrapper.class);
            Defense.notNull(keyWrapper, "No key found for index " + index);
        }
        return keyWrapper.getSecretKey();
    }

    @Override
    public int getCookieLife() {
        return this.cookieLife;
    }

    public static interface RpcTarget {
        public void addKey(KeyWrapper var1);

        public KeyWrapper getKey(byte[] var1);
    }

    private class MbrshpListener
    extends MembershipListenerStub {
        private MbrshpListener() {
        }

        @Override
        public void viewAccepted(View newView) {
            if (newView instanceof MergeView) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        KeyTrackerGroupRpcImpl.this.addNewKey();
                    }
                });
                t.start();
            }
        }
    }
}

