/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.common.security.LockingService;
import com.pingidentity.common.util.PropertyInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.util.RspList;
import org.sourceid.saml20.service.impl.grouprpc.BasePreferredNodesGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.ReplicationMode;
import org.sourceid.saml20.service.impl.grouprpc.RpcResponseMode;
import org.sourceid.saml20.service.impl.grouprpc.RspUtil;
import org.sourceid.saml20.service.impl.proxy.LockingServiceFactory;
import org.sourceid.saml20.state.StateMgmtFactory;

public class AccountLockingServiceGroupRpcImpl
implements LockingServiceFactory {
    private static final Map<String, AccountLockingServiceRPCClient> instances = new ConcurrentHashMap<String, AccountLockingServiceRPCClient>();

    @Override
    public LockingService getInstance(String name) {
        AccountLockingServiceRPCClient instance = instances.get(name);
        if (instance == null) {
            instances.putIfAbsent(name, new AccountLockingServiceRPCClient(name));
            instance = instances.get(name);
        }
        return instance;
    }

    private static class AccountLockingServiceRPCClient
    extends BasePreferredNodesGroupRpc
    implements LockingService {
        private static final String FILENAME = "cluster-account-locking.conf";
        private static final Class<?>[] LOG_FAILED_SIG = new Class[]{String.class, String.class};
        private static final String LOG_FAILED_NAME = "logFailedLogin";
        private static final Class<?>[] LOG_MALICIOUS_SIG = new Class[]{String.class, String.class};
        private static final String LOG_MALICIOUS_NAME = "logMaliciousAction";
        private static final Class<?>[] CLEAR_FAILED_SIG = new Class[]{String.class, String.class};
        private static final String CLEAR_FAILED_NAME = "clearFailedLogins";
        private static final Class<?>[] CLEAR_MALICIOUS_SIG = new Class[]{String.class, String.class};
        private static final String CLEAR_MALICIOUS_NAME = "clearMaliciousActions";
        private static final Class<?>[] IS_LOCKED_SIG = new Class[]{String.class, String.class};
        private static final String IS_LOCKED_NAME = "isLocked";
        private static final Class<?>[] IS_LOCKED_MAX_MALICIOUS_SIG = new Class[]{String.class, String.class};
        private static final String IS_LOCKED_MAX_MALICIOUS_NAME = "isLockedWithMaxMaliciousActions";
        private static final Class<?>[] IS_LOCKED_CUSTOM_SIG = new Class[]{String.class, String.class, Integer.class, Integer.class};
        private static final String IS_LOCKED_CUSTOM_NAME = "isLockedCustom";
        private static final Class<?>[] IS_LOCKED_REQUEST_SIG = new Class[]{String.class, LockingService.IsLockedRequest.class};
        private static final String IS_LOCKED_REQUEST_NAME = "isLockedRequest";
        private final LockingService service;
        private final String name;
        private final boolean allNodes;

        AccountLockingServiceRPCClient(String name) {
            super(FILENAME, true, StateMgmtFactory.getAdaptiveClusteringConfig().isReplicateAccountLockingState());
            this.name = name;
            this.allNodes = 0 == this.preferredNodes.getNodeIndices().length;
            this.service = AccountLockingService.forName(name);
        }

        @Override
        public void logFailedLogin(String key) {
            key = AccountLockingService.normalizeKey(key);
            Object[] args = new Object[]{this.name, key};
            this.callRemoteMethods(LOG_FAILED_NAME, (Class[])LOG_FAILED_SIG, key, true, ReplicationMode.ASYNC, args);
        }

        @Override
        public void logFailedPassword(String key) {
            if (AccountLockingService.doPasswordLocking()) {
                this.logFailedLogin(key);
            }
        }

        @Override
        public void logMaliciousAction(String key) {
            key = AccountLockingService.normalizeKey(key);
            Object[] args = new Object[]{this.name, key};
            this.callRemoteMethods(LOG_MALICIOUS_NAME, (Class[])LOG_MALICIOUS_SIG, key, true, ReplicationMode.ASYNC, args);
        }

        @Override
        public boolean isLocked(String key) {
            key = AccountLockingService.normalizeKey(key);
            if (!PropertyInfo.isAdaptiveClusteringEnabled() && this.allNodes) {
                return this.service.isLocked(key);
            }
            Object[] args = new Object[]{this.name, key};
            RspList rspList = this.callRemoteMethods(IS_LOCKED_NAME, (Class[])IS_LOCKED_SIG, key, true, RpcResponseMode.GET_FIRST, ReplicationMode.ASYNC, args);
            return RspUtil.getAnyTrue(rspList);
        }

        @Override
        public boolean isLockedWithMaxMaliciousActions(String key) {
            key = AccountLockingService.normalizeKey(key);
            if (!PropertyInfo.isAdaptiveClusteringEnabled() && this.allNodes) {
                return this.service.isLockedWithMaxMaliciousActions(key);
            }
            Object[] args = new Object[]{this.name, key};
            RspList rspList = this.callRemoteMethods(IS_LOCKED_MAX_MALICIOUS_NAME, (Class[])IS_LOCKED_MAX_MALICIOUS_SIG, key, true, RpcResponseMode.GET_FIRST, ReplicationMode.ASYNC, args);
            return RspUtil.getAnyTrue(rspList);
        }

        @Override
        public boolean isLocked(String key, int maxFailedLogins, int lockoutPeriod) {
            key = AccountLockingService.normalizeKey(key);
            if (!PropertyInfo.isAdaptiveClusteringEnabled() && this.allNodes) {
                return this.service.isLocked(key, maxFailedLogins, lockoutPeriod);
            }
            Object[] args = new Object[]{this.name, key, maxFailedLogins, lockoutPeriod};
            RspList rspList = this.callRemoteMethods(IS_LOCKED_CUSTOM_NAME, (Class[])IS_LOCKED_CUSTOM_SIG, key, true, RpcResponseMode.GET_FIRST, ReplicationMode.ASYNC, args);
            return RspUtil.getAnyTrue(rspList);
        }

        @Override
        public boolean isLocked(LockingService.IsLockedRequest request) {
            if (request.getLoginType() == LockingService.FailedLoginType.PASSWORD && !AccountLockingService.doPasswordLocking()) {
                return false;
            }
            if (!PropertyInfo.isAdaptiveClusteringEnabled() && this.allNodes) {
                return this.service.isLocked(request);
            }
            Object[] args = new Object[]{this.name, request};
            RspList rspList = this.callRemoteMethods(IS_LOCKED_REQUEST_NAME, (Class[])IS_LOCKED_REQUEST_SIG, request.getKey(), true, RpcResponseMode.GET_FIRST, ReplicationMode.ASYNC, args);
            return RspUtil.getAnyTrue(rspList);
        }

        @Override
        public void clearFailedLogins(String key) {
            key = AccountLockingService.normalizeKey(key);
            Object[] args = new Object[]{this.name, key};
            this.callRemoteMethods(CLEAR_FAILED_NAME, (Class[])CLEAR_FAILED_SIG, key, false, ReplicationMode.ASYNC, args);
        }

        @Override
        public void clearMaliciousActions(String key) {
            key = AccountLockingService.normalizeKey(key);
            Object[] args = new Object[]{this.name, key};
            this.callRemoteMethods(CLEAR_MALICIOUS_NAME, (Class[])CLEAR_MALICIOUS_SIG, key, false, ReplicationMode.ASYNC, args);
        }
    }
}

