/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import com.pingidentity.common.util.HostAddressUtils;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.util.RspList;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.saml20.domain.SynchronizationData;
import org.sourceid.saml20.domain.SynchronizationRequest;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.ReplicationStateManager;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.service.AdminNodeRoleService;
import org.sourceid.saml20.service.ConfigReplicationService;
import org.sourceid.saml20.service.adminstate.AdminNodeRole;
import org.sourceid.saml20.service.adminstate.AdminNodesStateManager;
import org.sourceid.saml20.service.adminstate.errors.AdminNodeStateManagementException;
import org.sourceid.saml20.service.impl.grouprpc.BaseGroupRpc;
import org.sourceid.saml20.service.util.Node;
import org.sourceid.saml20.service.util.NodeIndexRegistry;
import org.sourceid.util.UpgradeInfo;

public class AdminNodeRoleServiceGroupRpcImpl
extends BaseGroupRpc
implements AdminNodeRoleService {
    private static final Log log = LogFactory.getLog(AdminNodeRoleServiceGroupRpcImpl.class);
    private final NodeIndexRegistry nodeIndexRegistry;
    private final Mediator mediator = MgmtFactory.getMediator();
    private final AdminNodesStateManager adminNodesStateManager;
    private final AdminNodeConfigManager adminNodeConfigManager;
    private final ConfigReplicationService configReplicationService;
    private final ReplicationStateManager replicationStateManager;
    private static final String SWITCH_TO_PASSIVE_NAME = "switchToPassive";
    private static final Class<?>[] SWITCH_TO_PASSIVE_SIG = new Class[]{SynchronizationRequest.class};

    public AdminNodeRoleServiceGroupRpcImpl() {
        this.nodeIndexRegistry = MgmtFactory.getNodeIndexRegistry();
        this.adminNodesStateManager = MgmtFactory.getAdminNodesStateManager();
        this.adminNodeConfigManager = MgmtFactory.getAdminNodeConfigManager();
        this.configReplicationService = MgmtFactory.getConfigReplicationService();
        this.replicationStateManager = MgmtFactory.getReplicationStateManager();
    }

    @Override
    public List<String> switchToActive() throws AdminNodeStateManagementException {
        ArrayList<String> warnings = new ArrayList<String>();
        if (!this.mediator.isConsole() || !this.adminNodeConfigManager.isEnabledAndPassiveNode()) {
            log.debug((Object)"Ignoring call to switch this node to active admin console.");
            return Collections.emptyList();
        }
        List<Node> activeConsoles = this.adminNodesStateManager.getActiveNodesFromCluster();
        if (activeConsoles.size() > 1) {
            String errMsg = "Unable to switch this node to active, please try again later. There are currently multiple nodes that are active consoles in the cluster: " + activeConsoles;
            log.error((Object)errMsg);
            throw new AdminNodeStateManagementException(errMsg);
        }
        if (activeConsoles.size() == 1) {
            Node activeConsole = activeConsoles.get(0);
            List<String> syncWarnings = this.switchActiveToPassiveAndSync(activeConsole);
            warnings.addAll(syncWarnings);
        } else {
            String message = "Currently no active admin console node in cluster to attempt synchronization with.";
            log.debug((Object)message);
            warnings.add(message);
        }
        try {
            this.checkPostUpgradeReplicationState();
        }
        catch (IOException e) {
            log.warn((Object)"Unable to do post-upgrade replication processing on this node.", (Throwable)e);
        }
        this.replicationStateManager.setConfigProfileValidForReplication(true);
        this.adminNodeConfigManager.updateRole(AdminNodeRole.ACTIVE);
        this.nodeIndexRegistry.reregister();
        return warnings;
    }

    private List<String> switchActiveToPassiveAndSync(Node activeConsole) {
        ArrayList<String> warnings = new ArrayList<String>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending request to current active console node for switching to passive role: " + activeConsole));
        }
        Vector<Address> targets = new Vector<Address>();
        targets.add(activeConsole.getAddress());
        SynchronizationData payload = null;
        try {
            RspList rspList = this.callRemoteMethods(targets, SWITCH_TO_PASSIVE_NAME, (Class[])SWITCH_TO_PASSIVE_SIG, true, this.adminNodeConfigManager.getSynchronizationDataTimeoutMillis(), BaseGroupRpc.LogLevel.TRACE, this.mediator.makeSynchronizationRequest());
            payload = (SynchronizationData)rspList.getFirst();
        }
        catch (Exception ex) {
            log.warn((Object)("Exception encountered during RPC to previous active node " + activeConsole.getAddress()), (Throwable)ex);
        }
        if (payload == null) {
            String message = "Failed to retrieve synchronization data from previous active node " + activeConsole.getAddress();
            log.warn((Object)message);
            warnings.add(message);
        } else {
            this.mediator.deploySynchronizationData(payload);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received synchronization data, configSyncProfileId=" + payload.getConfigSyncProfileId() + ", configSyncTimestamp=" + payload.getConfigSyncTimestamp()));
            }
        }
        this.mediator.reloadConfiguration();
        return warnings;
    }

    private void checkPostUpgradeReplicationState() throws IOException {
        if (this.configReplicationService.isPublishReplicationDataOnStartup() && UpgradeInfo.isPostUpgradeProcessingRequired()) {
            if (!this.replicationStateManager.hasValidReplicationData()) {
                log.debug((Object)"Publishing post-upgrade replication config.");
                this.mediator.publishConfig();
            }
            log.debug((Object)"Setting post-upgrade processing required flag to 'false'.");
            UpgradeInfo.setPostUpgradeProcessingRequired(false);
        }
    }

    public static class AdminNodeRoleRequestHandler
    implements RpcTarget {
        private final Mediator mediator = MgmtFactory.getMediator();
        private final AdminNodeConfigManager adminNodeConfigManager = MgmtFactory.getAdminNodeConfigManager();

        @Override
        public SynchronizationData switchToPassive(SynchronizationRequest request) {
            String requesterAddress = request.getSourceNodeAddress();
            int requesterNodeIndex = request.getSourceNodeIndex();
            if (!this.mediator.isConsole() || this.adminNodeConfigManager.isPassiveNode()) {
                log.debug((Object)String.format("Received request from [nodeIndex=%d, address=%s] to switch role to passive, but this node is not an active admin console.", requesterNodeIndex, requesterAddress));
                return null;
            }
            if (requesterAddress != null) {
                try {
                    AdminAuditLogger.setIpAddress("[" + HostAddressUtils.getIpAddress(requesterAddress) + "]");
                }
                catch (UnknownHostException e) {
                    log.warn((Object)("Unable to format the requesting node's IP address for admin audit log: " + requesterAddress));
                }
            }
            this.adminNodeConfigManager.updateRole(AdminNodeRole.PASSIVE);
            MgmtFactory.getNodeIndexRegistry().reregister();
            try {
                log.debug((Object)("Received request to switch role to passive and returning latest synchronization data, requestor's configSyncProfileId=" + request.getConfigSyncProfileId() + ", configSyncTimestamp=" + request.getConfigSyncTimestamp() + ", nodeIndex=" + requesterNodeIndex + ", address=" + requesterAddress));
                SynchronizationData synchronizationData = this.mediator.getSynchronizationData(request);
                log.debug((Object)("Returning synchronization data, local configSyncProfileId=" + synchronizationData.getConfigSyncProfileId() + ", configSyncTimestamp=" + synchronizationData.getConfigSyncTimestamp()));
                return synchronizationData;
            }
            catch (IOException e) {
                log.error((Object)"Unexpected error retrieving synchronization data while handling the admin console role switch request.", (Throwable)e);
                return null;
            }
        }
    }

    public static interface RpcTarget {
        public SynchronizationData switchToPassive(SynchronizationRequest var1);
    }
}

