/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import com.pingidentity.common.util.TimerTaskBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.sourceid.config.ConfigProps;
import org.sourceid.mgmt.AdminNodeConfigManager;
import org.sourceid.saml20.domain.ReplicationArchive;
import org.sourceid.saml20.domain.ReplicationData;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.service.ConfigReplicationService;
import org.sourceid.saml20.service.ReplicationTargetNode;
import org.sourceid.saml20.service.adminstate.AdminNodeRole;
import org.sourceid.saml20.service.impl.grouprpc.BaseGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.RpcResponseMode;
import org.sourceid.saml20.service.util.Node;
import org.sourceid.saml20.service.util.NodeIndexRegistry;

public class ConfigReplicationServiceGroupRpcImpl
extends BaseGroupRpc
implements ConfigReplicationService {
    private static final Log log = LogFactory.getLog(ConfigReplicationServiceGroupRpcImpl.class);
    private static final String CFG_RPC_REPLICATION_STATUS_TIMEOUT = "rpc.replication.status.timeout";
    private static final String CFG_RPC_REPLICATION_DATA_TIMEOUT = "rpc.replication.data.timeout";
    private static final String CFG_REPLICATION_DATA_RETRIES = "replication.data.retries";
    private static final String CFG_REPLICATION_POLL_INTERVAL = "replication.poll.interval";
    private static final String CFG_PUBLISH_REPLICATION_DATA_ON_STARTUP = "publish.replication.data.on.startup";
    private static final String CFG_REQUIRE_REPLICATION_DATA_ON_STARTUP = "require.replication.data.on.startup";
    private static final String CFG_REPLICATE_AFTER_DROP_IN_DEPLOY = "replicate.after.drop.in.deploy";
    private static final String NOTIFY_CONFIG_PUBLISHED_NAME = "notifyConfigPublished";
    private static final Class<?>[] NOTIFY_CONFIG_PUBLISHED_SIG = new Class[]{ReplicationTargetNode.class};
    private static final String GET_REPLICATION_DATA_NAME = "getReplicationData";
    private static final Class<?>[] GET_REPLICATION_DATA_SIG = new Class[]{String.class, Date.class};
    private static final String GET_REPLICATION_STATUS_NAME = "getReplicationStatus";
    private static final Class<?>[] GET_REPLICATION_STATUS_SIG = new Class[0];
    private final Mediator mediator;
    private final AdminNodeConfigManager adminNodeConfigManager;
    private final ConfigReplicationService configReplicationService;
    private final NodeIndexRegistry nodeIndexRegistry;
    private final Object updatingFromClusterLock = new Object();
    private int replicationStatusTimeoutMillis = 2000;
    private int replicationDataTimeoutMillis = 20000;
    private int replicationDataRetries = 1;
    private int replicationPollInterval = 60;
    private boolean publishReplicationDataOnStartup = false;
    private boolean requireReplicationDataOnStartup = false;
    private boolean replicateAfterDropInDeploy = false;
    private volatile boolean listenForReplicationEvents = false;
    private final BlockingQueue<ReplicationTargetNode> configPublishers = new LinkedBlockingQueue<ReplicationTargetNode>();

    public ConfigReplicationServiceGroupRpcImpl(Mediator mediator, AdminNodeConfigManager adminNodeConfigManager, ConfigReplicationService configReplicationService, NodeIndexRegistry nodeIndexRegistry) {
        this.mediator = mediator;
        this.adminNodeConfigManager = adminNodeConfigManager;
        this.configReplicationService = configReplicationService;
        this.nodeIndexRegistry = nodeIndexRegistry;
        this.loadConfigProps();
        if (mediator.isDistributable()) {
            this.launchConfigSyncTask();
            this.launchConfigPublishedHandler();
        }
    }

    @Override
    public void setListenForReplicationEvents(boolean listen) {
        log.debug((Object)("Setting listenForReplicationEvents to " + listen));
        this.listenForReplicationEvents = listen;
    }

    private boolean isListenForReplicationEvents() {
        return this.listenForReplicationEvents;
    }

    @Override
    public void notifyConfigPublished() {
        Address localAddress = this.rpcDispatcher.getChannel().getAddress();
        if (localAddress == null) {
            log.warn((Object)"Local address is null, cluster will not be notified that updated config is available");
        } else {
            log.debug((Object)"Notifying cluster that updated config is available");
            this.callRemoteMethods(NOTIFY_CONFIG_PUBLISHED_NAME, NOTIFY_CONFIG_PUBLISHED_SIG, false, 1000, new ReplicationTargetNode(localAddress, this.mediator.getConfigProfileId(), this.getConfigTimestamp().toInstant()));
        }
    }

    @Override
    public boolean updateConfigFromCluster() {
        return this.updateConfigFromCluster(this.replicationDataRetries);
    }

    protected boolean updateConfigFromCluster(int retriesRemaining) {
        boolean result = false;
        do {
            log.debug((Object)("Checking cluster for latest config data, retriesRemaining=" + retriesRemaining));
            RspListEvalResult evalResult = this.getReplicationStatus(true);
            if (evalResult.getSelectedSource() == null) {
                log.debug((Object)"No nodes found with published config data more recent than this node's");
                retriesRemaining = 0;
                continue;
            }
            if (!this.updateConfigFromNode(evalResult.getSelectedSource(), this.getConfigProfileId(), this.getConfigTimestamp())) continue;
            result = true;
        } while (!result && --retriesRemaining >= 0);
        return result;
    }

    private RspListEvalResult getReplicationStatus(boolean getReplicationStatusFromAll) {
        RspList list;
        Address localAddress = this.rpcDispatcher.getChannel().getAddress();
        if (getReplicationStatusFromAll) {
            list = this.callRemoteMethods(null, GET_REPLICATION_STATUS_NAME, (Class[])GET_REPLICATION_STATUS_SIG, true, RpcResponseMode.GET_ALL, null, this.replicationStatusTimeoutMillis, new Object[0]);
        } else {
            Vector<Address> targets = new Vector<Address>();
            targets.add(this.getRandomNode(localAddress).getAddress());
            list = this.callRemoteMethods(targets, GET_REPLICATION_STATUS_NAME, (Class[])GET_REPLICATION_STATUS_SIG, true, RpcResponseMode.GET_ALL, null, this.replicationStatusTimeoutMillis, new Object[0]);
        }
        RspListEvalResult evalResult = new RspListEvaluator().evalRspList((RspList<ReplicationStatus>)list, localAddress, this.getConfigProfileId(), this.getConfigTimestamp(), Node.ReplicationStatus.FAILED.equals((Object)this.nodeIndexRegistry.getLocalNodeReplicationStatus()));
        if (evalResult.isLocalConfigProfileValidForReplication()) {
            this.mediator.setConfigProfileValidForReplication(true);
        }
        return evalResult;
    }

    private Node getRandomNode(Address localAddress) {
        int randomIndex;
        Node randomNode;
        List<Node> nodesList = this.nodeIndexRegistry.getNodes();
        if (nodesList.size() == 1) {
            return nodesList.get(0);
        }
        while (localAddress.equals((randomNode = nodesList.get(randomIndex = new Random().nextInt(nodesList.size()))).getAddress())) {
        }
        return randomNode;
    }

    @Override
    public boolean updateConfigFromNode(Address target) {
        return this.updateConfigFromNode(target, this.getConfigProfileId(), this.getConfigTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateConfigFromNode(Address target, String configProfileId, Date configTimestamp) {
        log.debug((Object)("Waiting for lock before retrieving config from " + target));
        Object object = this.updatingFromClusterLock;
        synchronized (object) {
            try {
                log.debug((Object)("Retrieving config data from node " + target));
                this.nodeIndexRegistry.setLocalNodeReplicationStatus(Node.ReplicationStatus.RETRIEVING);
                Vector<Address> targets = new Vector<Address>();
                targets.add(target);
                RspList rspList = this.callRemoteMethods(targets, GET_REPLICATION_DATA_NAME, (Class[])GET_REPLICATION_DATA_SIG, true, this.replicationDataTimeoutMillis, configProfileId, configTimestamp);
                ReplicationData payload = (ReplicationData)rspList.getFirst();
                if (this.isTargetNodeInBadState(target)) {
                    log.debug((Object)("Target node: " + target + " has failed replication status, will skip applying downloaded replication data from it."));
                    return this.failedToUpdateConfig();
                }
                if (payload == null) {
                    log.error((Object)("Failed to retrieve config data from node " + target));
                    return this.failedToUpdateConfig();
                }
                log.debug((Object)("Received config data from node " + target));
                this.logReceivedReplicationData(payload);
                this.nodeIndexRegistry.setLocalNodeReplicationStatus(Node.ReplicationStatus.APPLYING);
                this.mediator.deployReplicationData(payload);
                this.nodeIndexRegistry.setLocalNodeReplicationStatus(Node.ReplicationStatus.IDLE);
                return true;
            }
            catch (Throwable t) {
                log.error((Object)"Unexpected error occurred while updating config.", t);
                return this.failedToUpdateConfig();
            }
        }
    }

    @Override
    public boolean isPublishReplicationDataOnStartup() {
        return this.publishReplicationDataOnStartup;
    }

    @Override
    public boolean isRequireReplicationDataOnStartup() {
        return this.requireReplicationDataOnStartup;
    }

    @Override
    public boolean isReplicateAfterDropInDeploy() {
        return this.replicateAfterDropInDeploy;
    }

    private boolean failedToUpdateConfig() {
        this.nodeIndexRegistry.setLocalNodeReplicationStatus(Node.ReplicationStatus.FAILED);
        this.mediator.setConfigProfileValidForReplication(false);
        return false;
    }

    private boolean isTargetNodeInBadState(Address target) {
        Node targetNode = this.nodeIndexRegistry.getNode(target);
        return targetNode == null || Node.ReplicationStatus.FAILED.equals((Object)targetNode.getReplicationStatus());
    }

    @Override
    public void queueUpdateConfigFromNode(ReplicationTargetNode replicationTargetNode) {
        if (this.isReplicationDataConsumer()) {
            if (!this.isListenForReplicationEvents()) {
                log.debug((Object)"Config replication service is not yet listening for replication events");
            } else if (this.configPublishers.contains(replicationTargetNode)) {
                log.debug((Object)("Ignoring config from node " + replicationTargetNode.getAddress() + "; already queued"));
            } else if (!this.configPublishers.stream().allMatch(nodeInQueue -> nodeInQueue.isTargetNodeMoreRecent(replicationTargetNode))) {
                log.debug((Object)("Ignoring config from node " + replicationTargetNode.getAddress() + "; similar node already queued"));
            } else {
                log.debug((Object)("Adding node " + replicationTargetNode.getAddress() + " to list of queued publishers"));
                this.configPublishers.add(replicationTargetNode);
            }
        }
    }

    private void loadConfigProps() {
        ConfigProps props = new ConfigProps("cluster-config-replication.conf");
        this.replicationStatusTimeoutMillis = props.getInt(CFG_RPC_REPLICATION_STATUS_TIMEOUT, 2000);
        this.replicationDataTimeoutMillis = props.getInt(CFG_RPC_REPLICATION_DATA_TIMEOUT, 10000);
        this.replicationDataRetries = props.getInt(CFG_REPLICATION_DATA_RETRIES, 1);
        this.replicationPollInterval = props.getInt(CFG_REPLICATION_POLL_INTERVAL, 60);
        this.publishReplicationDataOnStartup = props.getBoolean(CFG_PUBLISH_REPLICATION_DATA_ON_STARTUP, false);
        this.requireReplicationDataOnStartup = props.getBoolean(CFG_REQUIRE_REPLICATION_DATA_ON_STARTUP, false);
        this.replicateAfterDropInDeploy = props.getBoolean(CFG_REPLICATE_AFTER_DROP_IN_DEPLOY, false);
    }

    protected void logReceivedReplicationData(ReplicationData data) {
        StringBuilder builder = new StringBuilder("Received replication data").append(", configProfileId=").append(data.getConfigProfileId()).append(", configTimestamp=").append(data.getConfigTimestamp()).append(", coreArchiveTimestamp=").append(this.getArchiveTimestampMessage(data.getCoreArchive())).append(", baseArchiveTimestamp=").append(this.getArchiveTimestampMessage(data.getBaseDeltaArchive()));
        for (ReplicationArchive archive : data.getDeltaArchives()) {
            builder.append(", deltaArchiveTimestamp=").append(this.getArchiveTimestampMessage(archive));
        }
        for (ReplicationArchive selectiveArchive : data.getSelectiveArchives()) {
            builder.append(", selectiveArchiveTimestamp=").append(this.getArchiveTimestampMessage(selectiveArchive));
        }
        log.debug((Object)builder.toString());
    }

    protected String getArchiveTimestampMessage(ReplicationArchive archive) {
        if (archive == null) {
            return "(absent)";
        }
        return archive.getTimestamp().toString();
    }

    private static boolean isRemoteTimeStampEarlier(Date localConfigTimeStamp, Date remoteConfigTimeStamp) {
        return localConfigTimeStamp != null && remoteConfigTimeStamp != null && remoteConfigTimeStamp.before(localConfigTimeStamp);
    }

    private Date getConfigTimestamp() {
        return this.mediator.getAutomaticConfigPublishDate() == null ? this.mediator.getConfigPublishDate() : this.mediator.getAutomaticConfigPublishDate();
    }

    private String getConfigProfileId() {
        return this.mediator.getConfigProfileId();
    }

    private void launchConfigSyncTask() {
        TimerTaskBase configSyncTask = new TimerTaskBase(){

            @Override
            public void doTask() {
                ConfigReplicationServiceGroupRpcImpl.this.periodicConfigurationSync();
            }
        };
        Timer timer = new Timer("ConfigSyncTask", true);
        long configurationDateCheckIntervalMillis = (long)this.replicationPollInterval * 1000L;
        log.debug((Object)("Scheduling configuration data sync in " + configurationDateCheckIntervalMillis + " milliseconds"));
        timer.schedule((TimerTask)configSyncTask, configurationDateCheckIntervalMillis, configurationDateCheckIntervalMillis);
    }

    private void periodicConfigurationSync() {
        if (this.isReplicationDataConsumer()) {
            log.debug((Object)"Checking cluster for latest config data");
            RspListEvalResult evalResult = this.getReplicationStatus(false);
            Address nodeToGetConfigFrom = evalResult.getSelectedSource();
            if (nodeToGetConfigFrom == null) {
                log.debug((Object)"Node queried did not have published config data more recent than this node's");
            } else {
                this.queueUpdateConfigFromNode(new ReplicationTargetNode(evalResult.getSelectedSource(), evalResult.getConfigProfileId(), evalResult.getReplicationDataDate().toInstant()));
            }
        }
    }

    private void launchConfigPublishedHandler() {
        Thread thread = new Thread(() -> {
            log.debug((Object)"Handler for config published events starting up ...");
            while (true) {
                try {
                    while (true) {
                        ReplicationTargetNode publisher = this.configPublishers.take();
                        this.configReplicationService.updateConfigFromNode(publisher.getAddress());
                    }
                }
                catch (InterruptedException publisher) {
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)"Unexpected error occurred while handling published config", t);
                    continue;
                }
                break;
            }
        });
        thread.setDaemon(true);
        thread.setName("Config Published Handler");
        thread.start();
    }

    private boolean isReplicationDataConsumer() {
        return this.mediator.isEngine() || this.mediator.isConsole() && this.mediator.isDistributable() && this.adminNodeConfigManager.isPassiveNode();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    public static class ReplicationStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean replicationSource;
        private Date configTimestamp;
        private String configProfileId;
        private boolean console;
        private AdminNodeRole consoleRole;

        public ReplicationStatus(String configProfileId, boolean console, AdminNodeRole consoleRole, boolean replicationSource, Date configTimestamp) {
            this.configProfileId = configProfileId;
            this.configTimestamp = configTimestamp;
            this.console = console;
            this.consoleRole = consoleRole;
            this.replicationSource = replicationSource;
        }

        public String getConfigProfileId() {
            return this.configProfileId;
        }

        public Date getConfigTimestamp() {
            return this.configTimestamp;
        }

        public boolean isConsole() {
            return this.console;
        }

        public AdminNodeRole getConsoleRole() {
            return this.consoleRole;
        }

        public boolean isReplicationSource() {
            return this.replicationSource;
        }
    }

    public static class ReplicationRequestHandler
    implements RpcTarget {
        private final Mediator mediator = MgmtFactory.getMediator();
        private final ConfigReplicationService configReplicationService = MgmtFactory.getConfigReplicationService();
        private final AdminNodeConfigManager adminNodeConfigManager = MgmtFactory.getAdminNodeConfigManager();

        @Override
        public void notifyConfigPublished(ReplicationTargetNode replicationTargetNode) {
            log.debug((Object)("Updated config was published by node " + replicationTargetNode.getAddress()));
            this.configReplicationService.queueUpdateConfigFromNode(replicationTargetNode);
        }

        @Override
        public ReplicationData getReplicationData(String configProfileId, Date configTimestamp) {
            if (!this.mediator.isReplicationSource()) {
                log.info((Object)"Received config data request, but this node cannot act as replication source");
                return null;
            }
            ReplicationData replicationData = this.mediator.getReplicationData(configProfileId, configTimestamp);
            log.debug((Object)("Received config data request, requestor's configProfileId=" + configProfileId + ", configTimestamp=" + configTimestamp + ", returning replication data, local configProfileId=" + replicationData.getConfigProfileId() + ", configTimestamp=" + replicationData.getConfigTimestamp()));
            return replicationData;
        }

        @Override
        public ReplicationStatus getReplicationStatus() {
            Date configTimeStamp = this.mediator.getAutomaticConfigPublishDate() == null ? this.mediator.getConfigPublishDate() : this.mediator.getAutomaticConfigPublishDate();
            log.debug((Object)("Received replication status request, returning configProfileId=" + this.mediator.getConfigProfileId() + ", configTimestamp=" + configTimeStamp + ", isReplicationSource=" + this.mediator.isReplicationSource()));
            return new ReplicationStatus(this.mediator.getConfigProfileId(), this.mediator.isConsole(), this.adminNodeConfigManager.getRole(), this.mediator.isReplicationSource(), configTimeStamp);
        }
    }

    public static interface RpcTarget {
        public void notifyConfigPublished(ReplicationTargetNode var1);

        public ReplicationData getReplicationData(String var1, Date var2);

        public ReplicationStatus getReplicationStatus();
    }

    protected static class RspListEvalResult {
        private Address selectedSource = null;
        private String configProfileId;
        private Date replicationDataDate;
        private boolean localConfigProfileValidForReplication = false;

        protected RspListEvalResult() {
        }

        public Address getSelectedSource() {
            return this.selectedSource;
        }

        public void setSelectedSource(Address selectedSource) {
            this.selectedSource = selectedSource;
        }

        public String getConfigProfileId() {
            return this.configProfileId;
        }

        public void setConfigProfileId(String configProfileId) {
            this.configProfileId = configProfileId;
        }

        public Date getReplicationDataDate() {
            return this.replicationDataDate == null ? null : new Date(this.replicationDataDate.getTime());
        }

        public void setReplicationDataDate(Date replicationDataDate) {
            this.replicationDataDate = replicationDataDate == null ? null : new Date(replicationDataDate.getTime());
        }

        public boolean isLocalConfigProfileValidForReplication() {
            return this.localConfigProfileValidForReplication;
        }

        public void setLocalConfigProfileValidForReplication(boolean localConfigProfileValid) {
            this.localConfigProfileValidForReplication = localConfigProfileValid;
        }
    }

    protected static class RspListEvaluator {
        protected RspListEvaluator() {
        }

        public RspListEvalResult evalRspList(RspList<ReplicationStatus> list, Address localAddress, String configProfileId, Date configTimestamp, boolean isInFailedReplicationStatus) {
            RspListEvalResult result = new RspListEvalResult();
            ReplicationStatus preferredStatus = null;
            for (Map.Entry entry : list.entrySet()) {
                if (!((Rsp)entry.getValue()).wasReceived() || ((Rsp)entry.getValue()).getValue() == null) continue;
                Address remoteAddr = (Address)entry.getKey();
                ReplicationStatus status = (ReplicationStatus)((Rsp)entry.getValue()).getValue();
                if (remoteAddr.equals(localAddress)) continue;
                if (status.getConfigTimestamp() == null || !status.isReplicationSource()) {
                    log.debug((Object)("Received replication status from node " + remoteAddr + " but node does not have published config data"));
                    continue;
                }
                if (status.getConfigProfileId().equals(configProfileId) && !isInFailedReplicationStatus) {
                    result.setLocalConfigProfileValidForReplication(true);
                }
                if (status.getConfigProfileId().equals(configProfileId) && configTimestamp != null && !status.getConfigTimestamp().after(configTimestamp) && !isInFailedReplicationStatus || isInFailedReplicationStatus && ConfigReplicationServiceGroupRpcImpl.isRemoteTimeStampEarlier(configTimestamp, status.getConfigTimestamp())) {
                    log.debug((Object)("Received replication status from node " + remoteAddr + " but config data is not more recent (local=" + configTimestamp + ", remote=" + status.getConfigTimestamp()));
                    continue;
                }
                log.debug((Object)("Received replication status from node " + remoteAddr + (status.isConsole() ? "(console)" : "") + ", configProfileId=" + status.getConfigProfileId() + ", configTimestamp=" + status.getConfigTimestamp()));
                if (preferredStatus != null && this.compare(status, preferredStatus) <= 0) continue;
                preferredStatus = status;
                this.populateReplicationStatusResult(result, remoteAddr, status);
            }
            if (preferredStatus != null) {
                log.debug((Object)("Selected replication source has configProfileId=" + preferredStatus.getConfigProfileId() + ", configTimestamp=" + preferredStatus.getConfigTimestamp()));
            }
            return result;
        }

        private int compare(ReplicationStatus status1, ReplicationStatus status2) {
            if (status1.isConsole() && status2.isConsole()) {
                if (status1.consoleRole == AdminNodeRole.ACTIVE) {
                    return 1;
                }
                if (status2.consoleRole == AdminNodeRole.ACTIVE) {
                    return -1;
                }
            } else {
                if (status1.isConsole()) {
                    return 1;
                }
                if (status2.isConsole()) {
                    return -1;
                }
            }
            return status1.getConfigTimestamp().compareTo(status2.getConfigTimestamp());
        }

        private void populateReplicationStatusResult(RspListEvalResult result, Address address, ReplicationStatus status) {
            result.setSelectedSource(address);
            result.setConfigProfileId(status.getConfigProfileId());
            result.setReplicationDataDate(status.getConfigTimestamp());
        }
    }
}

