/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.sourceid.config.ConfigProps;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.impl.grouprpc.PreferredNodeGroup;
import org.sourceid.saml20.service.impl.grouprpc.RpcResponseMode;

public class PreferredNodes {
    private static final String PREFERRED_NODE_GROUP_ID = "preferred.node.group.id";
    private Log log = LogFactory.getLog(this.getClass());
    private int[] nodeIndices;
    private String groupId;
    private int timeout;
    private RpcResponseMode rpcResponseMode;

    public PreferredNodes(String filename) {
        boolean warnIfNotFound = true;
        if (StringUtils.isBlank((String)filename)) {
            warnIfNotFound = false;
        }
        ConfigProps cfgProps = new ConfigProps(filename, warnIfNotFound);
        this.log.debug((Object)cfgProps);
        this.nodeIndices = this.getIntArray("preferred.node.indices", cfgProps);
        this.log.debug((Object)(filename + " preferred nodes indices: " + Arrays.toString(this.nodeIndices)));
        String aGroupId = this.getString(PREFERRED_NODE_GROUP_ID, cfgProps);
        if (aGroupId != null) {
            if (!StringUtils.isAlphanumeric((String)aGroupId)) {
                this.log.error((Object)("Invalid preferred.node.group.id: " + aGroupId));
                this.log.info((Object)"preferred.node.group.id is ignored.");
            } else {
                this.groupId = aGroupId;
                this.log.debug((Object)(filename + " preferred nodes group ID: " + this.groupId));
            }
        }
        this.timeout = cfgProps.getInt("rpc.timeout", 1500);
        this.log.debug((Object)("rpc timeout: " + this.timeout));
        boolean onlyMajority = cfgProps.getBoolean("synchronous.retrieve.majority.only");
        this.rpcResponseMode = onlyMajority ? RpcResponseMode.GET_MAJORITY : RpcResponseMode.GET_ALL;
    }

    public PreferredNodeGroup getNodeGroup() {
        if (this.getGroupId() != null && this.getNodeIndices() != null && this.getNodeIndices().length > 0) {
            return new PreferredNodeGroup(this.getGroupId(), Ints.asList((int[])this.getNodeIndices()));
        }
        return null;
    }

    private String getString(String propName, ConfigProps props) {
        String result = props.getProperty(propName);
        if (result != null && (result = result.trim()).isEmpty()) {
            result = null;
        }
        return result;
    }

    private int[] getIntArray(String propName, ConfigProps props) {
        List<String> strList = props.getList(propName);
        int[] intArray = null;
        try {
            intArray = this.toIntArray(strList);
        }
        catch (Exception e) {
            this.log.error((Object)("Invalid " + propName + ": " + props.getProperty(propName)));
            this.log.info((Object)(propName + " is ignored."));
        }
        return intArray;
    }

    private int[] toIntArray(List<String> strings) {
        int[] ints = new int[strings.size()];
        int i = 0;
        for (String s : strings) {
            ints[i++] = Integer.parseInt(s);
        }
        return ints;
    }

    private Vector<Address> getAddresses(int[] idxs) {
        Vector<Address> addresses = MgmtFactory.getNodeIndexRegistry().getAddresses(idxs);
        if (this.log.isDebugEnabled()) {
            String idxsStr = Arrays.toString(idxs);
            String addressesStr = addresses == null ? "all nodes" : addresses.toString();
            this.log.debug((Object)(idxsStr + " -> indices to addresses -> " + addressesStr));
        }
        return addresses;
    }

    public Vector<Address> getPreferredNodes() {
        return this.getAddresses(this.nodeIndices);
    }

    public int[] getNodeIndices() {
        return this.nodeIndices;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public RpcResponseMode getRpcResponseMode() {
        return this.rpcResponseMode;
    }

    public String getGroupId() {
        return this.groupId;
    }
}

