/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc.adaptive;

import com.pingidentity.common.util.consistent.Range;
import com.pingidentity.common.util.consistent.RangeList;
import java.util.HashMap;
import java.util.Map;
import org.sourceid.saml20.service.StateServiceId;

public class DownloadedRanges {
    private Map<StateServiceId, RangeList> rangesByService = new HashMap<StateServiceId, RangeList>();

    public void addRanges(StateServiceId serviceId, RangeList ranges) {
        RangeList currRanges = this.rangesByService.get((Object)serviceId);
        RangeList newRanges = ranges;
        if (currRanges != null) {
            newRanges = currRanges.add(ranges);
        }
        this.rangesByService.put(serviceId, newRanges);
    }

    public void removeRanges(StateServiceId serviceId, RangeList ranges) {
        RangeList currRanges = this.rangesByService.get((Object)serviceId);
        if (currRanges == null) {
            return;
        }
        RangeList newRanges = currRanges.subtract(ranges);
        this.rangesByService.put(serviceId, newRanges);
    }

    public boolean hasRange(StateServiceId serviceId, Range range) {
        RangeList currRanges = this.rangesByService.get((Object)serviceId);
        if (currRanges == null) {
            return false;
        }
        return currRanges.contains(range);
    }

    public RangeList getRangeList(StateServiceId serviceId) {
        RangeList ranges = this.rangesByService.get((Object)serviceId);
        if (ranges == null) {
            ranges = new RangeList();
        }
        return ranges;
    }
}

