/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc.adaptive;

import com.pingidentity.common.util.consistent.ConsistentHashRing;
import com.pingidentity.common.util.consistent.HashRingNode;
import com.pingidentity.common.util.consistent.Range;
import com.pingidentity.common.util.consistent.RangeDiff;
import com.pingidentity.common.util.consistent.RangeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.service.StateServiceId;
import org.sourceid.saml20.service.StateServiceRegistry;
import org.sourceid.saml20.service.impl.grouprpc.adaptive.DownloadBatch;
import org.sourceid.saml20.service.impl.grouprpc.adaptive.DownloadedRanges;
import org.sourceid.saml20.service.impl.grouprpc.adaptive.PurgeBatch;
import org.sourceid.saml20.service.impl.grouprpc.adaptive.RangeAndReplicas;
import org.sourceid.saml20.service.impl.grouprpc.adaptive.RangesToDownload;
import org.sourceid.saml20.service.impl.grouprpc.adaptive.RebalanceTask;

public class RebalanceState {
    private static final Log log = LogFactory.getLog(RebalanceState.class);
    private StateServiceRegistry serviceRegistry;
    private RangesToDownload rangesToDownload = new RangesToDownload();
    private Map<StateServiceId, RangeList> rangesToPurge = new HashMap<StateServiceId, RangeList>();
    private DownloadedRanges downloadedRanges = new DownloadedRanges();
    private RebalanceTask currentTask = null;

    public RebalanceState(StateServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public synchronized boolean hasCurrentTask() {
        return this.currentTask != null;
    }

    public synchronized void handleNewTask(RebalanceTask task) {
        this.currentTask = task;
        RangeList newRanges = this.currentTask.getNewRing().getRanges(this.currentTask.getLocalNode());
        log.debug((Object)("Rebalancing for new ring, old ring=" + this.currentTask.getOldRing() + ", new ring=" + this.currentTask.getNewRing() + (String)(log.isTraceEnabled() ? ", new ranges=" + newRanges : "")));
        this.rangesToDownload = new RangesToDownload();
        this.rangesToPurge = new HashMap<StateServiceId, RangeList>();
        for (StateServiceId serviceId : this.serviceRegistry.getServiceIds()) {
            RangeDiff diff = newRanges.getDiff(this.downloadedRanges.getRangeList(serviceId));
            if (!diff.getDropped().isEmpty()) {
                this.rangesToPurge.put(serviceId, diff.getDropped());
            }
            ArrayList<RangeAndReplicas> rangesAndReplicas = new ArrayList<RangeAndReplicas>();
            for (Range range : diff.getAdded().getRanges()) {
                RangeAndReplicas rangeAndReplicas = this.makeRangeAndReplicas(this.currentTask.getNewRing(), range, this.currentTask.getLocalNode());
                if (!rangeAndReplicas.hasReplicas()) continue;
                rangesAndReplicas.add(rangeAndReplicas);
            }
            this.rangesToDownload.addRanges(serviceId, rangesAndReplicas);
        }
    }

    public synchronized void addRangesToDownload(StateServiceId serviceId, Collection<RangeAndReplicas> rangesAndReplicas) {
        this.rangesToDownload.addRanges(serviceId, rangesAndReplicas);
    }

    public synchronized void addRangesToDownload(HashRingNode node, StateServiceId serviceId, Collection<RangeAndReplicas> rangesAndReplicas) {
        this.rangesToDownload.addRanges(node, serviceId, rangesAndReplicas);
    }

    public synchronized void reallocateRanges(HashRingNode node) {
        this.rangesToDownload.reallocateRanges(node);
    }

    public synchronized DownloadBatch removeDownloadBatch() {
        return this.rangesToDownload.removeDownloadBatch();
    }

    public synchronized PurgeBatch removePurgeBatch() {
        Iterator<Map.Entry<StateServiceId, RangeList>> iterator = this.rangesToPurge.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<StateServiceId, RangeList> entry = iterator.next();
            iterator.remove();
            return new PurgeBatch(entry.getKey(), entry.getValue());
        }
        return null;
    }

    public synchronized void handleRebalanceComplete() {
        this.rangesToDownload = new RangesToDownload();
        this.rangesToPurge = new HashMap<StateServiceId, RangeList>();
        this.downloadedRanges = new DownloadedRanges();
        RangeList ranges = this.currentTask.getNewRing().getRanges(this.currentTask.getLocalNode());
        for (StateServiceId serviceId : this.serviceRegistry.getServiceIds()) {
            this.downloadedRanges.addRanges(serviceId, ranges);
        }
        this.currentTask = null;
    }

    public synchronized void addDownloadedRanges(StateServiceId serviceId, RangeList ranges) {
        this.downloadedRanges.addRanges(serviceId, ranges);
    }

    public synchronized void removeDownloadedRanges(StateServiceId serviceId, RangeList ranges) {
        this.downloadedRanges.removeRanges(serviceId, ranges);
    }

    public synchronized boolean hasRange(StateServiceId serviceId, Range range) {
        return this.downloadedRanges.hasRange(serviceId, range);
    }

    private RangeAndReplicas makeRangeAndReplicas(ConsistentHashRing ring, Range range, HashRingNode localNode) {
        Set replicas = ring.getReplicaSet(range.getStart());
        replicas.remove(localNode);
        return new RangeAndReplicas(range, replicas);
    }
}

