/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.grouprpc.lock;

import com.pingidentity.jgroups.NodeAddress;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.ClusterLockService;
import org.sourceid.saml20.service.impl.grouprpc.BaseGroupRpc;
import org.sourceid.saml20.service.impl.grouprpc.MockRpcDispatcher;
import org.sourceid.saml20.service.impl.grouprpc.lock.ClusterLockClientRpcs;
import org.sourceid.saml20.service.impl.grouprpc.lock.ClusterLockConfig;
import org.sourceid.saml20.service.impl.grouprpc.lock.ClusterLockServer;
import org.sourceid.saml20.service.impl.grouprpc.lock.LockRequest;

@SuppressFBWarnings(value={"MS_PKGPROTECT"})
public class ClusterLockClient
extends BaseGroupRpc
implements ClusterLockClientRpcs,
ClusterLockService {
    public static final String LOCK_REQUEST_GRANTED = "lockRequestGranted";
    public static final Class<?>[] LOCK_REQUEST_GRANTED_SIG = new Class[]{String.class};
    private Map<String, LockRequest> lockRequests = new HashMap<String, LockRequest>();
    private ClusterLockConfig lockConfig = new ClusterLockConfig();

    public ClusterLockClient() {
        super(false);
        new RefreshLockRequestsTask().schedule();
    }

    public ClusterLockClient(MockRpcDispatcher mockRpcDispatcher) {
        super(mockRpcDispatcher);
    }

    @Override
    public void getLock(String lockName) throws InterruptedException {
        this.requestLock(lockName).waitForLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockRequest requestLock(String lockName) {
        LockRequest request;
        ClusterLockClient clusterLockClient = this;
        synchronized (clusterLockClient) {
            request = this.lockRequests.get(lockName);
            if (request == null) {
                request = new LockRequest(this, lockName);
                this.lockRequests.put(lockName, request);
            }
        }
        if (!request.isGranted()) {
            this.sendRequestLockRpc(lockName, true);
        }
        return request;
    }

    @Override
    public synchronized void releaseLock(String lockName) {
        LockRequest lockRequest;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Releasing lock " + lockName));
        }
        if ((lockRequest = this.lockRequests.remove(lockName)) != null) {
            this.sendReleaseLockRpc(lockName);
        }
    }

    @Override
    public synchronized void lockRequestGranted(String lockName) {
        LockRequest lockRequest = this.lockRequests.get(lockName);
        if (lockRequest != null) {
            lockRequest.grantLock();
        }
    }

    public synchronized void refreshLockRequests() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Refreshing lock requests");
        }
        for (LockRequest lockRequest : this.lockRequests.values()) {
            this.sendRequestLockRpc(lockRequest.getLockName(), !lockRequest.isGranted());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Finished refreshing lock requests");
        }
    }

    protected void sendReleaseLockRpc(String lockName) {
        Address coord = this.getCoordinator();
        Address localAddress = this.getLocalAddress();
        if (coord == null || localAddress == null) {
            this.log.warn((Object)("Cannot release lock " + lockName + " as coordinator or local address not found"));
        } else {
            Vector<Address> nodes = new Vector<Address>();
            nodes.add(coord);
            this.callRemoteMethods(nodes, "releaseLock", (Class[])ClusterLockServer.RELEASE_LOCK_SIG, false, 0, new NodeAddress(localAddress), lockName);
        }
    }

    protected void sendRequestLockRpc(String lockName, boolean grantRequired) {
        Address coord = this.getCoordinator();
        Address localAddress = this.getLocalAddress();
        if (coord == null || localAddress == null) {
            this.log.warn((Object)("Cannot request lock " + lockName + " as coordinator or local address not found"));
        } else {
            Vector<Address> nodes = new Vector<Address>();
            nodes.add(coord);
            this.callRemoteMethods(nodes, "requestLock", (Class[])ClusterLockServer.REQUEST_LOCK_SIG, false, 0, new NodeAddress(localAddress), lockName, grantRequired);
        }
    }

    protected Address getCoordinator() {
        return this.getViewAddresses().get(0);
    }

    private class RefreshLockRequestsTask
    implements Runnable {
        private RefreshLockRequestsTask() {
        }

        @Override
        public void run() {
            try {
                ClusterLockClient.this.refreshLockRequests();
            }
            catch (Throwable t) {
                ClusterLockClient.this.log.error((Object)"Error occurred while refreshing lock requests", t);
            }
            this.schedule();
        }

        public void schedule() {
            MgmtFactory.getSingleThreadedExecutor().schedule(this, ClusterLockClient.this.lockConfig.getLockCheckIntervalMillis(), TimeUnit.MILLISECONDS);
        }
    }
}

