/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.localmemory;

import com.pingidentity.common.util.SerialHashable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sourceid.saml20.service.AccountLinkingService;
import org.sourceid.saml20.service.AccountLinkingServiceException;

public class AccountLinkingServiceMapImpl
implements AccountLinkingService {
    private Map<CompositeKey, String> linkMap = new HashMap<CompositeKey, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lookupLink(String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        CompositeKey key = this.getKey(idpEntityId, authnAdapterId, externalIdentifier);
        AccountLinkingServiceMapImpl accountLinkingServiceMapImpl = this;
        synchronized (accountLinkingServiceMapImpl) {
            return this.linkMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeLink(String localIdentifier, String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        CompositeKey key = this.getKey(idpEntityId, authnAdapterId, externalIdentifier);
        AccountLinkingServiceMapImpl accountLinkingServiceMapImpl = this;
        synchronized (accountLinkingServiceMapImpl) {
            this.linkMap.put(key, localIdentifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExternalId(String newExternalIdentifier, String idpEntityId, String oldExternalIdentifier) throws AccountLinkingServiceException {
        AccountLinkingServiceMapImpl accountLinkingServiceMapImpl = this;
        synchronized (accountLinkingServiceMapImpl) {
            HashMap<CompositeKey, String> updatedEntries = new HashMap<CompositeKey, String>();
            Iterator<Map.Entry<CompositeKey, String>> i = this.linkMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<CompositeKey, String> entry = i.next();
                CompositeKey key = entry.getKey();
                if (key.getExternalIdentifier().equals(oldExternalIdentifier) && key.getIdpEntityId().equals(idpEntityId)) {
                    i.remove();
                }
                CompositeKey newKey = this.getKey(idpEntityId, key.getAuthnAdapterId(), newExternalIdentifier);
                updatedEntries.put(newKey, entry.getValue());
            }
            this.linkMap.putAll(updatedEntries);
        }
    }

    @Override
    public void terminateLink(String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        CompositeKey key = this.getKey(idpEntityId, authnAdapterId, externalIdentifier);
        this.linkMap.remove(key);
    }

    @Override
    public boolean isDataSourceInUse(String datasourceId) {
        return false;
    }

    private CompositeKey getKey(String idpEntityId, String authnAdapterId, String externalIdentifier) throws AccountLinkingServiceException {
        try {
            return new CompositeKey(idpEntityId, authnAdapterId, externalIdentifier);
        }
        catch (IOException e) {
            throw new AccountLinkingServiceException(e);
        }
    }

    private class CompositeKey
    extends SerialHashable {
        private String idpEntityId;
        private String authnAdapterId;
        private String externalIdentifier;

        public CompositeKey(String idpEntityId, String authnAdapterId, String externalIdentifier) throws IOException {
            super(new Serializable[]{idpEntityId, authnAdapterId, externalIdentifier});
            this.idpEntityId = idpEntityId;
            this.authnAdapterId = authnAdapterId;
            this.externalIdentifier = externalIdentifier;
        }

        public String getIdpEntityId() {
            return this.idpEntityId;
        }

        public String getAuthnAdapterId() {
            return this.authnAdapterId;
        }

        public String getExternalIdentifier() {
            return this.externalIdentifier;
        }

        @Override
        public String toString() {
            return "entityId=" + this.idpEntityId + " | adapterId=" + this.authnAdapterId + " | exId=" + this.externalIdentifier;
        }
    }
}

