/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.localmemory;

import com.pingidentity.common.util.ByteArrayHashKey;
import com.pingidentity.common.util.LogGuard;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.ArtifactPersistenceService;
import org.sourceid.saml20.service.util.NodeIndex;

public class ArtifactPersistenceServiceMapImpl
implements ArtifactPersistenceService,
Serializable {
    private Log log = LogFactory.getLog(this.getClass());
    private Map<ByteArrayHashKey, ArtifactPersistenceService.Message> artifactMap;
    private SortedMap<Long, List<ByteArrayHashKey>> sortedMap;
    private Integer endpointIndex;

    public ArtifactPersistenceServiceMapImpl() {
        this.init();
    }

    public ArtifactPersistenceServiceMapImpl(int idx) {
        this.init();
        this.endpointIndex = idx;
    }

    void init() {
        this.artifactMap = new HashMap<ByteArrayHashKey, ArtifactPersistenceService.Message>();
        this.sortedMap = new TreeMap<Long, List<ByteArrayHashKey>>();
    }

    private int getEndpointIndex() {
        if (this.endpointIndex == null) {
            this.endpointIndex = MgmtFactory.getMediator().isStandalone() ? 0 : NodeIndex.getIndex();
        }
        return this.endpointIndex;
    }

    @Override
    public byte[] precomputeHandle(int length) {
        return IDGenerator.generateBytes(length);
    }

    public synchronized void saveArtifact(byte[] messageHandleBytes, ArtifactPersistenceService.Message msg, int timeoutSeconds) {
        ByteArrayHashKey key = new ByteArrayHashKey(messageHandleBytes);
        this.artifactMap.put(key, msg);
        int timeoutMillis = timeoutSeconds * 1000;
        long nowTimestamp = System.currentTimeMillis();
        long timoutTimestamp = nowTimestamp + (long)timeoutMillis;
        LinkedList<ByteArrayHashKey> artifactsList = (LinkedList<ByteArrayHashKey>)this.sortedMap.get(timoutTimestamp);
        if (artifactsList == null) {
            artifactsList = new LinkedList<ByteArrayHashKey>();
            this.sortedMap.put(timoutTimestamp, artifactsList);
        }
        artifactsList.add(key);
        this.cleanupExpiredEntries(nowTimestamp);
    }

    @Override
    public ArtifactPersistenceService.Handle saveArtifact(ArtifactPersistenceService.Message msg, int timeoutSeconds) {
        byte[] messageHandleBytes = msg.getHandle();
        if (messageHandleBytes == null) {
            messageHandleBytes = this.precomputeHandle(msg.getMessageHandleLength());
        }
        this.saveArtifact(messageHandleBytes, msg, timeoutSeconds);
        return new ArtifactPersistenceService.Handle(messageHandleBytes, this.getEndpointIndex());
    }

    @Override
    public synchronized ArtifactPersistenceService.Message retrieveAndRemoveArtifact(byte[] messageHandlebytes) {
        return this.retrieveAndRemoveArtifact(messageHandlebytes, System.currentTimeMillis());
    }

    public synchronized ArtifactPersistenceService.Message retrieveAndRemoveArtifact(byte[] messageHandlebytes, long nowTimestamp) {
        this.cleanupExpiredEntries(nowTimestamp);
        ByteArrayHashKey key = new ByteArrayHashKey(messageHandlebytes);
        return this.artifactMap.remove(key);
    }

    protected synchronized void cleanupExpiredEntries(long nowTimestamp) {
        SortedMap<Long, List<ByteArrayHashKey>> expiredArtifactsMap = this.sortedMap.headMap(nowTimestamp);
        for (List<ByteArrayHashKey> expiredArtifacts : expiredArtifactsMap.values()) {
            for (ByteArrayHashKey expiredArtifactString : expiredArtifacts) {
                ArtifactPersistenceService.Message message = this.artifactMap.remove(expiredArtifactString);
                if (message == null || !this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Removing expired artifact " + LogGuard.encode(expiredArtifactString.toBase64())));
            }
        }
        expiredArtifactsMap.clear();
    }

    protected synchronized int getArtifactMapSize() {
        return this.artifactMap.size();
    }

    protected synchronized int getSortedMapSize() {
        return this.sortedMap.size();
    }

    protected synchronized int getTotalNumItemsInSortedMap() {
        int ct = 0;
        for (Map.Entry<Long, List<ByteArrayHashKey>> entry : this.sortedMap.entrySet()) {
            ct += entry.getValue().size();
        }
        return ct;
    }
}

