/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.localmemory;

import com.pingidentity.common.util.Cache;
import com.pingidentity.common.util.DistributableCache;
import java.io.Serializable;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.service.AssertionReplayPreventionService;
import org.sourceid.saml20.service.StateService;
import org.sourceid.saml20.service.StateServiceId;
import org.sourceid.saml20.state.ConsistentHashTracker;
import org.sourceid.saml20.state.StateAccepter;
import org.sourceid.saml20.state.StateMgmtFactory;

public class AssertionReplayPreventionSvcInMemoryImpl
implements AssertionReplayPreventionService,
StateAccepter,
Serializable,
StateService<AssertionInfo> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AssertionReplayPreventionSvcInMemoryImpl.class);
    private Clock clock;
    private long timeBucket;
    DistributableCache<String> assertionIds;

    public AssertionReplayPreventionSvcInMemoryImpl() {
        this(60000L);
    }

    public AssertionReplayPreventionSvcInMemoryImpl(long timeBucketMillis) {
        this(timeBucketMillis, false);
    }

    public AssertionReplayPreventionSvcInMemoryImpl(long timeBucketMillis, boolean rpcHandler) {
        this(timeBucketMillis, rpcHandler, Clock.systemDefaultZone());
    }

    public AssertionReplayPreventionSvcInMemoryImpl(long timeBucketMillis, boolean rpcHandler, Clock clock) {
        this(timeBucketMillis, rpcHandler, clock, StateMgmtFactory.makeConsistentHashTracker(false, false));
    }

    public AssertionReplayPreventionSvcInMemoryImpl(long timeBucketMillis, boolean rpcHandler, Clock clock, ConsistentHashTracker tracker) {
        if (timeBucketMillis <= 0L) {
            throw new IllegalArgumentException("timeBucketMillis must be greater than zero");
        }
        this.timeBucket = timeBucketMillis;
        this.assertionIds = new DistributableCache(0L, Integer.MAX_VALUE, false, tracker);
        this.setClock(clock);
        if (rpcHandler) {
            StateMgmtFactory.getStateServiceRegistry().registerService(this);
        }
    }

    public synchronized void setClock(Clock clock) {
        this.clock = clock;
        this.assertionIds.setClock(clock);
    }

    @Override
    public synchronized void clear(String id) {
        this.assertionIds.remove(id);
    }

    @Override
    public synchronized boolean isReplay(String assertionId, Calendar notOnOrAfter) {
        boolean isReplay;
        long timeKey = this.bucketTime(notOnOrAfter.getTime().getTime());
        long currentExpiry = this.assertionIds.getTimestampForKey(assertionId);
        boolean bl = isReplay = currentExpiry > this.clock.millis();
        if (!isReplay) {
            this.assertionIds.tryPutWithTimestamp(assertionId, assertionId, timeKey);
        }
        return isReplay;
    }

    @Override
    public synchronized boolean containsId(String assertionId) {
        long expTime;
        return this.assertionIds.containsKey(assertionId) && (expTime = this.assertionIds.getTimestampForKey(assertionId)) > System.currentTimeMillis();
    }

    @Override
    public synchronized void setState(StateAccepter other) {
        this.setState((AssertionReplayPreventionSvcInMemoryImpl)other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setState(AssertionReplayPreventionSvcInMemoryImpl other) {
        AssertionReplayPreventionSvcInMemoryImpl assertionReplayPreventionSvcInMemoryImpl = other;
        synchronized (assertionReplayPreventionSvcInMemoryImpl) {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                StringBuilder stringBuilder = sb.append("setState called with ");
                sb.append(other.assertionIds.size()).append(" ids");
                log.debug((Object)stringBuilder);
            }
            this.assertionIds = other.assertionIds;
            this.timeBucket = other.timeBucket;
        }
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + "/" + this.assertionIds.size();
    }

    @Override
    public synchronized StateServiceId getServiceId() {
        return StateServiceId.ASSERTION_REPLAY_SERVICE;
    }

    @Override
    public synchronized void importRecords(Collection<AssertionInfo> records) {
        for (AssertionInfo info : records) {
            long timestamp = this.assertionIds.getTimestampForKey(info.getId());
            timestamp = Math.max(timestamp, info.getNotOnOrAfterMillis());
            this.assertionIds.tryPutWithTimestamp(info.getId(), info.getId(), timestamp);
        }
    }

    @Override
    public synchronized Collection<AssertionInfo> getRecords(int startHash, int endHashExclusive) {
        Collection<Cache.Entry<String, String>> entries = this.assertionIds.getEntriesForRange(startHash, endHashExclusive);
        ArrayList<AssertionInfo> result = new ArrayList<AssertionInfo>();
        for (Cache.Entry<String, String> entry : entries) {
            result.add(new AssertionInfo(entry.getKey(), entry.getTimestamp()));
        }
        return result;
    }

    @Override
    public synchronized void purgeRecords(int startHash, int endHashExclusive) {
        Collection<String> ids = this.assertionIds.getKeysForRange(startHash, endHashExclusive);
        for (String id : ids) {
            this.assertionIds.remove(id);
        }
    }

    synchronized long bucketTime(long rawTime) {
        long howmany = rawTime / this.timeBucket;
        return (howmany + 1L) * this.timeBucket;
    }

    public static class AssertionInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private long notOnOrAfterMillis;

        public AssertionInfo(String id, long notOnOrAfterMillis) {
            this.id = id;
            this.notOnOrAfterMillis = notOnOrAfterMillis;
        }

        public String getId() {
            return this.id;
        }

        public long getNotOnOrAfterMillis() {
            return this.notOnOrAfterMillis;
        }
    }
}

