/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.localmemory;

import com.pingidentity.common.util.Cache;
import com.pingidentity.common.util.CachePurgeBeforeExpiryTracker;
import com.pingidentity.common.util.DistributableCache;
import com.pingidentity.common.util.SerialHashable;
import com.pingidentity.pingcommons.crypto.IDGenerator;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.saml20.domain.AuthnSessionSettings;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.AuthnSessionPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.service.AuthnSessionInfo;
import org.sourceid.saml20.service.AuthnSessionInfoImpl;
import org.sourceid.saml20.service.AuthnSessionInfoWithoutBeansImpl;
import org.sourceid.saml20.service.BeanFilter;
import org.sourceid.saml20.service.CachedSessionGroupInfo;
import org.sourceid.saml20.service.CachedSessionGroupStatus;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.IdpSessionRegistry;
import org.sourceid.saml20.service.Session;
import org.sourceid.saml20.service.SessionInfoForPartnerSessionsResult;
import org.sourceid.saml20.service.SessionRegistryException;
import org.sourceid.saml20.service.StateService;
import org.sourceid.saml20.service.StateServiceId;
import org.sourceid.saml20.service.impl.grouprpc.PreferredNodeGroup;
import org.sourceid.saml20.service.session.AuthnSessionContextData;
import org.sourceid.saml20.service.util.AuthnSessionContextDataUtil;
import org.sourceid.saml20.state.ConsistentHashTracker;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.saml20.state.SizeLimitProps;
import org.sourceid.saml20.state.StateAccepter;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.NameIdHashKey;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.servlet.ExtendedSessionIdListener;
import org.sourceid.websso.servlet.ExtendedSessionIdManager;
import org.sourceid.websso.servlet.ExtendedSri;
import org.sourceid.websso.servlet.SessionIdUtil;

public class IdpSessionRegistryMapImpl
implements IdpSessionRegistry,
Serializable,
StateAccepter,
ExtendedSessionIdListener,
StateService<SessionInfoAndTimestamp> {
    private static final long serialVersionUID = 1L;
    private static final transient Log log = LogFactory.getLog(IdpSessionRegistryMapImpl.class);
    private transient AuthnSessionPolicyManager sessionPolicyManager = MgmtFactory.getAuthnSessionPolicyManager();
    private SessionIdUtil sessionIdUtil = SessionIdUtil.getInstance();
    int maxSessionsPerSessionId;
    int maxPartnerSessionsPerSession;
    int maxSrisPerUserKey;
    protected Map<String, SessionInfoAndBeanHash> assertionIdToSessionInfoMap;
    protected Map<NameIdHashKey, Set<SessionInfoAndBeanHash>> nameIdToSessionInfosMap;
    private Clock clock = Clock.systemDefaultZone();
    private SizeLimitProps sizeLimitProps = new SizeLimitProps();
    private int expiryPeriodMins;
    private int userKeyExpiryPeriodMins;
    private int tombstoneRetentionMins;
    protected Map<String, IdpSessionInfo> sriToSessionInfoMap;
    protected ExtendedSessionIdToInfoMap extendedSessionIdToInfoMap;
    protected UniqueUserKeyToSriMap uniqueUserKeyToSrisMap;
    protected transient UniqueUserKeyToSrisRegistry userKeyToSrisRegistry = new UniqueUserKeyToSrisRegistry();
    protected Cache<String, SessionTombstoneInfo> sriToSessionTombstoneInfoMap;

    public IdpSessionRegistryMapImpl() {
        int configMaxPfSessions = this.sizeLimitProps.getIdpMaxSessions();
        int configMaxSessionsPerSessionId = this.sizeLimitProps.getIdpMaxIndividualSessions();
        int configMaxPartnerSessionsPerSession = this.sizeLimitProps.getIdpMaxPartnerSessions();
        int configExpiryPeriodMins = this.sizeLimitProps.getIdpExpiryMins();
        int configMaxUniqueUserKeys = this.sizeLimitProps.getMaxUniqueUserKeys();
        int configMaxSrisPerUserKey = this.sizeLimitProps.getMaxUserKeySris();
        int configUserKeyExpiryPeriodMins = this.sizeLimitProps.getUserKeyExpiryMins();
        int tombstoneRetentionMins = this.sizeLimitProps.getIdpTombstoneRetentionMins();
        this.initialize(configMaxPfSessions, configMaxSessionsPerSessionId, configMaxPartnerSessionsPerSession, configExpiryPeriodMins, configMaxUniqueUserKeys, configMaxSrisPerUserKey, configUserKeyExpiryPeriodMins, tombstoneRetentionMins, StateMgmtFactory.makeConsistentHashTracker(false, true), StateMgmtFactory.makeConsistentHashTracker(false, false));
    }

    public IdpSessionRegistryMapImpl(int maxPfSessions, int maxSessionsPerSessionId, int maxPartnerSessionsPerSession, int expiryPeriodMins, int maxUniqueUserKeys, int maxSrisPerUserKey, int userKeyExpiryPeriodMins, int tombstoneRetentionMins, ConsistentHashTracker tracker, ConsistentHashTracker userKeyTracker) {
        this.initialize(maxPfSessions, maxSessionsPerSessionId, maxPartnerSessionsPerSession, expiryPeriodMins, maxUniqueUserKeys, maxSrisPerUserKey, userKeyExpiryPeriodMins, tombstoneRetentionMins, tracker, userKeyTracker);
    }

    public synchronized void setClock(Clock clock) {
        this.clock = clock;
        this.extendedSessionIdToInfoMap.setClock(clock);
    }

    private void initialize(int maxPfSessions, int maxSessionsPerSessionId, int maxPartnerSessionsPerSession, int expiryPeriodMins, int maxUniqueUserKeys, int maxSrisPerUserKey, int userKeyExpiryPeriodMins, int tombstoneRetentionMins, ConsistentHashTracker tracker, ConsistentHashTracker userKeyTracker) {
        log.debug((Object)("Creating " + this.getClass()));
        ExtendedSessionIdManager.getInstance().addListener(this);
        this.maxSessionsPerSessionId = maxSessionsPerSessionId;
        this.maxPartnerSessionsPerSession = maxPartnerSessionsPerSession;
        this.maxSrisPerUserKey = maxSrisPerUserKey;
        this.expiryPeriodMins = expiryPeriodMins;
        this.userKeyExpiryPeriodMins = userKeyExpiryPeriodMins;
        this.tombstoneRetentionMins = tombstoneRetentionMins;
        this.assertionIdToSessionInfoMap = new HashMap<String, SessionInfoAndBeanHash>();
        this.sriToSessionInfoMap = new HashMap<String, IdpSessionInfo>();
        this.nameIdToSessionInfosMap = new HashMap<NameIdHashKey, Set<SessionInfoAndBeanHash>>();
        this.extendedSessionIdToInfoMap = new ExtendedSessionIdToInfoMap((long)expiryPeriodMins * 60L * 1000L, maxPfSessions, this.sizeLimitProps.getStatsLogIntervalMins(), tracker);
        this.uniqueUserKeyToSrisMap = new UniqueUserKeyToSriMap((long)userKeyExpiryPeriodMins * 60L * 1000L, maxUniqueUserKeys, this.sizeLimitProps.getStatsLogIntervalMins(), userKeyTracker);
        this.sriToSessionTombstoneInfoMap = new Cache((long)tombstoneRetentionMins * 60L * 1000L, maxPfSessions, 1024, 0.75f, true);
        log.debug((Object)("Max Sessions: " + maxPfSessions));
        log.debug((Object)("Max Unique User Keys: " + maxUniqueUserKeys));
        StateMgmtFactory.getStateServiceRegistry().registerService(this);
        StateMgmtFactory.getStateServiceRegistry().registerService(this.userKeyToSrisRegistry);
    }

    @Override
    public synchronized Map<IdpHashableAuthnBean, Collection<Session>> getRegistered(String extendedSessionId) {
        HashMap<IdpHashableAuthnBean, Collection<Session>> registered = new HashMap<IdpHashableAuthnBean, Collection<Session>>();
        Collection<BeanAndSessions> beansAndSessions = this.getBeansAndSessions(extendedSessionId);
        if (beansAndSessions != null) {
            for (BeanAndSessions beanAndSessions : beansAndSessions) {
                registered.put(beanAndSessions.getBean(), beanAndSessions.getSessions());
            }
        }
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("getRegistered(extendedSessionId=").append(this.sessionIdUtil.hashIdForLog(extendedSessionId)).append(") returning authn beans ");
            msg.append(registered.keySet());
            log.debug((Object)msg);
        }
        return registered;
    }

    @Override
    public synchronized AuthnSessionInfo getAuthnSessionInfoBySri(String extendedSriStr, Boolean updateActivityTime, BeanFilter beanFilter) throws SessionRegistryException {
        Set<IdpHashableAuthnBean> beans = Collections.emptySet();
        String persistentSessionGroupId = null;
        long lastActivityTimeMillis = 0L;
        long sessionSeriesId = 0L;
        List<CachedSessionGroupStatus> sessionGroupStatuses = new ArrayList<CachedSessionGroupStatus>();
        Set<String> uniqueUserKeys = Collections.emptySet();
        AuthnSessionContextData sessionContextData = null;
        Set<String> indexKeysToRefresh = Collections.emptySet();
        ExtendedSri extendedSri = this.getExtendedSri(extendedSriStr, "Error getting authn session info by SRI");
        IdpSessionInfo info = this.sriToSessionInfoMap.get(extendedSri.getSri());
        if (info != null) {
            this.extendedSessionIdToInfoMap.get(info.getExtendedSessionId());
            lastActivityTimeMillis = info.getLastActivityTimeMillis();
            persistentSessionGroupId = info.getPersistentSessionGroupId();
            sessionSeriesId = info.getSessionSeriesId();
            this.invalidateSessions(info, updateActivityTime);
            beans = this.getBeans(info);
            sessionGroupStatuses = this.getCachedSessionGroupStatuses(info, beans);
            uniqueUserKeys = info.getUniqueUserKeys();
            sessionContextData = AuthnSessionContextDataUtil.makeCopy(info.getSessionContextData());
            indexKeysToRefresh = this.getIndexKeysToRefresh(beans);
        }
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("getAuthnSessionInfoBySri(extendedSri=").append(extendedSriStr).append(") returning authnBeans=");
            msg.append(beans);
            log.debug((Object)msg);
        }
        if (beanFilter != BeanFilter.NO_BEANS) {
            if (beanFilter == BeanFilter.AUTHN_SESSIONS) {
                beans = beans.stream().filter(IdpHashableAuthnBean::isValidForSso).collect(Collectors.toSet());
            }
            return new AuthnSessionInfoImpl.Builder().setSessionSeriesId(sessionSeriesId).setBeans(beans).setPersistentSessionGroupId(persistentSessionGroupId).setSessionGroupStatuses(sessionGroupStatuses).setLastActivityTimeMillis(lastActivityTimeMillis).setUniqueUserKeys(uniqueUserKeys).setSessionContextData(sessionContextData).setIndexKeysToRefresh(indexKeysToRefresh).build();
        }
        boolean hasAuthnSessions = beans.stream().anyMatch(IdpHashableAuthnBean::isValidForSso);
        return new AuthnSessionInfoWithoutBeansImpl.Builder().setSessionSeriesId(sessionSeriesId).setHasAuthnSessions(hasAuthnSessions).setPersistentSessionGroupId(persistentSessionGroupId).setSessionGroupStatuses(sessionGroupStatuses).setLastActivityTimeMillis(lastActivityTimeMillis).setUniqueUserKeys(uniqueUserKeys).setSessionContextData(sessionContextData).setIndexKeysToRefresh(indexKeysToRefresh).build();
    }

    @Override
    public synchronized AuthnSessionInfo getAuthnSessionInfo(String extendedSessionId) {
        Set<IdpHashableAuthnBean> beans = Collections.emptySet();
        String persistentSessionGroupId = null;
        long lastActivityTimeMillis = 0L;
        long sessionSeriesId = 0L;
        List<CachedSessionGroupStatus> sessionGroupStatuses = new ArrayList<CachedSessionGroupStatus>();
        Set<String> uniqueUserKeys = Collections.emptySet();
        AuthnSessionContextData sessionContextData = null;
        Set<String> indexKeysToRefresh = Collections.emptySet();
        IdpSessionInfo info = (IdpSessionInfo)this.extendedSessionIdToInfoMap.get(extendedSessionId);
        if (info != null) {
            lastActivityTimeMillis = info.getLastActivityTimeMillis();
            persistentSessionGroupId = info.getPersistentSessionGroupId();
            sessionSeriesId = info.getSessionSeriesId();
            this.invalidateSessions(info, true);
            beans = this.getBeans(info).stream().filter(bean -> bean.isValidForSso()).collect(Collectors.toSet());
            sessionGroupStatuses = this.getCachedSessionGroupStatuses(info, beans);
            uniqueUserKeys = info.getUniqueUserKeys();
            sessionContextData = AuthnSessionContextDataUtil.makeCopy(info.getSessionContextData());
            indexKeysToRefresh = this.getIndexKeysToRefresh(beans);
        }
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("getAuthnSessionInfo(extendedSessionId=").append(this.sessionIdUtil.hashIdForLog(extendedSessionId)).append(") returning sessionSeriesId=" + sessionSeriesId + ", authnBeans=");
            msg.append(beans);
            log.debug((Object)msg);
        }
        return new AuthnSessionInfoImpl.Builder().setSessionSeriesId(sessionSeriesId).setBeans(beans).setPersistentSessionGroupId(persistentSessionGroupId).setSessionGroupStatuses(sessionGroupStatuses).setLastActivityTimeMillis(lastActivityTimeMillis).setUniqueUserKeys(uniqueUserKeys).setSessionContextData(sessionContextData).setIndexKeysToRefresh(indexKeysToRefresh).build();
    }

    private Set<String> getIndexKeysToRefresh(Collection<IdpHashableAuthnBean> beans) {
        HashSet<String> indexKeysToRefresh = new HashSet<String>();
        for (IdpHashableAuthnBean bean : beans) {
            indexKeysToRefresh.addAll(IdpSessionRegistrySupport.getIndexKeysForBean(bean));
        }
        return indexKeysToRefresh;
    }

    private List<CachedSessionGroupStatus> getCachedSessionGroupStatuses(IdpSessionInfo idpSessionInfo, Set<IdpHashableAuthnBean> beans) {
        HashMap<String, CachedSessionGroupStatus> result = new HashMap<String, CachedSessionGroupStatus>();
        Map<String, Set> beansByGroupId = beans.stream().filter(bean -> bean.getStoredSessionGroupId() != null).collect(Collectors.toMap(IdpHashableAuthnBean::getStoredSessionGroupId, bean -> new HashSet<IdpHashableAuthnBean>(Collections.singleton(bean)), (oldValue, newValue) -> {
            oldValue.addAll(newValue);
            return oldValue;
        }));
        for (Map.Entry<String, Set> entry : beansByGroupId.entrySet()) {
            CachedSessionGroupInfo sessionGroupInfo = idpSessionInfo.getSessionGroupInfo(entry.getKey());
            if (sessionGroupInfo == null) continue;
            CachedSessionGroupStatus status = (CachedSessionGroupStatus)result.get(entry.getKey());
            if (status == null) {
                status = new CachedSessionGroupStatus(entry.getKey());
                result.put(entry.getKey(), status);
            }
            long currentTimeMillis = this.getCurrentTimeMillis();
            long elapsedTimeMillis = Math.max(0L, currentTimeMillis - sessionGroupInfo.getLastActivityTimeMillis());
            long minimumIdleTimeout = Long.MAX_VALUE;
            for (IdpHashableAuthnBean bean2 : entry.getValue()) {
                AuthnSessionSettings sourceSettings = MgmtFactory.getAuthnSessionPolicyManager().getEffectiveSettings(bean2.getAuthnSourceKey(), bean2.getDeviceSharingType());
                if (sourceSettings.hasIdleTimeout()) {
                    minimumIdleTimeout = Math.min(minimumIdleTimeout, sourceSettings.getIdleTimeoutMillis());
                }
                if (bean2.getOriginalIdleTimeoutMins() == -1) continue;
                minimumIdleTimeout = Math.min(minimumIdleTimeout, TimeUnit.MINUTES.toMillis(bean2.getOriginalIdleTimeoutMins()));
            }
            double elapsedFraction = (double)elapsedTimeMillis / (double)minimumIdleTimeout;
            status.setIdleTimeoutFractionElapsed(Math.min(1.0, elapsedFraction));
        }
        return new ArrayList<CachedSessionGroupStatus>(result.values());
    }

    private ExtendedSri getExtendedSri(String extendedSriStr, String errorMsgStr) throws SessionRegistryException {
        ExtendedSri extendedSri = null;
        try {
            extendedSri = new ExtendedSri(extendedSriStr);
        }
        catch (InvalidParameterException e) {
            throw new SessionRegistryException(errorMsgStr, e);
        }
        return extendedSri;
    }

    public synchronized void updateCacheAccessTime(String extendedSriStr) throws SessionRegistryException {
        ExtendedSri extendedSri = this.getExtendedSri(extendedSriStr, "Error updating cache access time");
        IdpSessionInfo info = this.sriToSessionInfoMap.get(extendedSri.getSri());
        if (info == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateCacheAccessTime(extendedSri=" + extendedSriStr + ")"));
        }
        this.extendedSessionIdToInfoMap.get(info.getExtendedSessionId());
    }

    @Override
    public synchronized void updateCachedSessionGroupInfos(String extendedSriStr, Collection<CachedSessionGroupInfo> sessionGroupInfos) throws SessionRegistryException {
        ExtendedSri extendedSri = this.getExtendedSri(extendedSriStr, "Error updating cached session group infos");
        IdpSessionInfo info = this.sriToSessionInfoMap.get(extendedSri.getSri());
        if (info == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateCachedSessionGroupInfos(extendedSri=" + extendedSriStr + ", infos=" + sessionGroupInfos + ")"));
        }
        info.updateSessionGroupInfos(sessionGroupInfos);
    }

    private void invalidateSessions(IdpSessionInfo info, boolean updateActivityTime) {
        long currentTimeMillis = this.getCurrentTimeMillis();
        HashSet<IdpHashableAuthnBean> toUnregister = new HashSet<IdpHashableAuthnBean>();
        for (BeanAndSessions beanAndSessions : info.getBeansAndSessions().values()) {
            IdpHashableAuthnBean bean = beanAndSessions.getBean();
            if (!bean.isValidForSso()) continue;
            boolean invalidate = false;
            String event = "session invalid";
            AuthnSessionSettings settings = this.sessionPolicyManager.getEffectiveSettings(bean.getAuthnSourceKey(), bean.getDeviceSharingType());
            int idleTimeoutMins = this.getExpiryPeriodMins();
            if (settings.hasIdleTimeout()) {
                settings.setIdleTimeoutMins(Math.min(idleTimeoutMins, settings.getIdleTimeoutMins()));
            } else {
                settings.setIdleTimeoutMins(idleTimeoutMins);
            }
            if (!settings.isEnableSessions()) {
                invalidate = true;
                event = "sessions disabled for source";
            } else if (!settings.isSessionValid(bean, info.getLastActivityTimeMillis(), currentTimeMillis)) {
                invalidate = true;
                event = "session idle or max timeout reached";
            } else if (this.isStoredSessionGroupRevoked(bean)) {
                invalidate = true;
                event = "session group revoked";
            }
            if (!invalidate) continue;
            bean.setValidForSso(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("invalidateSessions(extendedSessionId=" + this.sessionIdUtil.hashIdForLog(info.getExtendedSessionId()) + "): authn bean " + bean + " " + event + ", authnSourceKey=" + bean.getAuthnSourceKey()));
            }
            if (bean.isDoLogout() || !beanAndSessions.getSessions().isEmpty()) continue;
            toUnregister.add(bean);
        }
        for (IdpHashableAuthnBean beanToUnregister : toUnregister) {
            this.unregisterAuthnBean(beanToUnregister);
        }
        if (updateActivityTime) {
            info.setLastActivityTimeMillis(currentTimeMillis);
        }
    }

    @Override
    public synchronized void unregisterAuthnBean(IdpHashableAuthnBean authnBean) {
        String sri = this.sessionIdUtil.getSriFromPrimaryValue(authnBean.getPrimarySessionId());
        IdpSessionInfo sessionInfo = this.sriToSessionInfoMap.get(sri);
        int beanCount = 0;
        if (sessionInfo != null) {
            BeanAndSessions beanAndSessions = sessionInfo.getBeansAndSessions().remove(authnBean.getSerializedHash());
            beanCount = sessionInfo.getBeansAndSessions().size();
            if (beanCount == 0) {
                this.extendedSessionIdToInfoMap.remove(sessionInfo.getExtendedSessionId());
                this.sriToSessionInfoMap.remove(sri);
            }
            this.checkRemoveFromNameIdMap(sessionInfo, authnBean);
            if (beanAndSessions != null) {
                this.cleanupSessions(beanAndSessions);
            }
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("unregisterAuthnBean: authnBean=").append(authnBean).append(", primarySessionId=").append(this.sessionIdUtil.hashIdForLog(authnBean.getPrimarySessionId()));
            sb.append(". Session now has ").append(beanCount).append(" beans associated with it.");
            log.debug((Object)sb);
        }
    }

    private void unregisterIdpSessionInfo(IdpSessionInfo sessionInfo) {
        this.extendedSessionIdToInfoMap.remove(sessionInfo.getExtendedSessionId());
        IdpSessionInfo registered = this.sriToSessionInfoMap.get(sessionInfo.getSri());
        if (sessionInfo.equals(registered)) {
            this.sriToSessionInfoMap.remove(sessionInfo.getSri());
        }
        for (BeanAndSessions beanAndSessions : sessionInfo.getBeansAndSessions().values()) {
            this.checkRemoveFromNameIdMap(sessionInfo, beanAndSessions.getBean());
            this.cleanupSessions(beanAndSessions);
        }
        sessionInfo.getBeansAndSessions().clear();
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("unregisterIdpSessionInfo: extendedSessionId=").append(this.sessionIdUtil.hashIdForLog(sessionInfo.getExtendedSessionId()));
            log.debug((Object)sb);
        }
    }

    private void cleanupSessions(BeanAndSessions beanAndSessions) {
        for (Session session : beanAndSessions.getSessions()) {
            this.cleanupSession(session);
        }
        beanAndSessions.getSessions().clear();
    }

    @Override
    public void registerSessionIssued(String oldExtendedSessionId, String newExtendedSessionId, Long sessionSeriesId, IdpHashableAuthnBean authnBean, Session session, Collection<String> uniqueUserKeys) {
        this.registerBeansAndSession(oldExtendedSessionId, newExtendedSessionId, sessionSeriesId, 0L, Collections.singleton(authnBean), session, null, uniqueUserKeys, null);
    }

    @Override
    public void registerBeans(String oldExtendedSessionId, String newExtendedSessionId, Long sessionSeriesId, Long lastActivityTime, Set<IdpHashableAuthnBean> beans, Collection<CachedSessionGroupInfo> sessionGroupInfos, Collection<String> uniqueUserKeys, AuthnSessionContextData sessionContextData) {
        this.registerBeansAndSession(oldExtendedSessionId, newExtendedSessionId, sessionSeriesId, lastActivityTime, beans, null, sessionGroupInfos, uniqueUserKeys, sessionContextData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBeansAndSession(String oldExtendedSessionId, String newExtendedSessionId, long sessionSeriesId, long lastActivityTime, Set<IdpHashableAuthnBean> authnBeans, Session session, Collection<CachedSessionGroupInfo> sessionGroupInfos, Collection<String> uniqueUserKeys, AuthnSessionContextData sessionContextData) {
        IdpSessionRegistryMapImpl idpSessionRegistryMapImpl = this;
        synchronized (idpSessionRegistryMapImpl) {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("registerBeansAndSession: authnBeans ");
                sb.append(StringUtils.join((Collection)authnBeans.stream().map(SerialHashable::getSerializedHash).collect(Collectors.toList()), (String)","));
                if (session != null) {
                    sb.append(" | session ");
                    sb.append(session.toShortString());
                }
                sb.append(" | sessionSeriesId ");
                sb.append(sessionSeriesId);
                log.debug((Object)sb);
            }
            IdpHashableAuthnBean firstBean = authnBeans.iterator().next();
            String sri = this.sessionIdUtil.getSriFromPrimaryValue(firstBean.getPrimarySessionId());
            IdpSessionInfo sessionInfo = (IdpSessionInfo)this.extendedSessionIdToInfoMap.remove(oldExtendedSessionId);
            if (sessionInfo == null) {
                sessionInfo = new IdpSessionInfo(newExtendedSessionId, sri, this.getCurrentTimeMillis());
            }
            if (lastActivityTime > 0L) {
                sessionInfo.setLastActivityTimeMillis(lastActivityTime);
            }
            sessionInfo.setSessionSeriesId(sessionSeriesId);
            sessionInfo.setExtendedSessionId(newExtendedSessionId);
            if (CollectionUtils.isNotEmpty(uniqueUserKeys)) {
                sessionInfo.addUniqueUserKeys(uniqueUserKeys);
            }
            if (sessionContextData != null) {
                sessionInfo.setSessionContextData(sessionContextData);
            }
            this.extendedSessionIdToInfoMap.put(newExtendedSessionId, sessionInfo);
            this.sriToSessionInfoMap.put(sri, sessionInfo);
            if (sessionGroupInfos != null) {
                sessionInfo.updateSessionGroupInfos(sessionGroupInfos);
            }
            this.updateSessionInfo(authnBeans, sessionInfo);
            authnBeans.stream().filter(IdpHashableAuthnBean::isValidForSso).forEach(bean -> this.removeSessionTombstone(sri, bean.getSerializedHash()));
            int partnerSessionCount = 0;
            if (session != null) {
                BeanAndSessions beanAndSessions = sessionInfo.getBeansAndSessions().get(firstBean.getSerializedHash());
                Set<Session> assertionList = beanAndSessions.getSessions();
                assertionList.add(session);
                if (assertionList.size() > this.maxPartnerSessionsPerSession) {
                    Iterator<Session> iterator = assertionList.iterator();
                    this.cleanupSession(iterator.next());
                    iterator.remove();
                }
                partnerSessionCount = assertionList.size();
                this.checkRegisterInAssertionIdMap(sessionInfo, firstBean, session);
            }
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("registerBeansAndSession: oldExtendedSessionId=").append(this.sessionIdUtil.hashIdForLog(oldExtendedSessionId));
                sb.append(", newExtendedSessionId=").append(this.sessionIdUtil.hashIdForLog(newExtendedSessionId));
                sb.append(", authnBeans=").append(StringUtils.join((Collection)authnBeans.stream().map(SerialHashable::getSerializedHash).collect(Collectors.toList()), (String)","));
                sb.append(". Session now has ").append(sessionInfo.getBeansAndSessions().size()).append(" beans associated with it.");
                if (session != null) {
                    sb.append(" Bean now has " + partnerSessionCount + " partner sessions associated with it.");
                }
                log.debug((Object)sb);
                log.debug((Object)("registerBeansAndSession: new registry state=" + this.toString()));
            }
            if (log.isDebugEnabled() && CollectionUtils.isNotEmpty(sessionInfo.getUniqueUserKeys())) {
                log.debug((Object)("registerBeansAndSession: Unique user keys associated with session=" + sessionInfo.getUniqueUserKeys().stream().map(key -> "'" + key + "'").collect(Collectors.joining(", "))));
            }
        }
        ExtendedSessionIdManager.getInstance().notifyExtendedSessionIdUpdated(this, oldExtendedSessionId, newExtendedSessionId);
    }

    private void updateSessionInfo(Set<IdpHashableAuthnBean> authnBeans, IdpSessionInfo sessionInfo) {
        for (IdpHashableAuthnBean authnBean : authnBeans) {
            BeanAndSessions beanAndSessions;
            if (authnBean.getStoredSessionGroupId() != null) {
                sessionInfo.setPersistentSessionGroupId(authnBean.getStoredSessionGroupId());
            }
            if ((beanAndSessions = sessionInfo.getBeansAndSessions().get(authnBean.getSerializedHash())) == null) {
                beanAndSessions = new BeanAndSessions(authnBean);
                sessionInfo.getBeansAndSessions().put(authnBean.getSerializedHash(), beanAndSessions);
            } else {
                IdpHashableAuthnBean existing = beanAndSessions.getBean();
                if (existing.isDoLogout()) {
                    authnBean.setDoLogout(true);
                }
                beanAndSessions.setBean(authnBean);
            }
            if (sessionInfo.getBeansAndSessions().size() > this.maxSessionsPerSessionId) {
                BeanAndSessions toRemove = sessionInfo.getBeansAndSessions().values().iterator().next();
                this.unregisterAuthnBean(toRemove.getBean());
            }
            this.checkRegisterInNameIdMap(sessionInfo, authnBean);
        }
    }

    @Override
    public synchronized void onExtendedSessionIdUpdated(ExtendedSessionIdListener sender, String oldId, String newId) {
        IdpSessionInfo info;
        if (sender.equals(this)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("onExtendedSessionIdUpdated: oldId=" + this.sessionIdUtil.hashIdForLog(oldId) + ", newId=" + this.sessionIdUtil.hashIdForLog(newId)));
        }
        if ((info = (IdpSessionInfo)this.extendedSessionIdToInfoMap.remove(oldId)) != null) {
            info.setExtendedSessionId(newId);
            this.extendedSessionIdToInfoMap.put(newId, info);
        }
    }

    @Override
    public synchronized Map<IdpHashableAuthnBean, Collection<Session>> getIssuedSessions(Collection<IdpHashableAuthnBean> authnBeans) throws SessionRegistryException {
        LinkedHashMap<IdpHashableAuthnBean, Collection<Session>> result = new LinkedHashMap<IdpHashableAuthnBean, Collection<Session>>();
        for (IdpHashableAuthnBean bean : authnBeans) {
            result.put(bean, this.getIssuedSessions(bean));
        }
        return result;
    }

    @Override
    public synchronized SessionInfoForPartnerSessionsResult getSessionInfoForPartnerSessions(String partnerEntityId, NameIDType nameId, Collection<String> sessionIndices) {
        HashSet<String> primarySessionIds = new HashSet<String>();
        HashSet<String> storedSessionGroupIds = new HashSet<String>();
        HashSet<IdpHashableAuthnBean> beans = new HashSet<IdpHashableAuthnBean>();
        NameIdHashKey hashKey = new NameIdHashKey(partnerEntityId, nameId);
        Set<SessionInfoAndBeanHash> sessionInfoAndBeanHashes = this.nameIdToSessionInfosMap.get(hashKey);
        if (sessionInfoAndBeanHashes != null) {
            for (SessionInfoAndBeanHash sessionInfoAndBeanHash : sessionInfoAndBeanHashes) {
                IdpHashableAuthnBean bean;
                BeanAndSessions beanAndSessions = this.getBeanAndSessions(sessionInfoAndBeanHash);
                if (beanAndSessions == null || !((bean = beanAndSessions.getBean()) instanceof IdpConnHashableAuthnBean)) continue;
                IdpConnHashableAuthnBean idpConnBean = (IdpConnHashableAuthnBean)bean;
                if (sessionIndices != null && !sessionIndices.isEmpty() && !sessionIndices.contains(idpConnBean.getSessionIndex())) continue;
                primarySessionIds.add(idpConnBean.getPrimarySessionId());
                if (idpConnBean.getStoredSessionGroupId() != null) {
                    storedSessionGroupIds.add(idpConnBean.getStoredSessionGroupId());
                }
                beans.addAll(this.getBeans(sessionInfoAndBeanHash.getSessionInfo()));
            }
        }
        return new SessionInfoForPartnerSessionsResult(primarySessionIds, storedSessionGroupIds, beans);
    }

    private void checkRegisterInAssertionIdMap(IdpSessionInfo sessionInfo, IdpHashableAuthnBean bean, Session session) {
        if (session.isWebSsoSession()) {
            this.assertionIdToSessionInfoMap.put(session.getWebSsoSession().getAssertionId(), new SessionInfoAndBeanHash(sessionInfo, bean.getSerializedHash()));
        }
    }

    private void checkRegisterInNameIdMap(IdpSessionInfo sessionInfo, IdpHashableAuthnBean bean) {
        IdpConnection idpConn;
        IdpConnHashableAuthnBean idpConnBean;
        if (bean instanceof IdpConnHashableAuthnBean && (idpConnBean = (IdpConnHashableAuthnBean)bean).getEntityId() != null && idpConnBean.getNameId() != null && (idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnection(idpConnBean.getEntityId(), false)) != null && idpConn.getProtocol().equals(Protocol.SAML20)) {
            NameIdHashKey hashKey = new NameIdHashKey(idpConnBean.getEntityId(), idpConnBean.getNameId());
            Set<SessionInfoAndBeanHash> infos = this.nameIdToSessionInfosMap.get(hashKey);
            if (infos == null) {
                infos = new HashSet<SessionInfoAndBeanHash>();
                this.nameIdToSessionInfosMap.put(hashKey, infos);
            }
            infos.add(new SessionInfoAndBeanHash(sessionInfo, bean.getSerializedHash()));
        }
    }

    private void checkRemoveFromNameIdMap(IdpSessionInfo sessionInfo, IdpHashableAuthnBean bean) {
        NameIdHashKey hashKey;
        Set<SessionInfoAndBeanHash> infos;
        IdpConnHashableAuthnBean idpConnBean;
        if (bean instanceof IdpConnHashableAuthnBean && (idpConnBean = (IdpConnHashableAuthnBean)bean).getEntityId() != null && idpConnBean.getNameId() != null && (infos = this.nameIdToSessionInfosMap.get(hashKey = new NameIdHashKey(idpConnBean.getEntityId(), idpConnBean.getNameId()))) != null) {
            infos.remove(new SessionInfoAndBeanHash(sessionInfo, bean.getSerializedHash()));
            if (infos.isEmpty()) {
                this.nameIdToSessionInfosMap.remove(hashKey);
            }
        }
    }

    private synchronized Collection<Session> getIssuedSessions(IdpHashableAuthnBean authnBean) {
        LinkedHashSet<Session> sessionList = new LinkedHashSet<Session>();
        BeanAndSessions beanAndSessions = this.getBeanAndSessions(authnBean);
        if (beanAndSessions != null) {
            sessionList = new LinkedHashSet<Session>(beanAndSessions.getSessions());
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("getIssuedSessions for authnbean ").append(authnBean).append(" sessions: ");
            ArrayList<String> sessionStrs = new ArrayList<String>();
            for (Session s : sessionList) {
                sessionStrs.add(s.toShortString());
            }
            sb.append(sessionStrs);
            log.debug((Object)sb);
        }
        return sessionList;
    }

    synchronized Session getSession(String assertionId) {
        BeanAndSessions beanAndSessions;
        Session session = null;
        SessionInfoAndBeanHash sessionAndBean = this.assertionIdToSessionInfoMap.get(assertionId);
        if (sessionAndBean != null && (beanAndSessions = this.getBeanAndSessions(sessionAndBean)) != null) {
            for (Session tmpsession : beanAndSessions.getSessions()) {
                if (!tmpsession.isWebSsoSession() || !assertionId.equals(tmpsession.getWebSsoSession().getAssertionId())) continue;
                session = tmpsession;
                break;
            }
        }
        return session;
    }

    @Override
    public synchronized IdpHashableAuthnBean setBeanInvalidForSso(String extendedSriStr, String authnBeanSerializedHash) throws SessionRegistryException {
        BeanAndSessions beanAndSessions;
        if (log.isDebugEnabled()) {
            log.debug((Object)("setBeanInvalidForSso called for authnBean SRI='" + extendedSriStr + "' and serialized hash ID = '" + authnBeanSerializedHash + "'"));
        }
        ExtendedSri extendedSri = this.getExtendedSri(extendedSriStr, "Invalid SRI provided");
        this.addSessionTombstone(extendedSri.getSri(), authnBeanSerializedHash);
        IdpSessionInfo sessionInfo = this.sriToSessionInfoMap.get(extendedSri.getSri());
        if (sessionInfo != null && (beanAndSessions = sessionInfo.beansAndSessions.get(authnBeanSerializedHash)) != null && beanAndSessions.getBean() != null) {
            beanAndSessions.getBean().setValidForSso(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("setBeanInvalidForSso successful for authnBean SRI='" + extendedSri + "' and serialized hash ID = '" + authnBeanSerializedHash + "'"));
            }
            return beanAndSessions.getBean();
        }
        return null;
    }

    @Override
    public synchronized void unregisterSessions(IdpHashableAuthnBean authnBean, Collection<? extends Session> sessions) throws SessionRegistryException {
        for (Session session : sessions) {
            this.unregisterSession(authnBean, session);
        }
    }

    @Override
    public synchronized void unregisterSessions(Collection<String> assertionIds) throws SessionRegistryException {
        for (String assertionId : assertionIds) {
            this.unregisterSession(assertionId);
        }
    }

    synchronized Session unregisterSession(String assertionId) {
        BeanAndSessions beanAndSessions;
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("unregisterSession: ");
            sb.append(assertionId);
            log.debug((Object)sb);
        }
        Session session = null;
        SessionInfoAndBeanHash sessionInfoAndBean = this.assertionIdToSessionInfoMap.remove(assertionId);
        if (sessionInfoAndBean != null && (beanAndSessions = this.getBeanAndSessions(sessionInfoAndBean)) != null) {
            Iterator<Session> i = beanAndSessions.getSessions().iterator();
            while (i.hasNext()) {
                Session tempSession = i.next();
                if (!tempSession.isWebSsoSession() || !assertionId.equals(tempSession.getWebSsoSession().getAssertionId())) continue;
                session = tempSession;
                i.remove();
                break;
            }
            if (beanAndSessions.getSessions().isEmpty() && !beanAndSessions.getBean().isValidForSso() && !beanAndSessions.getBean().isDoLogout()) {
                this.unregisterAuthnBean(beanAndSessions.getBean());
            }
        }
        return session;
    }

    synchronized void unregisterSession(IdpHashableAuthnBean hashableAuthnBean, Session session) {
        BeanAndSessions beanAndSessions;
        if (session.isWebSsoSession()) {
            this.unregisterSession(session.getWebSsoSession().getAssertionId());
            return;
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("unregisterSession: ");
            sb.append(session.toShortString());
            log.debug((Object)sb);
        }
        if ((beanAndSessions = this.getBeanAndSessions(hashableAuthnBean)) == null) {
            return;
        }
        beanAndSessions.getSessions().remove(session);
        if (beanAndSessions.getSessions().isEmpty() && !beanAndSessions.getBean().isValidForSso() && !beanAndSessions.getBean().isDoLogout()) {
            this.unregisterAuthnBean(beanAndSessions.getBean());
        }
    }

    @Override
    public synchronized Map<IdpHashableAuthnBean, Collection<Session>> getRegisteredByAssertionIds(Collection<String> assertionIds) {
        Map<IdpHashableAuthnBean, Collection<Session>> registered = new HashMap<IdpHashableAuthnBean, Collection<Session>>();
        HashSet extendedSessionIds = new HashSet();
        for (String assertionId : assertionIds) {
            Optional.ofNullable(this.assertionIdToSessionInfoMap.get(assertionId)).map(SessionInfoAndBeanHash::getSessionInfo).map(IdpSessionInfo::getExtendedSessionId).ifPresent(extendedSessionIds::add);
        }
        for (String extendedSessionId : extendedSessionIds) {
            Map<IdpHashableAuthnBean, Collection<Session>> registeredForLocalSession = this.getRegistered(extendedSessionId);
            registered = this.combine(registered, registeredForLocalSession);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getRegisteredByAssertionIds for assertionIds " + assertionIds + " : " + registered));
        }
        return registered;
    }

    @Override
    public synchronized void setBeansInvalidForSso(Collection<String> primaryIds) {
        if (log.isDebugEnabled()) {
            ArrayList idsForLog = new ArrayList();
            if (primaryIds != null) {
                primaryIds.stream().forEach(primaryId -> idsForLog.add(this.sessionIdUtil.hashIdForLog((String)primaryId)));
            }
            log.debug((Object)("Flagging beans for primary session ID's " + primaryIds + " as invalid for SSO"));
        }
        HashSet<IdpHashableAuthnBean> beans = new HashSet<IdpHashableAuthnBean>();
        if (primaryIds != null) {
            for (String primaryId2 : primaryIds) {
                Collection<IdpHashableAuthnBean> sessionBeans = this.getBeansByPrimarySessionId(primaryId2);
                if (sessionBeans == null) continue;
                beans.addAll(sessionBeans);
            }
        }
        for (IdpHashableAuthnBean bean : beans) {
            bean.setValidForSso(false);
        }
    }

    @Override
    public synchronized void setBeansInvalidForLogout(Collection<IdpHashableAuthnBean> beans) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("setBeansInvalidForLogout: authnBeans ");
            sb.append(StringUtils.join((Collection)beans.stream().map(SerialHashable::getSerializedHash).collect(Collectors.toList()), (String)","));
            log.debug((Object)sb.toString());
        }
        for (IdpHashableAuthnBean bean : beans) {
            bean.setDoLogout(false);
            BeanAndSessions existing = this.getBeanAndSessions(bean);
            if (existing == null) continue;
            existing.getBean().setDoLogout(false);
            if (existing.getBean().isValidForSso() || !existing.getSessions().isEmpty()) continue;
            this.unregisterAuthnBean(existing.getBean());
        }
    }

    protected long getCurrentTimeMillis() {
        return this.clock.millis();
    }

    protected int getExpiryPeriodMins() {
        return this.expiryPeriodMins;
    }

    private boolean isStoredSessionGroupRevoked(IdpHashableAuthnBean bean) {
        return bean.getStoredSessionGroupId() != null && StateMgmtFactory.getSessionRevocationService().getRevokedSriInfoLocal(bean.getStoredSessionGroupId()) != null;
    }

    private void cleanupSession(Session session) {
        if (session.isWebSsoSession()) {
            this.assertionIdToSessionInfoMap.remove(session.getWebSsoSession().getAssertionId());
        }
    }

    private Map<IdpHashableAuthnBean, Collection<Session>> combine(Map<IdpHashableAuthnBean, Collection<Session>> first, Map<IdpHashableAuthnBean, Collection<Session>> second) {
        HashMap<IdpHashableAuthnBean, Collection<Session>> returnMap = new HashMap<IdpHashableAuthnBean, Collection<Session>>();
        HashSet<IdpHashableAuthnBean> beans = new HashSet<IdpHashableAuthnBean>();
        beans.addAll(first.keySet());
        beans.addAll(second.keySet());
        for (IdpHashableAuthnBean bean : beans) {
            Collection<Session> secondSessionCollection;
            HashSet<Session> sessions = new HashSet<Session>();
            Collection<Session> firstSessionCollection = first.get(bean);
            if (firstSessionCollection != null) {
                sessions.addAll(firstSessionCollection);
            }
            if ((secondSessionCollection = second.get(bean)) != null) {
                sessions.addAll(secondSessionCollection);
            }
            returnMap.put(bean, sessions);
        }
        return returnMap;
    }

    private Set<IdpHashableAuthnBean> getBeans(IdpSessionInfo info) {
        if (info == null) {
            return null;
        }
        return info.getBeansAndSessions().values().stream().map(BeanAndSessions::getBean).collect(Collectors.toSet());
    }

    private Collection<IdpHashableAuthnBean> getBeansByPrimarySessionId(String primaryId) {
        return this.getBeans(this.sriToSessionInfoMap.get(this.sessionIdUtil.getSriFromPrimaryValue(primaryId)));
    }

    private Collection<BeanAndSessions> getBeansAndSessions(String extendedSessionId) {
        IdpSessionInfo info = (IdpSessionInfo)this.extendedSessionIdToInfoMap.get(extendedSessionId);
        if (info == null) {
            return null;
        }
        return info.getBeansAndSessions().values();
    }

    private BeanAndSessions getBeanAndSessions(SessionInfoAndBeanHash infoAndHash) {
        if (infoAndHash == null) {
            return null;
        }
        return infoAndHash.getSessionInfo().getBeansAndSessions().get(infoAndHash.getBeanHash());
    }

    private BeanAndSessions getBeanAndSessions(IdpHashableAuthnBean authnBean) {
        IdpSessionInfo sessionInfo = this.getSessionInfo(authnBean);
        if (sessionInfo == null) {
            return null;
        }
        return sessionInfo.getBeansAndSessions().get(authnBean.getSerializedHash());
    }

    private IdpSessionInfo getSessionInfo(IdpHashableAuthnBean bean) {
        if (bean == null) {
            return null;
        }
        String sri = this.sessionIdUtil.getSriFromPrimaryValue(bean.getPrimarySessionId());
        return this.sriToSessionInfoMap.get(sri);
    }

    @Override
    public synchronized void setState(StateAccepter other) {
        this.setState((IdpSessionRegistryMapImpl)other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setState(IdpSessionRegistryMapImpl fromother) {
        IdpSessionRegistryMapImpl idpSessionRegistryMapImpl = fromother;
        synchronized (idpSessionRegistryMapImpl) {
            this.assertionIdToSessionInfoMap = fromother.assertionIdToSessionInfoMap;
            this.sriToSessionInfoMap = fromother.sriToSessionInfoMap;
            this.uniqueUserKeyToSrisMap = fromother.uniqueUserKeyToSrisMap;
            this.extendedSessionIdToInfoMap = fromother.extendedSessionIdToInfoMap;
            this.nameIdToSessionInfosMap = fromother.nameIdToSessionInfosMap;
        }
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("setState called: ");
            sb.append(fromother);
            log.debug((Object)sb);
        }
    }

    @Override
    public synchronized PreferredNodeGroup getPreferredNodeGroup() {
        return null;
    }

    @Override
    public synchronized int getSessionInfoMapSize() {
        return this.extendedSessionIdToInfoMap.size();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("{extendedSessionId->info=").append(this.extendedSessionIdToInfoMap.size());
        sb.append(", sri->info=").append(this.sriToSessionInfoMap.size());
        sb.append(", uniqueUserKey->sris=").append(this.uniqueUserKeyToSrisMap.size());
        sb.append(", assertionId->info=").append(this.assertionIdToSessionInfoMap.size());
        sb.append(", nameId->infos=").append(this.nameIdToSessionInfosMap.size());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public synchronized StateServiceId getServiceId() {
        return StateServiceId.IDP_SESSION_REGISTRY;
    }

    @Override
    public synchronized void importRecords(Collection<SessionInfoAndTimestamp> records) {
        for (SessionInfoAndTimestamp record : records) {
            IdpSessionInfo toImport = record.getIdpSessionInfo();
            IdpSessionInfo existing = (IdpSessionInfo)this.extendedSessionIdToInfoMap.get(toImport.getExtendedSessionId());
            if (existing != null) {
                this.unregisterIdpSessionInfo(existing);
            }
            if (!this.extendedSessionIdToInfoMap.tryPutWithTimestamp(toImport.getExtendedSessionId(), toImport, record.getTimestamp())) continue;
            this.sriToSessionInfoMap.put(toImport.getSri(), toImport);
            for (BeanAndSessions beanAndSessions : toImport.getBeansAndSessions().values()) {
                if (this.sessionTombstoneExists(toImport.getSri(), beanAndSessions.getBean().getSerializedHash())) {
                    beanAndSessions.getBean().setValidForSso(false);
                }
                this.checkRegisterInNameIdMap(toImport, beanAndSessions.getBean());
                for (Session session : beanAndSessions.getSessions()) {
                    this.checkRegisterInAssertionIdMap(toImport, beanAndSessions.getBean(), session);
                }
            }
        }
    }

    @Override
    public synchronized Collection<SessionInfoAndTimestamp> getRecords(int startHash, int endHashExclusive) {
        ArrayList<SessionInfoAndTimestamp> result = new ArrayList<SessionInfoAndTimestamp>();
        Collection rangeEntries = this.extendedSessionIdToInfoMap.getEntriesForRange(startHash, endHashExclusive);
        for (Cache.Entry rangeEntry : rangeEntries) {
            IdpSessionInfo idpSessionInfo = (IdpSessionInfo)rangeEntry.getValue();
            if (idpSessionInfo == null) continue;
            result.add(new SessionInfoAndTimestamp(new IdpSessionInfo(idpSessionInfo), rangeEntry.getTimestamp()));
        }
        return result;
    }

    @Override
    public synchronized void purgeRecords(int startHash, int endHashExclusive) {
        Collection<String> extendedSessionIds = this.extendedSessionIdToInfoMap.getKeysForRange(startHash, endHashExclusive);
        for (String extendedSessionId : extendedSessionIds) {
            IdpSessionInfo idpSessionInfo = (IdpSessionInfo)this.extendedSessionIdToInfoMap.get(extendedSessionId);
            if (idpSessionInfo == null) continue;
            this.unregisterIdpSessionInfo(idpSessionInfo);
        }
    }

    private void addSessionTombstone(String sri, String beanHash) {
        SessionTombstoneInfo info = this.sriToSessionTombstoneInfoMap.get(sri);
        if (info == null) {
            info = new SessionTombstoneInfo();
            this.sriToSessionTombstoneInfoMap.put(sri, info);
        }
        info.addTombstone(beanHash, this.clock.millis(), Duration.ofMinutes(this.tombstoneRetentionMins).toMillis());
    }

    private void removeSessionTombstone(String sri, String beanHash) {
        SessionTombstoneInfo info = this.sriToSessionTombstoneInfoMap.get(sri);
        if (info == null) {
            return;
        }
        info.removeTombstone(beanHash);
        if (info.isEmpty()) {
            this.sriToSessionTombstoneInfoMap.remove(sri);
        }
    }

    private boolean sessionTombstoneExists(String sri, String beanHash) {
        SessionTombstoneInfo info = this.sriToSessionTombstoneInfoMap.get(sri);
        if (info == null) {
            return false;
        }
        return info.hasTombstone(beanHash);
    }

    @Override
    public synchronized Collection<String> registerSriToUniqueUserKey(String uniqueUserKey, String extendedSri) {
        LinkedHashMap<String, SriAndTimestamp> sris = (LinkedHashMap<String, SriAndTimestamp>)this.uniqueUserKeyToSrisMap.get(uniqueUserKey);
        if (sris == null) {
            sris = new LinkedHashMap<String, SriAndTimestamp>();
            this.uniqueUserKeyToSrisMap.put(uniqueUserKey, sris);
        } else {
            this.removeExpiredUserKeySris(sris);
            sris.remove(extendedSri);
        }
        sris.put(extendedSri, new SriAndTimestamp(extendedSri, this.getCurrentTimeMillis()));
        ArrayList<String> srisToPurge = new ArrayList<String>();
        Iterator iterator = sris.keySet().iterator();
        for (int toPurgeCount = Math.max(0, sris.size() - this.maxSrisPerUserKey); toPurgeCount > 0 && iterator.hasNext(); --toPurgeCount) {
            srisToPurge.add((String)iterator.next());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("registerSriToUniqueUserKey: unique user key='" + uniqueUserKey + "' associated to SRI='" + extendedSri + "', SRI count=" + sris.size() + ", SRIs to purge=" + srisToPurge.size()));
            log.debug((Object)("registerSriToUniqueUserKey: new registry state=" + this.toString()));
        }
        return srisToPurge;
    }

    @Override
    public synchronized void unregisterSriFromUniqueUserKey(String uniqueUserKey, String extendedSri) {
        LinkedHashMap sris = (LinkedHashMap)this.uniqueUserKeyToSrisMap.get(uniqueUserKey);
        if (sris != null) {
            sris.remove(extendedSri);
            if (sris.isEmpty()) {
                this.uniqueUserKeyToSrisMap.remove(uniqueUserKey);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("unregisterSriFromUniqueUserKey: unique user key='" + uniqueUserKey + "', SRI='" + extendedSri + "'"));
            log.debug((Object)("unregisterSriFromUniqueUserKey: new registry state=" + this.toString()));
        }
    }

    @Override
    public synchronized Collection<String> getSrisForUniqueUserKey(String uniqueUserKey) {
        LinkedHashMap sris = (LinkedHashMap)this.uniqueUserKeyToSrisMap.get(uniqueUserKey);
        if (sris == null) {
            return new ArrayList<String>();
        }
        this.removeExpiredUserKeySris(sris);
        if (sris.isEmpty()) {
            this.uniqueUserKeyToSrisMap.remove(uniqueUserKey);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSrisForUniqueUserKey: unique user key='" + uniqueUserKey + "', SRIs=" + sris.keySet()));
        }
        return new ArrayList<String>(sris.keySet());
    }

    private void removeExpiredUserKeySris(LinkedHashMap<String, SriAndTimestamp> sris) {
        SriAndTimestamp entry;
        long cutoff = this.getCurrentTimeMillis() - TimeUnit.MINUTES.toMillis(this.userKeyExpiryPeriodMins);
        Iterator<SriAndTimestamp> iterator = sris.values().iterator();
        while (iterator.hasNext() && (entry = iterator.next()).getActivityTimeMillis() < cutoff) {
            iterator.remove();
        }
    }

    @Override
    public synchronized void updateSessionContextInfo(String extendedSessionId, AuthnSessionContextData sessionContextData) {
        IdpSessionInfo info = (IdpSessionInfo)this.extendedSessionIdToInfoMap.get(extendedSessionId);
        if (info != null) {
            info.setSessionContextData(sessionContextData);
            if (log.isDebugEnabled()) {
                log.debug((Object)("updateSessionContextInfo(extendedSessionId=" + this.sessionIdUtil.hashIdForLog(extendedSessionId) + ") - updated context information."));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("updateSessionContextInfo(extendedSessionId=" + this.sessionIdUtil.hashIdForLog(extendedSessionId) + ") - session was not found in local cache."));
        }
    }

    static class UniqueUserKeyToSris
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String uniqueUserKey;
        private LinkedHashMap<String, SriAndTimestamp> sris;
        private long timestamp;

        public UniqueUserKeyToSris(String uniqueUserKey, LinkedHashMap<String, SriAndTimestamp> sris, long timestamp) {
            this.uniqueUserKey = uniqueUserKey;
            this.sris = sris;
            this.timestamp = timestamp;
        }

        public String getUniqueUserKey() {
            return this.uniqueUserKey;
        }

        public LinkedHashMap<String, SriAndTimestamp> getSris() {
            return this.sris;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    static class SessionInfoAndTimestamp
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private IdpSessionInfo idpSessionInfo;
        private long timestamp;

        public SessionInfoAndTimestamp(IdpSessionInfo idpSessionInfo, long timestamp) {
            this.idpSessionInfo = idpSessionInfo;
            this.timestamp = timestamp;
        }

        public IdpSessionInfo getIdpSessionInfo() {
            return this.idpSessionInfo;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    class ExtendedSessionIdToInfoMap
    extends DistributableCache<IdpSessionInfo> {
        private static final long serialVersionUID = 1L;
        private CachePurgeBeforeExpiryTracker purgeBeforeExpiryTracker;

        public ExtendedSessionIdToInfoMap(long expiryPeriodMillis, int maxSize, float purgeLogIntervalMins, ConsistentHashTracker tracker) {
            super(expiryPeriodMillis, maxSize, true, tracker, IdpSessionRegistryMapImpl.this.sessionIdUtil::getSriFromExtendedId);
            String remedyMessage = "Consider increasing IdpSessionRegistryMapImpl.max.sessions or decreasing IdpSessionRegistryMapImpl.expiry.mins in size-limits.conf. Increasing the size of the map will increase PingFederate heap usage. Decreasing the expiry period will reduce the maximum idle timeout for authentication sessions and logout data.";
            this.purgeBeforeExpiryTracker = new CachePurgeBeforeExpiryTracker(expiryPeriodMillis, "IdP Session Registry", remedyMessage, purgeLogIntervalMins, "idp.session.registry.session.map.purge.unexpired");
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        protected void onEntryPurged(String extendedSessionId, IdpSessionInfo info, boolean expired, long timestamp) {
            IdpSessionRegistryMapImpl.this.unregisterIdpSessionInfo(info);
            this.purgeBeforeExpiryTracker.checkLogEntriesPurgedBeforeExpiry();
            if (!expired) {
                this.purgeBeforeExpiryTracker.trackEntryPurgedBeforeExpiry(timestamp);
            }
        }
    }

    static class UniqueUserKeyToSriMap
    extends DistributableCache<LinkedHashMap<String, SriAndTimestamp>> {
        private static final long serialVersionUID = 1L;
        private transient CachePurgeBeforeExpiryTracker purgeBeforeExpiryTracker;

        public UniqueUserKeyToSriMap(long expiryPeriodMillis, int maxSize, float purgeLogIntervalMins, ConsistentHashTracker tracker) {
            super(expiryPeriodMillis, maxSize, true, tracker);
            String remedyMessage = "You should increase IdpSessionRegistryMapImpl.max.user.keys in size-limits.conf. Increasing the size of the map will increase PingFederate heap usage but this map is relatively lightweight.";
            this.purgeBeforeExpiryTracker = new CachePurgeBeforeExpiryTracker(expiryPeriodMillis, "User Key to SRI Mapping", remedyMessage, purgeLogIntervalMins);
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        protected void onEntryPurged(String uniqueUserKey, LinkedHashMap<String, SriAndTimestamp> sris, boolean expired, long timestamp) {
            this.purgeBeforeExpiryTracker.checkLogEntriesPurgedBeforeExpiry();
            if (!expired) {
                this.purgeBeforeExpiryTracker.trackEntryPurgedBeforeExpiry(timestamp);
            }
        }
    }

    class UniqueUserKeyToSrisRegistry
    implements StateService<UniqueUserKeyToSris> {
        UniqueUserKeyToSrisRegistry() {
        }

        @Override
        public StateServiceId getServiceId() {
            return StateServiceId.UNIQUE_USER_KEY_TO_SRIS_REGISTRY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void importRecords(Collection<UniqueUserKeyToSris> records) {
            IdpSessionRegistryMapImpl idpSessionRegistryMapImpl = IdpSessionRegistryMapImpl.this;
            synchronized (idpSessionRegistryMapImpl) {
                for (UniqueUserKeyToSris record : records) {
                    LinkedHashMap existingSris = (LinkedHashMap)IdpSessionRegistryMapImpl.this.uniqueUserKeyToSrisMap.get(record.getUniqueUserKey());
                    if (existingSris != null) {
                        UniqueUserKeyToSris existing = new UniqueUserKeyToSris(record.getUniqueUserKey(), existingSris, IdpSessionRegistryMapImpl.this.uniqueUserKeyToSrisMap.getTimestampForKey(record.getUniqueUserKey()));
                        record = this.mergeRecords(record, existing);
                    }
                    IdpSessionRegistryMapImpl.this.uniqueUserKeyToSrisMap.tryPutWithTimestamp(record.getUniqueUserKey(), record.getSris(), record.getTimestamp());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<UniqueUserKeyToSris> getRecords(int startHash, int endHashExclusive) {
            IdpSessionRegistryMapImpl idpSessionRegistryMapImpl = IdpSessionRegistryMapImpl.this;
            synchronized (idpSessionRegistryMapImpl) {
                ArrayList<UniqueUserKeyToSris> result = new ArrayList<UniqueUserKeyToSris>();
                Collection rangeEntries = IdpSessionRegistryMapImpl.this.uniqueUserKeyToSrisMap.getEntriesForRange(startHash, endHashExclusive);
                for (Cache.Entry rangeEntry : rangeEntries) {
                    String uniqueUserKey = rangeEntry.getKey();
                    LinkedHashMap sris = (LinkedHashMap)rangeEntry.getValue();
                    if (Util.isEmpty(sris) || uniqueUserKey == null) continue;
                    result.add(new UniqueUserKeyToSris(uniqueUserKey, sris, rangeEntry.getTimestamp()));
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void purgeRecords(int startHash, int endHashExclusive) {
            IdpSessionRegistryMapImpl idpSessionRegistryMapImpl = IdpSessionRegistryMapImpl.this;
            synchronized (idpSessionRegistryMapImpl) {
                Collection<String> uniqueUserKeys = IdpSessionRegistryMapImpl.this.uniqueUserKeyToSrisMap.getKeysForRange(startHash, endHashExclusive);
                for (String uniqueUserKey : uniqueUserKeys) {
                    IdpSessionRegistryMapImpl.this.uniqueUserKeyToSrisMap.remove(uniqueUserKey);
                }
            }
        }

        private UniqueUserKeyToSris mergeRecords(UniqueUserKeyToSris record1, UniqueUserKeyToSris record2) {
            String userKey = record1.getUniqueUserKey();
            long timestamp = Math.max(record1.getTimestamp(), record2.getTimestamp());
            LinkedHashMap<String, SriAndTimestamp> sris = new LinkedHashMap<String, SriAndTimestamp>();
            Iterator<SriAndTimestamp> iterator1 = record1.getSris().values().iterator();
            Iterator<SriAndTimestamp> iterator2 = record2.getSris().values().iterator();
            SriAndTimestamp sri1 = this.consume(iterator1);
            SriAndTimestamp sri2 = this.consume(iterator2);
            while (sri1 != null || sri2 != null) {
                boolean takeSri1 = false;
                if (sri1 != null) {
                    if (sri2 == null) {
                        takeSri1 = true;
                    } else {
                        boolean bl = takeSri1 = sri1.getActivityTimeMillis() < sri2.getActivityTimeMillis();
                    }
                }
                if (takeSri1) {
                    this.addSri(sris, sri1);
                    sri1 = this.consume(iterator1);
                    continue;
                }
                this.addSri(sris, sri2);
                sri2 = this.consume(iterator2);
            }
            return new UniqueUserKeyToSris(userKey, sris, timestamp);
        }

        private void addSri(LinkedHashMap<String, SriAndTimestamp> sris, SriAndTimestamp sri) {
            sris.remove(sri.getExtendedSri());
            sris.put(sri.getExtendedSri(), sri);
        }

        private SriAndTimestamp consume(Iterator<SriAndTimestamp> iterator) {
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }
    }

    static class SessionTombstoneInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, Long> tombstones = new LinkedHashMap<String, Long>();

        SessionTombstoneInfo() {
        }

        public boolean isEmpty() {
            return this.tombstones.isEmpty();
        }

        public boolean hasTombstone(String beanHash) {
            return this.tombstones.containsKey(beanHash);
        }

        public void addTombstone(String beanHash, long currentTimeMillis, long tombstoneRetentionMillis) {
            this.purgeExpiredTombstones(currentTimeMillis, tombstoneRetentionMillis);
            this.tombstones.put(beanHash, currentTimeMillis);
        }

        public void removeTombstone(String beanHash) {
            this.tombstones.remove(beanHash);
        }

        private void purgeExpiredTombstones(long currentTimeMillis, long tombstoneRetentionMillis) {
            long tombstoneCreationTimeMillis;
            Iterator<Long> tombstoneIterator = this.tombstones.values().iterator();
            while (tombstoneIterator.hasNext() && currentTimeMillis - (tombstoneCreationTimeMillis = tombstoneIterator.next().longValue()) > tombstoneRetentionMillis) {
                tombstoneIterator.remove();
            }
        }
    }

    static class IdpSessionInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String internalId;
        private String extendedSessionId;
        private String sri;
        private long lastActivityTimeMillis;
        private Map<String, BeanAndSessions> beansAndSessions = new LinkedHashMap<String, BeanAndSessions>();
        private long sessionSeriesId;
        private String persistentSessionGroupId;
        private Map<String, CachedSessionGroupInfo> sessionGroupInfos = new HashMap<String, CachedSessionGroupInfo>(1);
        private Set<String> uniqueUserKeys = new HashSet<String>(3);
        private AuthnSessionContextData sessionContextData;

        public IdpSessionInfo(String sessionId, String sri, long currentTimeMillis) {
            this.internalId = IDGenerator.rndAlphaNumeric((int)25);
            this.extendedSessionId = sessionId;
            this.sri = sri;
            this.lastActivityTimeMillis = currentTimeMillis;
        }

        public IdpSessionInfo(IdpSessionInfo copyFrom) {
            this.internalId = copyFrom.internalId;
            this.extendedSessionId = copyFrom.extendedSessionId;
            this.sri = copyFrom.sri;
            this.lastActivityTimeMillis = copyFrom.lastActivityTimeMillis;
            this.sessionSeriesId = copyFrom.sessionSeriesId;
            if (copyFrom.beansAndSessions != null) {
                for (Map.Entry<String, BeanAndSessions> entry : copyFrom.beansAndSessions.entrySet()) {
                    this.beansAndSessions.put(entry.getKey(), new BeanAndSessions(entry.getValue()));
                }
            }
            this.sessionGroupInfos.putAll(copyFrom.sessionGroupInfos);
            this.uniqueUserKeys.addAll(copyFrom.uniqueUserKeys);
            this.sessionContextData = AuthnSessionContextDataUtil.makeCopy(copyFrom.sessionContextData);
        }

        public String getExtendedSessionId() {
            return this.extendedSessionId;
        }

        public void setExtendedSessionId(String extendedSessionId) {
            this.extendedSessionId = extendedSessionId;
        }

        public long getLastActivityTimeMillis() {
            return this.lastActivityTimeMillis;
        }

        public void setLastActivityTimeMillis(long lastActivityTimeMillis) {
            this.lastActivityTimeMillis = lastActivityTimeMillis;
        }

        public Map<String, BeanAndSessions> getBeansAndSessions() {
            return this.beansAndSessions;
        }

        public String getSri() {
            return this.sri;
        }

        public String getEncodedSeriesId() {
            return ExtendedSri.encodeSeriesId(this.sessionSeriesId);
        }

        public long getSessionSeriesId() {
            return this.sessionSeriesId;
        }

        public void setSessionSeriesId(long sessionSeriesId) {
            this.sessionSeriesId = sessionSeriesId;
        }

        public String getPersistentSessionGroupId() {
            return this.persistentSessionGroupId;
        }

        public void setPersistentSessionGroupId(String persistentSessionGroupId) {
            this.persistentSessionGroupId = persistentSessionGroupId;
        }

        public CachedSessionGroupInfo getSessionGroupInfo(String sessionGroupId) {
            return this.sessionGroupInfos.get(sessionGroupId);
        }

        public void updateSessionGroupInfos(Collection<CachedSessionGroupInfo> updates) {
            for (CachedSessionGroupInfo update : updates) {
                if (update.isDeleted()) {
                    this.sessionGroupInfos.remove(update.getId());
                    continue;
                }
                this.sessionGroupInfos.put(update.getId(), update);
            }
        }

        public Set<String> getUniqueUserKeys() {
            return Collections.unmodifiableSet(this.uniqueUserKeys);
        }

        public boolean addUniqueUserKeys(Collection<String> uniqueUserKeys) {
            return this.uniqueUserKeys.addAll(uniqueUserKeys);
        }

        public boolean removeUniqueUserKeys(Collection<String> uniqueUserKeys) {
            return this.uniqueUserKeys.removeAll(uniqueUserKeys);
        }

        public AuthnSessionContextData getSessionContextData() {
            return this.sessionContextData;
        }

        public void setSessionContextData(AuthnSessionContextData sessionContextData) {
            this.sessionContextData = sessionContextData;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.internalId == null ? 0 : this.internalId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IdpSessionInfo other = (IdpSessionInfo)obj;
            return !(this.internalId == null ? other.internalId != null : !this.internalId.equals(other.internalId));
        }
    }

    static class SriAndTimestamp
    implements Serializable {
        private String extendedSri;
        private long activityTimeMillis;

        public SriAndTimestamp(String extendedSri, long activityTimeMillis) {
            this.extendedSri = extendedSri;
            this.activityTimeMillis = activityTimeMillis;
        }

        public String getExtendedSri() {
            return this.extendedSri;
        }

        public long getActivityTimeMillis() {
            return this.activityTimeMillis;
        }
    }

    static class BeanAndSessions
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private IdpHashableAuthnBean bean;
        private Set<Session> sessions;

        public BeanAndSessions() {
        }

        public BeanAndSessions(IdpHashableAuthnBean bean) {
            this.bean = bean;
        }

        public BeanAndSessions(BeanAndSessions copyFrom) {
            this.bean = copyFrom.bean;
            if (copyFrom.sessions != null) {
                this.sessions = new LinkedHashSet<Session>(copyFrom.sessions);
            }
        }

        public IdpHashableAuthnBean getBean() {
            return this.bean;
        }

        public void setBean(IdpHashableAuthnBean bean) {
            this.bean = bean;
        }

        public Set<Session> getSessions() {
            if (this.sessions == null) {
                this.sessions = new LinkedHashSet<Session>();
            }
            return this.sessions;
        }
    }

    static class SessionInfoAndBeanHash
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private IdpSessionInfo sessionInfo;
        private String beanHash;

        public SessionInfoAndBeanHash(IdpSessionInfo sessionInfo, String beanHash) {
            this.sessionInfo = sessionInfo;
            this.beanHash = beanHash;
        }

        public IdpSessionInfo getSessionInfo() {
            return this.sessionInfo;
        }

        public String getBeanHash() {
            return this.beanHash;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.beanHash == null ? 0 : this.beanHash.hashCode());
            result = 31 * result + (this.sessionInfo == null ? 0 : this.sessionInfo.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SessionInfoAndBeanHash other = (SessionInfoAndBeanHash)obj;
            if (this.beanHash == null ? other.beanHash != null : !this.beanHash.equals(other.beanHash)) {
                return false;
            }
            return !(this.sessionInfo == null ? other.sessionInfo != null : !this.sessionInfo.equals(other.sessionInfo));
        }
    }
}

