/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.localmemory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.RevokedSriInfo;
import org.sourceid.saml20.service.SessionRevocationService;
import org.sourceid.saml20.service.impl.grouprpc.SessionRevocationServiceGroupRpcImpl;
import org.sourceid.saml20.state.SizeLimitProps;

public class SessionRevocationServiceMapImpl
implements SessionRevocationService,
SessionRevocationServiceGroupRpcImpl.RpcTarget {
    private static final int MILLISECS_PER_MINUTE = 60000;
    private static final int MAX_REVOCATIONS_TO_PRUNE = 100;
    private static final Log log = LogFactory.getLog(SessionRevocationServiceMapImpl.class);
    private int maxRevokedSris;
    private final HashMap<String, Long> revokedSris = new HashMap(1024, 0.75f);
    private final TreeMap<Long, List<String>> expirationTimeToSris = new TreeMap();

    public SessionRevocationServiceMapImpl() {
        log.debug((Object)("Creating " + SessionRevocationServiceMapImpl.class));
        SizeLimitProps config = new SizeLimitProps();
        this.maxRevokedSris = config.getSessionRevocationMaxRevokedSris();
        log.debug((Object)("Max revoked SRIs: " + this.maxRevokedSris));
        log.debug((Object)("Effective session revocation lifetime: " + this.getSessionRevocationLifetimeMins() + " minutes"));
    }

    @Override
    public synchronized void addRevokedSri(String sri) {
        this.addRevokedSri(sri, this.getCurrentTimeMillis() + this.getSessionRevocationLifetimeMillis());
    }

    @Override
    public synchronized void addRevokedSri(String sri, long expirationTime) {
        this.pruneExpiredRevocations(this.getCurrentTimeMillis());
        this.addRevokedSri(new RevokedSriInfo(sri, expirationTime));
        if (log.isDebugEnabled()) {
            log.debug((Object)("SRI revoked: " + sri));
        }
    }

    @Override
    public synchronized RevokedSriInfo getRevokedSriInfo(String sri) {
        Long expirationTime = this.revokedSris.get(sri);
        if (expirationTime == null) {
            return null;
        }
        if (this.isExpired(expirationTime)) {
            this.removeRevokedSri(sri);
            return null;
        }
        return new RevokedSriInfo(sri, expirationTime);
    }

    @Override
    public synchronized RevokedSriInfo getRevokedSriInfoLocal(String sri) {
        return this.getRevokedSriInfo(sri);
    }

    @Override
    public synchronized List<RevokedSriInfo> getRevokedSriInfos() {
        this.pruneExpiredRevocations(this.getCurrentTimeMillis());
        ArrayList<RevokedSriInfo> result = new ArrayList<RevokedSriInfo>();
        for (Map.Entry<Long, List<String>> entry : this.expirationTimeToSris.entrySet()) {
            if (this.isExpired(entry.getKey())) continue;
            entry.getValue().forEach(sri -> result.add(new RevokedSriInfo((String)sri, (Long)entry.getKey())));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getRevokedSriInfos returning " + result.size() + " revoked SRI's"));
        }
        return result;
    }

    public synchronized void importRevokedSriInfos(List<RevokedSriInfo> infos) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Importing " + infos.size() + " revoked SRI's"));
        }
        this.pruneExpiredRevocations(this.getCurrentTimeMillis());
        infos.forEach(this::addRevokedSri);
    }

    public synchronized int getNumberOfRevokedSris() {
        return this.revokedSris.size();
    }

    protected int getMaxRevocationsToPrune() {
        return 100;
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected int getSessionRevocationLifetimeMins() {
        return MgmtFactory.getSessionSettingsManager().getSessionSettings().getEffectiveSessionRevocationLifetime();
    }

    protected int getMaxRevokedSris() {
        return this.maxRevokedSris;
    }

    protected void setMaxRevokedSris(int maxRevokedSris) {
        this.maxRevokedSris = maxRevokedSris;
    }

    private long getSessionRevocationLifetimeMillis() {
        return (long)this.getSessionRevocationLifetimeMins() * 60000L;
    }

    private void addRevokedSri(RevokedSriInfo info) {
        boolean add = true;
        Long existingExpirationTime = this.revokedSris.get(info.getSri());
        if (existingExpirationTime != null) {
            add = false;
            if (existingExpirationTime < info.getExpirationTime()) {
                this.removeRevokedSri(info.getSri());
                add = true;
            }
        }
        if (add) {
            this.revokedSris.put(info.getSri(), info.getExpirationTime());
            List<String> revokedSris = this.expirationTimeToSris.get(info.getExpirationTime());
            if (revokedSris != null) {
                revokedSris.add(info.getSri());
            } else {
                this.expirationTimeToSris.put(info.getExpirationTime(), new ArrayList<String>(Collections.singletonList(info.getSri())));
            }
            this.checkMapSizeAndRemove();
        }
    }

    private void checkMapSizeAndRemove() {
        if (this.revokedSris.size() > this.getMaxRevokedSris()) {
            Map.Entry<Long, List<String>> earliestExpiryEntry = this.expirationTimeToSris.firstEntry();
            if (!this.isExpired(earliestExpiryEntry.getKey())) {
                log.info((Object)("Pruning an SRI revocation that has not yet expired: '" + earliestExpiryEntry.getValue().get(0) + "', consider increasing SessionRevocationServiceMapImpl.max.revoked.sris in size-limits.conf or reducing Session Revocation Lifetime and/or JWT token lifetime."));
            }
            this.removeRevokedSri(earliestExpiryEntry.getValue().get(0));
        }
    }

    private void removeRevokedSri(String sri) {
        Long expirationTime = this.revokedSris.remove(sri);
        List<String> revokedSris = this.expirationTimeToSris.get(expirationTime);
        if (revokedSris.remove(sri) && revokedSris.isEmpty()) {
            this.expirationTimeToSris.remove(expirationTime);
        }
    }

    private void pruneExpiredRevocations(long currentTime) {
        Map.Entry<Long, List<String>> entry;
        List<String> srisToPrune;
        Iterator<Map.Entry<Long, List<String>>> iter = this.expirationTimeToSris.entrySet().iterator();
        for (int prunedRevocations = 0; iter.hasNext() && prunedRevocations < this.getMaxRevocationsToPrune() && (entry = iter.next()).getKey() < currentTime; prunedRevocations += srisToPrune.size()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Pruning expired revoked SRIs " + entry.getValue()));
            }
            srisToPrune = entry.getValue();
            srisToPrune.forEach(this.revokedSris::remove);
            iter.remove();
        }
    }

    private boolean isExpired(long expirationTime) {
        return expirationTime < this.getCurrentTimeMillis();
    }
}

