/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.impl.localmemory;

import com.pingidentity.common.util.Cache;
import com.pingidentity.common.util.CachePurgeBeforeExpiryTracker;
import com.pingidentity.common.util.DistributableCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.SpSessionRegistry;
import org.sourceid.saml20.service.StateService;
import org.sourceid.saml20.service.StateServiceId;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.state.ConsistentHashTracker;
import org.sourceid.saml20.state.SizeLimitProps;
import org.sourceid.saml20.state.StateAccepter;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.servlet.SessionIdUtil;

public class SpSessionRegistryMapImpl
implements SpSessionRegistry,
StateAccepter,
Serializable,
StateService<SessionRegistryEntry> {
    private static final long serialVersionUID = 1L;
    private static final transient Log log = LogFactory.getLog(SpSessionRegistryMapImpl.class);
    int maxSessionsPerSessionId;
    Map<SpHashableAuthnBean, WebSsoSession> beanToSessionMap;
    SessionIdToBeansSetMap sessionIdToBeansMap;
    private static final List<SpHashableAuthnBean> EMPTY_BEAN_LIST = Collections.emptyList();
    private SessionIdUtil sessionIdUtil = SessionIdUtil.getInstance();
    private SizeLimitProps sizeLimitProps = new SizeLimitProps();

    public SpSessionRegistryMapImpl() {
        int configMaxPfSessions = this.sizeLimitProps.getSpMaxSessions();
        int configMaxSessionsPerSessionId = this.sizeLimitProps.getSpMaxIndividualSessions();
        int configExpiryPeriodMins = this.sizeLimitProps.getSpExpiryMins();
        this.initialize(configMaxPfSessions, configMaxSessionsPerSessionId, configExpiryPeriodMins, StateMgmtFactory.makeConsistentHashTracker(false, true));
    }

    public SpSessionRegistryMapImpl(int maxPfSessions, int maxSessionsPerSessionId, int expiryPeriodMins, ConsistentHashTracker hashTracker) {
        this.initialize(maxPfSessions, maxSessionsPerSessionId, expiryPeriodMins, hashTracker);
    }

    private void initialize(int maxPfSessions, int maxSessionsPerSessionId, int expiryPeriodMins, ConsistentHashTracker hashTracker) {
        this.maxSessionsPerSessionId = maxSessionsPerSessionId;
        this.beanToSessionMap = new HashMap<SpHashableAuthnBean, WebSsoSession>();
        this.sessionIdToBeansMap = new SessionIdToBeansSetMap((long)expiryPeriodMins * 60L * 1000L, maxPfSessions, this.sizeLimitProps.getStatsLogIntervalMins(), hashTracker);
        log.debug((Object)("Max Sessions: " + maxPfSessions + " total with " + maxSessionsPerSessionId + " per"));
        StateMgmtFactory.getStateServiceRegistry().registerService(this);
    }

    @Override
    public synchronized void setState(StateAccepter other) {
        this.setState((SpSessionRegistryMapImpl)other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setState(SpSessionRegistryMapImpl other) {
        SpSessionRegistryMapImpl spSessionRegistryMapImpl = other;
        synchronized (spSessionRegistryMapImpl) {
            this.beanToSessionMap = other.beanToSessionMap;
            this.sessionIdToBeansMap = other.sessionIdToBeansMap;
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("setState called: ");
                sb.append(other);
                log.debug((Object)sb);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("{bean->session=").append(this.beanToSessionMap.size());
        sb.append(", pfsessionid->beanslist=").append(this.sessionIdToBeansMap.size());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public synchronized void registerSessionReceived(SpHashableAuthnBean authnBean, WebSsoSession session) {
        String localSessionId = authnBean.getPrimarySessionId();
        this.beanToSessionMap.put(authnBean, session);
        LinkedHashSet<SpHashableAuthnBean> hashableAuthnBeans = (LinkedHashSet<SpHashableAuthnBean>)this.sessionIdToBeansMap.get(localSessionId);
        if (hashableAuthnBeans == null) {
            hashableAuthnBeans = new LinkedHashSet<SpHashableAuthnBean>();
            this.sessionIdToBeansMap.put(localSessionId, hashableAuthnBeans);
        } else if (hashableAuthnBeans.size() >= this.maxSessionsPerSessionId) {
            SpHashableAuthnBean toBeRemoved = (SpHashableAuthnBean)hashableAuthnBeans.iterator().next();
            this.unregisterSessionReceived(toBeRemoved);
        }
        hashableAuthnBeans.add(authnBean);
        if (log.isDebugEnabled()) {
            log.debug((Object)("registerSessionReceived: new registry state=" + this.toString()));
        }
    }

    @Override
    public synchronized Map<SpHashableAuthnBean, WebSsoSession> lookupAuthnBeansAndSessions(String sessionIdentifier) {
        Set hashableAuthnBeans = (Set)this.sessionIdToBeansMap.get(sessionIdentifier);
        if (hashableAuthnBeans != null) {
            HashMap<SpHashableAuthnBean, WebSsoSession> group = new HashMap<SpHashableAuthnBean, WebSsoSession>();
            for (SpHashableAuthnBean bean : hashableAuthnBeans) {
                WebSsoSession session = this.beanToSessionMap.get(bean);
                group.put(bean, session);
            }
            return group;
        }
        return Collections.emptyMap();
    }

    @Override
    public synchronized void unregisterSessionsReceived(Collection<SpHashableAuthnBean> authnBeans) {
        for (SpHashableAuthnBean bean : authnBeans == null ? EMPTY_BEAN_LIST : authnBeans) {
            this.unregisterSessionReceived(bean);
        }
    }

    private synchronized void unregisterSessionReceived(SpHashableAuthnBean authnBean) {
        this.beanToSessionMap.remove(authnBean);
        if (authnBean != null) {
            Set hashableAuthnBeans = (Set)this.sessionIdToBeansMap.get(authnBean.getPrimarySessionId());
            if (hashableAuthnBeans != null) {
                Iterator i = hashableAuthnBeans.iterator();
                while (i.hasNext()) {
                    SpHashableAuthnBean hashableAuthnBean = (SpHashableAuthnBean)i.next();
                    if (!hashableAuthnBean.equals(authnBean)) continue;
                    i.remove();
                    break;
                }
            }
            if (Util.isEmpty(hashableAuthnBeans)) {
                String primarySessionId = authnBean.getPrimarySessionId();
                this.sessionIdToBeansMap.remove(primarySessionId);
            }
        }
    }

    @Override
    public synchronized StateServiceId getServiceId() {
        return StateServiceId.SP_SESSION_REGISTRY;
    }

    @Override
    public synchronized void importRecords(Collection<SessionRegistryEntry> sessionRegistryEntries) {
        for (SessionRegistryEntry entry : sessionRegistryEntries) {
            String sessionId = entry.getLocalSessionId();
            this.purgeBeansAndSessions(sessionId);
            if (!this.sessionIdToBeansMap.tryPutWithTimestamp(sessionId, new LinkedHashSet<SpHashableAuthnBean>(entry.getBeanToSessionMap().keySet()), entry.getTimestamp())) continue;
            for (Map.Entry<SpHashableAuthnBean, WebSsoSession> beanToSessionEntry : entry.getBeanToSessionMap().entrySet()) {
                this.beanToSessionMap.put(beanToSessionEntry.getKey(), beanToSessionEntry.getValue());
            }
        }
    }

    @Override
    public synchronized Collection<SessionRegistryEntry> getRecords(int startHash, int endHashExclusive) {
        ArrayList<SessionRegistryEntry> result = new ArrayList<SessionRegistryEntry>();
        Collection rangeEntries = this.sessionIdToBeansMap.getEntriesForRange(startHash, endHashExclusive);
        for (Cache.Entry rangeEntry : rangeEntries) {
            Set authnBeans = (Set)rangeEntry.getValue();
            if (authnBeans == null) continue;
            LinkedHashMap<SpHashableAuthnBean, WebSsoSession> beanToSessionEntry = new LinkedHashMap<SpHashableAuthnBean, WebSsoSession>();
            for (SpHashableAuthnBean authnBean : authnBeans) {
                beanToSessionEntry.put(authnBean, this.beanToSessionMap.get(authnBean));
            }
            SessionRegistryEntry tmpSessionRegistryEntry = new SessionRegistryEntry(rangeEntry.getKey(), beanToSessionEntry, rangeEntry.getTimestamp());
            result.add(tmpSessionRegistryEntry);
        }
        return result;
    }

    @Override
    public synchronized void purgeRecords(int startHash, int endHashExclusive) {
        Collection<String> localSessionIds = this.sessionIdToBeansMap.getKeysForRange(startHash, endHashExclusive);
        for (String localSessionId : localSessionIds) {
            this.purgeBeansAndSessions(localSessionId);
        }
    }

    @Override
    public synchronized int getSessionInfoMapSize() {
        return this.sessionIdToBeansMap.size();
    }

    public synchronized void updateCacheAccessTime(String primarySessionId) {
        Set beans = (Set)this.sessionIdToBeansMap.get(primarySessionId);
        if (beans != null && log.isDebugEnabled()) {
            log.debug((Object)("updateCacheAccessTime(primarySessionId=" + this.sessionIdUtil.hashIdForLog(primarySessionId) + ")"));
        }
    }

    private synchronized void purgeBeansAndSessions(String sessionId) {
        Set beans = (Set)this.sessionIdToBeansMap.remove(sessionId);
        this.purgeSessions(beans);
    }

    private synchronized void purgeSessions(Set<SpHashableAuthnBean> beans) {
        if (beans != null) {
            for (SpHashableAuthnBean bean : beans) {
                this.beanToSessionMap.remove(bean);
            }
        }
    }

    static class SessionRegistryEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String localSessionId;
        private final Map<SpHashableAuthnBean, WebSsoSession> beanToSessionMap;
        private final long timestamp;

        public SessionRegistryEntry(String localSessionId, Map<SpHashableAuthnBean, WebSsoSession> beanToSessionMap, long timestamp) {
            this.localSessionId = localSessionId;
            this.beanToSessionMap = beanToSessionMap;
            this.timestamp = timestamp;
        }

        public String getLocalSessionId() {
            return this.localSessionId;
        }

        public Map<SpHashableAuthnBean, WebSsoSession> getBeanToSessionMap() {
            return this.beanToSessionMap;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    class SessionIdToBeansSetMap
    extends DistributableCache<Set<SpHashableAuthnBean>> {
        private static final long serialVersionUID = 1L;
        private CachePurgeBeforeExpiryTracker purgeBeforeExpiryTracker;

        public SessionIdToBeansSetMap(long expiryPeriodMillis, int maxSize, float purgeLogIntervalMins, ConsistentHashTracker tracker) {
            super(expiryPeriodMillis, maxSize, true, tracker, SpSessionRegistryMapImpl.this.sessionIdUtil::getSriFromPrimaryValue);
            String remedyMessage = "Consider increasing SpSessionRegistryMapImpl.max.sessions or decreasing SpSessionRegistryMapImpl.expiry.mins in size-limits.conf. Increasing the size of the map will increase PingFederate heap usage. Decreasing the expiry period will reduce the maximum idle timeout for logout data.";
            this.purgeBeforeExpiryTracker = new CachePurgeBeforeExpiryTracker(expiryPeriodMillis, "SP Session Registry", remedyMessage, purgeLogIntervalMins, "sp.session.registry.session.map.purge.unexpired");
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        protected void onEntryPurged(String sessionId, Set<SpHashableAuthnBean> beans, boolean expired, long timestamp) {
            SpSessionRegistryMapImpl.this.purgeSessions(beans);
            this.purgeBeforeExpiryTracker.checkLogEntriesPurgedBeforeExpiry();
            if (!expired) {
                this.purgeBeforeExpiryTracker.trackEntryPurgedBeforeExpiry(timestamp);
            }
        }
    }
}

