/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.session;

import com.pingidentity.common.util.ObfuscationException;
import com.pingidentity.common.util.Obfuscator;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.service.session.AuthnSessionContextData;
import org.sourceid.saml20.service.session.SessionGroupMetadata;
import org.sourceid.saml20.service.session.SessionGroupMetadataUtil;
import org.sourceid.saml20.service.session.data.SessionGroupData;

public class SessionGroupInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String hashedSessionId;
    private long sessionSeriesId;
    private long expiryTimeMillis;
    private long lastActivityTimeMillis;
    private String sri;
    private AuthnSessionContextData contextData;

    public SessionGroupInfo() {
    }

    public SessionGroupInfo(SessionGroupData sessionData) {
        this.id = sessionData.getId();
        this.hashedSessionId = sessionData.getHashedSessionId();
        this.expiryTimeMillis = sessionData.getExpiryTimeMillis();
        this.lastActivityTimeMillis = sessionData.getLastActivityTimeMillis();
        SessionGroupMetadataUtil metaDataTranslatorUtil = new SessionGroupMetadataUtil();
        SessionGroupMetadata sessionGroupMetadata = null;
        String metadataStr = sessionData.getMetadata();
        if (StringUtils.isNotBlank((String)metadataStr)) {
            try {
                String decryptedMetadata = Obfuscator.deobfuscate(metadataStr);
                sessionGroupMetadata = metaDataTranslatorUtil.dsMetadataToSessionGroupMetadata(decryptedMetadata);
            }
            catch (ObfuscationException ignored) {
                sessionGroupMetadata = metaDataTranslatorUtil.dsMetadataToSessionGroupMetadata(metadataStr);
            }
        }
        if (sessionGroupMetadata != null) {
            this.sessionSeriesId = sessionGroupMetadata.getSeriesId();
            this.sri = sessionGroupMetadata.getSri();
            this.contextData = sessionGroupMetadata.getContextData();
        }
    }

    public SessionGroupData toSessionGroupData(String prevHashedSessionId) {
        SessionGroupData result = new SessionGroupData();
        result.setId(this.id);
        result.setHashedSessionId(this.hashedSessionId);
        result.setPrevHashedSessionId(prevHashedSessionId);
        result.setExpiryTimeMillis(this.expiryTimeMillis);
        result.setLastActivityTimeMillis(this.lastActivityTimeMillis);
        SessionGroupMetadataUtil metaDataTranslatorUtil = new SessionGroupMetadataUtil();
        SessionGroupMetadata sessionGroupMetadata = new SessionGroupMetadata(this.sessionSeriesId, this.sri, this.contextData);
        String metadata = metaDataTranslatorUtil.sessionGroupMetaDataToString(sessionGroupMetadata);
        if (StringUtils.isNotBlank((String)metadata)) {
            String encryptedMetadata = Obfuscator.obfuscate(metadata, true);
            result.setMetadata(encryptedMetadata);
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHashedSessionId() {
        return this.hashedSessionId;
    }

    public void setHashedSessionId(String hashedSessionId) {
        this.hashedSessionId = hashedSessionId;
    }

    public long getSessionSeriesId() {
        return this.sessionSeriesId;
    }

    public void setSessionSeriesId(long sessionSeriesId) {
        this.sessionSeriesId = sessionSeriesId;
    }

    public String getSri() {
        return this.sri;
    }

    public void setSri(String sri) {
        this.sri = sri;
    }

    public long getExpiryTimeMillis() {
        return this.expiryTimeMillis;
    }

    public void setExpiryTimeMillis(long expiryTimeMillis) {
        this.expiryTimeMillis = expiryTimeMillis;
    }

    public long getLastActivityTimeMillis() {
        return this.lastActivityTimeMillis;
    }

    public void setLastActivityTimeMillis(long lastActivityTimeMillis) {
        this.lastActivityTimeMillis = lastActivityTimeMillis;
    }

    public AuthnSessionContextData getContextData() {
        return this.contextData;
    }

    public void setContextData(AuthnSessionContextData contextData) {
        this.contextData = contextData;
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return String.format("SessionGroupInfo: id=%s, hashedSessionId=%s, sri=%s, sessionSeriesId=%s, expiryTime=%s, lastActivityTime=%s", this.id, this.hashedSessionId, this.sri, this.sessionSeriesId, dateFormat.format(this.expiryTimeMillis), dateFormat.format(this.lastActivityTimeMillis));
    }
}

