/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.session.data.impl;

import com.pingidentity.common.util.JDBCHelper;
import com.pingidentity.common.util.ServiceInformation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.service.session.data.AbstractSessionStorageManagerImpl;
import org.sourceid.saml20.service.session.data.AuthnSessionData;
import org.sourceid.saml20.service.session.data.SessionGroupAndSessionsData;
import org.sourceid.saml20.service.session.data.SessionGroupData;
import org.sourceid.saml20.service.session.data.SessionStorageException;

public class SessionStorageManagerJdbcImpl
extends AbstractSessionStorageManagerImpl {
    private static final Log log = LogFactory.getLog(SessionStorageManagerJdbcImpl.class);
    private ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.service.session.data.impl.SessionStorageManagerJdbcImpl");
    private static final String PINGFEDERATE_SESSION_GROUPS = "pingfederate_session_groups";
    private static final String PINGFEDERATE_SESSION_USER_IDS = "pingfederate_session_user_ids";
    static final String HASHED_SESSION_ID = "hashed_session_id";
    static final String EXPIRY_TIME = "expiry_time";
    static final String LAST_ACTIVITY_TIME = "last_activity_time";
    static final String PARENT_GROUP_ID = "parent_group_id";
    static final String METADATA = "metadata";
    static final String ID = "id";
    private static final List<String> SESSION_GROUP_COLUMNS = Arrays.asList("id", "hashed_session_id", "expiry_time", "last_activity_time", "parent_group_id", "metadata");
    private static final String SESSION_GROUP_COLUMNS_STR = StringUtils.join(SESSION_GROUP_COLUMNS, (String)",");
    static final String PSG = "psg";
    private static final String QUALIFIED_SESSION_GROUP_COLUMNS_STR = StringUtils.join((Collection)SESSION_GROUP_COLUMNS.stream().map(col -> "psg." + col + " AS psg_" + col).collect(Collectors.toList()), (String)",");
    private static final String DELETE_SESSION_GROUPS = "DELETE FROM pingfederate_session_groups WHERE hashed_session_id IN (%1$s)";
    private static final String DELETE_SESSION_GROUPS_BY_GROUP_IDS = "DELETE FROM pingfederate_session_groups WHERE id IN (%1$s)";
    private static final String INSERT_SESSION_GROUP = "INSERT INTO pingfederate_session_groups (" + SESSION_GROUP_COLUMNS_STR + ") VALUES (" + SessionStorageManagerJdbcImpl.makePlaceholders(SESSION_GROUP_COLUMNS.size()) + ")";
    private static final String UPDATE_SESSION_GROUP = "UPDATE pingfederate_session_groups SET hashed_session_id = ?, expiry_time = ?, last_activity_time = ?, parent_group_id = ?, metadata = ? WHERE id = ? AND hashed_session_id = ?";
    private static final String PINGFEDERATE_SESSION_DATA = "pingfederate_session_data";
    private static final String SESSION_GROUP_ID = "session_group_id";
    private static final String ATTRIBUTE_HASH = "attribute_hash";
    private static final String ROW_INDEX = "row_index";
    private static final String SESSION_DATA_1 = "session_data_1";
    private static final String SESSION_DATA_2 = "session_data_2";
    private static final List<String> AUTHN_SESSION_COLUMNS = Arrays.asList("session_group_id", "attribute_hash", "row_index", "session_data_1", "session_data_2");
    private static final String AUTHN_SESSION_COLUMNS_STR = StringUtils.join(AUTHN_SESSION_COLUMNS, (String)",");
    static final String PSD = "psd";
    private static final String QUALIFIED_AUTHN_SESSION_COLUMNS_STR = StringUtils.join((Collection)AUTHN_SESSION_COLUMNS.stream().map(col -> "psd." + col + " AS psd_" + col).collect(Collectors.toList()), (String)",");
    static final String PSUI = "pusi";
    static final String UNIQUE_USER_ID = "unique_user_id";
    private static final List<String> UNIQUE_USER_ID_COLUMNS = Arrays.asList("session_group_id", "unique_user_id");
    private static final String UNIQUE_USER_ID_COLUMNS_STR = StringUtils.join(UNIQUE_USER_ID_COLUMNS, (String)",");
    private static final String QUALIFIED_UNIQUE_USER_ID_COLUMNS_STR = StringUtils.join((Collection)UNIQUE_USER_ID_COLUMNS.stream().map(col -> "pusi." + col + " AS pusi_" + col).collect(Collectors.toList()), (String)",");
    private static final String INSERT_UNIQUE_USER_IDS = "INSERT INTO pingfederate_session_user_ids (" + UNIQUE_USER_ID_COLUMNS_STR + ") VALUES (" + SessionStorageManagerJdbcImpl.makePlaceholders(UNIQUE_USER_ID_COLUMNS.size()) + ")";
    private static final String SELECT_SESSION_GROUP_UNIQUE_USER_IDS = "SELECT " + QUALIFIED_UNIQUE_USER_ID_COLUMNS_STR + " FROM pingfederate_session_user_ids pusi WHERE pusi.session_group_id = ?";
    private static final String SELECT_SESSION_GROUPS_AND_SESSIONS = "SELECT " + QUALIFIED_SESSION_GROUP_COLUMNS_STR + "," + QUALIFIED_AUTHN_SESSION_COLUMNS_STR + " FROM pingfederate_session_groups psg INNER JOIN pingfederate_session_data psd ON psg.id=psd.session_group_id WHERE psg.%1$s IN (%2$s) ORDER BY psd.session_group_id,psd.attribute_hash,psd.row_index ASC";
    private static final String SELECT_SESSION_GROUPS_BY_UNIQUE_USER_ID = "SELECT " + QUALIFIED_SESSION_GROUP_COLUMNS_STR + "," + QUALIFIED_UNIQUE_USER_ID_COLUMNS_STR + " FROM pingfederate_session_groups psg INNER JOIN pingfederate_session_user_ids pusi ON psg.id=pusi.session_group_id WHERE pusi.unique_user_id = ? ORDER BY psg.id ASC";
    private static final String DELETE_AUTHN_SESSIONS = "DELETE FROM pingfederate_session_data WHERE session_group_id = ? AND attribute_hash IN (%1$s)";
    private static final String INSERT_AUTHN_SESSION = "INSERT INTO pingfederate_session_data (" + AUTHN_SESSION_COLUMNS_STR + ") VALUES (" + SessionStorageManagerJdbcImpl.makePlaceholders(AUTHN_SESSION_COLUMNS.size()) + ")";
    private Clock clock = Clock.systemDefaultZone();

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void deleteAllSessionGroups() throws SessionStorageException {
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            String statementStr = String.format("DELETE FROM %s", PINGFEDERATE_SESSION_GROUPS);
            PreparedStatement statement = jdbcHelper.getPreparedStatement(statementStr);
            statement.executeUpdate();
        }
        catch (SQLException | NamingException e) {
            throw new SessionStorageException("Error deleting all sessions", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int numberOfSessionGroups() throws SessionStorageException {
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            String statementStr = String.format("SELECT COUNT (*) FROM %s", PINGFEDERATE_SESSION_GROUPS);
            jdbcHelper.getPreparedStatement(statementStr);
            ResultSet resultSet = jdbcHelper.getResultSet();
            if (!resultSet.first()) throw new SessionStorageException("Query for number of rows in table pingfederate_session_groups returned no results");
            int n = resultSet.getInt(1);
            return n;
        }
        catch (SQLException | NamingException e) {
            throw new SessionStorageException("Error getting number of session groups", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int numberOfSessionRows() throws SessionStorageException {
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            String statementStr = String.format("SELECT COUNT (*) FROM %s", PINGFEDERATE_SESSION_DATA);
            jdbcHelper.getPreparedStatement(statementStr);
            ResultSet resultSet = jdbcHelper.getResultSet();
            if (!resultSet.first()) throw new SessionStorageException("Query for number of rows in table pingfederate_session_data returned no results");
            int n = resultSet.getInt(1);
            return n;
        }
        catch (SQLException | NamingException e) {
            throw new SessionStorageException("Error getting number of session rows", (Throwable)e);
        }
    }

    public boolean isDataSourceInUse(String datasourceId) {
        return datasourceId != null && datasourceId.equals(this.getJndiName());
    }

    public void deleteSessionGroups(Collection<String> hashedSessionIds) throws SessionStorageException {
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            String statementStr = String.format(DELETE_SESSION_GROUPS, SessionStorageManagerJdbcImpl.makePlaceholders(hashedSessionIds.size()));
            PreparedStatement statement = jdbcHelper.getPreparedStatement(statementStr);
            this.bindVariables(statement, 1, hashedSessionIds);
            statement.executeUpdate();
        }
        catch (SQLException | NamingException e) {
            throw new SessionStorageException("Error deleting session groups", (Throwable)e);
        }
    }

    public void deleteSessionGroupsByGroupIds(Collection<String> sessionGroupIds) throws SessionStorageException {
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            String statementStr = String.format(DELETE_SESSION_GROUPS_BY_GROUP_IDS, SessionStorageManagerJdbcImpl.makePlaceholders(sessionGroupIds.size()));
            PreparedStatement statement = jdbcHelper.getPreparedStatement(statementStr);
            this.bindVariables(statement, 1, sessionGroupIds);
            statement.executeUpdate();
        }
        catch (SQLException | NamingException e) {
            throw new SessionStorageException("Error deleting session groups", (Throwable)e);
        }
    }

    public void createSessionGroup(SessionGroupData sessionGroupData) throws SessionStorageException {
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            PreparedStatement statement = jdbcHelper.getPreparedStatement(INSERT_SESSION_GROUP);
            statement.setString(1, sessionGroupData.getId());
            statement.setString(2, sessionGroupData.getHashedSessionId());
            statement.setTimestamp(3, new Timestamp(sessionGroupData.getExpiryTimeMillis()));
            statement.setTimestamp(4, new Timestamp(sessionGroupData.getLastActivityTimeMillis()));
            statement.setString(5, sessionGroupData.getParentGroupId());
            statement.setString(6, sessionGroupData.getMetadata());
            statement.executeUpdate();
        }
        catch (SQLException | NamingException e) {
            throw new SessionStorageException("Error inserting session group data", (Throwable)e);
        }
    }

    public void updateSessionGroup(SessionGroupData sessionGroupData) throws SessionStorageException {
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            PreparedStatement statement = jdbcHelper.getPreparedStatement(UPDATE_SESSION_GROUP);
            statement.setString(1, sessionGroupData.getHashedSessionId());
            statement.setTimestamp(2, new Timestamp(sessionGroupData.getExpiryTimeMillis()));
            statement.setTimestamp(3, new Timestamp(sessionGroupData.getLastActivityTimeMillis()));
            statement.setString(4, sessionGroupData.getParentGroupId());
            statement.setString(5, sessionGroupData.getMetadata());
            statement.setString(6, sessionGroupData.getId());
            statement.setString(7, sessionGroupData.getPrevHashedSessionId());
            int rowCount = statement.executeUpdate();
            if (rowCount == 0) {
                throw new SessionStorageException("No matching rows found when updating session group");
            }
        }
        catch (SQLException | NamingException e) {
            throw new SessionStorageException("Error updating session group data", (Throwable)e);
        }
    }

    public Collection<SessionGroupAndSessionsData> getSessionGroupsAndSessions(Collection<String> hashedSessionIds) throws SessionStorageException {
        return this.getSessionGroupsAndSessions(hashedSessionIds, SELECT_SESSION_GROUPS_AND_SESSIONS, HASHED_SESSION_ID);
    }

    public Collection<SessionGroupAndSessionsData> getSessionGroupsAndSessionsByGroupIds(Collection<String> sessionGroupIds) throws SessionStorageException {
        return this.getSessionGroupsAndSessions(sessionGroupIds, SELECT_SESSION_GROUPS_AND_SESSIONS, ID);
    }

    public Collection<SessionGroupData> getSessionGroupsByUniqueUserId(String uniqueUserId) throws SessionStorageException {
        ArrayList<SessionGroupData> results = new ArrayList<SessionGroupData>();
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            PreparedStatement statement = jdbcHelper.getPreparedStatement(SELECT_SESSION_GROUPS_BY_UNIQUE_USER_ID);
            statement.setString(1, uniqueUserId);
            ResultSet resultSet = jdbcHelper.getResultSet();
            while (resultSet.next()) {
                results.add(this.getSessionGroupDataFromResultSet(resultSet, PSG));
            }
        }
        catch (SQLException | NamingException e) {
            throw new SessionStorageException("Error retrieving session groups, session data and unique user IDs via unique user key '" + uniqueUserId + "'", (Throwable)e);
        }
        return results;
    }

    public void saveAuthnSessions(Collection<AuthnSessionData> sessionDatas) throws SessionStorageException {
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            for (AuthnSessionData sessionData : sessionDatas) {
                this.saveAuthnSession(jdbcHelper, sessionData);
            }
        }
        catch (SQLException | NamingException e) {
            throw new SessionStorageException("Error saving authn session data", (Throwable)e);
        }
    }

    public void deleteAuthnSessions(String sessionGroupId, Collection<String> attributeHashes) throws SessionStorageException {
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            this.deleteAuthnSessions(jdbcHelper, sessionGroupId, attributeHashes);
        }
        catch (SQLException | NamingException e) {
            throw new SessionStorageException("Error deleting authn session data", (Throwable)e);
        }
    }

    public void addUniqueUserId(String sessionGroupId, String uniqueUserId) throws SessionStorageException {
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            PreparedStatement statement = jdbcHelper.getPreparedStatement(INSERT_UNIQUE_USER_IDS);
            statement.setString(1, sessionGroupId);
            statement.setString(2, uniqueUserId);
            statement.executeUpdate();
        }
        catch (SQLException | NamingException e) {
            throw new SessionStorageException("Error inserting unique user ID data", (Throwable)e);
        }
    }

    public boolean supportsBatchCleanup() {
        return true;
    }

    public void deleteExpiredSessionGroups() throws SessionStorageException {
        log.debug((Object)("Cleaning expired session groups, batch size = " + this.getExpiredSessionGroupBatchSize()));
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            long startTime = this.clock.millis();
            String deleteExpiredSessionGroups = this.getDeleteExpiredSessionGroupsStatement(jdbcHelper);
            PreparedStatement deleteStmt = jdbcHelper.getPreparedStatement(deleteExpiredSessionGroups);
            log.debug((Object)("DELETE statement for expired session group cleanup: " + deleteExpiredSessionGroups));
            Timestamp cutoff = new Timestamp(startTime - TimeUnit.MINUTES.toMillis(this.getExpirationTimeOffsetMins()));
            deleteStmt.setTimestamp(1, cutoff);
            log.debug((Object)("Time threshold for expired session group cleanup: " + cutoff));
            int totalSessionGroupsDeleted = 0;
            boolean done = false;
            while (!done) {
                int sessionGroupsDeleted = deleteStmt.executeUpdate();
                totalSessionGroupsDeleted += sessionGroupsDeleted;
                log.trace((Object)("Cleaned " + sessionGroupsDeleted + " session groups."));
                done = sessionGroupsDeleted == 0;
            }
            long endTime = this.clock.millis();
            log.debug((Object)("Cleaned " + totalSessionGroupsDeleted + " session groups in " + (endTime - startTime) + " milliseconds"));
        }
        catch (SQLException | NamingException e) {
            throw new SessionStorageException("An error occurred while deleting expired session groups", (Throwable)e);
        }
    }

    protected String getDeleteExpiredSessionGroupsStatement(JDBCHelper jdbcHelper) throws SQLException {
        String deleteExpiredSessionGroups = String.format("DELETE FROM %s WHERE %s <= ?", PINGFEDERATE_SESSION_GROUPS, this.getExpirationTimeColumnName());
        if (jdbcHelper.isHypersonicHql()) {
            deleteExpiredSessionGroups = String.format("DELETE FROM %s WHERE %s <= ? AND rownum() <= %d", PINGFEDERATE_SESSION_GROUPS, this.getExpirationTimeColumnName(), this.getExpiredSessionGroupBatchSize());
        } else if (jdbcHelper.isSqlServer()) {
            deleteExpiredSessionGroups = String.format("DELETE TOP (%d) FROM %s WHERE %s <= ?", this.getExpiredSessionGroupBatchSize(), PINGFEDERATE_SESSION_GROUPS, this.getExpirationTimeColumnName());
        } else if (jdbcHelper.isOracle()) {
            deleteExpiredSessionGroups = String.format("DELETE FROM %s WHERE %s <= ? AND ROWNUM <= %d", PINGFEDERATE_SESSION_GROUPS, this.getExpirationTimeColumnName(), this.getExpiredSessionGroupBatchSize());
        } else if (jdbcHelper.isMySql()) {
            deleteExpiredSessionGroups = String.format("DELETE FROM %s WHERE %s <= ? LIMIT %d", PINGFEDERATE_SESSION_GROUPS, this.getExpirationTimeColumnName(), this.getExpiredSessionGroupBatchSize());
        } else if (jdbcHelper.isPostgres()) {
            deleteExpiredSessionGroups = String.format("DELETE FROM %s WHERE %s IN (SELECT %s FROM %s WHERE %s <= ? LIMIT %s)", PINGFEDERATE_SESSION_GROUPS, ID, ID, PINGFEDERATE_SESSION_GROUPS, this.getExpirationTimeColumnName(), this.getExpiredSessionGroupBatchSize());
        }
        return deleteExpiredSessionGroups;
    }

    protected String getExpirationTimeColumnName() {
        return this.configStore.getStringValue("ExpirationTimeColumnName", EXPIRY_TIME);
    }

    protected int getExpiredSessionGroupBatchSize() {
        return this.configStore.getIntValue("ExpiredSessionGroupBatchSize", 500);
    }

    protected int getExpirationTimeOffsetMins() {
        return this.configStore.getIntValue("ExpirationTimeOffsetMins", 10);
    }

    protected JDBCHelper getJDBCHelper() throws NamingException, SQLException {
        return new JDBCHelper(this.getJndiName(), (ServiceInformation)this);
    }

    protected int getSessionDataSegmentLength() {
        return this.configStore.getIntValue("SessionDataSegmentLength", 3500);
    }

    protected String getJndiName() {
        return this.configStore.getStringValue("PingFederateDSJNDIName", "PFDefaultDS");
    }

    private Collection<SessionGroupAndSessionsData> getSessionGroupsAndSessions(Collection<String> ids, String selectStmt, String idColumnName) throws SessionStorageException {
        Set<String> uniqueUserIds;
        SessionGroupData sessionGroupData = null;
        ArrayList<AuthnSessionData> authnSessionDataList = new ArrayList<AuthnSessionData>();
        try (JDBCHelper jdbcHelper = this.getJDBCHelper();){
            AuthnSessionKey authnSessionKey;
            String statementStr = String.format(selectStmt, idColumnName, SessionStorageManagerJdbcImpl.makePlaceholders(ids.size()));
            PreparedStatement statement = jdbcHelper.getPreparedStatement(statementStr);
            this.bindVariables(statement, 1, ids);
            ResultSet resultSet = jdbcHelper.getResultSet();
            HashMap segmentsByAuthnSession = new HashMap();
            while (resultSet.next()) {
                String attributeHash;
                String sessionGroupId;
                ArrayList<String> segments;
                if (sessionGroupData == null) {
                    sessionGroupData = this.getSessionGroupDataFromResultSet(resultSet, PSG);
                }
                if ((segments = (ArrayList<String>)segmentsByAuthnSession.get(authnSessionKey = new AuthnSessionKey(sessionGroupId = resultSet.getString("psd_session_group_id"), attributeHash = resultSet.getString("psd_attribute_hash")))) == null) {
                    segments = new ArrayList<String>();
                    segmentsByAuthnSession.put(authnSessionKey, segments);
                }
                for (String column : Arrays.asList("psd_session_data_1", "psd_session_data_2")) {
                    String sessionData = resultSet.getString(column);
                    if (sessionData == null) continue;
                    segments.add(sessionData);
                }
            }
            for (Map.Entry entry : segmentsByAuthnSession.entrySet()) {
                authnSessionKey = (AuthnSessionKey)entry.getKey();
                String sessionData = String.join((CharSequence)"", (Iterable)entry.getValue());
                authnSessionDataList.add(new AuthnSessionData(authnSessionKey.getSessionGroupId(), authnSessionKey.getAttributeHash(), sessionData));
            }
            uniqueUserIds = this.getUniqueUserIdsForSessionGroup(sessionGroupData, jdbcHelper);
        }
        catch (SQLException | NamingException e) {
            throw new SessionStorageException("Error retrieving session groups, sessions and unique user IDs", (Throwable)e);
        }
        if (sessionGroupData == null) {
            return Collections.emptyList();
        }
        SessionGroupAndSessionsData sessionGroupAndSessionsData = new SessionGroupAndSessionsData(sessionGroupData, authnSessionDataList);
        sessionGroupAndSessionsData.setUniqueUserIds(uniqueUserIds);
        return Collections.singletonList(sessionGroupAndSessionsData);
    }

    private Set<String> getUniqueUserIdsForSessionGroup(SessionGroupData sessionGroupData, JDBCHelper jdbcHelper) throws SQLException {
        HashSet<String> uniqueUserIds = new HashSet<String>();
        if (sessionGroupData != null) {
            PreparedStatement statement = jdbcHelper.getPreparedStatement(SELECT_SESSION_GROUP_UNIQUE_USER_IDS);
            statement.setString(1, sessionGroupData.getId());
            ResultSet resultSet = jdbcHelper.getResultSet();
            while (resultSet.next()) {
                uniqueUserIds.add(resultSet.getString(this.columnNameWithPrefix(UNIQUE_USER_ID, PSUI)));
            }
        }
        return uniqueUserIds;
    }

    private void saveAuthnSession(JDBCHelper jdbcHelper, AuthnSessionData sessionData) throws SQLException {
        this.deleteAuthnSessions(jdbcHelper, sessionData.getSessionGroupId(), Arrays.asList(sessionData.getAttributeHash()));
        jdbcHelper.setAutoCommit(false);
        Queue<String> segments = this.getSessionDataSegments(sessionData.getSessionData());
        int rowIndex = 0;
        PreparedStatement statement = jdbcHelper.getPreparedStatement(INSERT_AUTHN_SESSION);
        try {
            while (!segments.isEmpty()) {
                statement.setString(1, sessionData.getSessionGroupId());
                statement.setString(2, sessionData.getAttributeHash());
                statement.setInt(3, rowIndex++);
                statement.setString(4, segments.remove());
                if (segments.isEmpty()) {
                    statement.setString(5, null);
                } else {
                    statement.setString(5, segments.remove());
                }
                statement.executeUpdate();
            }
            jdbcHelper.commit();
        }
        catch (Exception e) {
            jdbcHelper.rollback();
            throw e;
        }
        jdbcHelper.setAutoCommit(true);
    }

    private Queue<String> getSessionDataSegments(String sessionData) {
        LinkedList<String> result = new LinkedList<String>();
        int startIndex = 0;
        int endIndex = Math.min(this.getSessionDataSegmentLength(), sessionData.length());
        while (startIndex < sessionData.length()) {
            result.add(sessionData.substring(startIndex, endIndex));
            startIndex = endIndex;
            endIndex = Math.min(endIndex + this.getSessionDataSegmentLength(), sessionData.length());
        }
        return result;
    }

    private void deleteAuthnSessions(JDBCHelper jdbcHelper, String sessionGroupId, Collection<String> attributeHashes) throws SQLException {
        String statementStr = String.format(DELETE_AUTHN_SESSIONS, SessionStorageManagerJdbcImpl.makePlaceholders(attributeHashes.size()));
        PreparedStatement statement = jdbcHelper.getPreparedStatement(statementStr);
        statement.setString(1, sessionGroupId);
        this.bindVariables(statement, 2, attributeHashes);
        statement.executeUpdate();
    }

    private static String makePlaceholders(int count) {
        return StringUtils.join(Collections.nCopies(count, "?"), (String)",");
    }

    private void bindVariables(PreparedStatement prepared, int startIndex, Collection<String> values) throws SQLException {
        for (String value : values) {
            prepared.setString(startIndex++, value);
        }
    }

    SessionGroupData getSessionGroupDataFromResultSet(ResultSet resultSet, String columnNamePrefix) throws SQLException {
        SessionGroupData result = new SessionGroupData();
        result.setId(resultSet.getString(this.columnNameWithPrefix(ID, columnNamePrefix)));
        result.setHashedSessionId(resultSet.getString(this.columnNameWithPrefix(HASHED_SESSION_ID, columnNamePrefix)));
        result.setPrevHashedSessionId(result.getHashedSessionId());
        result.setExpiryTimeMillis(resultSet.getTimestamp(this.columnNameWithPrefix(EXPIRY_TIME, columnNamePrefix)).getTime());
        result.setLastActivityTimeMillis(resultSet.getTimestamp(this.columnNameWithPrefix(LAST_ACTIVITY_TIME, columnNamePrefix)).getTime());
        result.setParentGroupId(resultSet.getString(this.columnNameWithPrefix(PARENT_GROUP_ID, columnNamePrefix)));
        result.setMetadata(resultSet.getString(this.columnNameWithPrefix(METADATA, columnNamePrefix)));
        return result;
    }

    String columnNameWithPrefix(String columnName, String prefix) {
        if (prefix == null) {
            return columnName;
        }
        return prefix + "_" + columnName;
    }

    private static class AuthnSessionKey {
        private String sessionGroupId;
        private String attributeHash;

        public AuthnSessionKey(String sessionGroupId, String attributeHash) {
            this.sessionGroupId = sessionGroupId;
            this.attributeHash = attributeHash;
        }

        public String getSessionGroupId() {
            return this.sessionGroupId;
        }

        public String getAttributeHash() {
            return this.attributeHash;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.attributeHash == null ? 0 : this.attributeHash.hashCode());
            result = 31 * result + (this.sessionGroupId == null ? 0 : this.sessionGroupId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AuthnSessionKey other = (AuthnSessionKey)obj;
            if (this.attributeHash == null ? other.attributeHash != null : !this.attributeHash.equals(other.attributeHash)) {
                return false;
            }
            return !(this.sessionGroupId == null ? other.sessionGroupId != null : !this.sessionGroupId.equals(other.sessionGroupId));
        }
    }
}

