/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.session.data.impl;

import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.ldap.LDAPCrudHelper;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.ldap.LDAPUtilOptions;
import com.sun.jndi.ldap.LdapName;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.controls.AssertionRequestControl;
import com.unboundid.ldap.sdk.controls.SubtreeDeleteRequestControl;
import com.unboundid.util.StaticUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.session.data.AbstractSessionStorageManagerImpl;
import org.sourceid.saml20.service.session.data.AuthnSessionData;
import org.sourceid.saml20.service.session.data.SessionGroupAndSessionsData;
import org.sourceid.saml20.service.session.data.SessionGroupData;
import org.sourceid.saml20.service.session.data.SessionStorageException;
import org.sourceid.util.log.AttributeMap;

public class SessionStorageManagerLdapImpl
extends AbstractSessionStorageManagerImpl {
    private static final Log log = LogFactory.getLog(SessionStorageManagerLdapImpl.class);
    private static final String OBJECT_CLASS = "objectClass";
    private ConfigStore configStore = ConfigStoreFarm.getConfig("org.sourceid.saml20.service.session.data.impl.SessionStorageManagerLdapImpl");

    public void createSessionGroup(SessionGroupData sessionGroupData) throws SessionStorageException {
        try {
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            LdapName ldapName = new LdapName(this.getSessionGroupDN(sessionGroupData.getId()));
            Attributes attributes = this.getAttributes(sessionGroupData);
            ldapCrudHelper.createEntry(ldapName, attributes);
        }
        catch (NamingException e) {
            throw new SessionStorageException((Throwable)e);
        }
    }

    public void updateSessionGroup(SessionGroupData sessionGroupData) throws SessionStorageException {
        try {
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            Filter previousHashedSessionIdFilter = Filter.createEqualityFilter((String)this.getAttributeSessionGroupHashedSessionId(), (String)sessionGroupData.getPrevHashedSessionId());
            ldapCrudHelper.addControl((Control)new AssertionRequestControl(previousHashedSessionIdFilter));
            LdapName ldapName = new LdapName(this.getSessionGroupDN(sessionGroupData.getId()));
            Attributes attributes = this.getAttributes(sessionGroupData);
            ldapCrudHelper.modifyEntry(ldapName, attributes, 2);
        }
        catch (NamingException e) {
            throw new SessionStorageException((Throwable)e);
        }
    }

    public void deleteSessionGroups(Collection<String> hashedSessionIds) throws SessionStorageException {
        Collection<AttributeMap> groupEntries = this.getAuthnSessionGroupAttributeMaps(this.getAttributeSessionGroupHashedSessionId(), hashedSessionIds);
        if (groupEntries != null) {
            for (AttributeMap groupEntry : groupEntries) {
                this.deleteGroupByGroupId(((AttributeValue)groupEntry.get((Object)this.getAttributeSessionGroupId())).getValue());
            }
        }
    }

    private Collection<AttributeMap> getAuthnSessionGroupAttributeMaps(String attributeFieldOfIds, Collection<String> ids) throws SessionStorageException {
        String authSessionGroupSearchCriteria = null;
        int idsCount = ids.size();
        if (idsCount > 1) {
            ArrayList<Filter> hashedSessionIdsFilters = new ArrayList<Filter>();
            for (String id : ids) {
                hashedSessionIdsFilters.add(Filter.createEqualityFilter((String)attributeFieldOfIds, (String)id));
            }
            authSessionGroupSearchCriteria = Filter.createANDFilter((Filter[])new Filter[]{this.getObjectClassEqualityFilter(this.getObjectClassAuthnSessionGroups()), Filter.createORFilter(hashedSessionIdsFilters)}).toString();
        } else if (idsCount == 1) {
            authSessionGroupSearchCriteria = Filter.createANDFilter((Filter[])new Filter[]{this.getObjectClassEqualityFilter(this.getObjectClassAuthnSessionGroups()), Filter.createEqualityFilter((String)attributeFieldOfIds, (String)ids.iterator().next())}).toString();
        } else {
            return Collections.emptyList();
        }
        return this.getAttributeMap(this.getSearchBase(), authSessionGroupSearchCriteria, 2);
    }

    public Collection<SessionGroupData> getSessionGroupsByUniqueUserId(String uniqueUserId) throws SessionStorageException {
        ArrayList<SessionGroupData> results = new ArrayList<SessionGroupData>();
        Collection<AttributeMap> groupEntries = this.getAuthnSessionGroupAttributeMaps(this.getAttributeSessionGroupUserIds(), Collections.singleton(uniqueUserId));
        if (groupEntries != null) {
            for (AttributeMap groupEntry : groupEntries) {
                results.add(this.getSessionGroup(groupEntry));
            }
        }
        return results;
    }

    public void deleteSessionGroupsByGroupIds(Collection<String> sessionGroupIds) throws SessionStorageException {
        for (String groupId : sessionGroupIds) {
            this.deleteGroupByGroupId(groupId);
        }
    }

    private void deleteGroupByGroupId(String groupId) throws SessionStorageException {
        try {
            LdapName ldapName = new LdapName(this.getSessionGroupDN(groupId));
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            ldapCrudHelper.addControl((Control)new SubtreeDeleteRequestControl());
            ldapCrudHelper.deleteEntry(ldapName);
        }
        catch (NamingException e) {
            throw new SessionStorageException((Throwable)e);
        }
    }

    public Collection<SessionGroupAndSessionsData> getSessionGroupsAndSessions(Collection<String> hashedSessionIds) throws SessionStorageException {
        ArrayList<SessionGroupAndSessionsData> sessionGroupAndSessions = new ArrayList<SessionGroupAndSessionsData>();
        Collection<AttributeMap> groupEntries = this.getAuthnSessionGroupAttributeMaps(this.getAttributeSessionGroupHashedSessionId(), hashedSessionIds);
        if (groupEntries != null) {
            for (AttributeMap groupEntry : groupEntries) {
                sessionGroupAndSessions.add(this.getSessionGroupAndSessionsData(this.getSessionGroupDN(groupEntry.getSingleValue(this.getAttributeSessionGroupId())), groupEntry));
            }
        }
        return sessionGroupAndSessions;
    }

    public Collection<SessionGroupAndSessionsData> getSessionGroupsAndSessionsByGroupIds(Collection<String> sessionGroupIds) throws SessionStorageException {
        ArrayList<SessionGroupAndSessionsData> sessionGroupAndSessions = new ArrayList<SessionGroupAndSessionsData>();
        if (sessionGroupIds != null) {
            for (String groupId : sessionGroupIds) {
                String sessionGroupBaseDN = this.getSessionGroupDN(groupId);
                Collection<AttributeMap> groupEntry = this.getAttributeMap(sessionGroupBaseDN, null, 0);
                if (groupEntry == null || groupEntry.isEmpty()) continue;
                sessionGroupAndSessions.add(this.getSessionGroupAndSessionsData(sessionGroupBaseDN, groupEntry.iterator().next()));
            }
        }
        return sessionGroupAndSessions;
    }

    private String getSessionGroupDN(String id) {
        StringBuilder sessionGroupDN = new StringBuilder();
        sessionGroupDN.append(this.getAttributeSessionGroupId());
        sessionGroupDN.append("=");
        sessionGroupDN.append(id);
        sessionGroupDN.append(",");
        sessionGroupDN.append(this.getSearchBase());
        return sessionGroupDN.toString();
    }

    private String getSessionDN(String groupId, String sessionAttributeHash) {
        StringBuilder sessionGroupDN = new StringBuilder();
        sessionGroupDN.append(this.getAttributeSessionAttributeHash());
        sessionGroupDN.append("=");
        sessionGroupDN.append(sessionAttributeHash);
        sessionGroupDN.append(",");
        sessionGroupDN.append(this.getSessionGroupDN(groupId));
        return sessionGroupDN.toString();
    }

    private SessionGroupAndSessionsData getSessionGroupAndSessionsData(String baseDnWithGroupId, AttributeMap groupEntry) throws SessionStorageException {
        SessionGroupAndSessionsData sessionGroupAndSessionsData = null;
        if (groupEntry != null) {
            SessionGroupData groupData = this.getSessionGroup(groupEntry);
            String authSessionSearchCriteria = this.getObjectClassEqualityFilter(this.getObjectClassAuthnSessions()).toString();
            Collection<AttributeMap> sessionEntries = this.getAttributeMap(baseDnWithGroupId, authSessionSearchCriteria, 1);
            ArrayList<AuthnSessionData> sessionDataEntries = new ArrayList<AuthnSessionData>();
            if (sessionEntries != null) {
                for (AttributeMap sessionEntry : sessionEntries) {
                    sessionDataEntries.add(this.getAuthnSessionData(sessionEntry, groupData.getId()));
                }
            }
            sessionGroupAndSessionsData = new SessionGroupAndSessionsData(groupData, sessionDataEntries);
            AttributeValue userIds = (AttributeValue)groupEntry.get((Object)this.getAttributeSessionGroupUserIds());
            if (userIds != null) {
                sessionGroupAndSessionsData.setUniqueUserIds(userIds.getValuesAsCollection());
            }
        }
        return sessionGroupAndSessionsData;
    }

    public void saveAuthnSessions(Collection<AuthnSessionData> sessionDatas) throws SessionStorageException {
        try {
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            for (AuthnSessionData sessionData : sessionDatas) {
                try {
                    this.deleteAuthnSession(sessionData.getSessionGroupId(), sessionData.getAttributeHash());
                }
                catch (SessionStorageException sessionStorageException) {
                    // empty catch block
                }
                String sessionDN = this.getSessionDN(sessionData.getSessionGroupId(), sessionData.getAttributeHash());
                LdapName ldapName = new LdapName(sessionDN);
                Attributes attributes = this.getAttributes(sessionData);
                ldapCrudHelper.createEntry(ldapName, attributes);
            }
        }
        catch (NamingException e) {
            throw new SessionStorageException((Throwable)e);
        }
    }

    private void deleteAuthnSession(String sessionGroupId, String attributeHash) throws SessionStorageException {
        try {
            this.deleteAuthnSessions(sessionGroupId, attributeHash);
        }
        catch (NamingException e) {
            throw new SessionStorageException((Throwable)e);
        }
    }

    public void deleteAuthnSessions(String sessionGroupId, Collection<String> attributeHashes) throws SessionStorageException {
        try {
            for (String attributeHash : attributeHashes) {
                this.deleteAuthnSessions(sessionGroupId, attributeHash);
            }
        }
        catch (NamingException e) {
            throw new SessionStorageException((Throwable)e);
        }
    }

    public boolean supportsBatchCleanup() {
        return false;
    }

    public void deleteExpiredSessionGroups() {
        log.warn((Object)"This implementation of session storage does not support batch cleanup of expired sessions");
    }

    private void deleteAuthnSessions(String sessionGroupId, String attributeHash) throws NamingException, SessionStorageException {
        LdapName ldapName = new LdapName(this.getSessionDN(sessionGroupId, attributeHash));
        LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this);
        LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
        ldapCrudHelper.deleteEntry(ldapName);
    }

    private SessionGroupData getSessionGroup(AttributeMap attributeMap) throws SessionStorageException {
        SessionGroupData sessionGroupData = new SessionGroupData();
        String groupId = attributeMap.getSingleValue(this.getAttributeSessionGroupId());
        sessionGroupData.setId(groupId);
        sessionGroupData.setHashedSessionId(attributeMap.getSingleValue(this.getAttributeSessionGroupHashedSessionId()));
        sessionGroupData.setPrevHashedSessionId(sessionGroupData.getHashedSessionId());
        sessionGroupData.setMetadata(attributeMap.getSingleValue(this.getAttributeSessionGroupMetadata()));
        sessionGroupData.setParentGroupId(attributeMap.getSingleValue(this.getAttributeSessionGroupParentId()));
        sessionGroupData.setExpiryTimeMillis(this.decodeGeneralisedTime(attributeMap.getSingleValue(this.getAttributeSessionGroupExpiryTime()), this.getAttributeSessionGroupExpiryTime()).longValue());
        sessionGroupData.setLastActivityTimeMillis(this.decodeGeneralisedTime(attributeMap.getSingleValue(this.getAttributeSessionGroupLastActivityTime()), this.getAttributeSessionGroupLastActivityTime()).longValue());
        return sessionGroupData;
    }

    private Long decodeGeneralisedTime(String attributeSingleValue, String attributeName) throws SessionStorageException {
        if (StringUtils.isEmpty((String)attributeSingleValue)) {
            throw new SessionStorageException("Invalid entry in LDAP. Unable to read attribute value for '" + attributeName + "'.");
        }
        try {
            return StaticUtils.decodeGeneralizedTime((String)attributeSingleValue).getTime();
        }
        catch (ParseException e) {
            throw new SessionStorageException((Throwable)e);
        }
    }

    private Attributes getAttributes(SessionGroupData sessionGroupData) {
        BasicAttributes attributes = new BasicAttributes();
        attributes.put(new BasicAttribute(OBJECT_CLASS, "top"));
        attributes.put(new BasicAttribute(OBJECT_CLASS, this.getObjectClassAuthnSessionGroups()));
        attributes.put(this.getAttributeSessionGroupId(), sessionGroupData.getId());
        attributes.put(this.getAttributeSessionGroupHashedSessionId(), sessionGroupData.getHashedSessionId());
        attributes.put(this.getAttributeSessionGroupExpiryTime(), StaticUtils.encodeGeneralizedTime((long)sessionGroupData.getExpiryTimeMillis()));
        attributes.put(this.getAttributeSessionGroupLastActivityTime(), StaticUtils.encodeGeneralizedTime((long)sessionGroupData.getLastActivityTimeMillis()));
        if (StringUtils.isNotEmpty((String)sessionGroupData.getMetadata())) {
            attributes.put(this.getAttributeSessionGroupMetadata(), sessionGroupData.getMetadata());
        }
        if (StringUtils.isNotEmpty((String)sessionGroupData.getParentGroupId())) {
            attributes.put(this.getAttributeSessionGroupParentId(), sessionGroupData.getParentGroupId());
        }
        return attributes;
    }

    private AuthnSessionData getAuthnSessionData(AttributeMap attributeMap, String groupId) {
        AuthnSessionData authnSessionData = new AuthnSessionData();
        authnSessionData.setSessionGroupId(groupId);
        authnSessionData.setSessionData(attributeMap.getSingleValue(this.getAttributeSessionData()));
        authnSessionData.setAttributeHash(attributeMap.getSingleValue(this.getAttributeSessionAttributeHash()));
        return authnSessionData;
    }

    private Attributes getAttributes(AuthnSessionData sessionData) {
        BasicAttributes attributes = new BasicAttributes();
        attributes.put(new BasicAttribute(OBJECT_CLASS, "top"));
        attributes.put(new BasicAttribute(OBJECT_CLASS, this.getObjectClassAuthnSessions()));
        attributes.put(this.getAttributeSessionAttributeHash(), sessionData.getAttributeHash());
        attributes.put(this.getAttributeSessionData(), sessionData.getSessionData());
        return attributes;
    }

    private void validateConfiguration() throws SessionStorageException {
        if (StringUtils.isEmpty((String)this.getJndiName())) {
            throw new SessionStorageException("An Authentication Session data store is not defined.");
        }
        if (StringUtils.isEmpty((String)this.getSearchBase())) {
            throw new SessionStorageException("The LDAP search base for Authentication Session is not defined.");
        }
        if (StringUtils.isEmpty((String)this.getObjectClassAuthnSessionGroups())) {
            throw new SessionStorageException("The Authentication Session Groups object class name is not defined.");
        }
        if (StringUtils.isEmpty((String)this.getObjectClassAuthnSessions())) {
            throw new SessionStorageException("The Authentication Sessions object class name is not defined.");
        }
    }

    private LdapDataSource getLdapDataSource() throws SessionStorageException {
        this.validateConfiguration();
        LdapDataSource dataSource = MgmtFactory.getDataSourceManager().getLdapDataSource(this.getJndiName());
        if (dataSource == null) {
            throw new SessionStorageException("Unable to connect to Authentication Session LDAP Data Source.");
        }
        if (dataSource.isGatewayEnabled()) {
            log.warn((Object)"LDAP Data Source is a PingOne Gateway enabled data source which is an UNSUPPORTED configuration.");
        }
        return dataSource;
    }

    private Collection<AttributeMap> getAttributeMap(String baseDN, String searchCriteria, int searchScope) throws SessionStorageException {
        try {
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(baseDN, searchCriteria, searchScope);
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this);
            return ldapUtil.getAttributesOfMatchingObjects(ldapOptions);
        }
        catch (NamingException e) {
            throw new SessionStorageException((Throwable)e);
        }
    }

    private Filter getObjectClassEqualityFilter(String objectClassName) {
        return Filter.createEqualityFilter((String)OBJECT_CLASS, (String)objectClassName);
    }

    public boolean isDataSourceInUse(String datasourceId) {
        return datasourceId != null && datasourceId.equals(this.getJndiName());
    }

    public void addUniqueUserId(String sessionGroupId, String uniqueUserId) throws SessionStorageException {
        try {
            LDAPUtil ldapUtil = LDAPUtil.newInstance(this.getLdapDataSource(), (ServiceInformation)this);
            LDAPCrudHelper ldapCrudHelper = new LDAPCrudHelper(ldapUtil);
            String sessionGroupDN = this.getSessionGroupDN(sessionGroupId);
            LdapName ldapName = new LdapName(sessionGroupDN);
            BasicAttributes attributes = new BasicAttributes();
            attributes.put(new BasicAttribute(this.getAttributeSessionGroupUserIds(), uniqueUserId));
            ldapCrudHelper.modifyEntry(ldapName, attributes, 1);
        }
        catch (NamingException e) {
            throw new SessionStorageException((Throwable)e);
        }
    }

    private String getJndiName() {
        return this.configStore.getStringValue("PingFederateDSJNDIName", "PFDefaultDS");
    }

    private String getSearchBase() {
        return this.configStore.getStringValue("SearchBase", "");
    }

    private String getObjectClassAuthnSessionGroups() {
        return this.configStore.getStringValue("AuthnSessionGroupsObjectClass", "pf-authn-session-groups");
    }

    private String getObjectClassAuthnSessions() {
        return this.configStore.getStringValue("AuthnSessionsObjectClass", "pf-authn-sessions");
    }

    private String getAttributeSessionGroupId() {
        return this.configStore.getStringValue(AttributeType.AUTHN_SESSION_GROUP_ID.getName(), AttributeType.AUTHN_SESSION_GROUP_ID.getDefaultValue());
    }

    private String getAttributeSessionGroupHashedSessionId() {
        return this.configStore.getStringValue(AttributeType.AUTHN_SESSION_GROUP_HASHED_SESSION_ID.getName(), AttributeType.AUTHN_SESSION_GROUP_HASHED_SESSION_ID.getDefaultValue());
    }

    private String getAttributeSessionGroupExpiryTime() {
        return this.configStore.getStringValue(AttributeType.AUTHN_SESSION_GROUP_EXPIRY_TIME.getName(), AttributeType.AUTHN_SESSION_GROUP_EXPIRY_TIME.getDefaultValue());
    }

    private String getAttributeSessionGroupLastActivityTime() {
        return this.configStore.getStringValue(AttributeType.AUTHN_SESSION_GROUP_LAST_ACTIVITY_TIME.getName(), AttributeType.AUTHN_SESSION_GROUP_LAST_ACTIVITY_TIME.getDefaultValue());
    }

    private String getAttributeSessionGroupParentId() {
        return this.configStore.getStringValue(AttributeType.AUTHN_SESSION_GROUP_PARENT_ID.getName(), AttributeType.AUTHN_SESSION_GROUP_PARENT_ID.getDefaultValue());
    }

    private String getAttributeSessionGroupMetadata() {
        return this.configStore.getStringValue(AttributeType.AUTHN_SESSION_GROUP_METADATA.getName(), AttributeType.AUTHN_SESSION_GROUP_METADATA.getDefaultValue());
    }

    private String getAttributeSessionGroupUserIds() {
        return this.configStore.getStringValue(AttributeType.AUTHN_SESSION_GROUP_USER_IDS.getName(), AttributeType.AUTHN_SESSION_GROUP_USER_IDS.getDefaultValue());
    }

    private String getAttributeSessionAttributeHash() {
        return this.configStore.getStringValue(AttributeType.AUTHN_SESSION_ATTRIBUTE_HASH.getName(), AttributeType.AUTHN_SESSION_ATTRIBUTE_HASH.getDefaultValue());
    }

    private String getAttributeSessionData() {
        return this.configStore.getStringValue(AttributeType.AUTHN_SESSION_ATTRIBUTE.getName(), AttributeType.AUTHN_SESSION_ATTRIBUTE.getDefaultValue());
    }

    public static enum AttributeType {
        AUTHN_SESSION_GROUP_ID("authnSessionGroupId", "pf-authn-session-group-id"),
        AUTHN_SESSION_GROUP_HASHED_SESSION_ID("authnSessionGroupHashedSessionId", "pf-authn-session-group-hashed-session-id"),
        AUTHN_SESSION_GROUP_EXPIRY_TIME("authnSessionGroupExpiryTime", "pf-authn-session-group-expiry-time"),
        AUTHN_SESSION_GROUP_LAST_ACTIVITY_TIME("authnSessionGroupLastActivityTime", "pf-authn-session-group-last-activity-time"),
        AUTHN_SESSION_GROUP_PARENT_ID("authnSessionGroupParentId", "pf-authn-session-group-parent-id"),
        AUTHN_SESSION_GROUP_METADATA("authnSessionGroupMetdata", "pf-authn-session-group-metadata"),
        AUTHN_SESSION_GROUP_USER_IDS("authnSessionGroupUserIds", "pf-authn-session-group-user-ids"),
        AUTHN_SESSION_ATTRIBUTE_HASH("authnSessionAttributeHash", "pf-authn-session-attribute-hash"),
        AUTHN_SESSION_ATTRIBUTE("authnSessionData", "pf-authn-session-data");

        private String name;
        private String defaultValue;

        private AttributeType(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

