/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.service.util;

import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import com.pingidentity.pingcommons.crypto.HashUtil;
import com.pingidentity.pingcommons.crypto.IDGenerator;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ByteUtil;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.ConfigStoreLocation;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class NodeIndex {
    private static final String QUALIFIER = "Qualifier";
    private static Log log = LogFactory.getLog(NodeIndex.class);
    private static final int MAX_STATIC_IDX = 65535;
    private static final int MIN_IDX = 0;
    static final String PF_CLUSTER_NODE_INDEX_KEY = "pf.cluster.node.index";
    private static ConfigStore configStore = ConfigStoreFarm.getConfig(ConfigStoreLocation.INSTANCE, "org.sourceid.saml20.service.util.NodeIndex");
    private static int index = -1;

    public static int getIndex() {
        if (index < 0) {
            NodeIndex.init();
        }
        return index;
    }

    static void init() {
        int configuredIndex;
        index = MgmtFactory.getMediator().isStandalone() ? ((configuredIndex = NodeIndex.getConfiguredNodeIndex()) > -1 ? configuredIndex : NodeIndex.generateCandidateNodeIndex(null, false)) : MgmtFactory.getNodeIndexRegistry().getLocalNodeIndex();
        log.info((Object)("My server node index is " + index));
    }

    public static int getConfiguredNodeIndex() {
        String idxString = System.getProperty(PF_CLUSTER_NODE_INDEX_KEY);
        if (!StringUtils.isBlank((String)idxString)) {
            try {
                int tempIndex = -1;
                log.info((Object)("Setting server node index from system property pf.cluster.node.index=" + idxString));
                tempIndex = idxString.contains(".") ? NodeIndex.parseTwoOctet(idxString) : Integer.parseInt(idxString);
                if (tempIndex >= 0 && tempIndex <= 65535) {
                    return tempIndex;
                }
                log.warn((Object)("Server node index out of range (0, 65535): " + tempIndex));
            }
            catch (Exception e) {
                log.error((Object)("Problem setting this server's node index from '" + idxString + "'. " + e.getClass().getSimpleName() + ": " + e.getMessage()));
            }
        }
        return -1;
    }

    public static int generateCandidateNodeIndex(String localAddress, boolean newQualifier) {
        String qualifier = configStore.getStringValue(QUALIFIER, null);
        if (qualifier == null || newQualifier) {
            qualifier = IDGenerator.rndAlphaNumeric((int)10);
            configStore.setStringValue(QUALIFIER, qualifier);
            log.debug((Object)("Generated random node index qualifier " + qualifier));
        }
        Object input = qualifier;
        if (localAddress != null) {
            log.info((Object)("Setting server node index from local address " + localAddress + " and qualifier " + qualifier));
            input = (String)input + ":";
            input = (String)input + localAddress;
        } else {
            log.info((Object)("Setting server node index from qualifier " + qualifier));
        }
        byte[] bytes = HashUtil.hashToBytes((String)input, (HashAlgorithm)HashAlgorithm.SHA256);
        byte[] truncated = Arrays.copyOf(bytes, 4);
        int result = Math.abs(ByteUtil.getInt(truncated));
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    static int parseTwoOctet(String idxString) {
        String[] strings = idxString.split("\\.");
        if (strings.length > 2) {
            throw new IllegalArgumentException("'" + idxString + "' can have only two octets");
        }
        short[] shorts = new short[strings.length];
        for (int i = 0; i < shorts.length; ++i) {
            shorts[i] = Short.parseShort(strings[i]);
            if (shorts[i] >= 0 && shorts[i] <= 255) continue;
            throw new IllegalArgumentException(strings[i] + " in '" + idxString + "' is invalid - each octet must be between 0 and 255");
        }
        return (shorts[0] << 8) + shorts[1];
    }
}

