/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.state;

import java.io.Serializable;
import org.sourceid.config.ConfigProps;

public class SizeLimitProps
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SIZE_LIMITS_CONF_FILENAME = "size-limits.conf";
    public static final String KEY_IDP_MAX_SESSIONS = "IdpSessionRegistryMapImpl.max.sessions";
    public static final String KEY_IDP_MAX_INDIVIDUAL_SESSIONS = "IdpSessionRegistryMapImpl.max.individual.sessions";
    public static final String KEY_IDP_MAX_PARTNER_SESSIONS = "IdpSessionRegistryMapImpl.max.partner.sessions";
    public static final String KEY_IDP_EXPIRY_MINS = "IdpSessionRegistryMapImpl.expiry.mins";
    public static final String KEY_IDP_MAX_UNIQUE_USER_KEYS = "IdpSessionRegistryMapImpl.max.user.keys";
    public static final String KEY_IDP_MAX_USER_KEY_SRIS = "IdpSessionRegistryMapImpl.max.user.key.sris";
    public static final String KEY_IDP_USER_KEY_EXPIRY_MINS = "IdpSessionRegistryMapImpl.user.key.expiry.mins";
    public static final String KEY_IDP_TOMBSTONE_RETENTION_MINS = "IdpSessionRegistryMapImpl.tombstone.retention.mins";
    public static final String KEY_SP_MAX_SESSIONS = "SpSessionRegistryMapImpl.max.sessions";
    public static final String KEY_SP_MAX_INDIVIDUAL_SESSIONS = "SpSessionRegistryMapImpl.max.individual.sessions";
    public static final String KEY_SP_EXPIRY_MINS = "SpSessionRegistryMapImpl.expiry.mins";
    public static final String KEY_IRSM_MAX_SIZE_STATE_MAP = "InterReqStateMgmtMapImpl.max.size.state.map";
    public static final String KEY_IRSM_MAX_DEPTH_STATE_STACK = "InterReqStateMgmtMapImpl.max.depth.state.stack";
    public static final String KEY_IRSM_MAX_SIZE_ATTR_MAP = "InterReqStateMgmtMapImpl.max.size.attr.map";
    public static final String KEY_IRSM_MAX_SESSION_ATTRS = "InterReqStateMgmtMapImpl.max.session.attrs";
    public static final String KEY_IRSM_EXPIRY_MINS = "InterReqStateMgmtMapImpl.expiry.mins";
    public static final String KEY_IRSM_EXPIRY_MINS_STATE_MAP = "InterReqStateMgmtMapImpl.expiry.mins.state.map";
    public static final String KEY_IRSM_EXPIRY_MINS_ATTR_MAP = "InterReqStateMgmtMapImpl.expiry.mins.attr.map";
    public static final String KEY_IRSM_TOMBSTONE_RETENTION_MINS = "InterReqStateMgmtMapImpl.tombstone.retention.mins";
    public static final String KEY_IRSM_TOMBSTONE_CLEANUP_INTERVAL_MINS = "InterReqStateMgmtMapImpl.tombstone.cleanup.mins";
    public static final String KEY_IRSM_MAX_ITEMS_IN_SET_ATTRIBUTE = "InterReqStateMgmtMapImpl.max.items.in.set.attribute";
    public static final String KEY_SESSION_REVOCATION_MAX_REVOKED_SRIS = "SessionRevocationServiceMapImpl.max.revoked.sris";
    public static final String KEY_METADATA_DIRECTORY_MAX_SIZE_IDP_CONN_MAP = "MetadataDirectory.max.size.idp.conn.map";
    public static final String KEY_METADATA_DIRECTORY_MAX_SIZE_SP_CONN_MAP = "MetadataDirectory.max.size.sp.conn.map";
    public static final String KEY_CLIENT_MANAGER_MAX_SIZE_CLIENTS_MAP = "ClientManagerXmlFileImpl.max.size.clients.map";
    public static final String KEY_STATS_LOG_INTERVAL_MINS = "stats.log.interval.mins";
    private ConfigProps configProps = new ConfigProps("size-limits.conf");

    public int getIdpMaxSessions() {
        return this.configProps.getInt(KEY_IDP_MAX_SESSIONS, 5000);
    }

    public int getIdpMaxIndividualSessions() {
        return this.configProps.getInt(KEY_IDP_MAX_INDIVIDUAL_SESSIONS, 500);
    }

    public int getIdpMaxPartnerSessions() {
        return this.configProps.getInt(KEY_IDP_MAX_PARTNER_SESSIONS, 500);
    }

    public int getIdpExpiryMins() {
        return this.configProps.getInt(KEY_IDP_EXPIRY_MINS, 1440);
    }

    public int getIdpTombstoneRetentionMins() {
        return this.configProps.getInt(KEY_IDP_TOMBSTONE_RETENTION_MINS, 30);
    }

    public int getSpMaxSessions() {
        return this.configProps.getInt(KEY_SP_MAX_SESSIONS, 5000);
    }

    public int getSpMaxIndividualSessions() {
        return this.configProps.getInt(KEY_SP_MAX_INDIVIDUAL_SESSIONS, 100);
    }

    public int getSpExpiryMins() {
        return this.configProps.getInt(KEY_SP_EXPIRY_MINS, 1440);
    }

    public int getIrsmMaxSizeStateMap() {
        return this.configProps.getInt(KEY_IRSM_MAX_SIZE_STATE_MAP, 10000);
    }

    public int getIrsmMaxDepthStateStack() {
        return this.configProps.getInt(KEY_IRSM_MAX_DEPTH_STATE_STACK, 1);
    }

    public int getIrsmMaxSizeAttrMap() {
        return this.configProps.getInt(KEY_IRSM_MAX_SIZE_ATTR_MAP, 10000);
    }

    public int getIrsmMaxSessionAttrs() {
        return this.configProps.getInt(KEY_IRSM_MAX_SESSION_ATTRS, 500);
    }

    public int getIrsmExpiryMinsStateMap() {
        return this.configProps.getInt(KEY_IRSM_EXPIRY_MINS_STATE_MAP, this.configProps.getInt(KEY_IRSM_EXPIRY_MINS, 30));
    }

    public int getIrsmExpiryMinsAttrMap() {
        return this.configProps.getInt(KEY_IRSM_EXPIRY_MINS_ATTR_MAP, this.configProps.getInt(KEY_IRSM_EXPIRY_MINS, 1440));
    }

    public int getIrsmTombstoneRetentionMins() {
        return this.configProps.getInt(KEY_IRSM_TOMBSTONE_RETENTION_MINS, 30);
    }

    public int getIrsmTombstoneCleanupIntervalMins() {
        return this.configProps.getInt(KEY_IRSM_TOMBSTONE_CLEANUP_INTERVAL_MINS, 10);
    }

    public int getIrsmMaxItemsInSetAttribute() {
        return this.configProps.getInt(KEY_IRSM_MAX_ITEMS_IN_SET_ATTRIBUTE, 100);
    }

    public int getSessionRevocationMaxRevokedSris() {
        return this.configProps.getInt(KEY_SESSION_REVOCATION_MAX_REVOKED_SRIS, 50000);
    }

    public int getMetadataDirectoryMaxSizeIdpConnMap() {
        return this.configProps.getInt(KEY_METADATA_DIRECTORY_MAX_SIZE_IDP_CONN_MAP, 10000);
    }

    public int getMetadataDirectoryMaxSizeSpConnMap() {
        return this.configProps.getInt(KEY_METADATA_DIRECTORY_MAX_SIZE_SP_CONN_MAP, 10000);
    }

    public int getClientManagerMaxSizeClientsMap() {
        return this.configProps.getInt(KEY_CLIENT_MANAGER_MAX_SIZE_CLIENTS_MAP, 10000);
    }

    public float getStatsLogIntervalMins() {
        return (float)this.configProps.getDouble(KEY_STATS_LOG_INTERVAL_MINS, 15.0);
    }

    public int getMaxUniqueUserKeys() {
        return this.configProps.getInt(KEY_IDP_MAX_UNIQUE_USER_KEYS, 50000);
    }

    public int getMaxUserKeySris() {
        return this.configProps.getInt(KEY_IDP_MAX_USER_KEY_SRIS, 100);
    }

    public int getUserKeyExpiryMins() {
        return this.configProps.getInt(KEY_IDP_USER_KEY_EXPIRY_MINS, this.getIdpExpiryMins() + 5);
    }
}

