/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.protocol.AssertionTypeUtil;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.service.SpSessionRegistry;
import org.sourceid.saml20.service.WebSsoSession;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.xmlbinding.assertion.NameIDType;
import org.sourceid.saml20.xmlbinding.assertion.SubjectType;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class SpSessionRegistrySupport {
    private static final Log log = LogFactory.getLog(SpSessionRegistrySupport.class);
    private static final AssertionTypeUtil ASSERTION_TYPE_UTIL = new AssertionTypeUtil();
    private static final org.sourceid.saml1x.protocol.AssertionTypeUtil SAML_11_ASSERTION_TYPE_UTIL = new org.sourceid.saml1x.protocol.AssertionTypeUtil();

    public static void registerAuthnBean(SpHashableAuthnBean bean) {
        SpSessionRegistrySupport.regSession(bean, null);
    }

    public static void registerSessionReceived(SpHashableAuthnBean authnBean, org.sourceid.saml20.xmlbinding.assertion.AssertionType assertion, String idpEntityId, String virtualServerId) {
        String id = assertion.getID();
        String sessionIndex = ASSERTION_TYPE_UTIL.getSessionIndex(assertion);
        SubjectType subject = assertion.getSubject();
        NameIDType nameID = subject.getNameID();
        WebSsoSession s = new WebSsoSession(idpEntityId, virtualServerId, id, sessionIndex, nameID);
        SpSessionRegistrySupport.regSession(authnBean, s);
    }

    private static void regSession(SpHashableAuthnBean authnBean, WebSsoSession s) {
        try {
            SpSessionRegistry spSessionRegistry = StateMgmtFactory.getSpSessionRegistry();
            spSessionRegistry.registerSessionReceived(authnBean, s);
        }
        catch (GeneralServiceException e) {
            log.error((Object)"Unable to register assertion received - SLO will not work.", (Throwable)e);
        }
    }

    public static void registerSessionReceived(SpHashableAuthnBean authnBean, AssertionType assertion, String idpEntityId, String virtualServerId) {
        String id = assertion.getAssertionID();
        String sessionIndex = null;
        WebSsoSession s = new WebSsoSession(idpEntityId, virtualServerId, id, sessionIndex, org.sourceid.saml1x.protocol.AssertionTypeUtil.getSaml20NameId(assertion));
        SpSessionRegistrySupport.regSession(authnBean, s);
    }

    public static void registerSessionReceived(SpHashableAuthnBean spAuthnBean, IdpConnHashableAuthnBean idpConnBean) {
        IdpConnection idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(idpConnBean.getAuthnSourceKey().getId(), true);
        WebSsoSession s = new WebSsoSession(idpConn.getEntityId(), idpConnBean.getVirtualServerId(), null, idpConnBean.getSessionIndex(), idpConnBean.getNameId());
        SpSessionRegistrySupport.regSession(spAuthnBean, s);
    }

    public static void unregisterSessions(Collection<SpHashableAuthnBean> authnBeans) {
        try {
            if (!authnBeans.isEmpty()) {
                StateMgmtFactory.getSpSessionRegistry().unregisterSessionsReceived(new ArrayList<SpHashableAuthnBean>(authnBeans));
            }
        }
        catch (GeneralServiceException e) {
            throw new ProcessRuntimeException(e);
        }
    }

    public static Map<SpHashableAuthnBean, WebSsoSession> lookupAuthnBeansAndSessions(String sessionIdentifier) {
        SpSessionRegistry spSessionRegistry = StateMgmtFactory.getSpSessionRegistry();
        try {
            return spSessionRegistry.lookupAuthnBeansAndSessions(sessionIdentifier);
        }
        catch (GeneralServiceException e) {
            throw new ProcessRuntimeException(e);
        }
    }

    public static boolean hasSessions(HttpServletRequest req, HttpServletResponse resp) {
        return !SpSessionRegistrySupport.lookupAuthnBeansAndSessions(StateMgmtFactory.getLocalSessionId(req, resp)).isEmpty();
    }
}

