/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.state;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import java.util.Map;
import org.sourceid.common.Util;
import org.sourceid.util.ExternalizationEncoder;
import org.sourceid.websso.servlet.SessionIdUtil;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class State
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private long created;
    private InMessageContext inMsgCtx;
    private OutMessageContext outMsgCtx;
    private Map<String, Object> parameters;
    private String primarySessionId;
    public static final Comparator<State> COMPARE_BY_CREATED_TIME = new Comparator<State>(){

        @Override
        public int compare(State state1, State state2) {
            long ts2;
            long ts1 = state1.getCreatedTimestamp();
            return ts1 < (ts2 = state2.getCreatedTimestamp()) ? 1 : (ts1 == ts2 ? 0 : -1);
        }
    };

    public State() {
        this.created = System.currentTimeMillis();
    }

    State(long ts) {
        this.created = ts;
    }

    public InMessageContext getInMsgCtx() {
        return this.inMsgCtx;
    }

    public void setInMsgCtx(InMessageContext inMsgCtx) {
        this.inMsgCtx = inMsgCtx;
    }

    public OutMessageContext getOutMsgCtx() {
        return this.outMsgCtx;
    }

    public void setOutMsgCtx(OutMessageContext outMsgCtx) {
        this.outMsgCtx = outMsgCtx;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public long getCreatedTimestamp() {
        return this.created;
    }

    public String getPrimarySessionId() {
        return this.primarySessionId;
    }

    public void setPrimarySessionId(String primarySessionId) {
        this.primarySessionId = primarySessionId;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte type = in.readByte();
        if (type == 0) {
            this.inMsgCtx = null;
        } else {
            this.inMsgCtx = new InMessageContext();
            this.inMsgCtx.readExternal(in);
        }
        type = in.readByte();
        if (type == 0) {
            this.outMsgCtx = null;
        } else {
            this.outMsgCtx = new OutMessageContext();
            this.outMsgCtx.readExternal(in);
        }
        this.parameters = ExternalizationEncoder.readStringObjectMap(in);
        this.created = ExternalizationEncoder.readLong(in);
        this.primarySessionId = ExternalizationEncoder.readString(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.inMsgCtx == null) {
            out.writeByte(0);
        } else {
            out.writeByte(11);
            this.inMsgCtx.writeExternal(out);
        }
        if (this.outMsgCtx == null) {
            out.writeByte(0);
        } else {
            out.writeByte(11);
            this.outMsgCtx.writeExternal(out);
        }
        ExternalizationEncoder.writeStringObjectMap(out, this.parameters);
        ExternalizationEncoder.writeLong(out, this.created);
        ExternalizationEncoder.writeString(out, this.primarySessionId);
    }

    public String toString() {
        return "State(" + this.created + "){" + Util.LINE_BREAK + "inMsgCtx=" + this.inMsgCtx + Util.LINE_BREAK + "outMsgCtx=" + this.outMsgCtx + Util.LINE_BREAK + "parameters=" + this.parameters + Util.LINE_BREAK + "sessionId=" + SessionIdUtil.getInstance().hashIdForLog(this.primarySessionId) + "}";
    }
}

