/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.state;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.jgroups.MuxRpcDispatcherMgr;
import com.pingidentity.localidentity.TrackedParamsAuditLogger;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.format.ISODateTimeFormat;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;
import org.sourceid.saml20.service.ArtifactPersistenceService;
import org.sourceid.saml20.service.AssertionReplayPreventionService;
import org.sourceid.saml20.service.ClusterLockService;
import org.sourceid.saml20.service.DistributedStateCoordinator;
import org.sourceid.saml20.service.IdpSessionRegistry;
import org.sourceid.saml20.service.InterRequestStateMgmt;
import org.sourceid.saml20.service.RevokedSriInfo;
import org.sourceid.saml20.service.SessionRevocationService;
import org.sourceid.saml20.service.SpSessionRegistry;
import org.sourceid.saml20.service.StateServiceRegistry;
import org.sourceid.saml20.service.impl.grouprpc.lock.ClusterLockClientRpcs;
import org.sourceid.saml20.service.impl.grouprpc.lock.StandaloneClusterLockService;
import org.sourceid.saml20.service.session.StoredSessionService;
import org.sourceid.saml20.service.session.data.SessionStorageManager;
import org.sourceid.saml20.state.AdaptiveClusteringConfig;
import org.sourceid.saml20.state.ConsistentHashTracker;
import org.sourceid.saml20.state.SessionReplicationInfo;
import org.sourceid.saml20.state.State;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.util.log.internal.TransactionIdSupport;
import org.sourceid.websso.servlet.PersistentSessionIdUtil;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.servlet.SessionIdUtil;

public class StateMgmtFactory {
    private static final Log log = LogFactory.getLog(StateMgmtFactory.class);
    private static final SessionIdUtil sessionIdUtil = SessionIdUtil.getInstance();
    private static final PersistentSessionIdUtil persistentSessionIdUtil = PersistentSessionIdUtil.getInstance();
    private static final ThreadLocal<SessionReplicationInfo> sessionReplicationInfo = new ThreadLocal();
    private static final AdaptiveClusteringConfig adaptiveClusteringConfig = new AdaptiveClusteringConfig();
    private static final StandaloneClusterLockService standaloneLockService = new StandaloneClusterLockService();
    private static final String STATE_SAVED = "org.sourceid.saml20.state.StateMgmtFactory.STATE_SAVED";
    private static final String STATE_ALTERED = "org.sourceid.saml20.state.StateMgmtFactory.STATE_ALTERED";

    public static InterRequestStateMgmt getInterRequestStateMgmt() {
        return GlobalRegistry.getService(InterRequestStateMgmt.class);
    }

    public static void saveState(HttpServletRequest request, HttpServletResponse resp, String stateKey, State state) {
        InterRequestStateMgmt mgmt = StateMgmtFactory.getInterRequestStateMgmt();
        request.setAttribute(STATE_ALTERED, (Object)true);
        request.setAttribute(STATE_SAVED, (Object)true);
        TransactionIdSupport.addTransactionIdToStateIfNeeded(state);
        mgmt.saveState(stateKey, state, request, resp);
    }

    public static State retrieveAndRemoveState(String stateKey, boolean failFast, HttpServletRequest req, HttpServletResponse resp) throws RenderPageException {
        InterRequestStateMgmt mgmt = StateMgmtFactory.getInterRequestStateMgmt();
        req.setAttribute(STATE_ALTERED, (Object)true);
        req.setAttribute(STATE_SAVED, (Object)false);
        State state = mgmt.retrieveAndRemoveState(stateKey, req, resp);
        if (state == null && failFast) {
            String msg = "Unable to resume processing because saved state was not found for key: " + stateKey;
            throw new RenderPageException(msg, "state.not.found.error.page.template.html");
        }
        StateMgmtFactory.restoreTrackedParamsForAuditing(state);
        TransactionIdSupport.restoreTransactionIdFromStateIfPresent(state);
        return state;
    }

    private static void restoreTrackedParamsForAuditing(State state) {
        Map trackedParams;
        Object trackedParamsObj;
        if (state != null && state.getParameters() != null && (trackedParamsObj = state.getParameters().get("pf.TrackedHttpParams")) != null && !(trackedParams = (Map)trackedParamsObj).isEmpty()) {
            TrackedParamsAuditLogger.setTrackedParams(trackedParams);
        }
    }

    public static void checkSessionRevoked(HttpServletRequest req, HttpServletResponse resp) {
        RevokedSriInfo info = StateMgmtFactory.getSessionRevocationService().getRevokedSriInfo(StateMgmtFactory.getSri(req, resp));
        if (info != null) {
            log.info((Object)("User session has been revoked, session ID's will be reset, SRI=" + info.getSri() + ", expiration time=" + ISODateTimeFormat.dateTime().withZoneUTC().print(info.getExpirationTime())));
            StateMgmtFactory.resetSessionIds(req, resp);
            StateMgmtFactory.saveSessionReplicationInfo(req, resp);
            TrackingIdSupport.setTrackingIdInThreadContext(req, resp);
        }
    }

    public static String getLocalSessionId(HttpServletRequest request, HttpServletResponse response) {
        return sessionIdUtil.getPrimaryValue(request, response);
    }

    public static String getExtendedSessionId(HttpServletRequest request, HttpServletResponse response) {
        return sessionIdUtil.getExtendedSessionId(request, response);
    }

    public static String getHashedPersistentSessionId(HttpServletRequest request, HttpServletResponse response) {
        String sessionId = persistentSessionIdUtil.getPrimaryValue(request, response, false);
        if (sessionId == null) {
            return null;
        }
        return persistentSessionIdUtil.hashPrimaryValue(sessionId);
    }

    public static String cycleHashedPersistentSessionId(HttpServletRequest request, HttpServletResponse response) {
        String sessionId = persistentSessionIdUtil.createInitialPrimaryValue(request, response);
        return persistentSessionIdUtil.hashPrimaryValue(sessionId);
    }

    public static String getSri(HttpServletRequest request, HttpServletResponse response) {
        return sessionIdUtil.getSri(request, response);
    }

    public static String getExtendedSri(HttpServletRequest request, HttpServletResponse response) {
        return sessionIdUtil.getExtendedSri(request, response);
    }

    public static String getExtendedSriV2(HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) {
        return sessionIdUtil.getExtendedSriV2(request, response, params);
    }

    public static void saveSessionReplicationInfo(HttpServletRequest request, HttpServletResponse response) {
        sessionReplicationInfo.set(sessionIdUtil.makeSessionReplicationInfo(request, response));
    }

    public static void removeSessionReplicationInfo() {
        sessionReplicationInfo.remove();
    }

    public static SessionReplicationInfo getSessionReplicationInfo() {
        return sessionReplicationInfo.get();
    }

    public static String resetSessionIds(HttpServletRequest request, HttpServletResponse response) {
        return sessionIdUtil.createInitialPrimaryValue(request, response);
    }

    public static IdpSessionRegistry getIdpSessionRegistry() {
        return GlobalRegistry.getService(IdpSessionRegistry.class);
    }

    public static SpSessionRegistry getSpSessionRegistry() {
        return GlobalRegistry.getService(SpSessionRegistry.class);
    }

    public static ArtifactPersistenceService getArtifactPersistenceService() {
        return GlobalRegistry.getService(ArtifactPersistenceService.class);
    }

    public static AssertionReplayPreventionService getBearerAssertionReplayPreventionSvc() {
        return GlobalRegistry.getService(AssertionReplayPreventionService.class);
    }

    public static SessionRevocationService getSessionRevocationService() {
        return GlobalRegistry.getService(SessionRevocationService.class);
    }

    public static DistributedStateCoordinator getDistributedStateCoordinator() {
        return GlobalRegistry.getService(DistributedStateCoordinator.class);
    }

    public static StateServiceRegistry getStateServiceRegistry() {
        return GlobalRegistry.getService(StateServiceRegistry.class);
    }

    public static StoredSessionService getStoredSessionService() {
        return GlobalRegistry.getService(StoredSessionService.class);
    }

    public static SessionStorageManager getSessionStorageManager() {
        return GlobalRegistry.getService(SessionStorageManager.class);
    }

    public static ConsistentHashTracker makeConsistentHashTracker(boolean hashPartitionKeyInLogs, boolean hashIdentifierInLogs) {
        if (ModeSupport.isDistributable() && PropertyInfo.isAdaptiveClusteringEnabled()) {
            return new ConsistentHashTracker(adaptiveClusteringConfig.getHashFunction(), hashPartitionKeyInLogs, hashIdentifierInLogs);
        }
        return new ConsistentHashTracker(null, hashPartitionKeyInLogs, hashIdentifierInLogs);
    }

    public static AdaptiveClusteringConfig getAdaptiveClusteringConfig() {
        return adaptiveClusteringConfig;
    }

    public static ClusterLockService getClusterLockService() {
        if (MgmtFactory.getMediator().isStandalone()) {
            return standaloneLockService;
        }
        return (ClusterLockService)MuxRpcDispatcherMgr.getMgr().getRpcInvocationTarget(ClusterLockClientRpcs.class);
    }

    public static boolean isStateSavedByRequest(HttpServletRequest req) {
        if (req.getAttribute(STATE_SAVED) != null) {
            return (Boolean)req.getAttribute(STATE_SAVED);
        }
        return false;
    }

    public static boolean isStateAlteredByRequest(HttpServletRequest req) {
        if (req.getAttribute(STATE_ALTERED) != null) {
            return (Boolean)req.getAttribute(STATE_ALTERED);
        }
        return false;
    }
}

