/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.state;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.PathUtil;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.servlet.HttpServletRespProxy;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class StateSupport {
    protected final PathUtil pathUtil;
    protected int pathEmbeddedCtxIdLength = 10;
    private String contextRoot;
    public static final String PATH_OVERRIDE_KEY = "use-this-path";

    public StateSupport(MetadataLocal meta) {
        this(meta, PropertyInfo.getContextPath());
    }

    public StateSupport(MetadataLocal meta, String contextRoot) {
        this.pathUtil = meta.getPathUtil();
        ConfigStore config = ConfigStoreFarm.getConfig(StateSupport.class);
        this.pathEmbeddedCtxIdLength = config.getIntValue("path-embedded-context-id-length", this.pathEmbeddedCtxIdLength);
        this.contextRoot = contextRoot;
    }

    public static void overridePath(HttpServletRequest req, String pathWithContextRoot) {
        req.setAttribute(PATH_OVERRIDE_KEY, (Object)pathWithContextRoot);
    }

    public String saveState(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherInfo, String pathQualifier) {
        return this.saveState(req, resp, inMsgCtx, outMsgCtx, otherInfo, pathQualifier, false);
    }

    public String saveState(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherInfo, String pathQualifier, boolean newContextId) {
        String path = this.getResumePath(req, pathQualifier, newContextId);
        String pathKey = this.getContextId(path);
        String stateKey = this.buildStateKey(req, resp, pathKey);
        if (resp instanceof HttpServletRespProxy) {
            ((HttpServletRespProxy)resp).setPreCommitRunnable(() -> {
                if (!this.skipSaveHook(req)) {
                    this.doSaveState(req, resp, stateKey, inMsgCtx, outMsgCtx, otherInfo);
                }
            });
        } else {
            this.doSaveState(req, resp, stateKey, inMsgCtx, outMsgCtx, otherInfo);
        }
        return path;
    }

    public String getResumePath(HttpServletRequest req, String pathQualifier, boolean newContextId) {
        String path = StateSupport.getPathWithOverride(req);
        if (this.pathUtil.isResumePath(path) && !newContextId) {
            return path;
        }
        if (!this.pathUtil.isResumePath(path = this.removeContextRoot(path))) {
            String id = this.makeNewContextId();
            path = this.pathUtil.stripPathParams(path);
            path = this.pathUtil.convertToResumePath(path, pathQualifier, id);
        } else if (newContextId) {
            path = this.pathUtil.replaceContextId(path, this.makeNewContextId());
        }
        path = this.prependContextRoot(path);
        return path;
    }

    public String insertNonce(String resumePathWithContextRoot) {
        String path = this.removeContextRoot(resumePathWithContextRoot);
        path = this.pathUtil.insertNonce(path);
        return this.prependContextRoot(path);
    }

    public String getContextId(String resumePathWithContextRoot) {
        String path = this.removeContextRoot(resumePathWithContextRoot);
        return this.pathUtil.getContextId(path);
    }

    public static String getPathWithOverride(HttpServletRequest req) {
        String overridePath = (String)req.getAttribute(PATH_OVERRIDE_KEY);
        if (overridePath != null) {
            return overridePath;
        }
        return StateSupport.getServletPathWithContextRoot(req);
    }

    public static String getServletPathWithContextRoot(HttpServletRequest req) {
        Object path = req.getServletPath();
        if (!StringUtils.isBlank((String)req.getContextPath())) {
            path = req.getContextPath() + (String)path;
        }
        return path;
    }

    protected String makeNewContextId() {
        return this.pathEmbeddedCtxIdLength > 0 ? IDGenerator.rndAlphaNumeric(this.pathEmbeddedCtxIdLength) : null;
    }

    private void doSaveState(HttpServletRequest req, HttpServletResponse resp, String stateKey, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherInfo) {
        State state = new State();
        state.setInMsgCtx(inMsgCtx);
        state.setOutMsgCtx(outMsgCtx);
        state.setParameters(otherInfo);
        StateMgmtFactory.saveState(req, resp, stateKey, state);
    }

    public String getStateKey(HttpServletRequest req, HttpServletResponse resp) {
        String pathKey = this.pathUtil.getContextId(req.getServletPath());
        if (AuthnApiSupport.getDefault().isApiRequest(req) && pathKey == null) {
            pathKey = AuthnApiSupport.getDefault().getFlowId(req.getPathInfo());
        }
        return this.buildStateKey(req, resp, pathKey);
    }

    protected String removeContextRoot(String path) {
        if (this.isContextRootConfigured()) {
            return path.substring(this.contextRoot.length());
        }
        return path;
    }

    protected String prependContextRoot(String path) {
        if (this.isContextRootConfigured()) {
            return this.contextRoot + path;
        }
        return path;
    }

    private boolean isContextRootConfigured() {
        return this.contextRoot != null && this.contextRoot.length() > 1;
    }

    public String buildStateKey(HttpServletRequest req, HttpServletResponse resp, String pathKey) {
        String cookieKey = StateMgmtFactory.getLocalSessionId(req, resp);
        return pathKey == null ? cookieKey : cookieKey + "_" + pathKey;
    }

    protected boolean skipSaveHook(HttpServletRequest req) {
        return false;
    }
}

